<?php
header("Content-Type: application/json");

$employee_id = $_GET['employee_id'] ?? null;

if (!$employee_id) {
    echo json_encode([
        "success" => false,
        "message" => "Employee ID missing"
    ]);
    exit;
}

// ------------------------------
// YOUR SQL GOES HERE
// Example query (you will write actual SQL):
//
// SELECT date, leave_type, leave_reason, leave_status
// FROM attendance
// WHERE employee_id = ? 
// AND leave_status IS NOT NULL
//
// ------------------------------

// Fake output example (replace with DB result)
$rows = [
    ["date" => "2025-12-12", "leave_type" => "CL", "leave_reason" => "Fever", "leave_status" => "pending"],
    ["date" => "2025-12-15", "leave_type" => "PL", "leave_reason" => "Family Event", "leave_status" => "approved"]
];

// Convert DB rows → JS expected structure        
$leaves = [];                      

foreach ($rows as $r) {
    $leaves[] = [
        "date"   => $r["date"],
        "type"   => $r["leave_type"],
        "reason" => $r["leave_reason"],
        "status" => $r["leave_status"],
        "source" => "user"
    ];            
}

echo json_encode([
    "success" => true,
    "leaves" => $leaves
]);
