<?php
// Database connection
$employeeattend_path = strstr(__DIR__, 'employeeattendance', true) . 'employeeattendance/';

require_once($employeeattend_path."include/config.php");    
require_once(GLOBAL_INCLUDE_PATH."include/startup.php");   


$alltables = new AllTables();

// Get inputs
$year           = $_GET['year'] ?? date("Y");
$report         = $_GET['report'] ?? 'matrix';
$employee_id    = $_GET['employee_id'] ?? null;  

// Force download as CSV

/* ///
header("Content-Type: text/csv");
header("Content-Disposition: attachment; filename={$report}_{$year}.csv");
$output = fopen("php://output", "w");
*/

// Route to correct report
switch ($report) {
    case "matrix":
        generate_matrix_report($alltables, $year, $output);
        break;
    case "monthly_summary":
        generate_monthly_summary($alltables, $year, $output);
        break;
    case "employee_wise":
        if (!$employee_id) {
            echo "Employee ID required for employee-wise report";
            exit;
        }
        generate_employee_wise($alltables, $year, $employee_id, $output);
        break;
    case "daily_list":
        generate_daily_list($alltables, $year, $output);
        break;
    default:
        echo "Invalid report type";
}

///fclose($output);         
///exit;    

/* ---------------------------
   REPORT FUNCTIONS
---------------------------- */

// 1. Yearly Matrix Report
function generate_matrix_report($alltables, $year, $output) {
    // Header row: Employee, Jan 1 ... Dec 31
    $daysInYear = (date("L", strtotime("$year-01-01")) ? 366 : 365);
    $header = ["Employee"];
    for ($d = 1; $d <= $daysInYear; $d++) {
        $header[] = date("d-M", strtotime("$year-01-01 +".($d-1)." days"));
    }
    /// fputcsv($output, $header);

    $res = $alltables->getInfo("","SELECT id, firstname, middlename, lastname FROM mstemployee ORDER BY id");
    
    print_r($res); exit;                
    
    foreach($res as $single_row)
    {
        $fullname   = $single_row['firstname']." ".$single_row['middlename']." ".$single_row['lastname'];
        $row        = [$fullname];
        for ($d = 1; $d <= $daysInYear; $d++) {
            $date = date("Y-m-d", strtotime("$year-01-01 +".($d-1)." days"));
            $q = $alltables->getInfo("","SELECT status FROM attendance 
                                        WHERE employee_id={$single_row['id']} AND date='$date'");
                                        
            print_r($q);  exit;                                      
                                        
            if (count($q)>0) {
                $row[] = $q[0]['status']; // P or A
            } else {
                $row[] = "";
            }
        }
        ///fputcsv($output, $row);                     
    }
    
}

// 2. Monthly Summary
function generate_monthly_summary($mysqli, $year, $output) {
    $header = ["Employee", "Month", "Presents", "Absents"];
    fputcsv($output, $header);

    $res = $mysqli->query("SELECT id, name FROM employees ORDER BY name");
    while ($emp = $res->fetch_assoc()) {
        for ($m = 1; $m <= 12; $m++) {
            $monthStart = "$year-".str_pad($m, 2, "0", STR_PAD_LEFT)."-01";
            $monthEnd = date("Y-m-t", strtotime($monthStart));

            $q = $mysqli->query("SELECT status, COUNT(*) as cnt 
                                 FROM attendance 
                                 WHERE employee_id={$emp['id']} 
                                 AND date BETWEEN '$monthStart' AND '$monthEnd'
                                 GROUP BY status");

            $present = $absent = 0;
            while ($r = $q->fetch_assoc()) {
                if ($r['status'] == 'Present') $present = $r['cnt'];
                if ($r['status'] == 'Absent') $absent = $r['cnt'];
            }
            fputcsv($output, [$emp['name'], date("F", strtotime($monthStart)), $present, $absent]);
        }
    }
}

// 3. Employee-wise Report
function generate_employee_wise($mysqli, $year, $emp_id, $output) {
    $q = $mysqli->query("SELECT name FROM employees WHERE id=$emp_id");
    $emp = $q->fetch_assoc();

    fputcsv($output, ["Employee-wise Report for {$emp['name']} ($year)"]);
    fputcsv($output, ["Date", "Status"]);

    $res = $mysqli->query("SELECT date, status FROM attendance 
                           WHERE employee_id=$emp_id 
                           AND YEAR(date)=$year 
                           ORDER BY date");
    while ($row = $res->fetch_assoc()) {
        fputcsv($output, [$row['date'], $row['status']]);
    }
}

// 4. Daily Attendance List
function generate_daily_list($mysqli, $year, $output) {
    fputcsv($output, ["Date", "Employee", "Status"]);

    $res = $mysqli->query("SELECT a.date, e.name, a.status 
                           FROM attendance a
                           JOIN employees e ON a.employee_id = e.id
                           WHERE YEAR(a.date)=$year
                           ORDER BY a.date, e.name");
    while ($row = $res->fetch_assoc()) {
        fputcsv($output, [$row['date'], $row['name'], $row['status']]);
    }
}
?>