<?php
$employeeattend_path = strstr(__DIR__, 'employeeattendance', true) . 'employeeattendance/';
require_once($employeeattend_path."include/config.php");          
require_once(GLOBAL_INCLUDE_PATH."include/startup.php");         

// Get inputs
$year           = $_GET['year'] ?? date("Y");
$report         = $_GET['report'] ?? 'matrix';
$employee_id    = $_GET['employee_id'] ?? null;

    if (ob_get_level()) ob_end_clean(); // clear existing buffers safely      
    /// Force download as CSV
    header('Content-Type: text/csv; charset=UTF-8');              
    header("Content-Disposition: attachment; filename={$report}_{$year}.csv");      
    echo "\xEF\xBB\xBF"; // optional, for Excel UTF-8   
    $output = fopen("php://output", "w");  


/*
*   if (headers_sent($file, $line)) {
*       die("⚠️ Headers already sent in $file on line $line 1");                           
*   }
*/

// Database connection
$alltables = new AllTables();         
                                            

// Route to correct report
switch ($report) {
    case "matrix":
        generate_matrix_report($alltables, $year, $output);           
        break;
    case "monthly_summary":
        generate_monthly_summary($alltables, $year, $output);
        break;
    case "employee_wise":
        if (!$employee_id) {
            echo "Employee ID required for employee-wise report";
            exit;
        }
        generate_employee_wise($alltables, $year, $employee_id, $output);
        break;
    case "daily_list":
        generate_daily_list($alltables, $year, $output);
        break;
    default:
        echo "Invalid report type";
}

///fclose($output);         
exit;

/* ---------------------------
   REPORT FUNCTIONS
---------------------------- */

// 1. Yearly Matrix Report
function generate_matrix_report($alltables, $year, $output) {  
    // Header row: Employee, Jan 1 ... Dec 31
    $daysInYear = (date("L", strtotime("$year-01-01")) ? 366 : 365);                           
    $header     = ["Employee"];
    for ($d = 1; $d <= $daysInYear; $d++) {
        $header[] = date("d-M", strtotime("$year-01-01 +".($d-1)." days"));         
    }     
    fputcsv($output, $header);                                            
    $res = $alltables->getInfo("","SELECT id, UPPER(firstname) AS firstname, UPPER(middlename) AS middlename, UPPER(lastname) AS lastname FROM mstemployee ORDER BY id");       
    foreach($res as $single_row)
    {
        $fullname   = $single_row['firstname']." ".$single_row['middlename']." ".$single_row['lastname'];
        $row        = [$fullname];
        
        for ($d = 1; $d <= $daysInYear; $d++) {
            $date       = date("Y-m-d", strtotime("$year-01-01 +".($d-1)." days"));                      
            $employeeid = $single_row['id'];
            $q = $alltables->getInfo("","SELECT status FROM attendance 
                                        WHERE employee_id=$employeeid AND date='$date'");                                                          
            if (count($q)>0) 
            {
                $row[] = $q[0]['status']=="Absent"? "A" : "P"; // P or A  
            } else {
                $row[] = "P";                                                          
            }
        }
        fputcsv($output, $row);                                                                                   
    }    
}

// 2. Monthly Summary
function generate_monthly_summary($alltables, $year, $output) {
    /// $header = ["Employee", "Month", "Presents", "Absents"];
    $header = ["Employee", "Month", "Absents"];
    fputcsv($output, $header);

    $res = $alltables->getInfo("","SELECT id, UPPER(CONCAT(firstname,' ', middlename,' ',lastname)) AS name FROM mstemployee ORDER BY name");
    foreach($res as $emp) {
        for ($m = 1; $m <= 12; $m++) {
            $monthStart = "$year-".str_pad($m, 2, "0", STR_PAD_LEFT)."-01";
            $monthEnd = date("Y-m-t", strtotime($monthStart));

            $q = $alltables->getInfo("","SELECT status, COUNT(*) as cnt 
                                 FROM attendance 
                                 WHERE employee_id={$emp['id']} 
                                 AND date BETWEEN '$monthStart' AND '$monthEnd'
                                 GROUP BY status");  
            
            $present = $absent = 0;
            foreach($q as $r) {
            /// if ($r['status'] == 'Present')  $present = $r['cnt'];     
                if ($r['status'] == 'Absent')   $absent  = $r['cnt'];      
            }
            /// fputcsv($output, [$emp['name'], date("F", strtotime($monthStart)), $present, $absent]);
            fputcsv($output, [$emp['name'], date("F", strtotime($monthStart)), $absent]);    
        }
    }
}

// 3. Employee-wise Report
function generate_employee_wise($alltables, $year, $emp_id, $output) {
    $q = $alltables->getInfo("","SELECT UPPER(CONCAT(firstname,' ', middlename,' ',lastname)) AS name FROM mstemployee WHERE id=$emp_id");
    $emp_name = $q[0]['name'];       
    
    fputcsv($output, ["Employee-wise Report for $emp_name ($year)"]);      
    fputcsv($output, ["Date", "Status"]);
    
    $res = $alltables->getInfo("","SELECT date, status FROM attendance 
                                   WHERE employee_id=$emp_id 
                                   AND YEAR(date)=$year 
                                   ORDER BY date");                                                                      
    foreach($res as $row) {
        fputcsv($output, [date("d-m-Y",strtotime($row['date'])), $row['status']]);                                                                             
    }
}

// 4. Daily Attendance List
function generate_daily_list($alltables, $year, $output) {
    fputcsv($output, ["Date", "Employee", "Status"]);

    $res = $alltables->getInfo("","SELECT a.date, UPPER(CONCAT(firstname,' ', middlename,' ',lastname)) AS name , a.status 
                           FROM attendance a
                           JOIN mstemployee e ON a.employee_id = e.id
                           WHERE YEAR(a.date)=$year
                           ORDER BY a.date, name");                
    foreach($res as $row)
    {
        if($row['status']=="Absent")
        {
            fputcsv($output, [date("d-m-Y", strtotime($row['date'])), $row['name'], $row['status']]);                           
        }
    }
}
?>