<?php
// internal function for utf8 decoding
// thanks to Jamie Pratt for noticing that PHP's function is a little 
// screwy

function my_utf8_decode($string)
{
return strtr($string, 
  "???????\A5\B5\C0\C1\C2\C3\C4\C5\C6\C7\C8\C9\CA\CB\CC\CD\CE\CF\D0\D1\D2\D3\D4\D5\D6\D8\D9\DA\DB\DC\DD\DF\E0\E1\E2\E3\E4\E5\E6\E7\E8\E9\EA\EB\EC\ED\EE\EF\F0\F1\F2\F3\F4\F5\F6\F8\F9\FA\FB\FC\FD\FF", 
  "SOZsozYYuAAAAAAACEEEEIIIIDNOOOOOOUUUUYsaaaaaaaceeeeiiiionoooooouuuuyy");
}

// paranoid sanitization -- only let the alphanumeric set through
function sanitize_paranoid_string($string, $min='', $max='')
{
  $string = preg_replace("/[^a-zA-Z0-9]/", "", $string);
  $len = strlen($string);
  if((($min != '') && ($len < $min)) || (($max != '') && ($len > $max)))
    return FALSE;
  return $string;
}

// sanitize a string in prep for passing a single argument to system() (or similar)
function sanitize_system_string($string, $min='', $max='')
{
  $pattern = '/(;|\||`|>|<|&|^|"|'."\n|\r|'".'|{|}|[|]|\)|\()/i'; // no piping, passing possible environment variables ($),
                           // seperate commands, nested execution, file redirection, 
                           // background processing, special commands (backspace, etc.), quotes
                           // newlines, or some other special characters
  $string = preg_replace($pattern, '', $string);
  $string = '"'.preg_replace('/\$/', '\\\$', $string).'"'; //make sure this is only interpretted as ONE argument
  $len = strlen($string);
  if((($min != '') && ($len < $min)) || (($max != '') && ($len > $max)))
    return FALSE;
  return $string;
}

// sanitize a string for SQL input (simple slash out quotes and slashes)
function sanitize_sql_string($string, $min='', $max='')
{
  $pattern[0] = '/(\\\\)/';
  $pattern[1] = "/\"/";
  $pattern[2] = "/'/";
  $replacement[0] = '\\\\\\';
  $replacement[1] = '\"';
  $replacement[2] = "\\'";
  $len = strlen($string);
  if((($min != '') && ($len < $min)) || (($max != '') && ($len > $max)))
    return FALSE;
  return preg_replace($pattern, $replacement, $string);
}

function toAscii($str, $replace=array(), $delimiter='-') {
if( !empty($replace) ) {
	$str = str_replace((array)$replace, ' ', $str);
	}
	//$clean = iconv('UTF-8', 'ASCII//TRANSLIT', $str);
	$clean = mb_convert_encoding($str,'UTF-8', 'ASCII//TRANSLIT');
	$clean = preg_replace("/[^a-zA-Z0-9\/_|+ -]/", '', $clean);
	$clean = strtolower(trim($clean, '-'));
	$clean = preg_replace("/[\/_|+ -]+/", $delimiter, $clean);

	return $clean;
}

function ProperCase($strToConvert)
{
	$strToReturn = ucwords(strtoupper($strToConvert));
	return $strToReturn;

} 	
	
// sanitize a string for SQL input (simple slash out quotes and slashes)
function sanitize_ldap_string($string, $min='', $max='')
{
  $pattern = '/(\)|\(|\||&)/';
  $len = strlen($string);
  if((($min != '') && ($len < $min)) || (($max != '') && ($len > $max)))
    return FALSE;
  return preg_replace($pattern, '', $string);
}


// sanitize a string for HTML (make sure nothing gets interpretted!)
function sanitize_html_string($string)
{
  $pattern[0] = '/\&/';
  $pattern[1] = '/</';
  $pattern[2] = "/>/";
  $pattern[3] = '/\n/';
  $pattern[4] = '/"/';
  $pattern[5] = "/'/";
  $pattern[6] = "/%/";
  $pattern[7] = '/\(/';
  $pattern[8] = '/\)/';
  $pattern[9] = '/\+/';
  $pattern[10] = '/-/';
  $replacement[0] = '&amp;';
  $replacement[1] = '&lt;';
  $replacement[2] = '&gt;';
  $replacement[3] = '<br>';
  $replacement[4] = '&quot;';
  $replacement[5] = '&#39;';
  $replacement[6] = '&#37;';
  $replacement[7] = '&#40;';
  $replacement[8] = '&#41;';
  $replacement[9] = '&#43;';
  $replacement[10] = '&#45;';
  return preg_replace($pattern, $replacement, $string);
}

// make int int!
function sanitize_int($integer, $min='', $max='')
{
  $int = intval($integer);
  if((($min != '') && ($int < $min)) || (($max != '') && ($int > $max)))
    return FALSE;
  return $int;
}

// make float float!
function sanitize_float($float, $min='', $max='')
{
  $float = floatval($float);
  if((($min != '') && ($float < $min)) || (($max != '') && ($float > $max)))
    return FALSE;
  return $float;
}

// glue together all the other functions
function sanitize($input, $flags, $min='', $max='')
{
  if($flags & UTF8) $input = my_utf8_decode($input);
  if($flags & PARANOID) $input = sanitize_paranoid_string($input, $min, $max);
  if($flags & INT) $input = sanitize_int($input, $min, $max);
  if($flags & FLOAT) $input = sanitize_float($input, $min, $max);
  if($flags & HTML) $input = sanitize_html_string($input, $min, $max);
  if($flags & SQL) $input = sanitize_sql_string($input, $min, $max);
  if($flags & LDAP) $input = sanitize_ldap_string($input, $min, $max);
  if($flags & SYSTEM) $input = sanitize_system_string($input, $min, $max);
  return $input;
}

function getAllCountryListForCombo($GCountry='')
	{
		$conuntries = new AllTables();
		
		$countrylist = $conuntries->getInfo("","select * from mstcountry");
		
		$rowcount = count($countrylist);
		
		$strCountryList = "";
		
		if ($rowcount > 0)
		{
			
			for($i=0;$i<$rowcount;$i++) 
			{	
				
				if(strtolower($GCountry) == strtolower($countrylist[$i]['CountryName']))
				{
					$strCountryList .= "<option value='".$countrylist[$i]['CountryName']."' selected='selected'>".ucwords(strtolower($countrylist[$i]['CountryName']))."</option>";
				}
				else
				{	
					$strCountryList .= "<option value='".$countrylist[$i]['CountryName']."'>".ucwords(strtolower($countrylist[$i]['CountryName']))."</option>";
				}
			}
		}
		return $strCountryList;	
	}	
	
	
	function getAllCountryCodeListForCombo($GCountry='')
	{
		$conuntries = new AllTables();
		
		$countrylist = $conuntries->getInfo("","select * from mstcountry where countrycode !='' order by countrycode DESC "); 
		
		$rowcount = count($countrylist);
		
		$strCountryList = "";
		
		if ($rowcount > 0)
		{
			
			for($i=0;$i<$rowcount;$i++) 
			{	
				
				if(strtolower($GCountry) == strtolower($countrylist[$i]['countrycode']))
				{
					$strCountryList .= "<option value='".$countrylist[$i]['countrycode']."' selected='selected'>".ucwords(strtolower($countrylist[$i]['countrycode']))."</option>";
				}
				else
				{	
					$strCountryList .= "<option value='".$countrylist[$i]['countrycode']."'>".ucwords(strtolower($countrylist[$i]['countrycode']))."</option>";
				}
			}
		}
		return $strCountryList;	
	}
	
	

	
	function getAllStateListForCombo($stateid='',$countryid='',$countryname='')
	{
	    
	   	$states = new State();
		$statelist = $states->getState("","select StateId,StateName from mststate ORDER BY StateName, StateId");
		$rowcount = (is_array($statelist))?count($statelist):0;
		
		$strstateList = "";
		
		if ($rowcount > 0)
		{
			
			for($i=0;$i<$rowcount;$i++) 
			{	
				if($stateid == $statelist[$i]['StateId'])
				{
					$strstateList .= '<option value="'.$statelist[$i]["StateId"].'-'.$statelist[$i]["StateName"].'" selected="selected">'.ucwords(strtolower($statelist[$i]["StateName"])).'</option>';
				}
				else
				{	
					$strstateList .= '<option value="'.$statelist[$i]["StateId"].'-'.$statelist[$i]["StateName"].'">'.ucwords(strtolower($statelist[$i]["StateName"])).'</option>';
				}
			}
		}
		return $strstateList;	
	}	
	
	
	function getStateListForCombo($GStateid='',$countryid='',$countryname='')
	{
		$testclass		=	new AllTables();
		
	
	    $statelist = $testclass->getInfo("","select * FROM mststate ORDER BY State");
		$rowcount = count($statelist);
		
		$strstatelist = "";
		
		if ($rowcount > 0)                                                                   
		{
			for($i=0;$i<$rowcount;$i++) 
			{	
				if(strtoupper($GStateid)==$statelist[$i]['StateId'])
				{
					$strstatelist .= "<option value='".$statelist[$i]['StateId']."-".$statelist[$i]['State']."' selected='selected'>".ucwords(strtolower($statelist[$i]['State']))."</option>";
				}
				else
				{	
					$strstatelist .= "<option value='".$statelist[$i]['StateId']."-".$statelist[$i]['State']."'>".ucwords(strtolower($statelist[$i]['State']))."</option>";
				}
			}
		}
		unset($testclass);
		return $strstatelist;	
	}
	
	
	
	
	
	function getCityListForCombo($GCity='',$stateid='')
	{
		$testclass		=	new AllTables();
		
	
		$citylist = $testclass->getInfo("","select cityid,cityname,citycode from mstcity where stateid= $stateid ORDER BY cityorder DESC , cityname, cityid");
	
		$rowcount = count($citylist);
		
		$strCityList = "";
		
		if ($rowcount > 0)
		{
			for($i=0;$i<$rowcount;$i++) 
			{	
				if(strtoupper($GCity)==$citylist[$i]['cityid'])
				{
					$strCityList .= "<option value='".$citylist[$i]['cityid']."-".$citylist[$i]['cityname']."' selected='selected'>".ucwords(strtolower($citylist[$i]['cityname']))."</option>";
				}
				else
				{	
					$strCityList .= "<option value='".$citylist[$i]['cityid']."-".$citylist[$i]['cityname']."'>".ucwords(strtolower($citylist[$i]['cityname']))."</option>";
				}
			}
		}
		unset($testclass);
		return $strCityList;	
	}
	
	
	
	
	
	
?>