<?php

class CompanyJson
{
        function filter_invalidCharacters($datatocheck='')
        {
            /* [Checking Invalid UTF8 Charcters] 
                � Rejects:- 1] 2 byte sequences and 
            *               2] Characters above U+10000 (ie. Unicode Char's having more than 4 digits)  
            *  Referred from :-  https://webcollab.sourceforge.io/unicode.html  
            */ 
            $filtered_data = preg_replace( '/[\x00-\x08\x10\x0B\x0C\x0E-\x19\x7F]'.
             
                                            '|(?<=^|[\x00-\x7F])[\x80-\xBF]+'.
                                            
                                            '|([\xC0\xC1]|[\xF0-\xFF])[\x80-\xBF]*'.
                                            
                                            '|[\xC2-\xDF]((?![\x80-\xBF])|[\x80-\xBF]{2,})'.
                                            
                                            '|[\xE0-\xEF](([\x80-\xBF](?![\x80-\xBF]))|(?![\x80-\xBF]{2})|[\x80-\xBF]{3,})/',
                                            
                                            ' ', $datatocheck );  
            return $filtered_data;
        }
        
        function getCertificates_intoJSON($companyid='')
        {   /*
                This function returns data into Array or Json
            */
            
            $alltable = new AllTables();
            
            $sql="select * from trncompanycertificates where companyid=$companyid";
            
            $data = $alltable->getInfo('',$sql);
            
            return $data; 
        }
        
        function getMedia_intoJSON($companyid='')
        {   /*
                This function returns data into Array or Json
            */
            
            $alltable = new AllTables();
            
            $sql="select * from trnusermedia where companyid=$companyid";
            
            $data = $alltable->getInfo('',$sql);
            
            return $data;
        }
        
        function getUsers_intoJSON($companyid='')
        {   /*
                This function returns data into Array or Json
            */
            
            $alltable = new AllTables();
            
            $sql="select * from mstusers where companyid=$companyid";
            
            $data = $alltable->getInfo('',$sql);
            
            return $data; 
        }
        
        
        function getCompanyProfiles_intoJSON($companyid='')
        {   /*
                This function returns data into Array or Json
            */
            
            $alltable = new AllTables();
            
            $sql="select * from trncompanyprofile where companyid=$companyid";
            
            $data = $alltable->getInfo('',$sql);
            
            return $data;  
        }
        
        function getCompanyVideos_intoJSON($companyid='')
        {   /*
                This function returns data into Array or Json
            */
            
            $alltable = new AllTables();
            
            $sql="select * from trncompanyvideo where companyid=$companyid";
            
            $data = $alltable->getInfo('',$sql); 
            
            return $data; 
        }
        
        function getCompanyAwards_intoJSON($companyid='')
        {   /*
                This function returns data into Array or Json
            */
            
            $alltable = new AllTables();
            
            $sql="select * from trncompanyawards where companyid=$companyid";
            
            $data = $alltable->getInfo('',$sql); 
            
            return $data; 
        }
        
        function getCompanyExhibition_intoJSON($companyid='')
        {   /*
                This function returns data into Array or Json
            */
            
            $alltable = new AllTables();
            
            $sql="select * from trncompanyexhibition where companyid=$companyid";
            
            $data = $alltable->getInfo('',$sql); 
            
            return $data;  
        }
        
        function getCompany_intoJSON($companyid='')
        {   /*
                This function returns data into Array or Json
            */
            
            $alltable = new AllTables();
            
            
            if($companyid !='')
            {
                $sql="select * from mstcompany where CompanyID=$companyid";    
            }
            else
            {
                $sql="select * from mstcompany limit 200";
                
            }
            
            $data = $alltable->getInfo('',$sql);
            $count = count($data);             
            
            for($i=0;$i<$count;$i++)           
            {
                $companyid = $data[$i]['CompanyID'];
                
                /// Filtering Activities Column for Invalid UTF8 Charcters 
                $data[$i]['Activities'] = $this->filter_invalidCharacters($data[$i]['Activities']);
                
                /// Media Array
                $mediaarray = $this->getMedia_intoJSON($companyid);
                if(!empty($mediaarray))
                {
                    $data[$i]['media_array'] = $mediaarray; 
                }
                
                /// Certificate Array
                $allCertificates = $this->getCertificates_intoJSON($companyid);
                if(!empty($allCertificates))
                {
                    $data[$i]['certificate_array'] = $allCertificates;
                }
                
                /// Users Array
                $allUsers = $this->getUsers_intoJSON($companyid);
                if(!empty($allUsers))
                {
                    $data[$i]['users_array'] = $allUsers;
                }
         
                /// Company profile Array
                $allProfiles = $this->getCompanyProfiles_intoJSON($companyid);
                if(!empty($allProfiles))
                {
                    $data[$i]['companyprofile_array'] = $allProfiles;
                }
           
                /// Company video Array
                $allVideos = $this->getCompanyVideos_intoJSON($companyid);
                if(!empty($allVideos))
                {
                    $data[$i]['companyvideo_array'] = $allVideos;
                }
                
                ///  Company awards Array
                $allAwards = $this->getCompanyAwards_intoJSON($companyid);
                if(!empty($allAwards))
                {
                    $data[$i]['companyawards_array'] = $allAwards;
                }
                
                
            }
                                                                                
            return $data;        
        }
        
        function getCompanyProdData($companyid='',$company_objectid='')
        {
            $alltable = new AllTables();
            
            if( $companyid !='' )
            {
                $sql="select * from trncompanyprod where CompanyID=$companyid"; 
            }
            else
            {
                $sql="select * from trncompanyprod ";
            }
            
            $data = $alltable->getInfo('',$sql);
            $count = count($data);
            
            for($i=0; $i<$count; $i++)
            {
                $data[$i]['ProductName_mstproduct'] = $this->filter_invalidCharacters($data[$i]['ProductName_mstproduct']);
                $data[$i]['specifications'] = $this->filter_invalidCharacters($data[$i]['specifications']);
                $data[$i]['ProductDesc'] = $this->filter_invalidCharacters($data[$i]['ProductDesc']); 
                
                if( $company_objectid!=null || $company_objectid!='' )
                {
                    $data[$i]['CompanyObjectId'] = $company_objectid;   
                }
            }
            
            return $data;       
        }
        
        
}
?>