<?php

require_once(GLOBAL_INCLUDE_PATH."imageUpload/upload_class.php");

error_reporting(E_ALL);
ini_set("memory_limit", "64M");
set_time_limit(60);

class Foto_upload extends file_upload {
	
	var $x_size;
	var $y_size;
	var $x_max_size = 300;
	var $y_max_size = 200;
	var $x_max_thumb_size = 110;
	var $y_max_thumb_size = 88;
	var $thumb_folder;
	var $foto_folder;
	var $larger_dim;
	var $larger_curr_value;
	var $larger_dim_value;
	var $larger_dim_thumb_value;
	
	
	var $use_image_magick = true; // switch between true and false
	// I suggest to use ImageMagick on Linux/UNIX systems, it works on windows too, but it's hard to configurate
	// check your existing configuration by your web hosting provider
	function convertToWebP($foto)
	{
		if ($this->use_image_magick) {
			$FileExtension = $this->get_extension($foto);
			if ($FileExtension!='.webp')
			{			
				$fotoToSave = str_replace($FileExtension, '.webp', $foto);
			//exec("/usr/bin/convert $filename -quality 50 -define webp:lossless=true $fotoToSave ");
				exec("/usr/bin/convert $foto -strip -quality 50 -define webp:lossless=true $fotoToSave ");
				return 1;
			}
			else 
			{
				return 0;
			}			
		}	
	}
	function process_image($landscape_only = false, $create_thumb = false, $delete_tmp_file = false, $compression = 85) {
		$filename = $this->upload_dir.$this->file_copy;
		$this->check_dir($this->thumb_folder); // run these checks to create not existing directories
		$this->check_dir($this->foto_folder); // the upload dir is created during the file upload (if not already exists)
		$thumb = $this->thumb_folder.$this->file_copy;
		$foto = $this->foto_folder.$this->file_copy;
		if ($landscape_only) {
			$this->get_img_size($filename);
			if ($this->y_size > $this->x_size) {
				$this->img_rotate($filename, $compression);
			}
		}
		$this->check_dimensions($filename); // check which size is longer then the max value
		if ($this->larger_curr_value > $this->larger_dim_value) {
			$this->thumbs($filename, $foto, $this->larger_dim_value, $compression);
		} else {
		    // convert input.jpg -gravity center -background white -extent 50x50  output.jpg
			exec("/usr/bin/convert $filename -strip -quality 50 -define webp:lossless=true $foto ");			
			//copy($filename, $foto);
		}
		if ($this->use_image_magick) {
			$FileExtension = $this->get_extension($foto);
			$fotoToSave = str_replace($FileExtension, '.webp', $foto);				
			//exec("/usr/bin/convert $filename -quality 50 -define webp:lossless=true $fotoToSave ");
			exec("/usr/bin/convert $foto -strip -quality 50 -define webp:lossless=true $fotoToSave ");
		}
		if ($create_thumb) {
			if ($this->larger_curr_value > $this->larger_dim_thumb_value) {
				$this->thumbs($filename, $thumb, $this->larger_dim_thumb_value, $compression); // finally resize the image
			} else {
				exec("/usr/bin/convert $filename -strip -quality 50 -define webp:lossless=true $thumb ");				
				//copy($filename, $thumb);
			}
		}
		if ($delete_tmp_file) $this->del_temp_file($filename); // note if you delete the tmp file the check if a file exists will not work
	}
	function create_marketing_image_with_logo($orgImage,$CompanyName,$left,$top,$logofilename,$logoleft='',$logotop='')
	{
	    if ($this->use_image_magick) {
	        
	        $FileExtension = $this->get_extension($orgImage);
	        $foto = $this->upload_dir.$orgImage;
	        $CompanyNameinImage = str_replace(' ','-',str_replace(':','',$CompanyName));
	        $fotoToSave = $this->foto_folder.$CompanyNameinImage.'-'.$orgImage;
	        $logoname = str_replace($this->get_extension($logofilename),'',$logofilename);
	        $fileToSaveWithLogo  = $this->foto_folder.$CompanyNameinImage.'-'.$logoname.'-'.$orgImage;
	        $logopath = $this->foto_folder.$logofilename;
	        
	        // exec("/usr/bin/convert -strokewidth 0 -fill \"rgba( 255, 255, 255 , 5 )\" -draw 'rectangle 0,0 500,33' -font helvetica -pointsize 16 -fill black -draw \"text 150,30 '$CompanyName'\" $foto $fotoToSave "); 
	        if($orgImage=='Digital_Invite_Final_Anufood.jpg')
	        {
	            // for combining logo 
	            // /usr/bin/convert /home/anufoodindia/public_html/images_temp/images/Hall4-Booth-NoH2-Digital_Invite_Final_Anufood.jpg /home/anufoodindia/public_html/images_temp/images/blank_img.png -geometry 100x100+203+224 -composite /home/anufoodindia/public_html/images_temp/images/Hall-4-StallNo-22-Digital_Invite_Final_Anufood-logo.jpg
	            exec("/usr/bin/convert -pointsize 25 -fill black -density 80 -draw \"text $left,$top '$CompanyName'\" $foto $fotoToSave ");
	            $logoleft = ($logoleft =='')?'203':$logoleft;
	            $logotop  = ($logotop =='')? '224':$logotop;
	            exec("/usr/bin/convert $fotoToSave $logopath -geometry 100x100+$logoleft+$logotop -composite $fileToSaveWithLogo ");
	        }
	        else
	        {
	            exec("/usr/bin/convert -pointsize 20 -fill black -density 60 -draw \"text $left,$top '$CompanyName'\" $foto $fotoToSave ");
	            $logoleft = ($logoleft =='')?'351':$logoleft;
	            $logotop  = ($logotop =='')? '320':$logotop;
	            exec("/usr/bin/convert $fotoToSave $logopath -geometry 100x100+$logoleft+$logotop -composite $fileToSaveWithLogo ");
	        }
            // echo $this->file_copy = "/usr/bin/convert -strokewidth 0 -fill '#0008' -draw 'rectangle 0,0 500,33' -font helvetica -pointsize 12 -fill white -draw \"text $left,$top '$CompanyName'\" $foto $fotoToSave ";
            
            // exec("/usr/bin/convert $foto -gravity North -background '#0008'  -splice 0x18 -font helvetica -pointsize 16 -fill white -annotate +0+2  '$CompanyName' $fotoToSave ");
            // exec("/usr/bin/montage -label \"$CompanyName\"  $foto -font Candice -pointsize 18 -geometry +0+0 -background Gold $fotoToSave ");
            
            //new function adde 1 /4/22
            // exec("/usr/bin/convert -background '#0008' -fill white -gravity center -size 400x30 caption:'$CompanyName' $foto  +swap -gravity north -composite  $fotoToSave ");
		    /*
		    width=`identify -format %w dragon.gif`; 
            convert -background '#0008' -fill white -gravity center -size ${width}x30 \
            caption:"Faerie Dragons love hot apple pies\!" \
            dragon.gif +swap -gravity south -composite  anno_caption.jpg
		    */  
		    
		    $this->file_copy = $CompanyNameinImage.'-'.$logoname.'-'.$orgImage;
	    }
	}
	function create_marketing_image($orgImage,$CompanyName,$left,$top)
	{
	    if ($this->use_image_magick) {
	        
	        $FileExtension = $this->get_extension($orgImage);
	        $foto = $this->upload_dir.$orgImage;
	        $CompanyNameinImage = str_replace(' ','-',str_replace(':','',$CompanyName));
	        $fotoToSave = $this->foto_folder.$CompanyNameinImage.'-'.$orgImage;
	        // exec("/usr/bin/convert -strokewidth 0 -fill \"rgba( 255, 255, 255 , 5 )\" -draw 'rectangle 0,0 500,33' -font helvetica -pointsize 16 -fill black -draw \"text 150,30 '$CompanyName'\" $foto $fotoToSave "); 
	        if($orgImage=='Digital_Invite_Final_Anufood.jpg')
	        {
	            exec("/usr/bin/convert -pointsize 25 -fill black -density 80 -draw \"text $left,$top '$CompanyName'\" $foto $fotoToSave ");
          
	        }
	        else
	        {
	            exec("/usr/bin/convert -pointsize 20 -fill black -density 60 -draw \"text $left,$top '$CompanyName'\" $foto $fotoToSave ");
	        }
            // echo $this->file_copy = "/usr/bin/convert -strokewidth 0 -fill '#0008' -draw 'rectangle 0,0 500,33' -font helvetica -pointsize 12 -fill white -draw \"text $left,$top '$CompanyName'\" $foto $fotoToSave ";
            
            // exec("/usr/bin/convert $foto -gravity North -background '#0008'  -splice 0x18 -font helvetica -pointsize 16 -fill white -annotate +0+2  '$CompanyName' $fotoToSave ");
            // exec("/usr/bin/montage -label \"$CompanyName\"  $foto -font Candice -pointsize 18 -geometry +0+0 -background Gold $fotoToSave ");
            
            //new function adde 1 /4/22
            // exec("/usr/bin/convert -background '#0008' -fill white -gravity center -size 400x30 caption:'$CompanyName' $foto  +swap -gravity north -composite  $fotoToSave ");
		    /*
		    width=`identify -format %w dragon.gif`; 
            convert -background '#0008' -fill white -gravity center -size ${width}x30 \
            caption:"Faerie Dragons love hot apple pies\!" \
            dragon.gif +swap -gravity south -composite  anno_caption.jpg
		    */  
		    
		    $this->file_copy = $CompanyNameinImage.'-'.$orgImage;
	    }
	}
	function process_pdf($create_thumb = false, $delete_tmp_file = true) {
		$filename = $this->upload_dir.$this->file_copy;
		$this->check_dir($this->thumb_folder); // run these checks to create not existing directories
		$this->check_dir($this->foto_folder); // the upload dir is created during the file upload (if not already exists)
		
		$thumb = $this->thumb_folder.$this->file_copy;
		$foto = $this->foto_folder.$this->file_copy;
		
		copy($filename, $foto);
		if ($create_thumb) {
			exec("convert \"{$foto}[0]\" -colorspace RGB -geometry 100 $thumb");
			copy($filename, $thumb);
		}
		if ($delete_tmp_file) $this->del_temp_file($filename); // note if you delete the tmp file the check if a file exists will not work
	}
	function get_img_size($file) {
		$img_size = getimagesize($file);
		$this->x_size = $img_size[0];
		$this->y_size = $img_size[1];
	}
	function check_dimensions($filename) {
		$this->get_img_size($filename);
		$x_check = $this->x_size - $this->x_max_size;
		$y_check = $this->y_size - $this->y_max_size;
		if ($x_check < $y_check) {
			$this->larger_dim = "y";
			$this->larger_curr_value = $this->y_size;
			$this->larger_dim_value = $this->y_max_size;
			$this->larger_dim_thumb_value = $this->y_max_thumb_size;
		} else {
			$this->larger_dim = "x";
			$this->larger_curr_value = $this->x_size;
			$this->larger_dim_value = $this->x_max_size;
			$this->larger_dim_thumb_value = $this->x_max_thumb_size;
		}
	}
	function img_rotate($wr_file, $comp) {
		$new_x = $this->y_size;
		$new_y = $this->x_size;
		if ($this->use_image_magick) {
			exec(sprintf("mogrify -rotate 90 -quality %d %s", $comp, $wr_file));
			//mogrify -strip input.jpg 
		} else {
			$src_img = imagecreatefromjpeg($wr_file);
			$rot_img = imagerotate($src_img, 90, 0);
			$new_img = imagecreatetruecolor($new_x, $new_y);
			imageantialias($new_img, TRUE);
			imagecopyresampled($new_img, $rot_img, 0, 0, 0, 0, $new_x, $new_y, $new_x, $new_y);
			imagejpeg($new_img, $this->upload_dir.$this->file_copy, $comp);
		}
	}
	function thumbs($file_name_src, $file_name_dest, $target_size, $quality = 80) {
		//print_r(func_get_args());
		$size = getimagesize($file_name_src);
		if ($this->larger_dim == "x") {
			$w = number_format($target_size, 0, ',', '');
			$h = number_format(($size[1]/$size[0])*$target_size,0,',','');
		} else {
			$h = number_format($target_size, 0, ',', '');
			$w = number_format(($size[0]/$size[1])*$target_size,0,',','');
		}
		if ($this->use_image_magick) {
			exec(sprintf("/usr/bin/convert -strip -interlace Plane -compress LossLess %s -resize %dx%d -quality %d %s", $file_name_src, $w, $h, 100, $file_name_dest));
		} else {
			$dest = imagecreatetruecolor($w, $h);
			imageantialias($dest, TRUE);
			$src = imagecreatefromjpeg($file_name_src);
			imagecopyresampled($dest, $src, 0, 0, 0, 0, $w, $h, $size[0], $size[1]);
			imagejpeg($dest, $file_name_dest, $quality);
		}
	}
}
?>