<?php

// commented by rajiv on 5th apr 2025 to avoid warning in error file "Undefined array key "SCRIPT_NAME"
// if (!isset($_SERVER["REQUEST_URI"])) $_SERVER["REQUEST_URI"] = (isset($_SERVER["QUERY_STRING"]))? "{$_SERVER["SCRIPT_NAME"]}?{$_SERVER["QUERY_STRING"]}" : $_SERVER["SCRIPT_NAME"];

function array_stripslashes($string){
	if (is_array($string)){
		foreach ($string as $key=>$value) $string[$key] = array_stripslashes($value);
	}else{
		$string = stripslashes($string);
	};
	return $string;
};
/* commented by rajiv to see if there is any adverse effect on 18th jan 2021
if (get_magic_quotes_gpc()){
	$_GET = array_stripslashes($_GET);
	$_POST = array_stripslashes($_POST);
	if (phpversion() > "4.0.6") $_COOKIE = array_stripslashes($_COOKIE);
	else $_HTTP_COOKIE_VARS = array_stripslashes($_HTTP_COOKIE_VARS);
};
if (@count($_GET)) extract($_GET);
if (@count($_POST)) extract($_POST);

ini_set("register_globals", "Off");
$dir = "https://".$_SERVER['HTTP_HOST']; //.$_SERVER['REQUEST_URI'];
//$dir = substr($dir,0,strrpos($dir, "/"))."/";
if (is_array($_GET) || is_array($_POST)){
	if ($_SERVER["REQUEST_METHOD"] == "POST"){
		extract($_POST);
	}else{
		extract($_GET);
	};
};
*/

/*
function handler($data_type, $data_string, $data_file, $data_line, $data_varible){
	global $err;
	$err = $err + 1;
};

function check_error(&$error){
	global $err;
	if($err>0){
		$error = true;
		$err = 0;
	};
};
set_error_handler("handler");
*/
$rare_characters = "";
$usual_characters = "aeiou  ";
function convert($text){
	global $rare_characters;
	global $usual_characters;
	$text = strtolower($text);
	for ($x = 0; $x < strlen($rare_characters); $x++){
		$text = str_replace(substr($rare_characters,$x,1),substr($usual_characters,$x,1),$text);
	};
	for ($x = 0; $x < strlen($text); $x++){
		if (urlencode(substr($text,$x,1)) != substr($text,$x,1) & substr($text,$x,1) != ""){
			$text = str_replace(substr($text,$x,1)," ",$text);
		};
	};
	while(strpos($text,"  ")){
		$text = str_replace("  "," ",$text);
	};
	$text = trim($text);
	return $text;
};
// commented temporarily by rajiv on 21st oct 2022 for converting the site to php 8
function matchvalues($text,$term,$max){
	$array_texts = split(" ",$text);
	$array_terms = split(" ",$term);
	for ($x = 0; $x < count($array_terms); $x++){
		for ($y = 0; $y < count($array_texts); $y++){
			if ($array_terms[$x] == $array_texts[$y]){
				$matchs += 1;
				break;
			};
		};
	};
	$score = $matchs * 2 * $max / (count($array_terms) + count ($array_texts));
	$score = (int) $score;
	return $score;
};

function sort_results($array1, $array2){
	if ($array1["score"] == $array2["score"]){ return 0; };
	return ($array1["score"] > $array2["score"] ? -1 : 1);
};
function convert_url($url){
	//$url = strtolower($url);
	if(strpos($url,"http") === false){
		$url = "http://" . $url;
	};
	return $url;
};
function convert_keywords($keywords){
	$keywords = strtolower($keywords);
	$keywords = str_replace(","," ",$keywords);
	$keywords = str_replace("  "," ",$keywords);
	return $keywords;
};
function parse_input($text){
//	if (get_magic_quotes_gpc()) $text = stripslashes($text);
	if (function_exists("mysql_escape_string")) $text = mysql_escape_string($text);
	return $text;
};
function parse_output($text){
	$text = str_replace('\"',"&#34;",$text);
	$text = str_replace('\\\'',"'",$text);
	$text = str_replace('<',"&lt;",$text);
	$text = str_replace('>',"&gt;",$text);
	return $text;
}
$month_names = array ("","January","February","March","April","May","June","July","August","September","October","November","December");


function datediff($per,$d1,$d2)
{ 
 //  print "d2 : $d2<br>";
 //  print "d1 : $d1<br>";
   
   $d = strtotime($d2)-strtotime($d1); 
	
   switch($per)
   {
	  case "yyyy":
            $d  = $d*=12*7/365.25; 
            break;
        case "w":
            $d  = $d/=604800;           
            break;			 
   } 
   //print round($d);
   return round($d);    
       
} 

 function datediffNew($interval, $datefrom, $dateto, $using_timestamps = false) {
 /*
 $interval can be:
 yyyy - Number of full years
 q - Number of full quarters
 m - Number of full months
 y - Difference between day numbers
 (eg 1st Jan 2004 is "1", the first day. 2nd Feb 2003 is "33". The datediff is "-32".)
 d - Number of full days
 w - Number of full weekdays
 ww - Number of full weeks
 h - Number of full hours
 n - Number of full minutes
 s - Number of full seconds (default)
 */
    if (($dateto=='')&&($datefrom==''))
    {
        return 0;
    }    
    if ((!$using_timestamps)&&($datefrom!='')&&($dateto!='')) {
        $datefrom = strtotime($datefrom, 0);
        $dateto = strtotime($dateto, 0);
    }
 $difference = intval($dateto) - intval($datefrom); // Difference in seconds

 switch($interval) {

 case 'yyyy': // Number of full years
  
 $years_difference = floor($difference / 31536000);
 if (mktime(date("H", $datefrom), date("i", $datefrom), date("s", $datefrom), date("n", $datefrom), date("j", $datefrom), date("Y", $datefrom)+$years_difference) > $dateto) {
 $years_difference--;
 }
 if (mktime(date("H", $dateto), date("i", $dateto), date("s", $dateto), date("n", $dateto), date("j", $dateto), date("Y", $dateto)-($years_difference+1)) > $datefrom) {
 $years_difference++;
 }
 $datediff = $years_difference;
 break;
  
 case "q": // Number of full quarters
  
 $quarters_difference = floor($difference / 8035200);
 while (mktime(date("H", $datefrom), date("i", $datefrom), date("s", $datefrom), date("n", $datefrom)+($quarters_difference*3), date("j", $dateto), date("Y", $datefrom)) < $dateto) {
 $months_difference++;
 }
 $quarters_difference--;
 $datediff = $quarters_difference;
 break;
  
 case "m": // Number of full months
  
 $months_difference = floor($difference / 2678400);
 while (mktime(date("H", $datefrom), date("i", $datefrom), date("s", $datefrom), date("n", $datefrom)+($months_difference), date("j", $dateto), date("Y", $datefrom)) < $dateto) {
 $months_difference++;
 }
 $months_difference--;
 $datediff = $months_difference;
 break;
  
 case 'y': // Difference between day numbers
  
 $datediff = date("z", $dateto) - date("z", $datefrom);
 break;
  
 case "d": // Number of full days
  
 $datediff = floor($difference / 86400);
 break;
  
 case "w": // Number of full weekdays
  
 $days_difference = floor($difference / 86400);
 $weeks_difference = floor($days_difference / 7); // Complete weeks
 $first_day = date("w", $datefrom);
 $days_remainder = floor($days_difference % 7);
 $odd_days = $first_day + $days_remainder; // Do we have a Saturday or Sunday in the remainder?
 if ($odd_days > 7) { // Sunday
 $days_remainder--;
 }
 if ($odd_days > 6) { // Saturday
 $days_remainder--;
 }
 $datediff = ($weeks_difference * 5) + $days_remainder;
 break;
  
 case "ww": // Number of full weeks
  
 $datediff = floor($difference / 604800);
 break;
  
 case "h": // Number of full hours
  
 $datediff = floor($difference / 3600);
 break;
  
 case "n": // Number of full minutes
  
 $datediff = floor($difference / 60);
 break;
  
 default: // Number of full seconds (default)
  
 $datediff = $difference;
 break;
 }
  
 return $datediff;
  
 }
  
 

/*
function formatdate($date1,$dateformat)
{
	
	$string = $date1; 	
	{
		$string = $date1; 	
		$stringArray = explode("-", $string); 

		$date = mktime(0,0,0,$stringArray[1],$stringArray[2],$stringArray[0]); 

		$converteddate = date($dateformat, $date); 
		return ($converteddate);    	 
	}
}
*/
function formatdate_new($date1,$dateformat="d-m-Y")
{
    $date = date_create($date1);
	$converteddate = date_format($date,$dateformat); 
    return $converteddate;
}
function formatdate($date1,$dateformat="d-m-Y")
{
	$string = $date1; 	
	if ($string > "1900-12-30")
	{
		$string = $date1; 	
		$stringArray = explode("-", $string); 
        if (is_array($stringArray))
        {
		    $date = mktime(0,0,0,intval($stringArray[1]),intval($stringArray[2]),intval($stringArray[0])); 
            $converteddate = date($dateformat, $date);
        }
		return ($converteddate);    	 
	}
}

function format_number($strAmount)
{ 		

	list($OrgAmount)= split ('[.]', $strAmount);	
	
	// -- If Decimal Amount is Blank Then Make It '00 ---- ////
	
//	if ($DotAmount =='')
//	{
		$DotAmount ='00';
//	}	    
    // -- End Decimal Amount
    
    $strlength	 = strlen($OrgAmount);			// Length Of Amount 
        
    if ($strlength >'0')
    {
		if ($strlength == '1')
		{
			$a = substr($OrgAmount,"0","1");
			$strAm ="$a.$DotAmount";					
			return($strAm); 					
		}
		else if ($strlength =='2')
		{
			$a = substr($OrgAmount,"0","2");
			$strAm ="$a.$DotAmount";					
			return($strAm); 					
		}
		else if ($strlength =='3')
		{
			$a = substr($OrgAmount,"0","3");
			$strAm ="$a.$DotAmount";					
			return($strAm); 				
		}
		else if ($strlength =='4')
		{
			$b = substr($OrgAmount,"1","3");
			$a = substr($OrgAmount,"0","1");
			$strAm ="$a,$b.$DotAmount";					
			return($strAm); 		
		}
		else if ($strlength =='5')
		{
			$b = substr($OrgAmount,"2","3");
			$a = substr($OrgAmount,"0","2");
			$strAm ="$a,$b.$DotAmount";					
			return($strAm); 				
		}
		else if ($strlength =='6')
		{
			$c = substr($OrgAmount,"3","3");
			$b = substr($OrgAmount,"1","2");
			$a = substr($OrgAmount,"0","1");
			$strAm ="$a,$b,$c.$DotAmount";					
			return($strAm); 		
		}
		else if ($strlength =='7')
		{
			$c = substr($OrgAmount,"4","3");
			$b = substr($OrgAmount,"2","2");
			$a = substr($OrgAmount,"0","2");
			$strAm ="$a,$b,$c.$DotAmount";					
			return($strAm); 
							
		}
		else if ($strlength =='8')
		{
			$d = substr($OrgAmount,"5","3");
			$c = substr($OrgAmount,"3","2");
			$b = substr($OrgAmount,"1","2");
			$a = substr($OrgAmount,"0","1");
			$strAm ="$a,$b,$c,$d.$DotAmount";					
			return($strAm); 		
		}
		else if ($strlength =='9')
		{
			$d = substr($OrgAmount,"6","3");
			$c = substr($OrgAmount,"4","2");
			$b = substr($OrgAmount,"2","2");
			$a = substr($OrgAmount,"0","2");
			$strAm ="$a,$b,$c,$d.$DotAmount";					
			return($strAm); 
		}
		else if ($strlength =='10')
		{	
			$e = substr($OrgAmount,"7","3");
			$d = substr($OrgAmount,"5","2");
			$c = substr($OrgAmount,"3","2");
			$b = substr($OrgAmount,"1","2");
			$a = substr($OrgAmount,"0","1");
			
			$strAm ="$a,$b,$c,$d,$e.$DotAmount";					
			return($strAm); 
		}
		else if ($strlength =='11')
		{
			$e = substr($OrgAmount,"8","3");
			$d = substr($OrgAmount,"6","2");
			$c = substr($OrgAmount,"4","2");
			$b = substr($OrgAmount,"2","2");
			$a = substr($OrgAmount,"0","2");
			$strAm ="$a,$b,$c,$d,$e.$DotAmount";					
			return($strAm); 
		}		
	}
}

/** highlite text.src contents
 * Perform a simple text replace
 * This should be used when the string does not contain HTML
 * (off by default)
 */
define('STR_HIGHLIGHT_SIMPLE', 1);
/* end of highlite.src */
/* start of various_script.src */

/*
class Script_Timer
{
  function __construct()
  {
       return true;
  }
   
  public static function Start_Timer ()
   {
        if (!defined(TIMER_START_TIME))
        {
            define ("TIMER_START_TIME", microtime());
        }
       return true;
  }
  public static function Get_Time ($decimals=2)
   {
       // $decimals will set the number of decimals you want for your milliseconds.

       // format start time
       $start_time = explode (" ", TIMER_START_TIME);
       $start_time = $start_time[1] + $start_time[0];
       // get and format end time
       $end_time = explode (" ", microtime());
       $end_time = $end_time[1] + $end_time[0];
       
       return number_format ($end_time - $start_time, $decimals);
   }
}
*/

 function insert($pairs,$table) { // method for inserting record to the database 
    $SQL="INSERT INTO $table ("; 
    $first=true; 
    foreach ($pairs as $key=>$value) { 
        if ($key!="id" || $key!="title" || $key!="submit") { // everything except record ID,title,submit 
        if ($first)  { 
            $value="\"".$value; 
            $first=false; 
        }else { 
            $key=",".$key; 
            $value=",\"".$value; 
        } 
        $fields.=$key; 
        $values.=$value."\""; 
        } 
    } 
    $SQL.=$fields.") VALUES(".$values.")"; 
    // Your database code here ... 
    return $SQL;
    } 

    function update($pairs,$table) { // method for updating records in the database 
    $SQL="UPDATE $table SET "; 
    $first=true; 
    foreach ($pairs as $key=>$value) { 
        if ($key!="id" || $key!="title" || $key!="submit") { // everything except record ID,title,submit 
        if ($first)  { 
            $SQL.="$key=\"$value\""; 
            $first=false; 
        }else { 
            $SQL.=",$key=\"$value\""; 
        } 
        } 
    } 
    $SQL.=" WHERE id=$pairs[id]"; 
    // Your database code here ... 
    } 

    function delete($id,$table) { // method for deleting record from a table 
    $SQL="DELETE FROM $table WHERE id=$id"; 
    $db->query($SQL); 
    // Your database code here ... 
    } 
 
function strProper($str) {
   $noUp = array('a','an','of','the','are','at','in');
   $str = trim($str);
   $str = strtoupper($str[0]) . strtolower(substr($str, 1));
   for($i=1; $i<strlen($str)-1; ++$i) {
       if($str[$i]==' ') {
           for($j=$i+1; $j<strlen($str) && $str[$j]!=' '; ++$j); //find next space
           $size = $j-$i-1;
           $shortWord = false;
           if($size<=3) {
               $theWord = substr($str,$i+1,$size);
               for($j=0; $j<count($noUp) && !$shortWord; ++$j)
                   if($theWord==$noUp[$j])
                       $shortWord = true;
           }
           if( !$shortWord )
               $str = substr($str, 0, $i+1) . strtoupper($str[$i+1]) . substr($str, $i+2);
       }    
       $i+=$size;
   }
   return $str;
} 

function replaceForURL($strOrgUrl)
{
    $ReturnURL ='';
    if ($strOrgUrl!='')
    {
	    $strOrgUrl = trim($strOrgUrl);
        // addition by rajiv on 20th sept 2024 to enhance the function and add hyphen
	    //$ReturnURL = str_replace("-","d0a",$strOrgUrl);
	
	    $ReturnURL = str_replace(" ","-",$strOrgUrl);
	    $ReturnURL = str_replace("&amp;","_and_",$ReturnURL);
	    $ReturnURL = str_replace("&","_and_",$ReturnURL);
	    $ReturnURL = str_replace("%2F","_s_",$ReturnURL);
	    $ReturnURL = str_replace("/","_s_",$ReturnURL);
	    $ReturnURL = str_replace("\\","",$ReturnURL);
	    $ReturnURL = str_replace("(","_bb_",$ReturnURL);
	    $ReturnURL = str_replace(")","_rbrb_",$ReturnURL);
	    $ReturnURL = str_replace("&#40;","_bb_",$ReturnURL);
	    $ReturnURL = str_replace("&#41;","_rbrb_",$ReturnURL);
	    $ReturnURL = str_replace("#40;","_bb_",$ReturnURL);
	    $ReturnURL = str_replace("#41;","_rbrb_",$ReturnURL);
	    $ReturnURL = str_replace("#45;","-",$ReturnURL);
	    $ReturnURL = str_replace("\"","",$ReturnURL);
	    $ReturnURL = str_replace("\'","",$ReturnURL);
	    $ReturnURL = str_replace("#","_",$ReturnURL);
	    $ReturnURL = str_replace("?","",$ReturnURL);
	    $ReturnURL = str_replace(".","",$ReturnURL);
	    $ReturnURL = strtolower(str_replace("%","",$ReturnURL));
	    return $ReturnURL;
    }
}

function replaceFromURL($strURL)
{
	$replaceURL = str_replace("-&amp;-"," & ",$strURL);
	$replaceURL = str_replace("&amp;"," & ",$strURL);
	$replaceURL = str_replace("_and_"," & ",$replaceURL);
	$replaceURL = str_replace("_n_"," & ",$replaceURL);
	$replaceURL = str_replace("%26"," & ",$replaceURL);
	$replaceURL = str_replace("_s_","/",$replaceURL);
	$replaceURL = str_replace("--"," & ",$replaceURL);
	$replaceURL = str_replace("_bb_","(",$replaceURL);
	$replaceURL = str_replace("_rbrb_",")",$replaceURL);
	$replaceURL = str_replace("rbrb",")",$replaceURL);
	$replaceURL = str_replace("-"," ",$replaceURL);
	$replaceURL = str_replace("_"," ",$replaceURL);
	
	
	// addition by rajiv on 15th may 2024 to enhance this function
	$replaceURL = str_replace('_s_',' and ',$replaceURL);
	$replaceURL = str_replace('&&','',$replaceURL);
	$replaceURL = str_replace('& &','',$replaceURL);
	$replaceURL = str_replace('&#40;','',$replaceURL);
	$replaceURL = str_replace('&#41;','',$replaceURL);
    $replaceURL = str_replace('&#45;','-',$replaceURL);
    $replaceURL = str_replace('  ',' ',$replaceURL);
    
    // addition by rajiv on 20th sept 2024 to enhance the function and add hyphen
    // $replaceURL = str_replace('d0a','-',$replaceURL);
    
    $findArray = array('  ');
    $replaceArray = array(' ');
    
    $replaceURL = str_replace($findArray,$replaceArray,$replaceURL);
    
    $pattern = '~([A-Za-z0-9])\1\1+~';
    $replaceURL = preg_replace($pattern,'\1',$replaceURL);
    // commented by rajiv on 27th june 2025 to avoid accidental duplicates like 'Agar Agar'
    // $replaceURL = preg_replace('/\b(\S+)(?:\s+\1\b)+/i', "$1", $replaceURL);
    // as per chatgpt suggestion allowing only 2 repeats
    $replaceURL = preg_replace('/\b(\S+)(?:\s+\1\b){2,}/i', "$1", $replaceURL);
    
    // remove multiple white spaces with one with below function
    // $replaceURL = preg_replace('!\s+!', ' ', $replaceURL);
	
	// $replaceURL = htmlspecialchars_decode($replaceURL, ENT_NOQUOTES);
	return $replaceURL;
}

function getUserIP()
	{
	if ( getenv( 'HTTP_CLIENT_IP' ) ){
			$userip = getenv( 'HTTP_CLIENT_IP' );
		}
		else if ( getenv( 'HTTP_X_FORWARDED_FOR' ) )	{
			$userip = getenv( 'HTTP_X_FORWARDED_FOR' );
		}
		else if ( getenv( 'HTTP_CF_IPCOUNTRY' ) )	{
			$userip = getenv( 'HTTP_CF_IPCOUNTRY' );
		}
		else {
			$userip = getenv( 'REMOTE_ADDR' );
		}
		return $userip;	
	}


///////////////////////////////////////
// sanitize.inc.php
// Sanitization functions for PHP
// by: Gavin Zuchlinski, Jamie Pratt, Hokkaido
// webpage: http://libox.net
// Last modified: September 27, 2003
//
// Many thanks to those on the webappsec list for helping me improve these functions
///////////////////////////////////////
// Function list:
// sanitize_paranoid_string($string) -- input string, returns string stripped of all non 
//           alphanumeric
// sanitize_system_string($string) -- input string, returns string stripped of special
//           characters
// sanitize_sql_string($string) -- input string, returns string with slashed out quotes
// sanitize_html_string($string) -- input string, returns string with html replacements
//           for special characters
// sanitize_int($integer) -- input integer, returns ONLY the integer (no extraneous 
//           characters
// sanitize_float($float) -- input float, returns ONLY the float (no extraneous 
//           characters)
// sanitize($input, $flags) -- input any variable, performs sanitization 
//           functions specified in flags. flags can be bitwise 
//           combination of PARANOID, SQL, SYSTEM, HTML, INT, FLOAT, LDAP, 
//           UTF8
///////////////////////////////////////
define("PARANOID", 1);
define("SQL", 2);
define("SYSTEM", 4);
define("HTML", 8);
define("INT", 16);
define("FLOAT", 32);
define("LDAP", 64);
define("UTF8", 128);

// internal function for utf8 decoding
// thanks to Jamie Pratt for noticing that PHP's function is a little 
// screwy

function my_utf8_decode($string)
{
return strtr($string, 
  "???????¥µÀÁÂÃÄÅÆÇÈÉÊËÌÍÎÏÐÑÒÓÔÕÖØÙÚÛÜÝßàáâãäåæçèéêëìíîïðñòóôõöøùúûüýÿ", 
  "SOZsozYYuAAAAAAACEEEEIIIIDNOOOOOOUUUUYsaaaaaaaceeeeiiiionoooooouuuuyy");
}

// paranoid sanitization -- only let the alphanumeric set through
function sanitize_paranoid_string($string, $min='', $max='')
{
  $string = ($string!='')?preg_replace("/[^a-zA-Z0-9]/", "", $string):'';
  $len = strlen($string);
  if((($min != '') && ($len < $min)) || (($max != '') && ($len > $max)))
    return FALSE;
  return $string;
}

// sanitize a string in prep for passing a single argument to system() (or similar)
function sanitize_system_string($string, $min='', $max='')
{
  $pattern = '/(;|\||`|>|<|&|^|"|'."\n|\r|'".'|{|}|[|]|\)|\()/i'; // no piping, passing possible environment variables ($),
                           // seperate commands, nested execution, file redirection, 
                           // background processing, special commands (backspace, etc.), quotes
                           // newlines, or some other special characters
  $string = preg_replace($pattern, '', $string);
  $string = '"'.preg_replace('/\$/', '\\\$', $string).'"'; //make sure this is only interpretted as ONE argument
  $len = strlen($string);
  if((($min != '') && ($len < $min)) || (($max != '') && ($len > $max)))
    return FALSE;
  return $string;
}

// sanitize a string for SQL input (simple slash out quotes and slashes)
function sanitize_sql_string($string, $min='', $max='')
{
  $pattern[0] = '/(\\\\)/';
  $pattern[1] = "/\"/";
  $pattern[2] = "/'/";
  $replacement[0] = '\\\\\\';
  $replacement[1] = '\"';
  $replacement[2] = "\\'";
  
  $len = ($string!='')?strlen($string):0;
  if((($min != '') && ($len < $min)) || (($max != '') && ($len > $max)))
    return FALSE;
    if ($string!='')
    {
        return preg_replace($pattern, $replacement, $string);
    }
}

// sanitize a string for SQL input (simple slash out quotes and slashes)
function sanitize_ldap_string($string, $min='', $max='')
{
  $pattern = '/(\)|\(|\||&)/';
  $len = strlen($string);
  if((($min != '') && ($len < $min)) || (($max != '') && ($len > $max)))
    return FALSE;
  return preg_replace($pattern, '', $string);
}


// sanitize a string for HTML (make sure nothing gets interpretted!)
function sanitize_html_string($string)
{
  if ($string!='')
  {
  $pattern[0] = '/\&/';
  $pattern[1] = '/</';
  $pattern[2] = "/>/";
  $pattern[3] = '/\n/';
  $pattern[4] = '/"/';
  $pattern[5] = "/'/";
  $pattern[6] = "/%/";
  $pattern[7] = '/\(/';
  $pattern[8] = '/\)/';
  $pattern[9] = '/\+/';
  $pattern[10] = '/-/';
  $replacement[0] = '&amp;';
  $replacement[1] = '&lt;';
  $replacement[2] = '&gt;';
  $replacement[3] = '<br>';
  $replacement[4] = '&quot;';
  $replacement[5] = '&#39;';
  $replacement[6] = '&#37;';
  $replacement[7] = '&#40;';
  $replacement[8] = '&#41;';
  $replacement[9] = '&#43;';
  $replacement[10] = '&#45;';
    return preg_replace($pattern, $replacement, $string);
  }
  else
  {
      return '';
  }
}

// make int int!
function sanitize_int($integer, $min='', $max='')
{
  $int = intval($integer);
  if((($min != '') && ($int < $min)) || (($max != '') && ($int > $max)))
    return FALSE;
  return $int;
}

// make float float!
function sanitize_float($float, $min='', $max='')
{
  $float = floatval($float);
  if((($min != '') && ($float < $min)) || (($max != '') && ($float > $max)))
    return FALSE;
  return $float;
}

// glue together all the other functions
function sanitize($input, $flags, $min='', $max='')
{
  if($flags & UTF8) $input = my_utf8_decode($input);
  if($flags & PARANOID) $input = sanitize_paranoid_string($input, $min, $max);
  if($flags & INT) $input = sanitize_int($input, $min, $max);
  if($flags & FLOAT) $input = sanitize_float($input, $min, $max);
  if($flags & HTML) $input = sanitize_html_string($input, $min, $max);
  if($flags & SQL) $input = sanitize_sql_string($input, $min, $max);
  if($flags & LDAP) $input = sanitize_ldap_string($input, $min, $max);
  if($flags & SYSTEM) $input = sanitize_system_string($input, $min, $max);
  return $input;
}

function preview_text($TEXT, $LIMIT, $TAGS = 0,$START=0) {

    $STOP =0;
    $RETURN ='';
    // TRIM TEXT
    $TEXT = ($TEXT!='')?trim($TEXT):'';

    // STRIP TAGS IF PREVIEW IS WITHOUT HTML
    if ($TAGS == 0) $TEXT = preg_replace('/\s\s+/', ' ', strip_tags($TEXT));

    // IF STRLEN IS SMALLER THAN LIMIT RETURN
    if (strlen($TEXT) < $LIMIT) return $TEXT;

    if ($TAGS == 0) return substr($TEXT, 0, $LIMIT) . " ...";
    else {

        $COUNTER = 0;
        for ($i = $START; $i<= strlen($TEXT); $i++) {

            if ($TEXT[$i] == "<") $STOP = 1;

            if ($STOP != 1) {

                $COUNTER++;
            }

            if ($TEXT[$i] == ">") $STOP = 0;
            $RETURN .= $TEXT[$i];

            if ($COUNTER >= $LIMIT && $TEXT[$i] == " ") break;

        }

        return $RETURN . "...";
    }
}

function sanitizeFileNameForURL($string, $force_lowercase = true, $anal = false) {
    $strip = array("~", "`", "!", "@", "#", "$", "%", "^", "&", "*", "(", ")", "_", "=", "+", "[", "{", "]",
                   "}", "\\", "|", ";", ":", "\"", "'", "&#8216;", "&#8217;", "&#8220;", "&#8221;", "&#8211;", "&#8212;",
                   "â€”", "â€“", ",", "<", ".", ">", "/", "?");
    $clean = trim(str_replace($strip, "", strip_tags($string)));
    $clean = preg_replace('/\s+/', "-", $clean);
    $clean = ($anal) ? preg_replace("/[^a-zA-Z0-9]/", "", $clean) : $clean ;
    return ($force_lowercase) ?
        (function_exists('mb_strtolower')) ?
            mb_strtolower($clean, 'UTF-8') :
            strtolower($clean) :
        $clean;
}

function ProperCase($strToConvert)
	{
	    $strToReturn ='';
	    if ($strToConvert!='')
	    {
		    $strToReturn = ucwords(strtolower($strToConvert));
	    }
		return $strToReturn;
	
	}

function title_case($title) {
        $smallwordsarray = array(
            'of','a','the','and','an','or','nor','but','is','if','then',
'else','when',
            'at','from','by','on','off','for','in','out',
'over','to','into','with','LLC','FZE','FZC'
        );

        $words = explode(' ', $title);
        foreach ($words as $key => $word)
        {
            if ($key == 0 or !in_array($word, $smallwordsarray))
            $words[$key] = ProperCase($word);
        }

        $newtitle = implode(' ', $words);
        return $newtitle;
    } 
    
   
function ago($datefrom,$dateto=-1)
    {
        // Defaults and assume if 0 is passed in that
        // its an error rather than the epoch
   
        if($datefrom==0) { return "A long time ago"; }
        if($dateto==-1) { $dateto = time(); }
       
        // Make the entered date into Unix timestamp from MySQL datetime field

        $datefrom = strtotime($datefrom);
   
        // Calculate the difference in seconds betweeen
        // the two timestamps

        $difference = $dateto - $datefrom;

        // Based on the interval, determine the
        // number of units between the two dates
        // From this point on, you would be hard
        // pushed telling the difference between
        // this function and DateDiff. If the $datediff
        // returned is 1, be sure to return the singular
        // of the unit, e.g. 'day' rather 'days'
   
        switch(true)
        {
            // If difference is less than 60 seconds,
            // seconds is a good interval of choice
            case(strtotime('-1 min', $dateto) < $datefrom):
                $datediff = $difference;
                $res = ($datediff==1) ? $datediff.' second ago' : $datediff.' seconds ago';
                break;
            // If difference is between 60 seconds and
            // 60 minutes, minutes is a good interval
            case(strtotime('-1 hour', $dateto) < $datefrom):
                $datediff = floor($difference / 60);
                $res = ($datediff==1) ? $datediff.' minute ago' : $datediff.' minutes ago';
                break;
            // If difference is between 1 hour and 24 hours
            // hours is a good interval
            case(strtotime('-1 day', $dateto) < $datefrom):
                $datediff = floor($difference / 60 / 60);
                $res = ($datediff==1) ? $datediff.' hour ago' : $datediff.' hours ago';
                break;
            // If difference is between 1 day and 7 days
            // days is a good interval               
            case(strtotime('-1 week', $dateto) < $datefrom):
                $day_difference = 1;
                while (strtotime('-'.$day_difference.' day', $dateto) >= $datefrom)
                {
                    $day_difference++;
                }
               
                $datediff = $day_difference;
                $res = ($datediff==1) ? 'yesterday' : $datediff.' days ago';
                break;
            // If difference is between 1 week and 30 days
            // weeks is a good interval           
            case(strtotime('-1 month', $dateto) < $datefrom):
                $week_difference = 1;
                while (strtotime('-'.$week_difference.' week', $dateto) >= $datefrom)
                {
                    $week_difference++;
                }
               
                $datediff = $week_difference;
                $res = ($datediff==1) ? 'last week' : $datediff.' weeks ago';
                break;           
            // If difference is between 30 days and 365 days
            // months is a good interval, again, the same thing
            // applies, if the 29th February happens to exist
            // between your 2 dates, the function will return
            // the 'incorrect' value for a day
            case(strtotime('-1 year', $dateto) < $datefrom):
                $months_difference = 1;
                while (strtotime('-'.$months_difference.' month', $dateto) >= $datefrom)
                {
                    $months_difference++;
                }
               
                $datediff = $months_difference;
                $res = ($datediff==1) ? $datediff.' month ago' : $datediff.' months ago';

                break;
            // If difference is greater than or equal to 365
            // days, return year. This will be incorrect if
            // for example, you call the function on the 28th April
            // 2008 passing in 29th April 2007. It will return
            // 1 year ago when in actual fact (yawn!) not quite
            // a year has gone by
            case(strtotime('-1 year', $dateto) >= $datefrom):
                $year_difference = 1;
                while (strtotime('-'.$year_difference.' year', $dateto) >= $datefrom)
                {
                    $year_difference++;
                }
               
                $datediff = $year_difference;
                $res = ($datediff==1) ? $datediff.' year ago' : $datediff.' years ago';
                break;
               
        }
        return $res;    
	}
	
	function get_rnd_iv($iv_len)
	{
	    $iv = '';
	    while ($iv_len-- > 0) {
	        $iv .= chr(mt_rand() & 0xff);
	    }
	    return $iv;
	}
	
	function md5_encrypt($plain_text, $iv_len = 16)
	{
		$password  = PASSWORD_SALT;
		$plain_text .= "\x13";
		$n = strlen($plain_text);
		if ($n % 16) $plain_text .= str_repeat("\0", 16 - ($n % 16));
		$i = 0;
		$enc_text = get_rnd_iv($iv_len);
		$iv = substr($password ^ $enc_text, 0, 512);
		while ($i < $n) 
		{
			$block = substr($plain_text, $i, 16) ^ pack('H*', md5($iv));
			$enc_text .= $block;
			$iv = substr($block . $iv, 0, 512) ^ $password;
			$i += 16;
		}
		return base64_encode($enc_text);
	}

	function md5_decrypt($enc_text,  $iv_len = 16)
	{	
		$password  = PASSWORD_SALT;
		$enc_text = base64_decode($enc_text);
		$n = strlen($enc_text);
		$i = $iv_len;
		$plain_text = '';
		$iv = substr($password ^ substr($enc_text, 0, $iv_len), 0, 512);
		while ($i < $n) {
			$block = substr($enc_text, $i, 16);
			$plain_text .= $block ^ pack('H*', md5($iv));
			$iv = substr($block . $iv, 0, 512) ^ $password;
			$i += 16;
		}
		return preg_replace('/\\x13\\x00*$/', '', $plain_text);
	}
	
	function randomBanner($bannerList)
	{
		if (is_array($bannerList))
		{
			$bannercount = count($bannerList);
			$num = rand (1,$bannercount);
			return $bannerList[$num];
		}
	}

	
	/*------------------------------------------------------------------------------
	 * Delete file 
	 * Returns success or failure
	_______________________________________________________________________________*/
	function deleteFile($fileNameToDelete)
	{
		$old = getcwd(); // Save the current directory
		
		$path_parts = pathinfo($fileNameToDelete);
		$path_to_file = $path_parts['dirname'];
		
		chdir($path_to_file);
		
		if (!unlink($fileNameToDelete)) {
			chdir($old); // Restore the old working directory    
			return false;
		} 
		else
		{
			chdir($old); // Restore the old working directory
			return true;
		}
	}
	
	function make_bitly_url($url,$login,$appkey,$format = 'xml',$version = '2.0.1')
	{
	  //create the URL
	  $bitly = 'http://api.bit.ly/shorten?version='.$version.'&longUrl='.urlencode($url).'&login='.$login.'&apiKey='.$appkey.'&format='.$format;
	  
	  //get the url
	  //could also use cURL here
	  $response = file_get_contents($bitly);
	  
	  //parse depending on desired format
	  if(strtolower($format) == 'json')
	  {
		$json = @json_decode($response,true);
		return $json['results'][$url]['shortUrl'];
	  }
	  else //xml
	  {
		$xml = simplexml_load_string($response);
		return 'http://bit.ly/'.$xml->results->nodeKeyVal->hash;
	  }
	}

/* usage */
//$short = make_bitly_url('http://davidwalsh.name','rajivatre','R_883f6492512b8e7ea6690715dcfae09a','json');		


	function badWordFilter($data){
		$originals = array("douche","punch","damn");
		$replacements = array("friend","love","wow");
		$data = str_ireplace($originals,$replacements,$data);
		return $data;
	}
	/*
	$myData = "Hi douche, damn I want to punch you for a good cause!";
	$cleaned = badWordFilter($myData);
	echo $cleaned;
	*/


/**
* Remove any non-ASCII characters and convert known non-ASCII characters
* to their ASCII equivalents, if possible.
*
* @param string $string
* @return string $string
* @author Jay Williams <myd3.com>
* @license MIT License
* @link http://gist.github.com/119517
*/
function convert_ascii($string)
{
// Replace Single Curly Quotes
$search[] = chr(226).chr(128).chr(152);
$replace[] = "'";
$search[] = chr(226).chr(128).chr(153);
$replace[] = "'";
 
// Replace Smart Double Curly Quotes
$search[] = chr(226).chr(128).chr(156);
$replace[] = '"';
$search[] = chr(226).chr(128).chr(157);
$replace[] = '"';
 
// Replace En Dash
$search[] = chr(226).chr(128).chr(147);
$replace[] = '--';
 
// Replace Em Dash
$search[] = chr(226).chr(128).chr(148);
$replace[] = '---';
 
// Replace Bullet
$search[] = chr(226).chr(128).chr(162);
$replace[] = '*';
 
// Replace Middle Dot
$search[] = chr(194).chr(183);
$replace[] = '*';
 
// Replace Ellipsis with three consecutive dots
$search[] = chr(226).chr(128).chr(166);
$replace[] = '...';
 
// Apply Replacements
$string = str_replace($search, $replace, $string);
 
// Remove any non-ASCII Characters
$string = preg_replace("/[^\x01-\x7F]/","", $string);
 
return $string;
}
// functions for dealer / distributor modules

		function returnTradePartnerType($typeid)
			{
				switch($typeid){
					case '0':
						$TradePartnerType = 'Franchise';
						break;
					case '1':
						$TradePartnerType = 'Franchise Partner';
						break;
					case '2':
						$TradePartnerType = 'Dealer / Distributor';
						break;
					case '3':
						$TradePartnerType = 'Retailer';
						break;
					case '4':
						$TradePartnerType = 'International Trade Partner';
						break;
					case '5':
						$TradePartnerType = 'Importer';
						break;
					case '6':
						$TradePartnerType = 'Exporter';
						break;		
				}
				return $TradePartnerType;
			}
			function returnInvestmentNumber($invNumber)
			{
				//$investmentcapacity
				switch($invNumber){
					case '999999':
						$TradePartnerType = 'upto 1 Million ';
						break;
					case '1999999':
						$TradePartnerType = '1 to 2 Millions ';
						break;
					case '4999999':
						$TradePartnerType = '2 to 5 Millions ';
						break;
					case '9999999':
						$TradePartnerType = '5 to 10 Millions ';
						break;
					case '10000001':
						$TradePartnerType = 'More than 10 Millions ';
						break;
					case '0':
						$TradePartnerType = 'No Minimum Investment Required';
						break;
				}	
				return $TradePartnerType;
			}
			
	function desanitize_html($string)
	{
  		$pattern[0] = '&';
  		$pattern[1] = '<';
  		$pattern[2] = ">";
  		$pattern[4] = '"';
  		$pattern[5] = "'";
  		$pattern[6] = "%";
  		$pattern[7] = '(';
  		$pattern[8] = ')';
  		$pattern[9] = '+';
  		$pattern[10] = '-';
  		$replacement[0] = '/\&amp;/';
  		$replacement[1] = '/\&lt;/';
  		$replacement[2] = '/\&gt;/';
  		$replacement[4] = '/\&quot;/';
  		$replacement[5] = '/\&#39;/';
  		$replacement[6] = '/\&#37;/';
  		$replacement[7] = '/\&#40;/';
  		$replacement[8] = '/\&#41;/';
  		$replacement[9] = '/\&#43;/';
  		$replacement[10] = '/\&#45;/';
        
        //Below code commented and added by Ketaki for products detail page 10 May 2021
        //return strip_tags(preg_replace($replacement,$pattern,$string));
        $arrayfortags = "<p></p><table></table><tr></tr><th></th><td></td><ul></ul><li></li><i></i><u></u><b></b><ol></ol><div></div>";
        return strip_tags(preg_replace($replacement,$pattern,$string),$arrayfortags);
}
/* end of various_scripts.src  */
 
/**
 * Only match whole words in the string
 * (off by default)
 */
define('STR_HIGHLIGHT_WHOLEWD', 2);
 
/**
 * Case sensitive matching
 * (off by default)
 */
define('STR_HIGHLIGHT_CASESENS', 4);
 
/**
 * Overwrite links if matched
 * This should be used when the replacement string is a link
 * (off by default)
 */
define('STR_HIGHLIGHT_STRIPLINKS', 8);
 
/**
 * Highlight a string in text without corrupting HTML tags
 *
 * @author      Aidan Lister <aidan@php.net>
 * @version     3.1.1
 * @param       string          $text           Haystack - The text to search
 * @param       array|string    $needle         Needle - The string to highlight
 * @param       bool            $options        Bitwise set of options
 * @param       array           $highlight      Replacement string
 * @return      Text with needle highlighted
 */
function str_highlight($text, $needle, $options = null, $highlight = null)
{
    // Default highlighting
    if ($highlight === null) {
        $highlight = '<strong>\1</strong>';
        //$highlight = '<span class="searchword">\1</span>';
    }
 
    // Select pattern to use
    if ($options & STR_HIGHLIGHT_SIMPLE) {
        $pattern = '#(%s)#';
        $sl_pattern = '#(%s)#';
    } else {
        $pattern = '#(?!<.*?)(%s)(?![^<>]*?>)#';
        $sl_pattern = '#<a\s(?:.*?)>(%s)</a>#';
    }
 
    // Case sensitivity
    if (!($options & STR_HIGHLIGHT_CASESENS)) {
        $pattern .= 'i';
        $sl_pattern .= 'i';
    }
 
    $needle = (array) $needle;
    foreach ($needle as $needle_s) {
        $needle_s = preg_quote($needle_s);
 
        // Escape needle with optional whole word check
        if ($options & STR_HIGHLIGHT_WHOLEWD) {
            $needle_s = '\b' . $needle_s . '\b';
        }
 
        // Strip links
        if ($options & STR_HIGHLIGHT_STRIPLINKS) {
            $sl_regex = sprintf($sl_pattern, $needle_s);
            $text = preg_replace($sl_regex, '\1', $text);
        }
		
        $regex = sprintf($pattern, $needle_s);
        $text = preg_replace($regex, $highlight, $text);
    }
 
    return $text;
}

function checkIfNullDate($dateToCheck)
	{
		$returndate='';
		if ($dateToCheck =='01-01-1970' || $dateToCheck =='0000-00-00' || $dateToCheck =='1970-01-01 00:00:00' || $dateToCheck =='0000-00-00 00:00:00' || $dateToCheck =='30-11--0001' || $dateToCheck =='00:00:00')
		{
			$returndate =null;
		}
		else 
		{
			$returndate =$dateToCheck;
		}	
		return $returndate;
	}