<?php
/*
 * This PHP implementation by Carlos Averett (cyt0plas-k-geoip.d8024e@t28.net)
 * 
 * This work is hereby released into the Public Domain. To view a copy of the public 
 * domain dedication, visit http://creativecommons.org/licenses/publicdomain/
 * or send a letter to Creative Commons, 559 Nathan Abbott Way, Stanford,
 * California 94305, USA.
 *
 * Installation: create the cache directory cache/geo, and make sure the server 
 * has write access to it.
 * 
 * A sample function, getGeoText() has been included, and should hopefully
 * demonstrate how to use this script.  If you choose to use this function,
 * make sure this file is included _before_ any content or headers are sent.
 */

// ======================================================================
// Sample code to display the geo targeting without the country code, and
// give the user a chance to correct makes
// ======================================================================

// If this is included at the start of a PHP script, it will handle wrong
// location entries.  This will also clear the cache.
if (isset($_GET['geoRedir']) && $_GET['geoRedir'])
	doGeoRedir();

function getGeoText($ip='') {
global $_GCountry;
global $_GCity;
	
	// Pull in the remote data
	if ($ip=='')
	{
		$geo = getGeoIP();
	}
	else
	{
		$geo = getGeoIP($ip);
	}	

	// If the country is unknown, leave it alone, else remove the (XX) code.
	if (strpos ($geo['Country'], '?') === FALSE)
		$country = ucwords ( strtolower( ereg_replace
			(' \([^\)]+)', '', $geo['Country'])));
	else
		$country = $geo['Country'];

	//return sprintf ('Country = %s <br/> ' .
	//	      'City = %s <br/>', $country, $geo['City'] );
	
	$_GCountry = $country;
	$_GCity = $geo['City'];
}


// ======================================================================
// End Sample Display Code
// ======================================================================

function doGeoRedir () {
	// If the user says their location is incorrect, clear the cache
	// and forward them to the correction page.
	
	// Get the subnet
	$ip = $_SERVER['REMOTE_ADDR'];
	$subnet = substr($ip, 0, strrpos ($ip, '.'));
	
	// Remove the cache file
	$cacheFile = 'cache/geo/' . $subnet . '.sub';
	unlink ($cacheFile);

	// Redirect
	header ('HTTP/1.1 301 Moved Permanently');
	header ('Location: http://hostip.info/correct.html');
	exit();
}

function getGeoIP ($ip = '') {

	// If $ip is empty, use remote addr
	if ( !strlen ( $ip ) )
		$ip = $_SERVER['REMOTE_ADDR'];

	// First off, we only want the subnet
	// changed by rajiv subnet is not working for city
	//$subnet = substr($ip, 0, strrpos ($ip, '.'));

	// Check if it's cachedA
	$cacheFile = '/home/dubaiyel/public_html/admin/geo/' . $ip . '.sub';

	// If it's cached, run the cache
	if (file_exists($cacheFile)) {
		include_once($cacheFile);

		// Has the cache expired?
		if (time() > $_GEO_CACHE['expire']) {
			// Delete the cache, and unset it.
			unlink ($cacheFile);
			unset ($_GEO_CACHE);
		}
	}
	
	if ( !isset($_GEO_CACHE) ) {
		// Expire after 1 week
		$expire = time() + (60 * 60 * 24 * 7);

		$alltext = '';
		
		$fd = fopen ('http://api.hostip.info/get_html.php?ip=' . $ip , 'r');
		while ($line = fgets ($fd, 1024))
			$alltext .= $line;
		fclose ($fd);
		$tokens = split ("[:\n]", $alltext);
	
		$_GEO_CACHE = array ($tokens[0] => $tokens[1], $tokens[2] => $tokens[3],$tokens[4] => $tokens[5], 'expire' => $expire);
		
		// Now write the cache
		$fp = fopen ($cacheFile, 'w');
		fputs ($fp, '<?php $_GEO_CACHE = unserialize("' . addslashes (serialize($_GEO_CACHE)) . '"); ?>');
		fclose ($fp);
	}
		
	// Show the output
	return $_GEO_CACHE;
}
?>