<?php
// Optimized and PHP 8.1+ safe version
class dbopenconn
{
    public $connection;
    public $db;
    private $connected = false;

    public function __construct()
    {
        $this->connection = mysqli_connect("127.0.0.1", DB_USER, DB_PASS);
        if (!$this->connection) {
            die("Database connection failed");
        }

        mysqli_set_charset($this->connection, "utf8mb4");

        $this->db = mysqli_select_db($this->connection, DB_NAME);
        if (!$this->db) {
            die("Could not select the database in dbopenconn");
        }

        $this->connected = mysqli_connect_errno() === 0;
    }

    public function dbconnect()
    {
        if (!$this->connected) {
            $this->connection = mysqli_connect("127.0.0.1", DB_USER, DB_PASS);
            mysqli_set_charset($this->connection, "utf8mb4");
            $this->db = mysqli_select_db($this->connection, DB_NAME);
            $this->connected = mysqli_connect_errno() === 0;
        }
    }

    public function dbdisconnect()
    {
        // Optional: mysqli_close($this->connection);
    }

    public function get_result($sql, $types = null, $params = null)
    {
        $stmt = $this->connection->prepare($sql);
        if (!$stmt) {
            return false;
        }

        if ($types && $params && is_array($params)) {
            $stmt->bind_param($types, ...$params);
        }

        if (!$stmt->execute()) {
            return false;
        }

        return $stmt->get_result();
    }

    public function get_result($sql, $types = null, $params = null)
    {
        $stmt = $this->connection->prepare($sql);
        if (!$stmt) {
            return false;
        }

        if ($types && $params && is_array($params)) {
            $stmt->bind_param($types, ...$params);
        }

        if (!$stmt->execute()) {
            return false;
        }

        return $stmt->get_result();
    }

    public function select_query($sqltext, $parameters = null, $parametertype = null)
    {
        if ($sqltext == '') return false;

        if (is_array($parameters)) {
            $stmt = $this->connection->prepare($sqltext);
            if (!$stmt) {
                trigger_error('Prepare failed: ' . $this->connection->error, E_USER_ERROR);
            }
            $stmt->bind_param($parametertype, ...$parameters);
            $stmt->execute();
            return $stmt->get_result();
        } else {
            return mysqli_query($this->connection, $sqltext);
        }
    }

    public function insert_query_prepared($sql, $params, $types = '')
    {
        $result = ($print == "") ? mysqli_query($this->connection, $sqltext) : $sqltext;
        $last_id = $this->connection->insert_id;
        return $last_id > 0 ? $last_id : ($this->connection->error ?: false);
    }

    public function update_query_prepared($sql, $params, $types = '')
    {
        if ($types && $params) {
            $stmt = $this->connection->prepare($sql);
            if (!$stmt) return $this->connection->error;
            $stmt->bind_param($types, ...$params);
            return $stmt->execute();
        }
        return false;
    }

    public function delete_query($sqltext, $print = "")
    {
        return ($print == "") ? mysqli_query($this->connection, $sqltext) : $sqltext;
    }

    public function numRows($result)
    {
        return ($result !== true) ? mysqli_num_rows($result) : 0;
    }

    public function mysqliRaiseError($errno = null)
    {
        $error = mysqli_error($this->connection);
        error_log("MySQL Error" . ($errno ? " #$errno:" : ":") . " $error");
        return false;
    }
}

class CommonProc
{
    public $obj1;
    private $con;

    public function __construct()
    {
        $this->obj1 = new dbopenconn();
        $this->con = $this->obj1->dbconnect();
    }

    public function getResults($ID = '', $sql = '', $debugquery = '', $fields = '*', $tablename = '', $KeyName = '')
    {
        $sqltext = ($ID !== '') ? "SELECT $fields FROM $tablename WHERE $KeyName = '" . addslashes($ID) . "'" : $sql;
        $companies = $this->obj1->select_query($sqltext);
        $compstr = [];

        if ($companies) {
            $numrows = $this->obj1->numRows($companies);
            while ($row = mysqli_fetch_assoc($companies)) {
                $compstr[] = $row;
            }
        }
        return $compstr;
    }

    public function AddToTable($CompanyData, $TableName)
    {
        if (!is_array($CompanyData)) return false;

        $fields = array_keys($CompanyData);
        $placeholders = rtrim(str_repeat('?,', count($fields)), ',');
        $types = str_repeat('s', count($fields));
        $values = array_values($CompanyData);

        $sql = "INSERT INTO $TableName (" . implode(",", $fields) . ") VALUES ($placeholders)";
        $result = $this->obj1->insert_query_prepared($sql, $values, $types);
        return ($result == 1) ? "true" : "false";
    }

    public function EditToTable($data, $where, $table)
    {
        if (!is_array($data)) return false;

        $fields = array_keys($data);
        $types = str_repeat('s', count($data));
        $values = array_values($data);

        $setPart = implode('=?, ', $fields) . '=?';
        $sql = "UPDATE $table SET $setPart WHERE $where";

        $result = $this->obj1->update_query_prepared($sql, $values, $types);
        return ($result == 1) ? "true" : "false";
    }


    public function DeleteFromTable($value, $key, $table, $sql = '')
    {
        if ($sql != '') {
            $result = $this->obj1->delete_query($sql);
        } elseif ($value != '' && $key != '' && $table != '') {
            $sqltext = "DELETE FROM $table WHERE $key = '" . addslashes($value) . "'";
            $result = $this->obj1->delete_query($sqltext);
        } else {
            return false;
        }

        $this->obj1->dbdisconnect();
        return ($result == 1) ? "true" : "false";
    }

    public function disconnect_db()
    {
        $this->obj1->dbdisconnect();
    }
}

class Sphinx_dbopenconn
{
    private $Sphinx_connection;

    public function Sphinx_dbconnect()
    {
        $this->Sphinx_connection = mysqli_connect("127.0.0.1", "", "", "", 9306);
        if (!$this->Sphinx_connection) {
            echo "Sphinx connection failed: " . mysqli_connect_error();
            exit;
        }
    }

    public function Sphinx_dbdisconnect()
    {
        if ($this->Sphinx_connection) {
            $this->Sphinx_connection->close();
        }
    }

    public function select_query($sqltext, $print = "")
    {
        return ($print == "") ? mysqli_query($this->Sphinx_connection, $sqltext) : $sqltext;
    }

    public function numRows($result)
    {
        return ($result) ? mysqli_num_rows($result) : 0;
    }

    public function mysqliRaiseError($errno = null)
    {
        // Placeholder
    }
}
