<?php
	
	/*
		This class will be used for operations on Company related data
		mainly mstCompany table
	*/
	
	class Companies
	{
	
		function __construct()
		{
			$this->obj1 = new dbopenconn();
			$this->con = $this->obj1-> dbconnect();
		}
		
		// get list of or single compani(es) from database
		function getCompanies($CompanyID='',$sql='',$debugquery='',$fields='*')
		{
			if ($CompanyID!="")
			{
				$sqltext = "Select $fields from mstcompanies where companyid='".$CompanyID."'";
			}
			else if ($sql!="")
			{
				$sqltext = $sql;
			}
			else
			{
				$sqltext = "Select $fields from mstcompanies";
			}
			$companies = $this->obj1->select_query($sqltext);
			$compstr = array();
			if ($companies)
			{
				$numrows = $this->obj1->numRows($companies);
			}
			if ($numrows ==1)
			{
				while ($companylist = mysqli_fetch_assoc($companies))
				{
					$compstr[] = $companylist;
				}	
			}
			else if($numrows > 1)
			{
				while ($companylist = mysqli_fetch_assoc($companies))
				{
					$compstr[] = $companylist;
				}
			}
			return $compstr;
		
		}
		function getCompaniesForDropDown($sql)
		{
		
			$companies = $this->obj1->select_query($sql);
			
			if ($companies)
			{
				$numrows = $this->obj1->numRows($companies);
			}
			if ($numrows > 0)
			{
				$found = array();
				while ($companylist = mysqli_fetch_assoc($companies))
				{
				$found[] = array(
					"value" => $companylist['ProductName'], 
					"display" => $companylist['ProductName'],
				);
				}
				return $found;
			}	
		}
		
		
		// add company to database
		function AddCompany($CompanyData)
		{
		if (is_array($CompanyData)== false)
			{
				return false;
			}
			else
			{
				$fieldnames =  "(";
				$fieldvalues = "(";
				foreach ($CompanyData as $k => $v) 
				{
					
					$fieldnames .=  ($fieldnames=="(")?"$k":",$k";
					$fieldvalues .= ($fieldvalues=="(")?"'$v'":",'$v'";
				}
				$sqltext = "insert into mstcompany ".$fieldnames.") values ".$fieldvalues.")";
				//echo $sqltext;
				$applications = $this->obj1->insert_query($sqltext);
				
				return ($applications == 1)?"true":"false";
			}
		
		}
		
		function EditCompany($applicationdata,$wherecondition)
		{
			if (is_array($applicationdata)== false)
			{
				return false;
			}
			else
			{
				$fieldnamesvalues =  "set ";
				
				foreach ($applicationdata as $k => $v) 
				{
					$fieldnamesvalues .=  ($fieldnamesvalues =="set ")?"$k='$v'":",$k='$v'";
				}
				$sqltext = "update mstcompany ".$fieldnamesvalues." where ".$wherecondition ;
				//echo $sqltext;
				$applications = $this->obj1->update_query($sqltext);
				return ($applications == 1)?"true":"false";
				
			}
		}
		
		function DeleteCompany($applicationdata)
		{
			if($applicationdata)
			{
				$sqltext = "delete from mstcompany where companyid='".$applicationdata."'";
				$applications = $this->obj1->delete_query($sqltext);
				return ($applications == 1)?"true":"false";
			}
		
		}
		// this function checks if company has got sufficient credits
		function CheckCompanyEnquiriesCredit($companyid)
		{
			$sqltext = " Select enquirypackageid,enquiriesused,enquiriesclosingbalance from mstcompany where companyid='$companyid' ";
			$companies = self::getCompanies('',$sqltext);
			$applications = 0;
			if ($companies)
			{
				if ($companies[0]['enquirypackageid'] >0)
				{
					if ($companies[0]['enquiriesclosingbalance'] > 0)
					{
						$applications = 1;
					}
				}
				else
				{
					$applications = 1;
				}
			}
			return ($applications == 1)?1:0;
		}
		// this function returns enq balance out of total enquiries
		function CheckCompanyEnquiriesBalance($companyid)
		{
			$sqltext = " Select enquirypackageid,enquiriesopeningbalance,enquiriesused,enquiriesclosingbalance from mstcompany where companyid='$companyid' ";
			$companies = self::getCompanies('',$sqltext);
			$applications = 0;
			if ($companies)
			{
				if ($companies[0]['enquirypackageid'] >0)
				{
					$applications = $companies[0]['enquiriesopeningbalance'].'|'.$companies[0]['enquiriesused'].'|'.$companies[0]['enquiriesclosingbalance'];
				}
			}
			return $applications;
		}
		// this function adds enquiries to company account
		function AddCompanyEnquiries($companyid,$noofenquiries=0)
		{
			// take a count of enq from trnpaymentheader for companyid 
			// update sum of enq from trnpaymentheader to mstcompany table in enquiriesopeningbalance and enquiriesclosingbalance
			// check below query tomorrow
			
			$sqltext = "UPDATE mstcompany a INNER JOIN ( SELECT companyid, sum( enqpurchased ) AS totalenqpurchase FROM trnpaymentheader WHERE companyid = '$companyid' GROUP BY companyid )b ON a.companyid = b.companyid SET a.enquiriesopeningbalance = b.totalenqpurchase, enquiriesclosingbalance = totalenqpurchase - enquiriesused ";

			//$sqltext = "UPDATE mstcompany SET enquiriesopeningbalance =  CASE WHEN enquiriesopeningbalance = 0 THEN $noofenquiries ELSE enquiriesopeningbalance + $noofenquiries END , enquiriesclosingbalance =  CASE WHEN enquiriesclosingbalance = 0 THEN $noofenquiries ELSE enquiriesclosingbalance + $noofenquiries END where companyid='$companyid'";
			//echo $sqltext;
			$applications = $this->obj1->update_query($sqltext);
			//self::UpdateEnquiryBalanceToSession($noofenquiries,0);
			return ($applications == 1)?1:0;
		}
		// this function reduces one enquiry from company account
		function DeductOneEnquiryCredit($companyid)
		{
			$sqltext = "update mstcompany set enquiriesused = enquiriesused + 1, enquiriesclosingbalance = enquiriesclosingbalance-1 where companyid='$companyid'";
				//echo $sqltext;
			$applications = $this->obj1->update_query($sqltext);
			self::UpdateEnquiryBalanceToSession(0,1);
			return ($applications == 1)?1:0;
		}
		// this function is called to check if enquiry is already bought
		function isEnquiryAlreadyBought($offerid,$companyid)
		{
			$sqltext = "Select offerseenincp from trnofferstocompanies where companyid='$companyid' and offerid='$offerid'";
			$companies = $this->obj1->select_query($sqltext);
			$applications = 0;
			if ($companies)
			{
				$numrows = $this->obj1->numRows($companies);
			}
			if ($numrows > 0 )
			{
				while ($companylist = mysqli_fetch_assoc($companies))
				{
					$compstr[] = $companylist;
				}
				if ($compstr[0]['offerseenincp']=='1')
				{
					$applications = 1;
				}
				else 
				{
					// enquiry is there in 
					$applications = 2;
				}		
			}
			return $applications;
		}
		
		// this function is used when user is buying single enquiry from his quota
		function BuyEnquiry($offerid,$companyid)
		{
			$chkSufficientEnq = self::CheckCompanyEnquiriesCredit($companyid);
			
			if ($chkSufficientEnq==0)
			{
				$retval = 0;
			}
			else
			{
				// check if already bought 
				$chkEnqBought = self::isEnquiryAlreadyBought($offerid,$companyid);	
				// if not then add to trnofferstocompanies
				$todaysdate = date("Y-m-d H:s:i");
				if ($chkEnqBought==0)
				{
					// if enquiry is not bought then insert into trncompanyprod with ignore so if record is already present then there wont be another record inserted
					$sqltext = "insert ignore into trnofferstocompanies (offerid,companyid,offerseenincp,offerseenincpdatetime)values('$offerid', '$companyid','1','$todaysdate')";
					//$applications = self::getCompanies('',$sqltext);
					$applications = $this->obj1->update_query($sqltext);
					// update enquiry with companyid and offerseenincp = 1 so we can assume this enquiry is bought by client
					$sqltext = "update trnofferstocompanies set offerseenincp = '1',offerseenincpdatetime = '$todaysdate' where offerid ='$offerid' and companyid='$companyid'";
					//$applications = self::getCompanies('',$sqltext);
					$applications = $this->obj1->update_query($sqltext);
					// update mstcompany table to deduct 1 enquiry from total enquiries
					$sqltext = "update mstcompany set enquiriesused = enquiriesused + 1,enquiriesclosingbalance = enquiriesclosingbalance -1 where companyid='$companyid'";
					//echo $sqltext;
					//$applications = self::getCompanies('',$sqltext);
					$applications = $this->obj1->update_query($sqltext);
					self::UpdateEnquiryBalanceToSession(0,1);
					$retval = ($applications == 1)?1:0;
				}
				else if ($chkEnqBought==2)
				{
					$sqltext = "update trnofferstocompanies set offerseenincp = '1',offerseenincpdatetime = '$todaysdate' where offerid ='$offerid' and companyid='$companyid'";
					//$applications = self::getCompanies('',$sqltext);
					$applications = $this->obj1->update_query($sqltext);
					$sqltext = "update mstcompany set enquiriesused = enquiriesused + 1,enquiriesclosingbalance = enquiriesclosingbalance -1 where companyid='$companyid'";
					//echo $sqltext;
					//$applications = self::getCompanies('',$sqltext);
					$applications = $this->obj1->update_query($sqltext);
					self::UpdateEnquiryBalanceToSession(0,1);
					$retval = ($applications == 1)?1:0;	
				}
				else
				{
					$retval = 0;
				}
			}
			return $retval;
		}
		function UpdateEnquiryBalanceToSession($noofenquiriesAdded,$noofenquiriesUsed)
		{
			global $G_EnqOpeningBalance,$G_EnqUsed,$G_EnqClosingBalance;
			if ($noofenquiriesAdded > 0)
			{
				session::add_param('EnqOpeningBalance',intval($G_EnqOpeningBalance+$noofenquiriesAdded));
				$G_EnqOpeningBalance 	= intval($G_EnqOpeningBalance+$noofenquiriesAdded);
			}
			else if ($noofenquiriesUsed > 0)
			{
				session::add_param('EnqUsed',intval($EnqUsed+$noofenquiriesUsed));
				session::add_param('enquiriesclosingbalance',intval($enquiriesclosingbalance-$noofenquiriesUsed));
				$G_EnqUsed				= intval($EnqUsed+$noofenquiriesUsed);
				$G_EnqClosingBalance	= intval($enquiriesclosingbalance-$noofenquiriesUsed);
			}
		}
		function updatePayments($companyid,$packageid,$chequeno,$cheuqedate,$bankname,$branch,$depositeddate,$paymentgateway,$repid,$txnid,$razorpay_payment_id='',$razorpay_signature='')
		{
			// update trnpaymentheader
			$sql = "select * from trnpaymentheader where companyid='".$companyid."' and txnid='".$txnid."'";
			$payments = self::getCompanies('',$sql);
			
			if (!$payments)
			{
				$sqlpackages 		= "select * from mstpackages where packageid='".$packageid."'";
				$packagedetails	 	= self::getCompanies('',$sqlpackages);
				$packagerowcount 	= count($packagedetails);
					if ($packagerowcount > 0)
					{
						$package_name 	= $packagedetails[0]['packagename'];
						$package_desc 	= $packagedetails[0]['packagedesc'];

						$noofleads 		= $packagedetails[0]['noofenquiries'];
					
						if ($paymentgateway=='')
						{
							$onlinepayment ='0';
							$onlinepaymentamount ='0';
						}
						else if (strtoupper($paymentgateway)=='PAYU')
						{
							$localcurrency	= 'INR';
							$packageamountlocalcurrency	= $packagedetails[0]['packageamountINR'];
							$packagetaxamount			= $packagedetails[0]['taxamountindia'];
							$packagefinalamount			=  $packageamountlocalcurrency + $packagetaxamount;
						}
						else
						{
							$localcurrency	= $packagedetails[0]['localcurrency'];
							$packageamountlocalcurrency	= $packagedetails[0]['packageamountlocalcurrency'];
							$packagetaxamount			= 0;
							$packagefinalamount			=  $packageamountlocalcurrency + $packagetaxamount;
						}
						$packageamountUSD			= $packagedetails[0]['packageamountUSD'];
						$membershipperiodmonths		= $packagedetails[0]['membershipperiodmonths'];
					}
						$sql = "insert into trnpaymentheader
						(companyid, packageamountlocalcurrency, packageamountUSD, packageamount, packagediscountamount, packagefinalamount, packagedetails, resellerid, repid, packageid, paymentgatewayname, txnid, enqpurchased, razorpay_payment_id, razorpay_signature) 			values('$companyid','$localcurrency','$packageamountUSD','$packageamountlocalcurrency','','$packagefinalamount','$package_desc','','$repid','$packageid','$paymentgateway','$txnid','$noofleads', '$razorpay_payment_id', '$razorpay_signature')";

						$applications = $this->obj1->insert_query($sql);
						
						$sqltext = "Select paymentheaderid from trnpaymentheader where companyid='$companyid' and txnid='$txnid'";
						//echo $sqltext;
						$companies = $this->obj1->select_query($sqltext);
						$applications = 0;
						if ($companies)
						{
								while ($paymentlist = mysqli_fetch_assoc($companies))
								{
									$paymentheaderid = $paymentlist['paymentheaderid'];
								}
								//echo 'payment header id'.$paymentheaderid;
								// update trnpaymentdetails
								if ($paymentgateway!='')
								{
									$onlinepayment = '1';
								}
								$sql = "insert into trnpaymentdetails(paymentheaderid, chequeno, chequedate, chequeamount, bankname, branch, depositeddate, onlinepayment, onlinepaymentamount) values('$paymentheaderid', '$chequeno','$chequedate','$chequeamount','$bankname','$branch','$depositeddate','$onlinepayment','$packagefinalamount')";
								//echo $sql;
								$applications = $this->obj1->insert_query($sql);
							
						}	
			}
		}
		
	}
	
	/*
		Registration Class : This will be used for two reasons
		1) To manage mstregistration table
		2) To Validate Login everytime
		
	*/
	
	class UserRegistration
	{
		function __construct()
		{
			$this->obj1 = new dbopenconn();
			$this->con = $this->obj1->dbconnect();
		}
		// get list of or single compani(es) from database
		function getUserInfo($UserID='',$sql='',$fields='*')
		{
			if ($UserID!="")
			{
				$sqltext = "Select $fields from mstusers where userid='".$UserID."'";
			}
			else if ($sql!="")
			{
				$sqltext = $sql;
			}
			else
			{
				$sqltext = "Select $fields from mstusers";
			}
				
			$users = $this->obj1->select_query($sqltext);
			
			if ($users)
			{
				$numrows = $this->obj1->numRows($users);
			}
			$userstr = array();
			if ($numrows ==1)
			{
				while ($userlist = mysqli_fetch_assoc($users))
				{
					$userstr[] = $userlist;
				}	
			}
			else if($numrows > 1)
			{
				while ($userlist = mysqli_fetch_assoc($users))
				{
					$userstr[] = $userlist;
				}
			}
			return $userstr;
		}
		
		// add company to database
		function AddUser($UserData)
		{
		if (is_array($UserData)== false)
			{
				return false;
			}
			else
			{
				$fieldnames =  "(";
				$fieldvalues = "(";
				foreach ($UserData as $k => $v) 
				{
					
					$fieldnames .=  ($fieldnames=="(")?"$k":",$k";
					$fieldvalues .= ($fieldvalues=="(")?"'$v'":",'$v'";
				}
				$sqltext = "insert into mstusers ".$fieldnames.") values ".$fieldvalues.")";
				//echo $sqltext;
				$applications = $this->obj1->insert_query($sqltext);
				return ($applications == 1)?"true":"false";
			}
		}
		
		function EditUser($applicationdata,$wherecondition)
		{
			if (is_array($applicationdata)== false)
			{
				return false;
			}
			else
			{
				$fieldnamesvalues =  "set ";
				
				foreach ($applicationdata as $k => $v) 
				{
					$fieldnamesvalues .=  ($fieldnamesvalues =="set ")?"$k='$v'":",$k='$v'";
				}
				$sqltext = "update mstusers ".$fieldnamesvalues." where ".$wherecondition ;
				//echo $sqltext;
				$applications = $this->obj1->update_query($sqltext);
				return ($applications == 1)?"true":"false";
				
			}
		
		}
		
		function DeleteUser($applicationdata)
		{
			if($applicationdata)
			{
				$sqltext = "delete from mstusers where userid='".$applicationdata."'";
				$applications = $this->obj1->delete_query($sqltext);
				return ($applications == 1)?"true":"false";
			}
		
		}
		
		// this function will be called to validate login everytime
		function ValidateLogin($username,$password,$ip='')
		{
			$returnvalue = "0";
			if (($username!='')&&($password!=''))
				{
					$userid = getUserInfo("","","select userid from mstusers where username='".$username."' and userpassword='".$password."' and userdeleted='0'");
					if ($userid[0]['userid']!="")
					{
						return $userid[0]['userid'];
					}
					else 
					{
						return $returnvalue;
					}
				}
			else
			{
				return $returnvalue;
			}	
		}
	}
	
	
	/*
		This class will be used for operations on Company related data
		mainly trnCompanyProduct table
	*/
	class CompanyProducts
	{
		function __construct()
		{
			$this->obj1 = new dbopenconn();
			$this->con = $this->obj1-> dbconnect();
		}
		// get Products for the Company
		function getCompanyProducts($CompanyProductID='',$sql='',$fields='*')
		{
			if ($CompanyProductID!="")
			{
				$sqltext = "Select $fields from trncompanyproduct where companyproductid='".$CompanyProductID."'";
			}
			else if ($sql!="")
			{
				$sqltext = $sql;
			}
			else
			{
				$sqltext = "Select $fields from trncompanyproduct limit 0,50";
			}
				
			$companyprod = $this->obj1->select_query($sqltext);
			$compprodstr = array();
			if ($companyprod)
			{
				$numrows = $this->obj1->numRows($companyprod);
			}
			
			if ($numrows ==1)
			{
				while ($companyprodlist = mysqli_fetch_assoc($companyprod))
				{
					$compprodstr[] = $companyprodlist;
				}	
			}
			else if($numrows > 1)
			{
				while ($companyprodlist = mysqli_fetch_assoc($companyprod))
				{
					$compprodstr[] = $companyprodlist;
				}
			}
			return $compprodstr;
		
		}
		function AddCompanyProducts($CompanyData)
		{
		if (is_array($CompanyData)== false)
			{
				return false;
			}
			else
			{
				$fieldnames =  "(";
				$fieldvalues = "(";
				foreach ($CompanyData as $k => $v) 
				{
					
					$fieldnames .=  ($fieldnames=="(")?"$k":",$k";
					$fieldvalues .= ($fieldvalues=="(")?"'$v'":",'$v'";
				}
				$sqltext = "insert into trncompanyproduct ".$fieldnames.") values ".$fieldvalues.")";
				//echo $sqltext;
				$applications = $this->obj1->insert_query($sqltext);
				return ($applications == 1)?"true":"false";
			}
		
		}
		
		function EditCompanyProducts($applicationdata,$wherecondition)
		{
			if (is_array($applicationdata)== false)
			{
				return false;
			}
			else
			{
				$fieldnamesvalues =  "set ";
				
				foreach ($applicationdata as $k => $v) 
				{
					$fieldnamesvalues .=  ($fieldnamesvalues =="set ")?"$k='$v'":",$k='$v'";
				}
				$sqltext = "update trncompanyproduct ".$fieldnamesvalues." where ".$wherecondition ;
				//echo $sqltext;
				$applications = $this->obj1->update_query($sqltext);
				return ($applications == 1)?"true":"false";
				
			}
		}
		function DeleteCompanyProducts($applicationdata)
		{
			if($applicationdata)
			{
				$sqltext = "delete from trncompanyproduct where companyproductid='".$applicationdata."'";
				$applications = $this->obj1->delete_query($sqltext);
				return ($applications == 1)?"true":"false";
			}
		
		}
	}
	
	/*
		This class will be used for operations on Company related data
		mainly trnCompanyProfile table
	*/
	
	class CompanyProfile
	{
		function __construct()
		{
			$this->obj1 = new dbopenconn();
			$this->con = $this->obj1-> dbconnect();
		}
		function GetCompanyProfile($CompanyProfileID='',$sql='',$debugquery='',$fields='*')
		{
			if ($CompanyProfileID!="")
			{
				$sqltext = "Select $fields from trncompanyprofile where companyprofileid='".$CompanyProfileID."'";
			}
			else if ($sql!="")
			{
				$sqltext = $sql;
			}
			
			$companies = $this->obj1->select_query($sqltext);
			$compstr = array();
			if ($companies)
			{
				$numrows = $this->obj1->numRows($companies);
			}
			if ($numrows ==1)
			{
				while ($companylist = mysqli_fetch_assoc($companies))
				{
					$compstr[] = $companylist;
				}	
			}
			else if($numrows > 1)
			{
				while ($companylist = mysqli_fetch_assoc($companies))
				{
					$compstr[] = $companylist;
				}
			}
			return $compstr;
		
		}
		function AddCompanyProfile($CompanyData)
		{
		if (is_array($CompanyData)== false)
			{
				return false;
			}
			else
			{
				$fieldnames =  "(";
				$fieldvalues = "(";
				foreach ($CompanyData as $k => $v) 
				{
					
					$fieldnames .=  ($fieldnames=="(")?"$k":",$k";
					$fieldvalues .= ($fieldvalues=="(")?"'$v'":",'$v'";
				}
				$sqltext = "insert into trncompanyprofile ".$fieldnames.") values ".$fieldvalues.")";
				//echo $sqltext;
				$applications = $this->obj1->insert_query($sqltext);
				return ($applications == 1)?"true":"false";
			}
		
		}
		function EditCompanyProfile($applicationdata,$wherecondition)
		{
			if (is_array($applicationdata)== false)
			{
				return false;
			}
			else
			{
				$fieldnamesvalues =  "set ";
				
				foreach ($applicationdata as $k => $v) 
				{
					$fieldnamesvalues .=  ($fieldnamesvalues =="set ")?"$k='$v'":",$k='$v'";
				}
				$sqltext = "update trncompanyprofile ".$fieldnamesvalues." where ".$wherecondition ;
				//echo $sqltext;
				$applications = $this->obj1->update_query($sqltext);
				return ($applications == 1)?"true":"false";
				
			}
		}
		function DeleteCompanyProfile($applicationdata)
		{
			if($applicationdata)
			{
				$sqltext = "delete from trncompanyprofile where companyprofileid='".$applicationdata."'";
				$applications = $this->obj1->delete_query($sqltext);
				return ($applications == 1)?"true":"false";
			}
		
		}
		
	}
	
	/*
		This class will be used for operations on Company related data
		mainly trnCompanyOffers and mstBuySell table
	*/
	class CompanyOffers
	{
		function __construct()
		{
			$this->obj1 = new dbopenconn();
			$this->con = $this->obj1-> dbconnect();
		}
		function getCompanyOffers($CompanyID='',$sql='',$debugquery='',$fields='*')
		{
			if ($CompanyID!="")
			{
				$sqltext = "Select $fields from trncompanyoffers where companyofferid='".$CompanyID."'";
			}
			else if ($sql!="")
			{
				$sqltext = $sql;
			}
			else
			{
				$sqltext = "Select $fields from trncompanyoffers limit 0,50";
			}
				
			$companies = $this->obj1->select_query($sqltext);
			$compstr = array();
			if ($companies)
			{
				$numrows = $this->obj1->numRows($companies);
			}
			if ($numrows ==1)
			{
				while ($companylist = mysqli_fetch_assoc($companies))
				{
					$compstr[] = $companylist;
				}	
			}
			else if($numrows > 1)
			{
				while ($companylist = mysqli_fetch_assoc($companies))
				{
					$compstr[] = $companylist;
				}
			}
			return $compstr;
		}
		function AddCompanyOffers($CompanyData)
		{
			if (is_array($CompanyData)== false)
			{
				return false;
			}
			else
			{
				$fieldnames =  "(";
				$fieldvalues = "(";
				foreach ($CompanyData as $k => $v) 
				{
					
					$fieldnames .=  ($fieldnames=="(")?"$k":",$k";
					$fieldvalues .= ($fieldvalues=="(")?"'$v'":",'$v'";
				}
				$sqltext = "insert into trncompanyoffers ".$fieldnames.") values ".$fieldvalues.")";
				//echo $sqltext;
				$applications = $this->obj1->insert_query($sqltext);
				return ($applications == 1)?"true":"false";
			}
		}
		function EditCompanyOffers($applicationdata,$wherecondition)
		{
			if (is_array($applicationdata)== false)
			{
				return false;
			}
			else
			{
				$fieldnamesvalues =  "set ";
				
				foreach ($applicationdata as $k => $v) 
				{
					$fieldnamesvalues .=  ($fieldnamesvalues =="set ")?"$k='$v'":",$k='$v'";
				}
				$sqltext = "update trncompanyoffers ".$fieldnamesvalues." where ".$wherecondition ;
				$applications = $this->obj1->update_query($sqltext);
				return ($applications == 1)?"true":"false";
				
			}
		}
		function DeleteCompanyOffers($applicationdata)
		{
			if($applicationdata)
			{
				$sqltext = "delete from trncompanyoffers where companyofferid='".$applicationdata."'";
				$applications = $this->obj1->delete_query($sqltext);
				return ($applications == 1)?"true":"false";
			}
		}
	
	}
	/*
		This class will be used for operations on Company related data
		mainly trnCompanyWebShop
	*/
	class CompanyWebStore
	{
		function __construct()
		{
			$this->obj1 = new dbopenconn();
			$this-> con = $this->obj1-> dbconnect();
		}
		function getCompanyWebStore($CompanyBusinessID='',$sql='',$debugquery='',$fields='*')
		{
			if ($CompanyBusinessID!="")
			{
				$sqltext = "Select $fields from trncompanywebstore where CompanyBusinessID='".$CompanyBusinessID."'";
			}
			else if ($sql!="")
			{
				$sqltext = $sql;
			}
			else
			{
				$sqltext = "Select $fields from trncompanywebstore limit 0,50";
			}
				
			$companies = $this->obj1->select_query($sqltext);
			$compstr = array();
			if ($companies)
			{
				$numrows = $this->obj1->numRows($companies);
			}
			if ($numrows ==1)
			{
				while ($companylist = mysqli_fetch_assoc($companies))
				{
					$compstr[] = $companylist;
				}	
			}
			else if($numrows > 1)
			{
				while ($companylist = mysqli_fetch_assoc($companies))
				{
					$compstr[] = $companylist;
				}
			}
			return $compstr;
		}
		function AddCompanyWebStore($CompanyData)
		{
			if (is_array($CompanyData)== false)
			{
				return false;
			}
			else
			{
				$fieldnames =  "(";
				$fieldvalues = "(";
				foreach ($CompanyData as $k => $v) 
				{
					
					$fieldnames .=  ($fieldnames=="(")?"$k":",$k";
					$fieldvalues .= ($fieldvalues=="(")?"'$v'":",'$v'";
				}
				$sqltext = "insert into trncompanywebstore ".$fieldnames.") values ".$fieldvalues.")";
				//echo $sqltext;
				$applications = $this->obj1->insert_query($sqltext);
				return ($applications == 1)?"true":"false";
			}
		}
		function EditCompanyWebStore($applicationdata)
		{
			if (is_array($applicationdata)== false)
			{
				return false;
			}
			else
			{
				$fieldnamesvalues =  "set ";
				
				foreach ($applicationdata as $k => $v) 
				{
					$fieldnamesvalues .=  ($fieldnamesvalues =="set ")?"$k='$v'":",$k='$v'";
				}
				$sqltext = "update trncompanywebstore ".$fieldnamesvalues." where ".$wherecondition ;
				//echo $sqltext;
				$applications = $this->obj1->update_query($sqltext);
				return ($applications == 1)?"true":"false";
				
			}
		}
		function DeleteCompanyWebStore($applicationdata)
		{
			if($applicationdata)
			{
				$sqltext = "delete from trncompanywebstore where CompanyBusinessID='".$applicationdata."'";
				$applications = $this->obj1->delete_query($sqltext);
				return ($applications == 1)?"true":"false";
			}
		}
	
	}
	/*
		This class will be used for operations on Company related data
		mainly trnCompanyWebShop
	*/
	class WebStoreStats
	{
		function __construct()
		{
			$this->obj1 = new dbopenconn();
			$this-> con = $this->obj1-> dbconnect();
		}
		function getWebStoreStats($WebStoreStatsID='',$sql='',$debugquery='',$fields='*')
		{
			if ($WebStoreStatsID!="")
			{
				$sqltext = "Select $fields from webstorestats where WebStoreStatsID='".$WebStoreStatsID."'";
			}
			else if ($sql!="")
			{
				$sqltext = $sql;
			}
			else
			{
				$sqltext = "Select $fields from webstorestats limit 0,50";
			}
				
			$companies = $this->obj1->select_query($sqltext);
			$compstr = array();
			if ($companies)
			{
				$numrows = $this->obj1->numRows($companies);
			}
			if ($numrows ==1)
			{
				while ($companylist = mysqli_fetch_assoc($companies))
				{
					$compstr[] = $companylist;
				}	
			}
			else if($numrows > 1)
			{
				while ($companylist = mysqli_fetch_assoc($companies))
				{
					$compstr[] = $companylist;
				}
			}
			return $compstr;
		}
		function AddWebStoreStats($CompanyData)
		{
			if (is_array($CompanyData)== false)
			{
				return false;
			}
			else
			{
				$fieldnames =  "(";
				$fieldvalues = "(";
				foreach ($CompanyData as $k => $v) 
				{
					
					$fieldnames .=  ($fieldnames=="(")?"$k":",$k";
					$fieldvalues .= ($fieldvalues=="(")?"'$v'":",'$v'";
				}
				$sqltext = "insert into webstorestats ".$fieldnames.") values ".$fieldvalues.")";
				//echo $sqltext;
				$applications = $this->obj1->insert_query($sqltext);
				return ($applications == 1)?"true":"false";
			}
		}
		function EditWebStoreStats($applicationdata)
		{
			if (is_array($applicationdata)== false)
			{
				return false;
			}
			else
			{
				$fieldnamesvalues =  "set ";
				
				foreach ($applicationdata as $k => $v) 
				{
					$fieldnamesvalues .=  ($fieldnamesvalues =="set ")?"$k='$v'":",$k='$v'";
				}
				$sqltext = "update webstorestats ".$fieldnamesvalues." where ".$wherecondition ;
				//echo $sqltext;
				$applications = $this->obj1->update_query($sqltext);
				return ($applications == 1)?"true":"false";
				
			}
		}
		function DeleteWebStoreStats($applicationdata)
		{
			if($applicationdata)
			{
				$sqltext = "delete from webstorestats where WebStoreStatsID='".$applicationdata."'";
				$applications = $this->obj1->delete_query($sqltext);
				return ($applications == 1)?"true":"false";
			}
		}
	
	}

	class UserPosts
	{
	
		function __construct()
		{
			$this->obj1 = new dbopenconn();
			$this->con = $this->obj1-> dbconnect();
		}
		
		// get list of or single compani(es) from database
		function getUserPosts($UserPostID='',$sql='',$debugquery='',$fields='*',$LocalityID='',$CountryID='',$CityID='')
		{
			global $G_userlocalityID;
			$LocalityID = ($LocalityID=='')?$G_userlocalityID:$LocalityID;
			
			if ($UserPostID!="")
			{
				$sqltext = "Select $fields from YP_trnUserPosts where userpostid='".$UserPostID."'";
			}
			elseif ($sql!="")
			{
				$sqltext = $sql;
			}
			elseif ($LocalityID!='')
			{
				$sqltext = "Select $fields from YP_trnUserPosts where localityid = '".$LocalityID."'";
			}
			elseif($CityID!='') 
			{
				$sqltext = "Select $fields from YP_trnUserPosts where localityid = '".$CityID."'";
			}
			else 
			{
				$sqltext = "Select $fields from YP_trnUserPosts where localityid = '".$CountryID."'";
			}
			
			$companies = $this->obj1->select_query($sqltext);
			$compstr = array();
			if ($companies)
			{
				$numrows = $this->obj1->numRows($companies);
			}
			if ($numrows ==1)
			{
				while ($companylist = mysqli_fetch_assoc($companies))
				{
					$compstr[] = $companylist;
				}	
			}
			else if($numrows > 1)
			{
				while ($companylist = mysqli_fetch_assoc($companies))
				{
					$compstr[] = $companylist;
				}
			}
			return $compstr;
		
		}
		function getLastPostID($PostbyUserId='')
		{
			if ($PostbyUserId!="")
			{
				$sqltext = "Select userpostid from YP_trnUserPosts where userpostbyuserid='".$PostbyUserId."' order by userpostid desc limit 0,1";
			}
			$companies = $this->obj1->select_query($sqltext);
			if ($companies)
			{
				$numrows = $this->obj1->numRows($companies);
			}
			$compstr = array();
			if ($numrows ==1)
			{
				while ($companylist = mysqli_fetch_assoc($companies))
				{
					$compstr[] = $companylist;
				}	
			}
			if (is_array($compstr))
			{
				$lastPostID = $compstr[0]['userpostid'];
			}
			else
			{
				$lastPostID =0;
			}
			return $lastPostID;
		
		}
		function getUserPostsImages($ImageID='',$sql='',$userpostid='')
		{
			if ($ImageID!='')
			{
				$sql = "Select * from YP_trnUserPostsImages where userpostimageid='$ImageID'";
			}
			else if ($userpostid!='')
			{
				$sql = "Select * from YP_trnUserPostsImages where userpostid='$userpostid'";
			}
			$postsarr = array();
			if ($sql!='')
			{
				$companies = $this->obj1->select_query($sql);
				if ($companies)
				{
					$numrows = $this->obj1->numRows($companies);
				}
				if ($numrows ==1)
				{
					while ($companylist = mysqli_fetch_assoc($companies))
					{
						$postsarr[] = $companylist;
					}	
				}
				else if($numrows > 1)
				{
					while ($companylist = mysqli_fetch_assoc($companies))
					{
						$postsarr[] = $companylist;
					}
				}
			}
			return $postsarr;
		}
		function getUserPostComments($UserPostID='',$sql='',$debugquery='',$fields='*')
		{
			if ($UserPostID!="")
			{
				$sqltext = "Select $fields from YP_trnUserPostComments where userpostid='".$UserPostID."'";
			}
			else if ($sql!="")
			{
				$sqltext = $sql;
			}
			if ($sqltext!='')
			{
				$companies = $this->obj1->select_query($sqltext);
			}
			$compstr = array();
			if ($companies)
			{
				$numrows = $this->obj1->numRows($companies);
			}
			if ($numrows ==1)
			{
				while ($companylist = mysqli_fetch_assoc($companies))
				{
					$compstr[] = $companylist;
				}	
			}
			else if($numrows > 1)
			{
				while ($companylist = mysqli_fetch_assoc($companies))
				{
					$compstr[] = $companylist;
				}
			}
			return $compstr;
		}
		// add user post to database
		function AddUserPost($UserPostData)
		{
		if (is_array($UserPostData)== false)
			{
				return false;
			}
			else
			{
				$fieldnames =  "(";
				$fieldvalues = "(";
				foreach ($UserPostData as $k => $v) 
				{
					
					$fieldnames .=  ($fieldnames=="(")?"$k":",$k";
					$fieldvalues .= ($fieldvalues=="(")?"'$v'":",'$v'";
				}
				$sqltext = "insert into YP_trnUserPosts ".$fieldnames.") values ".$fieldvalues.")";
				//echo $sqltext;
				$applications = $this->obj1->insert_query($sqltext);
				return ($applications == 1)?"true":"false";
			}
		}
		function AddUserPostImages($UserPostData)
		{
		if (is_array($UserPostData)== false)
			{
				return false;
			}
			else
			{
				$fieldnames =  "(";
				$fieldvalues = "(";
				foreach ($UserPostData as $k => $v) 
				{
					
					$fieldnames .=  ($fieldnames=="(")?"$k":",$k";
					$fieldvalues .= ($fieldvalues=="(")?"'$v'":",'$v'";
				}
				$sqltext = "insert into YP_trnUserPostsImages ".$fieldnames.") values ".$fieldvalues.")";
				//echo $sqltext;
				$applications = $this->obj1->insert_query($sqltext);
				return ($applications == 1)?"true":"false";
			}
		}
		function AddUserPostComment($UserPostData)
		{
		if (is_array($UserPostData)== false)
			{
				return false;
			}
			else
			{
				$fieldnames =  "(";
				$fieldvalues = "(";
				foreach ($UserPostData as $k => $v) 
				{
					
					$fieldnames .=  ($fieldnames=="(")?"$k":",$k";
					$fieldvalues .= ($fieldvalues=="(")?"'$v'":",'$v'";
				}
				$sqltext = "insert into YP_trnUserPostComments ".$fieldnames.") values ".$fieldvalues.")";
				//echo $sqltext;
				$applications = $this->obj1->insert_query($sqltext);
				return ($applications == 1)?"true":"false";
			}
		}
		function EditUserPosts($applicationdata,$wherecondition)
		{
			if (is_array($applicationdata)== false)
			{
				return false;
			}
			else
			{
				$fieldnamesvalues =  "set ";
				
				foreach ($applicationdata as $k => $v) 
				{
					$fieldnamesvalues .=  ($fieldnamesvalues =="set ")?"$k='$v'":",$k='$v'";
				}
				$sqltext = "update YP_trnUserPosts ".$fieldnamesvalues." where ".$wherecondition ;
				//echo $sqltext;
				$applications = $this->obj1->update_query($sqltext);
				return ($applications == 1)?"true":"false";
				
			}
		}
		
		function EditUserPostComment($applicationdata,$wherecondition)
		{
			if (is_array($applicationdata)== false)
			{
				return false;
			}
			else
			{
				$fieldnamesvalues =  "set ";
				
				foreach ($applicationdata as $k => $v) 
				{
					$fieldnamesvalues .=  ($fieldnamesvalues =="set ")?"$k='$v'":",$k='$v'";
				}
				$sqltext = "update YP_trnUserPostComments ".$fieldnamesvalues." where ".$wherecondition ;
				//echo $sqltext;
				$applications = $this->obj1->update_query($sqltext);
				return ($applications == 1)?"true":"false";
				
			}
		}
		function EditUserPostsImages($applicationdata,$wherecondition)
		{
			if (is_array($applicationdata)== false)
			{
				return false;
			}
			else
			{
				$fieldnamesvalues =  "set ";
				
				foreach ($applicationdata as $k => $v) 
				{
					$fieldnamesvalues .=  ($fieldnamesvalues =="set ")?"$k='$v'":",$k='$v'";
				}
				$sqltext = "update YP_trnUserPostsImages ".$fieldnamesvalues." where ".$wherecondition ;
				//echo $sqltext;
				$applications = $this->obj1->update_query($sqltext);
				return ($applications == 1)?"true":"false";
				
			}
		}
		
		function DeleteUserPosts($applicationdata)
		{
			if($applicationdata)
			{
				$applicationdata = intval($applicationdata);
				$sqltext = "delete from YP_trnUserPosts where userpostid='".$applicationdata."'";
				$applications = $this->obj1->delete_query($sqltext);
				self::DeleteUserPostsImages($applicationdata);
				return ($applications == 1)?"true":"false";
			}
		
		}
		function DeleteUserPostCommment($applicationdata)
		{
			if($applicationdata)
			{
				$applicationdata = intval($applicationdata);
				$sqltext = "delete from YP_trnUserPostComments where userpostcommentid = '".$applicationdata."'";
				$applications = $this->obj1->delete_query($sqltext);
				self::DeleteUserPostsImages($applicationdata);
				return ($applications == 1)?"true":"false";
			}
		
		}
		function DeleteUserPostsImages($applicationdata)
		{
			if($applicationdata)
			{
				$applicationdata = intval($applicationdata);
				$sqltext = "delete from YP_trnUserPostsImages where userpostimageid='".$applicationdata."'";
				$applications = $this->obj1->delete_query($sqltext);
				return ($applications == 1)?"true":"false";
			}
		
		}
		
		// to change here //
		function GetUserPostHTML($AllPostHomePage='1',$IndividualPage='',$LocalityID='')
		{
			
			$LocalityID = ($LocalityID=='')?$G_userlocalityID:$LocalityID;
			if ($AllPostHomePage=='1')
			{
				$sql = "Select * from YP_trnUserPosts a left join YP_trnUserPostsImages b on a.userpostid=b.userpostid inner join mstusers c on a.userpostbyuserid=c.userid 
				left join YP_mstuserpostcategory d on a.userpostcatid=d.userpostcatid where localityid = '".$LocalityID."' and userpostsuspended ='0' and userpostDontShow ='0' and userpostimagepath >'' order by userpostdate desc limit 0,100";
			}
			$getHomePagePosts = self::getUserPosts('',$sql);
			if ($getHomePagePosts)
			{
				$countrow = count($getHomePagePosts);
				$userpostid = 0;
				for ($i=0;$i<$countrow;$i++)
				{
					if ($userpostid!=$getHomePagePosts[$i]['userpostid'])
						{
							$curPostImageCount=0;
							if ($i > 0)
							{
								
								$PostImages			= ($PostImages!='')?$PostImages.'</ul>':'';
								$postHTML .= '<article class="shifty-item '.$postcatshortname.'">'.$PostImages.'<div class="postauthor"><img src="'.$userprofiephotopath.'"><h5><a href="'.DOC_ROOT.'user/'.$userid.'.htm">'.$userfullname.'</a></h5></div><p>'.$postcomments.'</p>
               							<ul class="article_links">
          									<li><a href="#" title="Like">Like</a></li>
          									<li><a href="#" title="Share">Share</a></li>
          									<li><a href="#" title="Comment">Comment</a></li>
											<li>'.ago($posteddate).'</li>
	          							</ul>
        						</article>';
								if ($getHomePagePosts[$i]['userpostimagepath']!='')
								{
									$PostImages = '<figure><img src="'.USER_PHOTO_DIR.$getHomePagePosts[$i]['userpostimagepath'].'" alt="Post By '.$userfullname.'"></figure>';
								}
								$userid				= $getHomePagePosts[$i]['userid'];  	
								$postcomments 		= preview_text($getHomePagePosts[$i]['userpostcomments'],500);
								//$postcomments 		= $getHomePagePosts[$i]['userpostcomments'];
								$postcatname  		= $getHomePagePosts[$i]['userpostcatname'];
								$postcatshortname  	= $getHomePagePosts[$i]['userpostcatshortname'];
								$postcatname  		= $getHomePagePosts[$i]['userpostcatname'];
								$userfullname 		= $getHomePagePosts[$i]['userfirstname'].' '.$getHomePagePosts[$i]['userlastname'];
								$posteddate   		= $getHomePagePosts[$i]['userpostdate'];
								$userprofiephotopath = ($getHomePagePosts[$i]['userprofiephotopath']!='')?$getHomePagePosts[$i]['userprofiephotopath']:IMAGE_DIR.'no-photo.png';
								
							}
							else
							{
								$userid				= $getHomePagePosts[$i]['userid'];
								$postcomments 		= preview_text($getHomePagePosts[$i]['userpostcomments'],500);
								//$postcomments 		= $getHomePagePosts[$i]['userpostcomments'];
								$postcatname  		= $getHomePagePosts[$i]['userpostcatname'];
								$postcatshortname  	= $getHomePagePosts[$i]['userpostcatshortname'];
								$postcatname  		= $getHomePagePosts[$i]['userpostcatname'];
								$userfullname 		= $getHomePagePosts[$i]['userfirstname'].' '.$getHomePagePosts[$i]['userlastname'];
								$posteddate   		= $getHomePagePosts[$i]['userpostdate'];
								$userprofiephotopath = ($getHomePagePosts[$i]['userprofiephotopath']!='')?$getHomePagePosts[$i]['userprofiephotopath']:IMAGE_DIR.'no-photo.png';
								if ($getHomePagePosts[$i]['userpostimagepath']!='')
								{
									$PostImages = '<figure><img src="'.USER_PHOTO_DIR.$getHomePagePosts[$i]['userpostimagepath'].'" alt="Post By '.$userfullname.'"></figure>';
								}	
							}	
							$userpostid=$getHomePagePosts[$i]['userpostid'];
						}
					else
						{
							$userid				= $getHomePagePosts[$i]['userid'];
							$postcomments 		= preview_text($getHomePagePosts[$i]['userpostcomments'],500);
							//$postcomments 		= $getHomePagePosts[$i]['userpostcomments'];
							$postcatname  		= $getHomePagePosts[$i]['userpostcatname'];
							$postcatshortname  	= $getHomePagePosts[$i]['userpostcatshortname'];
							$postcatname  		= $getHomePagePosts[$i]['userpostcatname'];
							$userfullname 		= $getHomePagePosts[$i]['userfirstname'].' '.$getHomePagePosts[$i]['userlastname'];
							$posteddate   		= $getHomePagePosts[$i]['userpostdate'];
							$userprofiephotopath = ($getHomePagePosts[$i]['userprofiephotopath']!='')?$getHomePagePosts[$i]['userprofiephotopath']:IMAGE_DIR.'no-photo.png';
								
							if ($curPostImageCount < 3)
							{
								if ($curPostImageCount==0)
								{
									$PostImages .= '<ul class="thumb"><li><figure><a href="#"><img src="'.USER_PHOTO_DIR.$getHomePagePosts[$i]['userpostimagepath'].'" alt="Post By '.$userfullname.'"></a></figure></li><li class="divider"></li>';
								}
								else if ($curPostImageCount==2)
								{	
									$PostImages .= '<li><figure><a href="#"><img src="'.USER_PHOTO_DIR.$getHomePagePosts[$i]['userpostimagepath'].'" alt="Post By '.$userfullname.'"></a></figure></li>';
								}
								else
								{
									$PostImages .= '<li><figure><a href="#"><img src="'.USER_PHOTO_DIR.$getHomePagePosts[$i]['userpostimagepath'].'" alt="Post By '.$userfullname.'"></a></figure></li><li class="divider"></li>';		
								}	
								$curPostImageCount++;
							}	
						}	
				
				}		
			
			}
			return $postHTML;
		}
		
		/*	
			structure of feed stored in database
			// add everything to the news feed including comments
			eg.
			news feed for post 1 will be as follows
			newsfeedid =1
			newsfeedpost id=1
			newsfeedpostbyuserid = userid who posted the post
			newsfeeddetails : username,userphoto,userpost
			
			if somebody comments on this post then
			update record by post id
			newsfeedid =1
			newsfeedpostid=1
			newsfeedpostbyuserid = userid who commented on the post
			
			//=====================================================
			this can be array  
			$Post = array 
			( 
					"heading" => headingtitle,
					"postdetails" => array( postby=> username, postbyuserphoto=> userphotopath, postdatetime => datetime, userpost=>userpost ),
					"usercomment" => array( commentbyusername = username, commentbyuserphoto = userphotopath, comment => userpost, commentdatetime = datetime ),
					"usercomment" => array( commentbyusername = username, commentbyuserphoto = userphotopath, comment => userpost, commentdatetime = datetime ),
					"usercomment" => array( commentbyusername = username, commentbyuserphoto = userphotopath, comment => userpost, commentdatetime = datetime ),
					"userlike" => array (), // other actions
					"userthank" => array()
			)		
			//=====================================================
			newsfeeddetails : post by username,post by userphoto,original userpost, comment by username, comment by userphoto, comment by userpost
			
			and so on
			
			if somebody like the post or share it
				
		*/
		
		function getActivityFeed($LocalityID='',$statRecordNo=0,$noOfRecords=50,$categoryid='')
		{
			global $G_userid;
			//$LocalityID = ($LocalityID=='')?$G_userlocalityID:$LocalityID;
			//$sql = "Select msx(newsfeedpostid),newsfeedbyuserid,newsfeeddetail from YP_newsfeed_static where localityid = '".$LocalityID."' group by newsfeedpostid order by newsfeedpostdate desc limit 0,100";			
			$strFields = "a.userpostid,userpostcommenttitle, userpostcomments,userpostdate,userpostlikes,userpostdislikes,userpostsharecount, userpostthanks, userpostzappi, userpostnamaste, userpostcatid, userpostcatname, EG_localityid, userid as postbyuserid, userfirstname as postbyuserfirstname, userlastname as postbyuserlastname, userprofiephotopath as postbyuserprofilephotopath, userpostcatname, a.localityid, localityname, localitywebsitename,replycount, repliedbynames, userpostlikenames,userpostdislikesnames ";
			$sqlCategory = '';
			if ($categoryid!='')
			{
				$sqlCategory = " and userpostcatid = '$categoryid' ";
			}	
			
			$sql = "Select $strFields from YP_trnUserPosts a inner join mstusers c on a.userpostbyuserid=c.userid inner join YP_mstlocality b on a.localityid=b.localityid where a.localityid = '".$LocalityID."' ".$sqlCategory." and userpostsuspended ='0' and userpostDontShow ='0' order by a.userpostlastcommentdatetime desc, a.userpostid desc limit $statRecordNo,$noOfRecords ";

			$postarr = self::getUserPosts('',$sql);
			$rowcount = count($postarr);
			if ($rowcount > 0)
			{
				$activityFeed = '';
				for ($i=0;$i<$rowcount;$i++)
				{
					$userpostid 				= $postarr[$i]['userpostid'];
					$postbyuserid				= $postarr[$i]['postbyuserid'];
					$postbyuserprofilelink		= 'user_profile/'.$postarr[$i]['postbyuserid'].'/';
					$postbyuserprofileimagepath	= self::SetProfilePhotoPath($postarr[$i]['postbyuserprofilephotopath']);
					$postbyfullusername			= $postarr[$i]['postbyuserfirstname'].' '.$postarr[$i]['postbyuserlastname'];
					$posttitle					= $postarr[$i]['userpostcommenttitle'];
					$postdesc					= $postarr[$i]['userpostcomments'];
					$posteddate					= $postarr[$i]['userpostdate'];
					$postcaturl					= 'category/'.$postarr[$i]['userpostcatid'].'/';
					$postcategoryname			= $postarr[$i]['userpostcatname'];
					
					$postlikecount				= $postarr[$i]['userpostlikes'];
					$postdislikecount			= $postarr[$i]['userpostdislikes'];
					
					$postthankcount				= $postarr[$i]['userpostthanks'];
					
					$postreplycount				= $postarr[$i]['replycount'];
					
					$postreplynames				= $postarr[$i]['repliedbynames'];
					
					$localityname				= $postarr[$i]['localityname'];
					$localitywebsitename		= $postarr[$i]['localitywebsitename'];	
					// to do here
					// check if post id is same then check if image name is same then go for comment html only
					// else if post id is same and image name is different then show 2 - 3 images together
					// else show only post
					$ImagePost = self::formatActivityImages($userpostid);
					$activityFeed .= self::formatActivityPost($userpostid,$postbyuserid,$postbyuserprofilelink,$postbyuserprofileimagepath,$postbyfullusername,$posttitle,$posteddate,$postdesc,$postcaturl,$postcategoryname,$postlikecount,$postreplycount,$localityname,$localitywebsitename,$ImagePost,$LocalityID);
					if ($G_userid!='')
					{
						$activityFeed .= self::formatActivityPostComment($userpostid);
					}
					$activityFeed .= '	</div>'; // two divs of post close here 

					$activityFeed .= '</div>';
				
				}
				
			}
			else
			{
				// there are no posts in this locality show message.
			}	
			
		return $activityFeed;
		}
		
		function SetProfilePhotoPath($profilephotopath)
		{
			//userprofiephotopath 
			if ($profilephotopath=='')
			{
				$imagePath = IMAGE_DIR.'no-photo.jpg';
				return $imagePath;
			}
			$provider = strpos($profilephotopath,'googleusercontent.com');
			if ($provider !== false)
			{
				// user has logged in with google so show his google user iamge
				$imagePath = $profilephotopath;
				return $imagePath;
			} 
			$provider = strpos($profilephotopath,'facebook.com');
			if ($provider !== false)
			{
				// user has logged in with facebook so show his facebook user iamge
				$imagePath = $profilephotopath;
				return $imagePath;
			}
			return $profilephotopath;
		}
		function formatActivityImages($postid)
		{
			 
			$imagesArr = self::getUserPostsImages('','',$postid);
			if (is_array($imagesArr))
			{
				$rowcount = count($imagesArr);
				if ($imagesArr[0]['userpostimagepath']!='')
				{
					$strPostImage = '<div class="img-polaroid">';
					$strPostImage .= '	<img class="lazy" data-original ="'.USER_PHOTO_DIR.$imagesArr[0]['userpostimagepath'].'">';
					$strPostImage .= '	<noscript><img src="'.USER_PHOTO_DIR.$imagesArr[0]['userpostimagepath'].'"></noscript>';
					$strPostImage .= '	<div class="clear"></div>';
					
					for ($i=1;$i < $rowcount;$i++)
					{
						
						$strPostImage .= '	<div class="img-polaroid forimage-next">';
						$strPostImage .= '	<img class="lazy" data-original ="'.USER_PHOTO_DIR.$imagesArr[$i]['userpostimagepath'].'">';
						$strPostImage .= '	<noscript><img src="'.USER_PHOTO_DIR.$imagesArr[$i]['userpostimagepath'].'"></noscript>';
						$strPostImage .= '	</div>';
					}	
					$strPostImage .= '</div>';
					$strPostImage .= '<div class="clear"></div>';
				}	
			}
			return $strPostImage;
		}
		function formatActivityPost($postid,$postbyuserid,$postbyuserprofilelink,$postbyuserprofileimagepath,$postbyfullusername,$posttitle,$posteddate,$postdesc,$postcaturl,$postcategoryname,$postlikecount,$postreplycount,$localityname,$localitywebsitename,$ImagePost,$localityid)
		{
					global $G_userid;
					$strPost = '<div class="media" id="'.$postid.'" data-class="whole-story">';
					$strPost .= '	<div class="media-object"><a data-class="linked-name" data-id="'.$postbyuserid.'" href="'.$postbyuserprofilelink.'">';
					$strPost .= '		<img class="avatar" src="'.$postbyuserprofileimagepath.'" alt="Photo of '.$postbyfullusername.'" title="'.$postbyfullusername.'"/> </a>';
					$strPost .= '	</div>';
				  
					$strPost .= '	<div class="media-body" id="b_'.$postid.'">';
					$strPost .= '		<div data-class="main-content-area">';
					$strPost .= '  			<div id="edit_'.$postid.'">';
					$strPost .= '				<h4 class="media-heading" id="a_'.$postid.'">';
					$strPost .= '					<span id="subject_'.$postid.'" class="subject">';
					$strPost .= '						<a href="/news_feed/?post='.$postid.'">'.$posttitle.'</a> ';
					$strPost .= '					</span> ';
					$strPost .= '					<span class="timestamp" data-utc="'.$posteddate.'">'.ago($posteddate).'</span> ';
					$strPost .= '				</h4>';
					$strPost .= '    			<h5 class="media-author"> ';
					$strPost .= '					<span class="user-name">';
					$strPost .= '						<a data-class="linked-name" class="tooltip-element" data-id="'.$postbyuserid.'" tooltip-id="'.$postbyuserid.'" href="/user_profile/'.$postbyuserid.'/">'.$postbyfullusername.'</a>';
					$strPost .= '					</span> ';
					$strPost .= '					<span class="media-location"> from <a href="javascript:void(0);" data-toggle="map-modal" data-target="#nearby-neighborhoods-map-modal" data-type="neighborhood" data-id="6">'.$localityname.'</a> ';
					$strPost .= '					</span>';
					$strPost .= '				</h5> ';
					$strPost .= $ImagePost;
					$strPost .= '    			<p id="message_'.$postid.'" class="short-products" data-class="post-content" data-story="'.$postdesc.'">'.$postdesc.'</p>';
					$strPost .= '				<div class="media-scope"> Posted in <a href="javascript:void(0);" data-target="#" data-toggle="#" data-type="locality" data-id="'.$localityid.'">'.$localityname.'</a> <span id="#">'; 
					$strPost .= '						<span data-class="topics-label"> in <a href="'.$postcaturl.'"> '.$postcategoryname.'</a></span> ';
					$strPost .= '					';
					$strPost .= '				</div>';
					$strPost .= '    			<div class="media-actions" id="bl_'.$postid.'">'; 
					
					if ($G_userid!='') {
					
					$strPost .= '					<span> ';
					$strPost .= '						<a class="btn btn-mini" data-action="like" data-add-like-url="/post/'.$postid.'/like/" data-contenttype="post" data-contentid="'.$postid.'" href="javascript:void(0);"> ';
					$strPost .= '						<span data-class="label" data-contentid="'.$postid.'">Like</span> <span data-class="count" data-contentid="'.$postid.'" class="count">'.$postlikecount.'</span> ';
					$strPost .= '						</a> ';
					$strPost .= '					</span> ';
					$strPost .= '					<span> ';
					$strPost .= '						<a href="javascript:void(0);" class="btn btn-mini" data-action="comment" data-contenttype="post" data-contentid="'.$postid.'"> ';
					$strPost .= '							<span data-class="label">Reply</span> <span data-class="count" class="count"> '.$postreplycount.' </span> ';
					$strPost .= '						</a>';
					$strPost .= '					</span>';
					$strPost .= ' 					<div class="dropdown"> <a class="btn btn-mini dropdown-toggle" data-toggle="dropdown" href="javascript:void(0);"><b class="caret"></b></a>';
					$strPost .= '  						<ul class="dropdown-menu" role="menu">';
					$strPost .= '  							<li role="menuitem" class="hidden-phone"> <a href="javascript:void(0);" data-action="edit-categories" data-lostfound="true" data-hide-resource="false" data-post-id="'.$postid.'">Change category</a> </li>';
					$strPost .= ' 							<li role="menuitem"><a href="javascript:void(0);" data-action="flag" data-flag-type="post" data-flag-id="'.$postid.'">Flag</a> </li>';
					$strPost .= '  						</ul>';
					$strPost .= '      				</div>';
					} else {
					
					$strPost .= '					<span> ';
					$strPost .= '						<a class="btn btn-mini" href="'.DOC_ROOT.'register.php?step=1&localityid='.base64_encode($localityid).'"> ';
					$strPost .= '						<span data-class="label">Join To Like</span> <span data-class="count" class="count">'.$postlikecount.'</span> ';
					$strPost .= '						</a> ';
					$strPost .= '					</span> ';
					$strPost .= '					<span> ';
					$strPost .= '						<a href="'.DOC_ROOT.'register.php?step=1&localityid='.base64_encode($localityid).'" class="btn btn-mini"> ';
					$strPost .= '							<span data-class="label">Join To Reply</span> <span data-class="count" class="count"> '.$postreplycount.' </span> ';
					$strPost .= '						</a>';
					$strPost .= '					</span>';
					
					}
					$strPost .= '    			</div>';
					$strPost .= '  			</div>';
					$strPost .= '		</div>';

//					$strPost .= '	</div>';

//					$strPost .= '</div>';
		return $strPost;	  
		}
		
		function formatActivityRemainingPostComments($postid='',$lastcommentid='')
		{
			global $G_userid;
			global $G_userfirstname;
			global $G_userlastname;
			
			$userfullname = $G_userfirstname.' '.$G_userlastname;
			if (($postid!='')&& ($lastcommentid!=''))
			{
				$postarr = self::getUserPostComments('',"Select * from YP_trnUserPostComments a inner join mstusers b on a.userpostcommentbyuserid=b.userid inner join YP_mstlocality c on c.localityid=b.EG_localityid where usercommentonpostid='$postid' and userpostcommentid < '$lastcommentid' order by userpostcommentid desc ");
			}
			
			$rowcount = count($postarr);
			
			
			
			if ($rowcount > 0)
			{
				// rowcount = 4 
				// 1 2 3 4
				for ($i=0;$i<$rowcount;$i++)
				{
					$userpostcommentid 			= $postarr[$i]['userpostcommentid'];
					$usercommentonpostid 		= $postarr[$i]['usercommentonpostid'];
					$userpostcomments 			= $postarr[$i]['userpostcomments'];
					
					$postcommentbyuserid		= $postarr[$i]['userpostcommentbyuserid'];
					$postbyuserprofilelink		= 'user_profile/'.$postcommentbyuserid.'/';
					$postbyuserprofileimagepath	=  self::SetProfilePhotoPath($postarr[$i]['userprofiephotopath']);
					$postbyfullusername			= $postarr[$i]['userfirstname'].' '.$postarr[$i]['userlastname'];
					$userpostcommentdate		= $postarr[$i]['userpostcommentdate'];
					$userlocalityname			= $postarr[$i]['localityname'];
					$postreplycount				= $rowcount;
					
					
					
					$strPostComment .= '	<div data-comment-content-id="'.$userpostcommentid.'" data-comment-content-type="post" class="media-comment" id="comment_'.$userpostcommentid.'">';
					$strPostComment .= '      <div class="" id="comment_inner_container_'.$userpostcommentid.'">';
					$strPostComment .= '        <div class="media-object hidden-phone"> <a data-class="linked-name" data-id="'.$postcommentbyuserid.'" href="'.$postbyuserprofilelink.'"><img class="avatar"
			   src="'.$postbyuserprofileimagepath.'" alt="Picture of '.$postbyfullusername.'" title="Picture of '.$postbyfullusername.'" /> </a> ';
			   		$strPostComment .= '        </div>';
					$strPostComment .= '        <div class="media-body">';
					$strPostComment .= '          <div id="edit_'.$userpostcommentid.'">';
					$strPostComment .= '            <h6 class="media-author"> <span class="user-name"><a data-class="linked-name" data-id="'.$postcommentbyuserid.'" href="'.$postbyuserprofilelink.'">'.$postbyfullusername.'</a></span> <span class="media-location"> from  <a href="javascript:void(0);" data-target="#nearby-neighborhoods-map-modal" data-toggle="map-modal" data-type="neighborhood" data-id="6">'.$userlocalityname.'</a> </span> <span class="timestamp">'.(ago($userpostcommentdate)).'</span></h6>';
					$strPostComment .= '            <span id="message_'.$userpostcommentid.'" data-story="'.$userpostcomments.'"></span>';
					$strPostComment .= '            <p>'.$userpostcomments.'</p>';
					$strPostComment .= '            <div class="media-actions"> ';
					$strPostComment .= '					<a href="javascript:void(0);" data-action="like" data-add-like-url="/comments/'.$userpostcommentid.'/like/" data-contenttype="comment" data-contentid="'.$userpostcommentid.'"> <span data-class="label">Like</span> </a> <a href="javascript:void(0)" data-action="flag" data-flag-type="comment" data-flag-id="'.$userpostcommentid.'">Flag </a>';
					$strPostComment .= '			</div>';
					$strPostComment .= '          </div>';
					$strPostComment .= '          <div class="media-thanks" id="comment_like_container_'.$userpostcommentid.'" data-class="like-container"><span id="like_'.$userpostcommentid.'"></span> </div>';
					$strPostComment .= '        </div>';
					$strPostComment .= '      </div>';
					$strPostComment .= '    </div>';
			
				} // for loop close 
				
			return $strPostComment;
			}
			
		}
		function formatActivityPostComment($postid='',$commentid='')
		{
			global $G_userid;
			global $G_userfirstname;
			global $G_userlastname;
			
			$userfullname = $G_userfirstname.' '.$G_userlastname;
			if ($postid!='')
			{
				$postarr = self::getUserPostComments('',"Select * from YP_trnUserPostComments a inner join mstusers b on a.userpostcommentbyuserid=b.userid inner join YP_mstlocality c on c.localityid=b.EG_localityid where usercommentonpostid='$postid' order by userpostcommentid desc");
			}
			else if ($commentid!='')
			{
				$postarr = self::getUserPostComments('',"Select * from YP_trnUserPostComments a inner join mstusers b on a.userpostcommentbyuserid=b.userid inner join YP_mstlocality c on c.localityid=b.EG_localityid where userpostcommentid='$commentid' ");
			}
			
			$rowcount = count($postarr);
			debug_to_console($rowcount);
			$strPostComment .= '<div class="media-comments" id="comment_container_'.$postid.'" data-num-comments="'.$rowcount.'" data-class="comment-like-container">';
			
			if ($rowcount > 0)
			{
				$startCount = 0;
				if ($rowcount > 3)
				{
					$lastdisplayedcommentid = $postarr[2]['userpostcommentid'];
					debug_to_console($lastdisplayedcommentid);
					$commentSummary = '<div class="media-comment comment-summarizer" data-action="view-all-comments" data-for-post="'.$postid.'" data-last-comment-id="'.$lastdisplayedcommentid.'">';
          			$commentSummary .= '<p><span class="comment-count"><i class="glyphicon-comment"></i></span>';
            		$commentSummary .= '<a href="javascript:void(0);" data-action="view-all-comments-link" data-last-comment-id="'.$lastdisplayedcommentid.'" data-for-post="'.$postid.'">';
              		$commentSummary .= 'View all <span data-class="count">'.$rowcount.'</span> Replies';
            		$commentSummary .= '</a>';
            		$commentSummary .= '<span class="error hide" id="comment_error">Failed to load comments.</span>';
          			$commentSummary .= '</p>';
        			$commentSummary .= '</div>';
					
					$strPostComment .= $commentSummary;
					//$startCount = $rowcount - 3; 
					$rowcount = 3;
				}
				// rowcount = 4 
				// 1 2 3 4
				for ($i=$startCount;$i<$rowcount;$i++)
				{
					$userpostcommentid 			= $postarr[$i]['userpostcommentid'];
					$usercommentonpostid 		= $postarr[$i]['usercommentonpostid'];
					$userpostcomments 			= $postarr[$i]['userpostcomments'];
					
					$postcommentbyuserid		= $postarr[$i]['userpostcommentbyuserid'];
					$postbyuserprofilelink		= 'user_profile/'.$postcommentbyuserid.'/';
					$postbyuserprofileimagepath	=  self::SetProfilePhotoPath($postarr[$i]['userprofiephotopath']);
					$postbyfullusername			= $postarr[$i]['userfirstname'].' '.$postarr[$i]['userlastname'];
					$userpostcommentdate		= $postarr[$i]['userpostcommentdate'];
					$userlocalityname			= $postarr[$i]['localityname'];
					$postreplycount				= $rowcount;
					
					
					
					$strPostComment .= '	<div data-comment-content-id="'.$userpostcommentid.'" data-comment-content-type="post" class="media-comment" id="comment_'.$userpostcommentid.'">';
					$strPostComment .= '      <div class="" id="comment_inner_container_'.$userpostcommentid.'">';
					$strPostComment .= '        <div class="media-object hidden-phone"> <a data-class="linked-name" data-id="'.$postcommentbyuserid.'" href="'.$postbyuserprofilelink.'"><img class="avatar"
			   src="'.$postbyuserprofileimagepath.'" alt="Picture of '.$postbyfullusername.'" title="Picture of '.$postbyfullusername.'" /> </a> ';
			   		$strPostComment .= '        </div>';
					$strPostComment .= '        <div class="media-body">';
					$strPostComment .= '          <div id="edit_'.$userpostcommentid.'">';
					$strPostComment .= '            <h6 class="media-author"> <span class="user-name"><a data-class="linked-name" data-id="'.$postcommentbyuserid.'" href="'.$postbyuserprofilelink.'">'.$postbyfullusername.'</a></span> <span class="media-location"> from  <a href="javascript:void(0);" data-target="#nearby-neighborhoods-map-modal" data-toggle="map-modal" data-type="neighborhood" data-id="6">'.$userlocalityname.'</a> </span> <span class="timestamp">'.(ago($userpostcommentdate)).'</span></h6>';
					$strPostComment .= '            <span id="message_'.$userpostcommentid.'" data-story="'.$userpostcomments.'"></span>';
					$strPostComment .= '            <p>'.$userpostcomments.'</p>';
					$strPostComment .= '            <div class="media-actions"> ';
					$strPostComment .= '					<a href="javascript:void(0);" data-action="like" data-add-like-url="/comments/'.$userpostcommentid.'/like/" data-contenttype="comment" data-contentid="'.$userpostcommentid.'"> <span data-class="label">Like</span> </a> <a href="javascript:void(0)" data-action="flag" data-flag-type="comment" data-flag-id="'.$userpostcommentid.'">Flag </a>';
					$strPostComment .= '			</div>';
					$strPostComment .= '          </div>';
					$strPostComment .= '          <div class="media-thanks" id="comment_like_container_'.$userpostcommentid.'" data-class="like-container"><span id="like_'.$userpostcommentid.'"></span> </div>';
					$strPostComment .= '        </div>';
					$strPostComment .= '      </div>';
					$strPostComment .= '    </div>';
			
				} // for loop close 
				
			}	//if close 
			
			// reply box for logged in user
			if ($G_userid!='') {
			
				$strPostComment .= '<div class="media-comment hide" id="comment_box'.$postid.'">';
    			$strPostComment .= '<form class="form-inline" id="comment_form'.$postid.'" name="comment_form" method="post" >';
				$userphotopath 	= self::SetProfilePhotoPath($G_UserPhotoPath);
      			$strPostComment .= '	<div class="media-object hidden-phone"><a data-class="linked-name" data-id="'.$G_userid.'" href="/user_profile/'.$G_userid.'/"> <img class="avatar" src="'.$userphotopath.'" alt="Picture of '.$userfullname.'" title="Picture of '.$userfullname.'" /> </a> </div>';
      			$strPostComment .= '		<div class="media-body">';
        		$strPostComment .= '			<textarea rows="1" cols="1" class="input-block-level" id="comment_body'.$postid.'" name="body"></textarea>';
        		$strPostComment .= '			<input type="submit" id="comment_submit" class="btn btn-primary btn-mini" value="Reply" />';
        		$strPostComment .= '			<button id="loading_comment_submit" disabled="disabled" class="btn btn-mini hide"><img alt="spinner" src="'.IMAGE_DIR.'loading.gif"> Loading... </button>';
        		$strPostComment .= '			<input type="hidden" id="comment_on_post_id'.$postid.'" name="post" value="'.$postid.'"/>';
				$strPostComment .= '			<input type="hidden" id="last_comment_id'.$userpostcommentid.'" name="last_comment_id" value="'.$userpostcommentid.'"/>';
        		$strPostComment .= '			<input type="hidden" id="comment_user_id" name="author" value="'.$G_userid.'"/>';
				$strPostComment .= '		</div>';
    			$strPostComment .= '</form>';
				$strPostComment .= '</div>';
			}
			
			$strPostComment .= '</div>'; // media comment container close
			
			
			
			//<textarea rows="1" cols="1" class="input-block-level" id="comment_body" name="body" style="overflow: hidden; word-wrap: break-word; resize: horizontal; height: 30px;"></textarea>
		return $strPostComment;
		}
		
	}	
		
?>