<?php
	
	/*
		This class will be used for operations on Company related data
		mainly mstCompany table
	*/
	
	class Companies
	{
	
		function Companies()
		{
			$this->obj1 = new dbopenconn();
			$this->con = $this->obj1-> dbconnect();
		}
		
		// get list of or single compani(es) from database
		function getCompanies($CompanyID='',$sql='',$debugquery='',$fields='*')
		{
			if ($CompanyID!="")
			{
				$sqltext = "Select $fields from mstcompanies where companyid='".$CompanyID."'";
			}
			else if ($sql!="")
			{
				$sqltext = $sql;
			}
			else
			{
				$sqltext = "Select $fields from mstcompanies";
			}
			$companies = $this->obj1->select_query($sqltext);
			
			if ($companies)
			{
				$numrows = $this->obj1->numRows($companies);
			}
			if ($numrows ==1)
			{
				while ($companylist = mysql_fetch_assoc($companies))
				{
					$compstr[] = $companylist;
				}	
			}
			else if($numrows > 1)
			{
				while ($companylist = mysql_fetch_assoc($companies))
				{
					$compstr[] = $companylist;
				}
			}
			return $compstr;
		
		}
		function getCompaniesForDropDown($sql)
		{
		
			$companies = $this->obj1->select_query($sql);
			
			if ($companies)
			{
				$numrows = $this->obj1->numRows($companies);
			}
			if ($numrows > 0)
			{
				$found = array();
				while ($companylist = mysql_fetch_assoc($companies))
				{
				$found[] = array(
					"value" => $companylist['ProductName'], 
					"display" => $companylist['ProductName'],
				);
				}
				return $found;
			}	
		}
		
		
		// add company to database
		function AddCompany($CompanyData)
		{
		if (is_array($CompanyData)== false)
			{
				return false;
			}
			else
			{
				$fieldnames =  "(";
				$fieldvalues = "(";
				foreach ($CompanyData as $k => $v) 
				{
					
					$fieldnames .=  ($fieldnames=="(")?"$k":",$k";
					$fieldvalues .= ($fieldvalues=="(")?"'$v'":",'$v'";
				}
				$sqltext = "insert into mstcompany ".$fieldnames.") values ".$fieldvalues.")";
				//echo $sqltext;
				$applications = $this->obj1->insert_query($sqltext);
				
				return ($applications == 1)?"true":"false";
			}
		
		}
		
		function EditCompany($applicationdata,$wherecondition)
		{
			if (is_array($applicationdata)== false)
			{
				return false;
			}
			else
			{
				$fieldnamesvalues =  "set ";
				
				foreach ($applicationdata as $k => $v) 
				{
					$fieldnamesvalues .=  ($fieldnamesvalues =="set ")?"$k='$v'":",$k='$v'";
				}
				$sqltext = "update mstcompany ".$fieldnamesvalues." where ".$wherecondition ;
				//echo $sqltext;
				$applications = $this->obj1->update_query($sqltext);
				return ($applications == 1)?"true":"false";
				
			}
		}
		
		function DeleteCompany($applicationdata)
		{
			if($applicationdata)
			{
				$sqltext = "delete from mstcompany where companyid='".$applicationdata."'";
				$applications = $this->obj1->delete_query($sqltext);
				return ($applications == 1)?"true":"false";
			}
		
		}
		// this function checks if company has got sufficient credits
		function CheckCompanyEnquiriesCredit($companyid)
		{
			$sqltext = " Select enquirypackageid,enquiriesused,enquiriesclosingbalance from mstcompany where companyid='$companyid' ";
			$companies = self::getCompanies('',$sqltext);
			$applications = 0;
			if ($companies)
			{
				if ($companies[0]['enquirypackageid'] >0)
				{
					if ($companies[0]['enquiriesclosingbalance'] > 0)
					{
						$applications = 1;
					}
				}
				else
				{
					$applications = 1;
				}
			}
			return ($applications == 1)?1:0;
		}
		// this function returns enq balance out of total enquiries
		function CheckCompanyEnquiriesBalance($companyid)
		{
			$sqltext = " Select enquirypackageid,enquiriesopeningbalance,enquiriesused,enquiriesclosingbalance from mstcompany where companyid='$companyid' ";
			$companies = self::getCompanies('',$sqltext);
			$applications = 0;
			if ($companies)
			{
				if ($companies[0]['enquirypackageid'] >0)
				{
					$applications = $companies[0]['enquiriesopeningbalance'].'|'.$companies[0]['enquiriesused'].'|'.$companies[0]['enquiriesclosingbalance'];
				}
			}
			return $applications;
		}
		// this function adds enquiries to company account
		function AddCompanyEnquiries($companyid,$noofenquiries=0)
		{
			// take a count of enq from trnpaymentheader for companyid 
			// update sum of enq from trnpaymentheader to mstcompany table in enquiriesopeningbalance and enquiriesclosingbalance
			// check below query tomorrow
			
			$sqltext = "UPDATE mstcompany a INNER JOIN ( SELECT companyid, sum( enqpurchased ) AS totalenqpurchase FROM trnpaymentheader WHERE companyid = '$companyid' GROUP BY companyid )b ON a.companyid = b.companyid SET a.enquiriesopeningbalance = b.totalenqpurchase, enquiriesclosingbalance = totalenqpurchase - enquiriesused ";

			//$sqltext = "UPDATE mstcompany SET enquiriesopeningbalance =  CASE WHEN enquiriesopeningbalance = 0 THEN $noofenquiries ELSE enquiriesopeningbalance + $noofenquiries END , enquiriesclosingbalance =  CASE WHEN enquiriesclosingbalance = 0 THEN $noofenquiries ELSE enquiriesclosingbalance + $noofenquiries END where companyid='$companyid'";
			//echo $sqltext;
			$applications = $this->obj1->update_query($sqltext);
			//self::UpdateEnquiryBalanceToSession($noofenquiries,0);
			return ($applications == 1)?1:0;
		}
		// this function reduces one enquiry from company account
		function DeductOneEnquiryCredit($companyid)
		{
			$sqltext = "update mstcompany set enquiriesused = enquiriesused + 1, enquiriesclosingbalance = enquiriesclosingbalance-1 where companyid='$companyid'";
				//echo $sqltext;
			$applications = $this->obj1->update_query($sqltext);
			UpdateEnquiryBalanceToSession(0,1);
			return ($applications == 1)?1:0;
		}
		// this function is called to check if enquiry is already bought
		function isEnquiryAlreadyBought($offerid,$companyid)
		{
			$sqltext = "Select offerseenincp from trnofferstocompanies where companyid='$companyid' and offerid='$offerid'";
			$companies = $this->obj1->select_query($sqltext);
			$applications = 0;
			if ($companies)
			{
				$numrows = $this->obj1->numRows($companies);
			}
			if ($numrows > 0 )
			{
				while ($companylist = mysql_fetch_assoc($companies))
				{
					$compstr[] = $companylist;
				}
				if ($compstr[0]['offerseenincp']=='1')
				{
					$applications = 1;
				}
				else 
				{
					// enquiry is there in 
					$applications = 2;
				}		
			}
			return $applications;
		}
		
		// this function is used when user is buying single enquiry from his quota
		function BuyEnquiry($offerid,$companyid)
		{
			$chkSufficientEnq = self::CheckCompanyEnquiriesCredit($companyid);

			if ($chkSufficientEnq==0)
			{
				$retval = 0;
			}
			else
			{
				// check if already bought 
				$chkEnqBought = self::isEnquiryAlreadyBought($offerid,$companyid);	
				// if not then add to trnofferstocompanies
				$todaysdate = date("Y-m-d H:s:i");
				if ($chkEnqBought==0)
				{
					// if enquiry is not bought then insert into trncompanyprod with ignore so if record is already present then there wont be another record inserted
					$sqltext = "insert ignore into trnofferstocompanies (offerid,companyid,offerseenincp,offerseenincpdatetime)values('$offerid', '$companyid','1','$todaysdate')";
					//$applications = self::getCompanies('',$sqltext);
					$applications = $this->obj1->update_query($sqltext);
					// update enquiry with companyid and offerseenincp = 1 so we can assume this enquiry is bought by client
					$sqltext = "update trnofferstocompanies set offerseenincp = '1',offerseenincpdatetime = '$todaysdate' where offerid ='$offerid' and companyid='$companyid'";
					//$applications = self::getCompanies('',$sqltext);
					$applications = $this->obj1->update_query($sqltext);
					// update mstcompany table to deduct 1 enquiry from total enquiries
					$sqltext = "update mstcompany set enquiriesused = enquiriesused + 1,enquiriesclosingbalance = enquiriesclosingbalance -1 where companyid='$companyid'";
					//echo $sqltext;
					//$applications = self::getCompanies('',$sqltext);
					$applications = $this->obj1->update_query($sqltext);
					UpdateEnquiryBalanceToSession(1,0);
					$retval = ($applications == 1)?1:0;
				}
				else if ($chkEnqBought==2)
				{
					$sqltext = "update trnofferstocompanies set offerseenincp = '1',offerseenincpdatetime = '$todaysdate' where offerid ='$offerid' and companyid='$companyid'";
					//$applications = self::getCompanies('',$sqltext);
					$applications = $this->obj1->update_query($sqltext);
					$sqltext = "update mstcompany set enquiriesused = enquiriesused + 1,enquiriesclosingbalance = enquiriesclosingbalance -1 where companyid='$companyid'";
					//echo $sqltext;
					//$applications = self::getCompanies('',$sqltext);
					$applications = $this->obj1->update_query($sqltext);
					UpdateEnquiryBalanceToSession(1,0);
					$retval = ($applications == 1)?1:0;	
				}
				else
				{
					$retval = 0;
				}
			}
			return $retval;
		}
		function UpdateEnquiryBalanceToSession($noofenquiriesAdded,$noofenquiriesUsed)
		{
			global $G_EnqOpeningBalance,$G_EnqUsed,$G_EnqClosingBalance;
			if ($noofenquiriesAdded > 0)
			{
				session::add_param('EnqOpeningBalance',intval($G_EnqOpeningBalance+$noofenquiries));
				$G_EnqOpeningBalance 	= intval($G_EnqOpeningBalance+$noofenquiries);
			}
			else if ($noofenquiriesUsed > 0)
			{
				session::add_param('EnqUsed',intval($EnqUsed+$noofenquiriesUsed));
				session::add_param('enquiriesclosingbalance',intval($enquiriesclosingbalance-$noofenquiriesUsed));
				$G_EnqUsed				= intval($EnqUsed+$noofenquiriesUsed);
				$G_EnqClosingBalance	= intval($enquiriesclosingbalance-$noofenquiriesUsed);
			}
		}
		function updatePayments($companyid,$packageid,$chequeno,$cheuqedate,$bankname,$branch,$depositeddate,$paymentgateway,$repid,$txnid)
		{
			// update trnpaymentheader
			$sql = "select * from trnpaymentheader where companyid='".$companyid."' and txnid='".$txnid."'";
			$payments = self::getCompanies('',$sql);
			
			if (!$payments)
			{
				$sqlpackages 		= "select * from mstpackages where packageid='".$packageid."'";
				$packagedetails	 	= self::getCompanies('',$sqlpackages);
				$packagerowcount 	= count($packagedetails);
					if ($packagerowcount > 0)
					{
						$package_name 	= $packagedetails[0]['packagename'];
						$package_desc 	= $packagedetails[0]['packagedesc'];

						$noofleads 		= $packagedetails[0]['noofenquiries'];
					
						if ($paymentgateway=='')
						{
							$onlinepayment ='0';
							$onlinepaymentamount ='0';
						}
						else if (strtoupper($paymentgateway)=='PAYU')
						{
							$localcurrency	= 'INR';
							$packageamountlocalcurrency	= $packagedetails[0]['packageamountINR'];
							$packagetaxamount			= $packagedetails[0]['taxamountindia'];
							$packagefinalamount			=  $packageamountlocalcurrency + $packagetaxamount;
						}
						else
						{
							$localcurrency	= $packagedetails[0]['localcurrency'];
							$packageamountlocalcurrency	= $packagedetails[0]['packageamountlocalcurrency'];
							$packagetaxamount			= 0;
							$packagefinalamount			=  $packageamountlocalcurrency + $packagetaxamount;
						}
						$packageamountUSD			= $packagedetails[0]['packageamountUSD'];
						$membershipperiodmonths		= $packagedetails[0]['membershipperiodmonths'];
					}
						$sql = "insert into trnpaymentheader
						(companyid, packageamountlocalcurrency, packageamountUSD, packageamount, packagediscountamount, packagefinalamount, packagedetails, resellerid, repid, packageid, paymentgatewayname, txnid, enqpurchased) 			values('$companyid','$localcurrency','$packageamountUSD','$packageamountlocalcurrency','','$packagefinalamount','$package_desc','','$repid','$packageid','$paymentgateway','$txnid','$noofleads')";

						$applications = $this->obj1->insert_query($sql);
						
						$sqltext = "Select paymentheaderid from trnpaymentheader where companyid='$companyid' and txnid='$txnid'";
						//echo $sqltext;
						$companies = $this->obj1->select_query($sqltext);
						$applications = 0;
						if ($companies)
						{
								while ($paymentlist = mysql_fetch_assoc($companies))
								{
									$paymentheaderid = $paymentlist['paymentheaderid'];
								}
								//echo 'payment header id'.$paymentheaderid;
								// update trnpaymentdetails
								if ($paymentgateway!='')
								{
									$onlinepayment = '1';
								}
								$sql = "insert into trnpaymentdetails(paymentheaderid, chequeno, chequedate, chequeamount, bankname, branch, depositeddate, onlinepayment, onlinepaymentamount) values('$paymentheaderid', '$chequeno','$chequedate','$chequeamount','$bankname','$branch','$depositeddate','$onlinepayment','$packagefinalamount')";
								//echo $sql;
								$applications = $this->obj1->insert_query($sql);
							
						}	
			}
		}
		
	}
	
	/*
		Registration Class : This will be used for two reasons
		1) To manage mstregistration table
		2) To Validate Login everytime
		
	*/
	
	class UserRegistration
	{
		function UserRegistration()
		{
			$this->obj1 = new dbopenconn();
			$this->con = $this->obj1->dbconnect();
		}
		// get list of or single compani(es) from database
		function getUserInfo($UserID='',$sql='',$fields='*')
		{
			if ($UserID!="")
			{
				$sqltext = "Select $fields from mstusers where userid='".$UserID."'";
			}
			else if ($sql!="")
			{
				$sqltext = $sql;
			}
			else
			{
				$sqltext = "Select $fields from mstusers";
			}
				
			$users = $this->obj1->select_query($sqltext);
			
			if ($users)
			{
				$numrows = $this->obj1->numRows($users);
			}
			
			if ($numrows ==1)
			{
				while ($userlist = mysql_fetch_assoc($users))
				{
					$userstr[] = $userlist;
				}	
			}
			else if($numrows > 1)
			{
				while ($userlist = mysql_fetch_assoc($users))
				{
					$userstr[] = $userlist;
				}
			}
			return $userstr;
		}
		
		// add company to database
		function AddUser($UserData)
		{
		if (is_array($UserData)== false)
			{
				return false;
			}
			else
			{
				$fieldnames =  "(";
				$fieldvalues = "(";
				foreach ($UserData as $k => $v) 
				{
					
					$fieldnames .=  ($fieldnames=="(")?"$k":",$k";
					$fieldvalues .= ($fieldvalues=="(")?"'$v'":",'$v'";
				}
				$sqltext = "insert into mstusers ".$fieldnames.") values ".$fieldvalues.")";
				//echo $sqltext;
				$applications = $this->obj1->insert_query($sqltext);
				return ($applications == 1)?"true":"false";
			}
		}
		
		function EditUser($applicationdata,$wherecondition)
		{
			if (is_array($applicationdata)== false)
			{
				return false;
			}
			else
			{
				$fieldnamesvalues =  "set ";
				
				foreach ($applicationdata as $k => $v) 
				{
					$fieldnamesvalues .=  ($fieldnamesvalues =="set ")?"$k='$v'":",$k='$v'";
				}
				$sqltext = "update mstusers ".$fieldnamesvalues." where ".$wherecondition ;
				//echo $sqltext;
				$applications = $this->obj1->update_query($sqltext);
				return ($applications == 1)?"true":"false";
				
			}
		
		}
		
		function DeleteUser($applicationdata)
		{
			if($applicationdata)
			{
				$sqltext = "delete from mstusers where userid='".$applicationdata."'";
				$applications = $this->obj1->delete_query($sqltext);
				return ($applications == 1)?"true":"false";
			}
		
		}
		
		// this function will be called to validate login everytime
		function ValidateLogin($username,$password,$ip='')
		{
			$returnvalue = "0";
			if (($username!='')&&($password!=''))
				{
					$userid = getUserInfo("","","select userid from mstusers where username='".$username."' and userpassword='".$password."' and userdeleted='0'");
					if ($userid[0]['userid']!="")
					{
						return $userid[0]['userid'];
					}
					else 
					{
						return $returnvalue;
					}
				}
			else
			{
				return $returnvalue;
			}	
		}
	}
	
	
	/*
		This class will be used for operations on Company related data
		mainly trnCompanyProduct table
	*/
	class CompanyProducts
	{
		function CompanyProducts()
		{
			$this->obj1 = new dbopenconn();
			$this->con = $this->obj1-> dbconnect();
		}
		// get Products for the Company
		function getCompanyProducts($CompanyProductID='',$sql='',$fields='*')
		{
			if ($CompanyProductID!="")
			{
				$sqltext = "Select $fields from trncompanyproduct where companyproductid='".$CompanyProductID."'";
			}
			else if ($sql!="")
			{
				$sqltext = $sql;
			}
			else
			{
				$sqltext = "Select $fields from trncompanyproduct limit 0,50";
			}
				
			$companyprod = $this->obj1->select_query($sqltext);
			
			if ($companyprod)
			{
				$numrows = $this->obj1->numRows($companyprod);
			}
			if ($numrows ==1)
			{
				while ($companyprodlist = mysql_fetch_assoc($companyprod))
				{
					$compprodstr[] = $companyprodlist;
				}	
			}
			else if($numrows > 1)
			{
				while ($companyprodlist = mysql_fetch_assoc($companyprod))
				{
					$compprodstr[] = $companyprodlist;
				}
			}
			return $compprodstr;
		
		}
		function AddCompanyProducts($CompanyData)
		{
		if (is_array($CompanyData)== false)
			{
				return false;
			}
			else
			{
				$fieldnames =  "(";
				$fieldvalues = "(";
				foreach ($CompanyData as $k => $v) 
				{
					
					$fieldnames .=  ($fieldnames=="(")?"$k":",$k";
					$fieldvalues .= ($fieldvalues=="(")?"'$v'":",'$v'";
				}
				$sqltext = "insert into trncompanyproduct ".$fieldnames.") values ".$fieldvalues.")";
				//echo $sqltext;
				$applications = $this->obj1->insert_query($sqltext);
				return ($applications == 1)?"true":"false";
			}
		
		}
		
		function EditCompanyProducts($applicationdata,$wherecondition)
		{
			if (is_array($applicationdata)== false)
			{
				return false;
			}
			else
			{
				$fieldnamesvalues =  "set ";
				
				foreach ($applicationdata as $k => $v) 
				{
					$fieldnamesvalues .=  ($fieldnamesvalues =="set ")?"$k='$v'":",$k='$v'";
				}
				$sqltext = "update trncompanyproduct ".$fieldnamesvalues." where ".$wherecondition ;
				//echo $sqltext;
				$applications = $this->obj1->update_query($sqltext);
				return ($applications == 1)?"true":"false";
				
			}
		}
		function DeleteCompanyProducts($applicationdata)
		{
			if($applicationdata)
			{
				$sqltext = "delete from trncompanyproduct where companyproductid='".$applicationdata."'";
				$applications = $this->obj1->delete_query($sqltext);
				return ($applications == 1)?"true":"false";
			}
		
		}
	}
	
	/*
		This class will be used for operations on Company related data
		mainly trnCompanyProfile table
	*/
	
	class CompanyProfile
	{
		function CompanyProfile()
		{
			$this->obj1 = new dbopenconn();
			$this->con = $this->obj1-> dbconnect();
		}
		function GetCompanyProfile($CompanyProfileID='',$sql='',$debugquery='',$fields='*')
		{
			if ($CompanyProfileID!="")
			{
				$sqltext = "Select $fields from trncompanyprofile where companyprofileid='".$CompanyProfileID."'";
			}
			else if ($sql!="")
			{
				$sqltext = $sql;
			}
			
			$companies = $this->obj1->select_query($sqltext);
			
			if ($companies)
			{
				$numrows = $this->obj1->numRows($companies);
			}
			if ($numrows ==1)
			{
				while ($companylist = mysql_fetch_assoc($companies))
				{
					$compstr[] = $companylist;
				}	
			}
			else if($numrows > 1)
			{
				while ($companylist = mysql_fetch_assoc($companies))
				{
					$compstr[] = $companylist;
				}
			}
			return $compstr;
		
		}
		function AddCompanyProfile($CompanyData)
		{
		if (is_array($CompanyData)== false)
			{
				return false;
			}
			else
			{
				$fieldnames =  "(";
				$fieldvalues = "(";
				foreach ($CompanyData as $k => $v) 
				{
					
					$fieldnames .=  ($fieldnames=="(")?"$k":",$k";
					$fieldvalues .= ($fieldvalues=="(")?"'$v'":",'$v'";
				}
				$sqltext = "insert into trncompanyprofile ".$fieldnames.") values ".$fieldvalues.")";
				//echo $sqltext;
				$applications = $this->obj1->insert_query($sqltext);
				return ($applications == 1)?"true":"false";
			}
		
		}
		function EditCompanyProfile($applicationdata,$wherecondition)
		{
			if (is_array($applicationdata)== false)
			{
				return false;
			}
			else
			{
				$fieldnamesvalues =  "set ";
				
				foreach ($applicationdata as $k => $v) 
				{
					$fieldnamesvalues .=  ($fieldnamesvalues =="set ")?"$k='$v'":",$k='$v'";
				}
				$sqltext = "update trncompanyprofile ".$fieldnamesvalues." where ".$wherecondition ;
				//echo $sqltext;
				$applications = $this->obj1->update_query($sqltext);
				return ($applications == 1)?"true":"false";
				
			}
		}
		function DeleteCompanyProfile($applicationdata)
		{
			if($applicationdata)
			{
				$sqltext = "delete from trncompanyprofile where companyprofileid='".$applicationdata."'";
				$applications = $this->obj1->delete_query($sqltext);
				return ($applications == 1)?"true":"false";
			}
		
		}
		
	}
	
	/*
		This class will be used for operations on Company related data
		mainly trnCompanyOffers and mstBuySell table
	*/
	class CompanyOffers
	{
		function CompanyOffers()
		{
			$this->obj1 = new dbopenconn();
			$this->con = $this->obj1-> dbconnect();
		}
		function getCompanyOffers($CompanyID='',$sql='',$debugquery='',$fields='*')
		{
			if ($CompanyID!="")
			{
				$sqltext = "Select $fields from trncompanyoffers where companyofferid='".$CompanyID."'";
			}
			else if ($sql!="")
			{
				$sqltext = $sql;
			}
			else
			{
				$sqltext = "Select $fields from trncompanyoffers limit 0,50";
			}
				
			$companies = $this->obj1->select_query($sqltext);
			
			if ($companies)
			{
				$numrows = $this->obj1->numRows($companies);
			}
			if ($numrows ==1)
			{
				while ($companylist = mysql_fetch_assoc($companies))
				{
					$compstr[] = $companylist;
				}	
			}
			else if($numrows > 1)
			{
				while ($companylist = mysql_fetch_assoc($companies))
				{
					$compstr[] = $companylist;
				}
			}
			return $compstr;
		}
		function AddCompanyOffers($CompanyData)
		{
			if (is_array($CompanyData)== false)
			{
				return false;
			}
			else
			{
				$fieldnames =  "(";
				$fieldvalues = "(";
				foreach ($CompanyData as $k => $v) 
				{
					
					$fieldnames .=  ($fieldnames=="(")?"$k":",$k";
					$fieldvalues .= ($fieldvalues=="(")?"'$v'":",'$v'";
				}
				$sqltext = "insert into trncompanyoffers ".$fieldnames.") values ".$fieldvalues.")";
				//echo $sqltext;
				$applications = $this->obj1->insert_query($sqltext);
				return ($applications == 1)?"true":"false";
			}
		}
		function EditCompanyOffers($applicationdata,$wherecondition)
		{
			if (is_array($applicationdata)== false)
			{
				return false;
			}
			else
			{
				$fieldnamesvalues =  "set ";
				
				foreach ($applicationdata as $k => $v) 
				{
					$fieldnamesvalues .=  ($fieldnamesvalues =="set ")?"$k='$v'":",$k='$v'";
				}
				$sqltext = "update trncompanyoffers ".$fieldnamesvalues." where ".$wherecondition ;
				$applications = $this->obj1->update_query($sqltext);
				return ($applications == 1)?"true":"false";
				
			}
		}
		function DeleteCompanyOffers($applicationdata)
		{
			if($applicationdata)
			{
				$sqltext = "delete from trncompanyoffers where companyofferid='".$applicationdata."'";
				$applications = $this->obj1->delete_query($sqltext);
				return ($applications == 1)?"true":"false";
			}
		}
	
	}
	/*
		This class will be used for operations on Company related data
		mainly trnCompanyWebShop
	*/
	class CompanyWebStore
	{
		function CompanyWebStore()
		{
			$this->obj1 = new dbopenconn();
			$this-> con = $this->obj1-> dbconnect();
		}
		function getCompanyWebStore($CompanyBusinessID='',$sql='',$debugquery='',$fields='*')
		{
			if ($CompanyBusinessID!="")
			{
				$sqltext = "Select $fields from trncompanywebstore where CompanyBusinessID='".$CompanyBusinessID."'";
			}
			else if ($sql!="")
			{
				$sqltext = $sql;
			}
			else
			{
				$sqltext = "Select $fields from trncompanywebstore limit 0,50";
			}
				
			$companies = $this->obj1->select_query($sqltext);
			
			if ($companies)
			{
				$numrows = $this->obj1->numRows($companies);
			}
			if ($numrows ==1)
			{
				while ($companylist = mysql_fetch_assoc($companies))
				{
					$compstr[] = $companylist;
				}	
			}
			else if($numrows > 1)
			{
				while ($companylist = mysql_fetch_assoc($companies))
				{
					$compstr[] = $companylist;
				}
			}
			return $compstr;
		}
		function AddCompanyWebStore($CompanyData)
		{
			if (is_array($CompanyData)== false)
			{
				return false;
			}
			else
			{
				$fieldnames =  "(";
				$fieldvalues = "(";
				foreach ($CompanyData as $k => $v) 
				{
					
					$fieldnames .=  ($fieldnames=="(")?"$k":",$k";
					$fieldvalues .= ($fieldvalues=="(")?"'$v'":",'$v'";
				}
				$sqltext = "insert into trncompanywebstore ".$fieldnames.") values ".$fieldvalues.")";
				//echo $sqltext;
				$applications = $this->obj1->insert_query($sqltext);
				return ($applications == 1)?"true":"false";
			}
		}
		function EditCompanyWebStore($applicationdata)
		{
			if (is_array($applicationdata)== false)
			{
				return false;
			}
			else
			{
				$fieldnamesvalues =  "set ";
				
				foreach ($applicationdata as $k => $v) 
				{
					$fieldnamesvalues .=  ($fieldnamesvalues =="set ")?"$k='$v'":",$k='$v'";
				}
				$sqltext = "update trncompanywebstore ".$fieldnamesvalues." where ".$wherecondition ;
				//echo $sqltext;
				$applications = $this->obj1->update_query($sqltext);
				return ($applications == 1)?"true":"false";
				
			}
		}
		function DeleteCompanyWebStore($applicationdata)
		{
			if($applicationdata)
			{
				$sqltext = "delete from trncompanywebstore where CompanyBusinessID='".$applicationdata."'";
				$applications = $this->obj1->delete_query($sqltext);
				return ($applications == 1)?"true":"false";
			}
		}
	
	}
	/*
		This class will be used for operations on Company related data
		mainly trnCompanyWebShop
	*/
	class WebStoreStats
	{
		function WebStoreStats()
		{
			$this->obj1 = new dbopenconn();
			$this-> con = $this->obj1-> dbconnect();
		}
		function getWebStoreStats($WebStoreStatsID='',$sql='',$debugquery='',$fields='*')
		{
			if ($WebStoreStatsID!="")
			{
				$sqltext = "Select $fields from webstorestats where WebStoreStatsID='".$WebStoreStatsID."'";
			}
			else if ($sql!="")
			{
				$sqltext = $sql;
			}
			else
			{
				$sqltext = "Select $fields from webstorestats limit 0,50";
			}
				
			$companies = $this->obj1->select_query($sqltext);
			
			if ($companies)
			{
				$numrows = $this->obj1->numRows($companies);
			}
			if ($numrows ==1)
			{
				while ($companylist = mysql_fetch_assoc($companies))
				{
					$compstr[] = $companylist;
				}	
			}
			else if($numrows > 1)
			{
				while ($companylist = mysql_fetch_assoc($companies))
				{
					$compstr[] = $companylist;
				}
			}
			return $compstr;
		}
		function AddWebStoreStats($CompanyData)
		{
			if (is_array($CompanyData)== false)
			{
				return false;
			}
			else
			{
				$fieldnames =  "(";
				$fieldvalues = "(";
				foreach ($CompanyData as $k => $v) 
				{
					
					$fieldnames .=  ($fieldnames=="(")?"$k":",$k";
					$fieldvalues .= ($fieldvalues=="(")?"'$v'":",'$v'";
				}
				$sqltext = "insert into webstorestats ".$fieldnames.") values ".$fieldvalues.")";
				//echo $sqltext;
				$applications = $this->obj1->insert_query($sqltext);
				return ($applications == 1)?"true":"false";
			}
		}
		function EditWebStoreStats($applicationdata)
		{
			if (is_array($applicationdata)== false)
			{
				return false;
			}
			else
			{
				$fieldnamesvalues =  "set ";
				
				foreach ($applicationdata as $k => $v) 
				{
					$fieldnamesvalues .=  ($fieldnamesvalues =="set ")?"$k='$v'":",$k='$v'";
				}
				$sqltext = "update webstorestats ".$fieldnamesvalues." where ".$wherecondition ;
				//echo $sqltext;
				$applications = $this->obj1->update_query($sqltext);
				return ($applications == 1)?"true":"false";
				
			}
		}
		function DeleteWebStoreStats($applicationdata)
		{
			if($applicationdata)
			{
				$sqltext = "delete from webstorestats where WebStoreStatsID='".$applicationdata."'";
				$applications = $this->obj1->delete_query($sqltext);
				return ($applications == 1)?"true":"false";
			}
		}
	
	}
		
?>	