<?php
//$imapPass   = 'evergr101%Sunny';
declare(strict_types=1);
require_once("../../../incl/config.php");
require_once(GLOBAL_INCLUDE_PATH."incl/startup.php");
require_once(GLOBAL_INCLUDE_PATH."incl/dbopenconn.php");	


date_default_timezone_set('Asia/Kolkata');

/* ========= CONFIG ========= */
$imapHost   = 'mail.gulfyp.com';
$imapPort   = 993;
$imapUser   = 'noreply@gulfyp.com';
$imapPass   = 'evergr101%Sunny';
$mailbox    = 'INBOX';
$onlySince  = (new DateTimeImmutable('14 days ago'))->format('d-M-Y');

$moveAfter  = true;
$moveTo     = 'INBOX.Processed/Bounces';

$outDir     = __DIR__;
$masterCsv  = $outDir . '/bounces_master_' . date('Y-m-d') . '.csv';
$noMxCsv    = $outDir . '/bounces_no_mx_' . date('Y-m-d') . '.csv';
/* ========================== */

$imapPath = sprintf('{%s:%d/imap/ssl/novalidate-cert}%s', $imapHost, $imapPort, $mailbox);
$conn = @imap_open($imapPath, $imapUser, $imapPass);
if (!$conn) {
    fwrite(STDERR, "IMAP connect failed: " . imap_last_error() . PHP_EOL);
    exit(1);
}

// Ensure move folder exists
if ($moveAfter) {
    $root = sprintf('{%s:%d/imap/ssl/novalidate-cert}', $imapHost, $imapPort);
    $list = imap_getmailboxes($conn, $root, '*') ?: [];
    $folders = array_map(function($o) { return $o->name; }, is_array($list) ? $list : []);
    if (!in_array($root . $moveTo, $folders, true)) {
        @imap_createmailbox($conn, imap_utf7_encode($root . $moveTo));
    }
}

/** ===== CSV helpers: write header once ===== */
function ensure_csv_with_header(string $path, array $header) {
    $needHeader = !file_exists($path) || (filesize($path) === 0);
    $fp = fopen($path, 'a');
    if (!$fp) return [null, false];
    if ($needHeader) {
        fputcsv($fp, $header);
    }
    return [$fp, true];
}

list($fpMaster, $ok1) = ensure_csv_with_header($masterCsv, ['datetime','category','final_recipient','action','status','diagnostic','recipient_domain','message_uid','subject']);
list($fpNoMx,  $ok2) = ensure_csv_with_header($noMxCsv,    ['datetime','final_recipient','recipient_domain','message_uid','subject']);
if (!$ok1 || !$ok2) {
    fwrite(STDERR, "Unable to open CSV files for writing.\n");
}

/** ===== IMAP fetch: prefer DSN/text parts ===== */
function decode_part(string $data, int $encoding): string {
    switch ($encoding) {
        case 3:  return base64_decode($data, true) ?: '';
        case 4:  return quoted_printable_decode($data);
        default: return $data;
    }
}

function fetch_bounce_text($conn, $uid): string {
    $structure = imap_fetchstructure($conn, $uid, FT_UID);
    if ($structure === false || !$structure) {
        $raw = imap_body($conn, $uid, FT_UID);
        return is_string($raw) ? $raw : '';
    }

    $text = '';
    if (!empty($structure->parts)) {
        $count = count($structure->parts);
        for ($i = 1; $i <= $count; $i++) {
            $part = $structure->parts[$i-1];
            $ctype = strtolower(($part->type ?? '') . '/' . ($part->subtype ?? ''));
            $raw   = imap_fetchbody($conn, $uid, (string)$i, FT_UID);
            if ($raw === false) continue;
            $raw = decode_part($raw, (int)($part->encoding ?? 0));

            if (strpos($ctype, 'message/delivery-status') !== false ||
                strpos($ctype, 'text/plain') !== false ||
                strpos($ctype, 'text/rfc822-headers') !== false) {
                $text .= "\n" . $raw;
            }
        }
        if ($text !== '') return $text;
    }

    $raw = imap_body($conn, $uid, FT_UID);
    return is_string($raw) ? $raw : '';
}

/** ===== Recipient extraction ===== */
function find_final_recipient(string $body, string $subject): ?string {
    // normalize line endings
    $norm = preg_replace("/\r\n|\r/", "\n", $body);

    // Exim block: "The following address(es) failed:"
    if (preg_match('/The following address(?:es)? failed:\s*([\s\S]*?)(?:\n\n|$)/i', $norm, $m)) {
        $block = $m[1];
        if (preg_match('/^\s*<?([A-Z0-9._%+\-]+@[A-Z0-9.\-]+\.[A-Z]{2,})>?/im', $block, $m2)) {
            return strtolower(trim($m2[1]));
        }
    }
    // RFC DSN
    if (preg_match('/Final-Recipient:\s*(?:rfc822;)?\s*<?([^>\s;]+)>?/i', $norm, $m)) {
        return strtolower(trim($m[1]));
    }
    // X-Failed-Recipients
    if (preg_match('/^X-Failed-Recipients:\s*([^\n]+)/mi', $norm, $m)) {
        $cand = trim($m[1]);
        if (preg_match('/([A-Z0-9._%+\-]+@[A-Z0-9.\-]+\.[A-Z]{2,})/i', $cand, $m2)) {
            return strtolower($m2[1]);
        }
        return strtolower($cand);
    }
    // RCPT TO
    if (preg_match('/RCPT TO:\s*<?([^>\s]+@[^>\s]+)>?/i', $norm, $m)) {
        return strtolower($m[1]);
    }
    // Generic in body (avoid returning your own address if present)
    if (preg_match('/\b([A-Z0-9._%+\-]+@[A-Z0-9.\-]+\.[A-Z]{2,})\b/i', $norm, $m)) {
        return strtolower($m[1]);
    }
    // Last resort: subject
    if (preg_match('/[A-Z0-9._%+\-]+@[A-Z0-9.\-]+\.[A-Z]{2,}/i', $subject, $m)) {
        return strtolower($m[0]);
    }
    return null;
}

/** ===== DNS helpers ===== */
function domain_has_mx(?string $domain): bool {
    if (!$domain) return false;
    $mx = @dns_get_record($domain, DNS_MX);
    return is_array($mx) && count($mx) > 0;
}

/** ===== Classifier ===== */
function classify_bounce(string $action, string $status, string $diagnostic, array $flags = []): string {
    $action = strtolower($action);
    $status = trim($status);
    $diag   = strtolower($diagnostic);

    if (!empty($flags['no_mx'])) return 'no_mx';

    // Dead server / network
    $deadHints = [
        'retry timeout exceeded','timed out','connection timed out',
        'connection refused','could not connect to','host not reachable'
    ];
    foreach ($deadHints as $h) {
        if ($h !== '' && strpos($diag, $h) !== false) return 'dead_server';
    }

    // Permanent (phrase-based) → HARD even if 4.x
    $hardPhrases = [
        'user unknown','unknown user','no such user','recipient unknown','recipient not found',
        'recipient address rejected','mailbox unavailable','mailbox does not exist','account disabled',
        'unrouteable address','bad destination mailbox address','relay denied, invalid recipient',
        'recipient rejected','not a known user','no mail-enabled subscriptions',
        '5.1.1','5.1.10'
    ];
    foreach ($hardPhrases as $p) {
        if ($p !== '' && strpos($diag, $p) !== false) return 'hard';
    }

    // Policy/auth rejections → HARD
    $policy = [
        '5.7.1','dmarc policy','dmarc reject','spf fail','dkim fail','blocked for abuse',
        'blacklist','blocklist','spamhaus','message content rejected','sender prohibited',
        'access denied','not permitted','unauthenticated sender','mail received as unauthenticated'
    ];
    foreach ($policy as $p) {
        if ($p !== '' && strpos($diag, $p) !== false) return 'hard';
    }

    // Action/status fallbacks
    if ($action === 'failed') return 'hard';
    if ($status !== '') {
        if (strpos($status, '5.') === 0) return 'hard';
        if (strpos($status, '4.') === 0) return 'soft';
    }

    return 'soft';
}

/** ===== SEARCH & PROCESS ===== */
$search = 'SINCE "' . $onlySince . '"';
$uids = imap_search($conn, $search, SE_UID);
if (!$uids) {
    echo "No messages matched ($search). Nothing to do." . PHP_EOL;
    imap_close($conn);
    exit(0);
}

/** ===== MAIN LOOP ===== */
foreach ($uids as $uid) {
    $msgno  = imap_msgno($conn, $uid);
    $header = $msgno ? imap_headerinfo($conn, $msgno) : false;
    
    $subject = (is_object($header) && isset($header->subject)) ? imap_utf8($header->subject) : '';
    
    // $date    = (is_object($header) && isset($header->date)) ? date('Y-m-d H:i:s', strtotime($header->date)) : date('Y-m-d H:i:s');
    if (is_object($header) && !empty($header->date)) {
        $timestamp = strtotime($header->date);
        $date = $timestamp !== false ? date('Y-m-d H:i:s', $timestamp) : date('Y-m-d H:i:s');
    } else {
        $date = date('Y-m-d H:i:s');
    }
    
    // Prefer DSN/text parts
    $body = fetch_bounce_text($conn, $uid);

    // Extract recipient email & domain (robust)
    $finalRecipient  = find_final_recipient($body, $subject) ?? '';
    // $recipientDomain = $finalRecipient ? substr(strrchr($finalRecipient, "@"), 1) : '';
    $recipientDomain = (is_string($finalRecipient) && strpos($finalRecipient, '@') !== false) ? substr(strrchr($finalRecipient, '@'), 1) : '';


    // Parse fields (best-effort)
    $action = '';
    $status = '';
    $diagnostic = '';
    if ($body !== '') {
        if (preg_match('/Action:\s*([^\r\n]+)/i', $body, $m))          $action = trim($m[1]);
        if (preg_match('/Status:\s*([0-9\.]+)/i', $body, $m))          $status = trim($m[1]);
        if (preg_match('/Diagnostic-Code:\s*(.+)/i', $body, $m))       $diagnostic = trim($m[1]);
        if ($finalRecipient === '' && preg_match('/^X-Failed-Recipients:\s*([^\r\n]+)/mi', $body, $m)) {
            $candidates = array_filter(array_map('trim', preg_split('/[, ]+/', $m[1])));
            if (!empty($candidates)) {
                $finalRecipient  = strtolower($candidates[0]);
                $recipientDomain = substr(strrchr($finalRecipient, "@"), 1);
            }
        }
    }

    // Only check MX if we actually have a recipient
    $noMxFlag = ($finalRecipient !== '' && $recipientDomain !== '') ? !domain_has_mx($recipientDomain) : false;

    // If we still don’t have a recipient, mark as unparsed (not no_mx)
    $category = ($finalRecipient === '')
        ? 'unparsed'
        : classify_bounce($action, $status, $diagnostic, ['no_mx' => $noMxFlag]);

    if ($fpMaster) {
        fputcsv($fpMaster, [$date, $category, $finalRecipient, $action, $status, $diagnostic, $recipientDomain, $uid, $subject]);
    }
    if ($finalRecipient !== '') {
        
        $stmt = $connect->prepare("
            UPDATE mstcompany
            SET email = TRIM(BOTH ',' FROM REPLACE(CONCAT(',', email, ','), CONCAT(',', ?, ','), ','))
            WHERE FIND_IN_SET(?, email)");
            
            /* for multiple separators
            UPDATE mstcompany
SET email = TRIM(BOTH ',;/ ' FROM 
            REPLACE(
                REPLACE(
                    REPLACE(CONCAT(',', REPLACE(REPLACE(REPLACE(email, ';', ','), '/', ','), ',,', ','), ','),
                           CONCAT(',', ?, ','), 
                           ','),
                ',,', ','),
            ',,', ','))
WHERE FIND_IN_SET(?, REPLACE(REPLACE(REPLACE(email, ';', ','), '/', ','), ',,', ','));
            */
        $stmt->bind_param("ss", $finalRecipient, $finalRecipient);
        $stmt->execute();
        $stmt->close();
        
        echo "UPDATE mstcompany
            SET email = TRIM(BOTH ',' FROM REPLACE(CONCAT(',', email, ','), CONCAT(',', '$finalRecipient', ','), ','))
            WHERE FIND_IN_SET('$finalRecipient', email);"."<br/>";
        
        
    }

    if ($category === 'no_mx' && $fpNoMx) {
        fputcsv($fpNoMx, [$date, $finalRecipient, $recipientDomain, $uid, $subject]);
    }

    if ($moveAfter) {
        @imap_mail_move($conn, (string)$uid, $moveTo, CP_UID);
    }
}

if ($fpMaster) fclose($fpMaster);
if ($fpNoMx)  fclose($fpNoMx);

if ($moveAfter) {
    imap_expunge($conn);
}

imap_close($conn);
echo "Bounce processing complete.\n";
