<?php
require_once(GLOBAL_INCLUDE_PATH."begin_gzip.php");
require_once(GLOBAL_INCLUDE_PATH."incl/startup.php");
require_once(GLOBAL_INCLUDE_PATH."incl/dbopenconn.php");
	
$latestcomps -> obj1 = new CommonProc();



if(basename(__FILE__) == basename($_SERVER["SCRIPT_FILENAME"]))
{
	$return_array = array();
	$sql= "select email,CompanyID from mstcompany where email<>'' and countryid=19 limit 0,1000";
	$resultlist = $latestcomps->obj1->getResults('',$sql);
	$rowcount= count($resultlist);

for($i=0;$i<$rowcount;$i++)
{
      $emailtoverify = $resultlist[$i]['email'];
      $CompanyID= $resultlist[$i]['CompanyID'];

if($emailtoverify == '' || !isset($emailtoverify))
{
    $return_array['error']              = 1;
    $return_array['message']            = 'No email address was submitted for verification';
    $return_array['domain_verified']    = 0;
    $return_array['format_verified']    = 0;
}
else
{
    $verify = new EmailVerify();

    if($verify->verify_formatting($emailtoverify))
    {
        $return_array['format_verified']    = 1;

        if($verify->verify_domain($emailtoverify))
        {
            $return_array['error']              = 0;
            $return_array['domain_verified']    = 1;
            $return_array['message']            = 'Formatting and domain have been verified';
        }
        else
        {
            $return_array['error']              = 1;
            $return_array['domain_verified']    = 0;
            $return_array['message']            = 'Formatting was verified, but verification of the domain has failed';
        }
    }
   
    else
    {
        $return_array['error']              = 1;
        $return_array['domain_verified']    = 0;
        $return_array['format_verified']    = 0;
        $return_array['message']            = 'Email was not formatted correctly';
    }
    
    if($return_array['error']==1) 
    {
      $return_array['companyid']              = $CompanyID;
      $return_array['email']              = $emailtoverify;
    }
    	
 
}
 
   if($return_array['error']==1) 
    {	
      echo json_encode($return_array);
   }
}

}


class EmailVerify 
{
	public function __construct()
	{
	
	}
	
	public function verify_domain($address_to_verify)
	{
	    // an optional sender 
	    $record = 'MX';
	    list($user, $domain) = explode('@', $address_to_verify.'.');
	    return checkdnsrr($domain, $record);
	}
	
	public function verify_formatting($address_to_verify)
	{
	    if(strstr($address_to_verify, "@") == FALSE)
	    {
	        return false;
	    }
	    else
	    {
	        list($user, $domain) = explode('@', $address_to_verify);
	
	        if(strstr($domain, '.') == FALSE){
	            return false;
	        }else{
	            return true;
	        }
	    }
	 }
 }
?>
