<?php
	
	class RSSFeed {
// VARIABLES
    // channel vars
    var $channel_url;
    var $channel_title;
    var $channel_description;
    var $channel_lang;
    var $channel_copyright;
    var $channel_date;
    var $channel_creator;
    var $channel_subject;   
    // image
    var $image_url;
    // items
    var $items = array();
    var $nritems;
    
// FUNCTIONS
    // constructor
    function RSSFeed() {
            $this->nritems=0;
        $this->channel_url='';
        $this->channel_title='';
        $this->channel_description='';
        $this->channel_lang='';
        $this->channel_copyright='';
        $this->channel_date='';
        $this->channel_creator='';
        $this->channel_subject='';
        $this->image_url='';
    }   
    // set channel vars
    function SetChannel($url, $title, $description, $lang, $copyright, $creator, $subject) {
        $this->channel_url=$url;
        $this->channel_title=$title;
        $this->channel_description=$description;
        $this->channel_lang=$lang;
        $this->channel_copyright=$copyright;
        $this->channel_date=date("Y-m-d").'T'.date("H:i:s").'+01:00';
        $this->channel_creator=$creator;
        $this->channel_subject=$subject;
    }
    // set image
    function SetImage($url) {
        $this->image_url=$url;  
    }
    // set item
    function SetItem($url, $title, $description) {
        $this->items[$this->nritems]['url']=$url;
        $this->items[$this->nritems]['title']=$title;
        $this->items[$this->nritems]['description']=$description;
        $this->nritems++;   
    }
    // output feed
    function Output() {
        $output =  '<?xml version="1.0" encoding="iso-8859-1"?>'."\n";
        $output .= '<rdf:RDF xmlns:rdf="http://www.w3.org/1999/02/22-rdf-syntax-ns#" xmlns="http://purl.org/rss/1.0/" xmlns:slash="http://purl.org/rss/1.0/modules/slash/" xmlns:taxo="http://purl.org/rss/1.0/modules/taxonomy/" xmlns:dc="http://purl.org/dc/elements/1.1/" xmlns:syn="http://purl.org/rss/1.0/modules/syndication/" xmlns:admin="http://webns.net/mvcb/" xmlns:feedburner="http://rssnamespace.org/feedburner/ext/1.0">'."\n";
        $output .= '<channel rdf:about="'.$this->channel_url.'">'."\n";
        $output .= '<title>'.$this->channel_title.'</title>'."\n";
        $output .= '<link>'.$this->channel_url.'</link>'."\n";
        $output .= '<description>'.$this->channel_description.'</description>'."\n";
        $output .= '<dc:language>'.$this->channel_lang.'</dc:language>'."\n";
        $output .= '<dc:rights>'.$this->channel_copyright.'</dc:rights>'."\n";
        $output .= '<dc:date>'.$this->channel_date.'</dc:date>'."\n";
        $output .= '<dc:creator>'.$this->channel_creator.'</dc:creator>'."\n";
        $output .= '<dc:subject>'.$this->channel_subject.'</dc:subject>'."\n";

        $output .= '<items>'."\n";
        $output .= '<rdf:Seq>';
        for($k=0; $k<$this->nritems; $k++) {
            $output .= '<rdf:li rdf:resource="'.$this->items[$k]['url'].'"/>'."\n"; 
        };      
        $output .= '</rdf:Seq>'."\n";
        $output .= '</items>'."\n";
        $output .= '<image rdf:resource="'.$this->image_url.'"/>'."\n";
        $output .= '</channel>'."\n";
        for($k=0; $k<$this->nritems; $k++) {
            $output .= '<item rdf:about="'.$this->items[$k]['url'].'">'."\n";
            $output .= '<title>'.$this->items[$k]['title'].'</title>'."\n";
            $output .= '<link>'.$this->items[$k]['url'].'</link>'."\n";
            $output .= '<description>'.$this->items[$k]['description'].'</description>'."\n";
            $output .= '<feedburner:origLink>'.$this->items[$k]['url'].'</feedburner:origLink>'."\n";
            $output .= '</item>'."\n";  
        };
        $output .= '</rdf:RDF>'."\n";
        return $output;
    }
};
		
	    require_once(GLOBAL_INCLUDE_PATH."incl/startup.php");
		require_once(GLOBAL_INCLUDE_PATH."incl/dbopenconn.php");
	
		$myfeed = new RSSFeed();
		$myfeed->SetChannel('http://'.strtolower(SITE_DOMAIN).'/feeds/Buy-Offers.rss',
          'Buy Offers On '.strtolower(SITE_DOMAIN).'',
                  'These are Buy Offers Posted on '.strtolower(SITE_DOMAIN).'',
          'en-us',
          'Copyright 2018-2025 '.strtolower(SITE_DOMAIN).'',
                  ''.strtolower(SITE_DOMAIN).'',
          'Latest Buy Offers on '.strtolower(SITE_DOMAIN).'');
		
		//$myfeed->SetImage('http://www.mysite.com/mylogo.jpg');
		
		
	   $query = "SELECT offerid, offertitle, searchproductterm, offerdate, offerdesc, maingroupnameurl FROM mstoffers a LEFT JOIN mstproduct b ON a.selectedproductid = b.productid
		LEFT JOIN mstmaingroup c ON b.maingroupid = c.maingroupid WHERE offerdontshow = '0' and offerbyuserid > 0 ORDER BY offerid DESC LIMIT 0 , 100";
	 
	   $result = mysql_query($query) or die ("Could not execute query");
	 
	   while($row = mysql_fetch_array($result)) {
		
				$desc = preview_text(strip_tags(str_replace('&amp;',' and ',$row[4])),100);
		
				$maingroupurl = ($row[5]=='')?'':$row[5];
				$enquirytitle = replaceForURL($row[1]);
				$enquiryid	  = intval($row[0]);
				$myfeed->SetItem('http://'.strtolower(SITE_DOMAIN).'/'.$maingroupurl. '-market/buy/'.$enquirytitle.'-'.$enquiryid.'.htm',
                   str_replace('&amp;','and',$row[1]),
                   $desc);
				   
		}
		$feedvar = $myfeed->output();
		
		$myFile = "/home/gulfyp/public_html/feeds/Buy-Offers.rss";
		unlink($myFile);
		$fh = fopen($myFile, 'w+') or die("can't open file");
		if ($fh){
			$stringData = $feedvar."\n";
			fwrite($fh, $stringData);
			fclose($fh);
		}
		else
		{
			echo 'error opening file';
		}
?>