<?php

///////////////////////////////////////
// sanitize.inc.php
// Sanitization functions for PHP
// by: Gavin Zuchlinski, Jamie Pratt, Hokkaido
// webpage: http://libox.net
// Last modified: September 27, 2003
//
// Many thanks to those on the webappsec list for helping me improve these functions
///////////////////////////////////////
// Function list:
// sanitize_paranoid_string($string) -- input string, returns string stripped of all non 
//           alphanumeric
// sanitize_system_string($string) -- input string, returns string stripped of special
//           characters
// sanitize_sql_string($string) -- input string, returns string with slashed out quotes
// sanitize_html_string($string) -- input string, returns string with html replacements
//           for special characters
// sanitize_int($integer) -- input integer, returns ONLY the integer (no extraneous 
//           characters
// sanitize_float($float) -- input float, returns ONLY the float (no extraneous 
//           characters)
// sanitize($input, $flags) -- input any variable, performs sanitization 
//           functions specified in flags. flags can be bitwise 
//           combination of PARANOID, SQL, SYSTEM, HTML, INT, FLOAT, LDAP, 
//           UTF8
///////////////////////////////////////
define("PARANOID", 1);
define("SQL", 2);
define("SYSTEM", 4);
define("HTML", 8);
define("INT", 16);
define("FLOAT", 32);
define("LDAP", 64);
define("UTF8", 128);

// internal function for utf8 decoding
// thanks to Jamie Pratt for noticing that PHP's function is a little 
// screwy

function my_utf8_decode($string)
{
return strtr($string, 
  "???????", 
  "SOZsozYYuAAAAAAACEEEEIIIIDNOOOOOOUUUUYsaaaaaaaceeeeiiiionoooooouuuuyy");
}

// paranoid sanitization -- only let the alphanumeric set through
function sanitize_paranoid_string($string, $min='', $max='')
{
  $string = preg_replace("/[^a-zA-Z0-9]/", "", $string);
  $len = strlen($string);
  if((($min != '') && ($len < $min)) || (($max != '') && ($len > $max)))
    return FALSE;
  return $string;
}

// sanitize a string in prep for passing a single argument to system() (or similar)
function sanitize_system_string($string, $min='', $max='')
{
  $pattern = '/(;|\||`|>|<|&|^|"|'."\n|\r|'".'|{|}|[|]|\)|\()/i'; // no piping, passing possible environment variables ($),
                           // seperate commands, nested execution, file redirection, 
                           // background processing, special commands (backspace, etc.), quotes
                           // newlines, or some other special characters
  $string = preg_replace($pattern, '', $string);
  $string = '"'.preg_replace('/\$/', '\\\$', $string).'"'; //make sure this is only interpretted as ONE argument
  $len = strlen($string);
  if((($min != '') && ($len < $min)) || (($max != '') && ($len > $max)))
    return FALSE;
  return $string;
}

// sanitize a string for SQL input (simple slash out quotes and slashes)
function sanitize_sql_string($string, $min='', $max='')
{
  $pattern[0] = '/(\\\\)/';
  $pattern[1] = "/\"/";
  $pattern[2] = "/'/";
  $replacement[0] = '\\\\\\';
  $replacement[1] = '\"';
  $replacement[2] = "\\'";
  $len = strlen($string);
  if((($min != '') && ($len < $min)) || (($max != '') && ($len > $max)))
    return FALSE;
  return preg_replace($pattern, $replacement, $string);
}

// sanitize a string for SQL input (simple slash out quotes and slashes)
function sanitize_ldap_string($string, $min='', $max='')
{
  $pattern = '/(\)|\(|\||&)/';
  $len = strlen($string);
  if((($min != '') && ($len < $min)) || (($max != '') && ($len > $max)))
    return FALSE;
  return preg_replace($pattern, '', $string);
}


// sanitize a string for HTML (make sure nothing gets interpretted!)
function sanitize_html_string($string)
{
  $pattern[0] = '/\&/';
  $pattern[1] = '/</';
  $pattern[2] = "/>/";
  $pattern[3] = '/\n/';
  $pattern[4] = '/"/';
  $pattern[5] = "/'/";
  $pattern[6] = "/%/";
  $pattern[7] = '/\(/';
  $pattern[8] = '/\)/';
  $pattern[9] = '/\+/';
  $pattern[10] = '/-/';
  $replacement[0] = '&amp;';
  $replacement[1] = '&lt;';
  $replacement[2] = '&gt;';
  $replacement[3] = '<br>';
  $replacement[4] = '&quot;';
  $replacement[5] = '&#39;';
  $replacement[6] = '&#37;';
  $replacement[7] = '&#40;';
  $replacement[8] = '&#41;';
  $replacement[9] = '&#43;';
  $replacement[10] = '&#45;';
  return preg_replace($pattern, $replacement, $string);
}

// make int int!
function sanitize_int($integer, $min='', $max='')
{
  $int = intval($integer);
  if((($min != '') && ($int < $min)) || (($max != '') && ($int > $max)))
    return FALSE;
  return $int;
}

// make float float!
function sanitize_float($float, $min='', $max='')
{
  $float = floatval($float);
  if((($min != '') && ($float < $min)) || (($max != '') && ($float > $max)))
    return FALSE;
  return $float;
}

// glue together all the other functions
function sanitize($input, $flags, $min='', $max='')
{
  if($flags & UTF8) $input = my_utf8_decode($input);
  if($flags & PARANOID) $input = sanitize_paranoid_string($input, $min, $max);
  if($flags & INT) $input = sanitize_int($input, $min, $max);
  if($flags & FLOAT) $input = sanitize_float($input, $min, $max);
  if($flags & HTML) $input = sanitize_html_string($input, $min, $max);
  if($flags & SQL) $input = sanitize_sql_string($input, $min, $max);
  if($flags & LDAP) $input = sanitize_ldap_string($input, $min, $max);
  if($flags & SYSTEM) $input = sanitize_system_string($input, $min, $max);
  return $input;
}

// end of sanitize
	function preview_text($TEXT, $LIMIT, $TAGS = 0) {
	
		// TRIM TEXT
		$TEXT = trim($TEXT);
	
		// STRIP TAGS IF PREVIEW IS WITHOUT HTML
		if ($TAGS == 0) $TEXT = preg_replace('/\s\s+/', ' ', strip_tags($TEXT));
	
		// IF STRLEN IS SMALLER THAN LIMIT RETURN
		if (strlen($TEXT) < $LIMIT) return $TEXT;
	
		if ($TAGS == 0) return substr($TEXT, 0, $LIMIT) . " ...";
		else {
	
			$COUNTER = 0;
			for ($i = 0; $i<= strlen($TEXT); $i++) {
	
				if ($TEXT{$i} == "<") $STOP = 1;
	
				if ($STOP != 1) {
	
					$COUNTER++;
				}
	
				if ($TEXT{$i} == ">") $STOP = 0;
				$RETURN .= $TEXT{$i};
	
				if ($COUNTER >= $LIMIT && $TEXT{$i} == " ") break;
	
			}
	
			return $RETURN . "...";
		}
	}	
	function ProperCase($strToConvert)
	{
		$strToReturn = ucwords(strtolower($strToConvert));
		return $strToReturn;
	
	} 
	function getCountryListForCombo($GCountry='')
	{
		
		$testclass		=	new AllTables();
		$countrylist 	=	$testclass->getInfo('', "SELECT * from mstcountry");
		
		$rowcount = count($countrylist);
		
		$strCountryList = "";
		
		if ($rowcount > 0)
		{
			$currentcountry = strtolower(rtrim(ltrim($GCountry)));
			for($i=0;$i<$rowcount;$i++) 	
			{	
				$databasecountry = strtolower(rtrim(ltrim($countrylist[$i]['countryname'])));
				$compare = strcmp($currentcountry,$databasecountry);
				
				if ($compare == 0)
				{
					$strCountryList .= "<option value='".$countrylist[$i]['countryid']."-".$countrylist[$i]['countryname']."' selected='selected'>".ucwords(strtolower($countrylist[$i]['countryname']))."</option>";
				}
				else
				{	
					$strCountryList .= "<option value='".$countrylist[$i]['countryid']."-".$countrylist[$i]['countryname']."'>".ucwords(strtolower($countrylist[$i]['countryname']))."</option>";
				}
			}
		}
		unset($testclass);
		return $strCountryList;	
	}
	
	function getCityListForCombo($GCity='',$countryid='',$countryname='')
	{
		$testclass		=	new AllTables();
		
		if ($countryid!='')
		{
			$citylist = $testclass->getInfo("","SELECT cityid,cityname,citycode FROM mstcity WHERE countryid ='".$countryid."' ORDER BY cityorder DESC , cityname, cityid");
		}
		else if($countryname!='')
		{
			$citylist = $testclass->getInfo("","SELECT cityid,cityname,citycode FROM mstcity WHERE countryid in (Select countryid from mstcountry where countryname ='".$countryname."') ORDER BY cityorder DESC , cityname, cityid");
		}
		else
		{
			$citylist = $testclass->getInfo("","select cityid,cityname,citycode from mstcity ORDER BY cityorder DESC , cityname, cityid");
		}
		$rowcount = count($citylist);
		
		$strCityList = "";
		
		if ($rowcount > 0)
		{
			for($i=0;$i<$rowcount;$i++) 
			{	
				if(strtoupper($GCity)==$citylist[$i]['cityname'])
				{
					$strCityList .= "<option value='".$citylist[$i]['cityid']."-".$citylist[$i]['cityname']."' selected='selected'>".ucwords(strtolower($citylist[$i]['cityname']))."</option>";
				}
				else
				{	
					$strCityList .= "<option value='".$citylist[$i]['cityid']."-".$citylist[$i]['cityname']."'>".ucwords(strtolower($citylist[$i]['cityname']))."</option>";
				}
			}
		}
		unset($testclass);
		return $strCityList;	
	}
	
	function getStateListForCombo($GStateid='',$countryid='',$countryname='')
	{
		$testclass		=	new AllTables();
		
		if ($countryid!='')
		{
			$statelist = $testclass->getInfo("","SELECT * FROM mststate WHERE countryid ='".$countryid."' ORDER BY State asc");
		}
		else if($countryname!='')
		{
			$statelist = $testclass->getInfo("","SELECT * FROM mststate WHERE countryid in (Select countryid from mstcountry where countryname ='".$countryname."') ORDER BY State");
		}
		else
		{
			$statelist = $testclass->getInfo("","select * FROM mststate ORDER BY State");
		}
		$rowcount = count($statelist);
		
		$strstatelist = "";
		
		if ($rowcount > 0)
		{
			for($i=0;$i<$rowcount;$i++) 
			{	
				if(strtoupper($GStateid)==$statelist[$i]['State'])
				{
					$strstatelist .= "<option value='".$statelist[$i]['StateId']."-".$statelist[$i]['State']."' selected='selected'>".ucwords(strtolower($statelist[$i]['State']))."</option>";
				}
				else
				{	
					$strstatelist .= "<option value='".$statelist[$i]['StateId']."-".$statelist[$i]['State']."'>".ucwords(strtolower($statelist[$i]['State']))."</option>";
				}
			}
		}
		unset($testclass);
		return $strstatelist;	
	}
	
	
	
	
	function getRegionsListForCombo($GRegion='')
	{
		
				$testclass		=	new AllTables();
				$regionlist 	=	$testclass->getInfo('', "SELECT * from mstregion order by regionname asc");
				
				$rowcount = count($regionlist);
				
				$strregionlist = "";
				
				if ($rowcount > 0)
				{
					$currentregion = strtolower(rtrim(ltrim($GRegion)));
					for($i=0;$i<$rowcount;$i++) 	
					{	
						$databaseregion = strtolower(rtrim(ltrim($regionlist[$i]['regionname'])));
						$compare = strcmp($currentregion,$databaseregion);
						
						if ($compare == 0)
						{
							$strregionlist .= "<option value='".$regionlist[$i]['regionid']."-".$regionlist[$i]['regionname']."' selected='selected'>".ucwords(strtolower($regionlist[$i]['regionname']))."</option>";
						}
						else
						{	
							$strregionlist .= "<option value='".$regionlist[$i]['regionid']."-".$regionlist[$i]['regionname']."'>".ucwords(strtolower($regionlist[$i]['regionname']))."</option>";
						}
					}
				}
				unset($testclass);
				return $strregionlist;	
	}
	function getPagesListForCombo($Gpages='')
	{
		
				$testclass		=	new AllTables();
				$pageslist 	=	$testclass->getInfo('', "SELECT * from mstpages ");
				
				$rowcount = count($pageslist);
				
				$strpageslist = "";
				
				if ($rowcount > 0)
				{
					$currentpages = strtolower(rtrim(ltrim($Gpages)));
					for($i=0;$i<$rowcount;$i++) 	
					{	
						$databasepages = strtolower(rtrim(ltrim($pageslist[$i]['pagename'])));
						$compare = strcmp($currentpages,$databasepages);
						
						if ($compare == 0)
						{
							$strpageslist .= "<option value='".$pageslist[$i]['pageid']."' selected='selected'>".ucwords(strtolower($pageslist[$i]['pagename']))."</option>";
						}
						else
						{	
							$strpageslist .= "<option value='".$pageslist[$i]['pageid']."'>".ucwords(strtolower($pageslist[$i]['pagename']))."</option>";
						}
					}
				}
				unset($testclass);
				return $strpageslist;	
	}
	function getThemeListForCombo($GTheme='')
	{
		
				$testclass		=	new AllTables();
				$themelist 	=	$testclass->getInfo('', "SELECT * from msttheme order by themename asc");
				
				$rowcount = count($themelist);
				
				$strTheme = "";
				
				if ($rowcount > 0)
				{
					$currenttheme = strtolower(rtrim(ltrim($GTheme)));
					for($i=0;$i<$rowcount;$i++) 	
					{	
						$databasetheme = strtolower(rtrim(ltrim($themelist[$i]['themename'])));
						$compare = strcmp($currenttheme,$databasetheme);
						
						if ($compare == 0)
						{
							$strTheme .= "<option value='".$themelist[$i]['themeid']."-".$themelist[$i]['themename']."' selected='selected'>".ucwords(strtolower($themelist[$i]['themename']))."</option>";
						}
						else
						{	
							$strTheme .= "<option value='".$themelist[$i]['themeid']."-".$themelist[$i]['themename']."'>".ucwords(strtolower($themelist[$i]['themename']))."</option>";
						}
					}
				}
				unset($testclass);
				return $strTheme;	
	}
	
	function CityName($cityid)
	{
	
			$testclass		=	new AllTables();
			$sql			=	"SELECT cityname from mstcity where cityid='$cityid'";
			$citylist 		=	$testclass->getInfo('',$sql);
			if(is_array($citylist))
			{
					$cityname	=	$citylist[0]['cityname'];
					return $cityname;
			}
	}
	function CountryName($countryid)
	{
	
			$testclass		=	new AllTables();
			$sql			=	"SELECT countryname from mstcountry where countryid='$countryid'";
			$countrylist 		=	$testclass->getInfo('',$sql);
			if(is_array($countrylist))
			{
					$countryname	=	$countrylist[0]['countryname'];
					return $countryname;
			}
	}
	function RegionName($regionid)
	{
	
			$testclass		=	new AllTables();
			$sql			=	"SELECT regionname from  mstregion where regionid='$regionid'";
			$Regionlist 		=	$testclass->getInfo('',$sql);
			if(is_array($Regionlist))
			{
					$regionname	=	$Regionlist[0]['regionname'];
					return $regionname;
			}
	}
	function LocationName($locationid)
	{
	
			$testclass				=	new AllTables();
			$sqlLocation			=	"SELECT locationname from  mstlocation where locationid='$locationid'";
			$LocationList 			=	$testclass->getInfo('',$sqlLocation);
			if(is_array($LocationList))
			{
					$locationname	=	$LocationList[0]['locationname'];
					//unset($testclass);
					return $locationname;
			}
	}
	function ThemeName($themeid)
	{
	
			$testclass			=	new AllTables();
			$sqlthemeid			=	"SELECT themename from  msttheme where themeid='$themeid'";
			$themelist 			=	$testclass->getInfo('',$sqlthemeid);
			if(is_array($themelist))
			{
					$themename	=	$themelist[0]['themename'];
					return $themename;
					unset($testclass);
			}
	}
	function getPackageDetails($tourpackageid)
	{
			$testclass			=	new AllTables();
			$sqlpack			=	"SELECT * from  GTR_tourpackages where tourpackageid='$tourpackageid'";
			$packlist 			=	$testclass->getInfo('',$sqlpack);
			if(is_array($packlist))
			{
					//$packname	=	$packlist[0]['tourpackagetitle'];
					return $packlist;
					unset($testclass);
			}
	}
	function PackageName($tourpackageid)
	{
	
			$testclass			=	new AllTables();
			$sqlpack			=	"SELECT * from  GTR_tourpackages where tourpackageid='$tourpackageid'";
			$packlist 			=	$testclass->getInfo('',$sqlpack);
			if(is_array($packlist))
			{
					$packname	=	$packlist[0]['tourpackagetitle'];
					return $packname;
					unset($testclass);
			}
	}
		function package_pdffilename($tourpackageid)
	{
	
			$testclass			=	new AllTables();
			$sqlpack			=	"SELECT pdf_filepath from  GTR_tourpackages where tourpackageid='$tourpackageid'";
			$packlist 			=	$testclass->getInfo('',$sqlpack);
			if(is_array($packlist))
			{
					$packname	=	$packlist[0]['pdf_filepath'];
					return $packname;
					unset($testclass);
			}
	}
	function getPackageListForCombo()
	{
		$packsql		=		"SELECT tourpackageid,tourpackagetitle FROM GTR_tourpackages where packagedeleted='0' group by tourpackagetitle ORDER BY tourpackagetitle";
		$testclass		=		new AllTables();
		$packagelist	=		$testclass->getInfo('',$packsql);
		$totalpack	=	count($packagelist);
		if($totalpack > 0)
			{
					$totalpack	=	count($packagelist);
					for($i=0;$i<$totalpack;$i++)
					{
							$tourpackageid				=		$packagelist[$i]['tourpackageid'];
							$tourpackagetitle			=		preview_text($packagelist[$i]['tourpackagetitle'],'25');
							
							$strPackage		.=		'<option value="'.$tourpackageid.'" >'.$tourpackagetitle.'</option>';
					}
					return $strPackage;
			}
	}
	function PackageListForHomePage($regionid,$countryid,$themeid,$pagename,$numberofday='')
	{
			$testclass		=		new AllTables();
			$numberofnights	=	$numberofday-1;
			
			//Condition starts here for serch.php
		if($pagename=='search.php')	
		{
			if($regionid!="")
				{
					 //$packsql		=		"SELECT a.tourpackageid,a.tourpackagedesc, a.tourpackagetitle,a.countryid, b.itineraryphotopath FROM GTR_tourpackages a left JOIN GTR_tourpackageItinerary b ON b.tourpackageid = a.tourpackageid where a.regionid='$regionid' and noofnights='$numberofnights' and  a.packagedeleted='0' group by a.tourpackagetitle ORDER BY a.tourpackageid DESC";
					 $packsql		=		"SELECT a.tourpackageid,a.tourpackagedesc, a.tourpackagetitle,a.countryid, b.itineraryphotopath FROM GTR_tourpackages a left JOIN GTR_tourpackageItinerary b ON b.tourpackageid = a.tourpackageid where a.regionid='$regionid' and  a.packagedeleted='0' group by a.tourpackagetitle ORDER BY a.tourpackageid DESC";
				}
			else if($countryid!="")
				{
					 //$packsql		=		"SELECT a.tourpackageid,a.tourpackagedesc, a.tourpackagetitle,a.countryid, b.itineraryphotopath FROM GTR_tourpackages a left JOIN GTR_tourpackageItinerary b ON b.tourpackageid = a.tourpackageid where a.countryid='$countryid' and noofnights='$numberofnights' and  a.packagedeleted='0' group by a.tourpackagetitle ORDER BY a.tourpackageid DESC";
					 $packsql		=		"SELECT a.tourpackageid,a.tourpackagedesc, a.tourpackagetitle,a.countryid, b.itineraryphotopath FROM GTR_tourpackages a left JOIN GTR_tourpackageItinerary b ON b.tourpackageid = a.tourpackageid where a.countryid='$countryid' and  a.packagedeleted='0' group by a.tourpackagetitle ORDER BY a.tourpackageid DESC";
				}
			else if($themeid!="")
				{
					 //$packsql		=		"SELECT a.tourpackageid,a.tourpackagedesc, a.tourpackagetitle,a.countryid, b.itineraryphotopath FROM GTR_tourpackages a left JOIN GTR_tourpackageItinerary b ON b.tourpackageid = a.tourpackageid where a.themeid='$themeid' and noofnights='$numberofnights' and  a.packagedeleted='0' group by a.tourpackagetitle ORDER BY a.tourpackageid DESC";
					 $packsql		=		"SELECT a.tourpackageid,a.tourpackagedesc, a.tourpackagetitle,a.countryid, b.itineraryphotopath FROM GTR_tourpackages a left JOIN GTR_tourpackageItinerary b ON b.tourpackageid = a.tourpackageid where a.themeid='$themeid' and  a.packagedeleted='0' group by a.tourpackagetitle ORDER BY a.tourpackageid DESC";
				}			
			else
				{	
				$packsql		=		"SELECT a.tourpackageid,a.tourpackagedesc, a.tourpackagetitle,a.countryid, b.itineraryphotopath FROM GTR_tourpackages a left JOIN GTR_tourpackageItinerary b ON b.tourpackageid = a.tourpackageid where a.packagedeleted='0' group by a.tourpackagetitle ORDER BY a.tourpackageid DESC";
			}
		
			/*if($regionid!="" && $countryid!="" && $themeid!="")
			{
					$packsql		=		"SELECT a.tourpackageid, a.tourpackagedesc,a.tourpackagetitle,a.countryid, b.itineraryphotopath FROM GTR_tourpackages a left JOIN GTR_tourpackageItinerary b ON b.tourpackageid = a.tourpackageid where a.regionid='$regionid' and a.countryid='$countryid' and a.themeid='$themeid' and noofnights='$numberofnights' and  a.packagedeleted='0' group by a.tourpackagetitle ORDER BY a.tourpackageid DESC";
			}
			else if($regionid!="" && $countryid!="" && $themeid=="")
			{
					$packsql		=		"SELECT a.tourpackageid, a.tourpackagedesc,a.tourpackagetitle,a.countryid, b.itineraryphotopath FROM GTR_tourpackages a left JOIN GTR_tourpackageItinerary b ON b.tourpackageid = a.tourpackageid where a.regionid='$regionid' and a.countryid='$countryid' and noofnights='$numberofnights' and  a.packagedeleted='0' group by a.tourpackagetitle ORDER BY a.tourpackageid DESC";
			}
			else if($regionid!="" && $countryid=="" && $themeid=="")
			{
				$packsql		=		"SELECT a.tourpackageid, a.tourpackagedesc,a.tourpackagetitle,a.countryid, b.itineraryphotopath FROM GTR_tourpackages a left JOIN GTR_tourpackageItinerary b ON b.tourpackageid = a.tourpackageid where a.regionid='$regionid' and noofnights='$numberofnights' and  a.packagedeleted='0' group by a.tourpackagetitle ORDER BY a.tourpackageid DESC";
			}
			else if($regionid=="" && $countryid!="" && $themeid!="")
			{
				$packsql		=		"SELECT a.tourpackageid,a.tourpackagedesc, a.tourpackagetitle,a.countryid, b.itineraryphotopath FROM GTR_tourpackages a left JOIN GTR_tourpackageItinerary b ON b.tourpackageid = a.tourpackageid where a.themeid='$themeid' and a.countryid='$countryid' and noofnights='$numberofnights' and  a.packagedeleted='0' group by a.tourpackagetitle ORDER BY a.tourpackageid DESC";
			}
			else if($regionid=="" && $countryid!="" && $themeid=="")
			{
					$packsql		=		"SELECT a.tourpackageid,a.tourpackagedesc, a.tourpackagetitle,a.countryid, b.itineraryphotopath FROM GTR_tourpackages a left JOIN GTR_tourpackageItinerary b ON b.tourpackageid = a.tourpackageid where  a.countryid='$countryid' and noofnights='$numberofnights' and  a.packagedeleted='0' group by a.tourpackagetitle ORDER BY a.tourpackageid DESC";
			}
			else if($regionid=="" && $countryid=="" && $themeid!="")
			{
				$packsql		=		"SELECT a.tourpackageid,a.tourpackagedesc, a.tourpackagetitle,a.countryid, b.itineraryphotopath FROM GTR_tourpackages a left JOIN GTR_tourpackageItinerary b ON b.tourpackageid = a.tourpackageid where a.themeid='$themeid' and noofnights='$numberofnights'  and  a.packagedeleted='0' group by a.tourpackagetitle ORDER BY a.tourpackageid DESC";
			}
			else if($regionid!="" && $countryid=="" && $themeid!="")
			{
					$packsql		=		"SELECT a.tourpackageid,a.tourpackagedesc, a.tourpackagetitle,a.countryid, b.itineraryphotopath FROM GTR_tourpackages a left JOIN GTR_tourpackageItinerary b ON b.tourpackageid = a.tourpackageid where a.themeid='$themeid' and a.regionid='$regionid' and noofnights='$numberofnights' and  a.packagedeleted='0' group by a.tourpackagetitle ORDER BY a.tourpackageid DESC";
			}
		else
			{	
				$packsql		=		"SELECT a.tourpackageid,a.tourpackagedesc, a.tourpackagetitle,a.countryid, b.itineraryphotopath FROM GTR_tourpackages a left JOIN GTR_tourpackageItinerary b ON b.tourpackageid = a.tourpackageid where a.packagedeleted='0' group by a.tourpackagetitle ORDER BY a.tourpackageid DESC";
			}*/
		}	
			
			else
			{
					$packsql		=		"SELECT a.tourpackageid, a.tourpackagetitle,a.countryid,a.tourpackagedesc, b.itineraryphotopath FROM GTR_tourpackages a left JOIN GTR_tourpackageItinerary b ON b.tourpackageid = a.tourpackageid where a.packagedeleted='0' and isspecialpackage='1' group by a.tourpackagetitle ORDER BY a.tourpackageid DESC";
			}
			
			$packagelist	=		$testclass->getInfo('',$packsql);
			$totalpack	=	count($packagelist);
			if($totalpack>0)
			{
					$totalpack	=	count($packagelist);
					for($i=0;$i<$totalpack;$i++)
					{
							$tourpackageid				=		$packagelist[$i]['tourpackageid'];
							$tourpackagetitle			=		preview_text($packagelist[$i]['tourpackagetitle'],'16');
							$tourpackagedesc			=		preview_text($packagelist[$i]['tourpackagedesc'],'60');
							$countryid					=		CountryName($packagelist[$i]['countryid']);
							$itineraryphotopath			=		$packagelist[$i]['itineraryphotopath'];
							if($itineraryphotopath!="")
							{
									 $imagesrc						=	PACKAGE_IMAGE.'thumb/'.$itineraryphotopath;
							}
							else
							{
									 $imagesrc						=	IMAGE_DIR.'mail_photo.jpeg';
							}
							$url						=		DOC_ROOT.'packagedetails.php?tourpackageid='.$tourpackageid;
							$moreurl					=		IMAGE_DIR.'gree_arr.jpg';
							if($pagename=='search.php')	
							{
							
											$strPackage		.=		'<div class="packages">';
											$strPackage		.=		'<div class="packageimg"><a href="'.$url.'"><img src="'.$imagesrc.'" width="181" height="120" class="imagesborder" /></a></div>';
											$strPackage		.=		'<div class="packagehading blacktwo"><a href="'.$url.'">'.$tourpackagetitle.'</a></div>';
											$strPackage		.=		'<div class="packagedetails blacknormal">"'.$tourpackagedesc.'"';
											$strPackage		.=		'</div>';
											$strPackage		.=		'<div class="more "> <a class="readmore1" href="'.$url.'">...More</a></div>';
											$strPackage		.=		'</div>';
							}
							else
							{
									$strPackage					.=		'<div class="specialpackagesinner">';
									$strPackage					.=		'<div class="specialpackageshading whitetext"><a href="'.$url.'">'.$tourpackagetitle.'</a></div>';
									$strPackage					.=		'<div class="specialpackagesimg"><a href="'.$url.'"><img src="'.$imagesrc.'" width="145" height="108"  class="imagesborder2"/></a></div>';
									$strPackage					.=		'<div class="specialpackagesimgmore"><a  class="whitetext" href="'.$url.'">'.$countryid.' >></a></div>';
									$strPackage					.=		'</div>';
							}
							
					}
					return $strPackage;
			}
			else
			{
				$CountryName	=	ProperCase(CountryName($countryid));
				$RegionName		=	ProperCase(RegionName($regionid));
				$ThemeName		=	ProperCase(ThemeName($themeid));
				
				$strPackage		.=		'<div class="panelgroup-info-holder">';
				$strPackage		.=		'<p class="redtext"><strong>No Related Package Found</strong></p><br/>See Other Packege For '.$CountryName. $RegionName.$ThemeName;
				$strPackage		.=		'</div>';
				//default detail
			if($regionid!="")
				{
					 $packsql		=		"SELECT a.tourpackageid,a.tourpackagedesc, a.tourpackagetitle,a.countryid, b.itineraryphotopath FROM GTR_tourpackages a left JOIN GTR_tourpackageItinerary b ON b.tourpackageid = a.tourpackageid where a.regionid='$regionid' and  a.packagedeleted='0' group by a.tourpackagetitle ORDER BY a.tourpackageid DESC";
				}
			if($countryid!="")
				{
					 $packsql		=		"SELECT a.tourpackageid,a.tourpackagedesc, a.tourpackagetitle,a.countryid, b.itineraryphotopath FROM GTR_tourpackages a left JOIN GTR_tourpackageItinerary b ON b.tourpackageid = a.tourpackageid where a.countryid='$countryid' and  a.packagedeleted='0' group by a.tourpackagetitle ORDER BY a.tourpackageid DESC";
				}
			if($themeid!="")
				{
					 $packsql		=		"SELECT a.tourpackageid,a.tourpackagedesc, a.tourpackagetitle,a.countryid, b.itineraryphotopath FROM GTR_tourpackages a left JOIN GTR_tourpackageItinerary b ON b.tourpackageid = a.tourpackageid where a.themeid='$themeid' and  a.packagedeleted='0' group by a.tourpackagetitle ORDER BY a.tourpackageid DESC";
				}	
			$packagelist	=		$testclass->getInfo('',$packsql);
			$totalpack	=	count($packagelist);
			if($totalpack>0)
			{
					$totalpack	=	count($packagelist);
					for($i=0;$i<$totalpack;$i++)
					{
							$tourpackageid				=		$packagelist[$i]['tourpackageid'];
							$tourpackagetitle			=		preview_text($packagelist[$i]['tourpackagetitle'],'16');
							$tourpackagedesc			=		preview_text($packagelist[$i]['tourpackagedesc'],'60');
							$countryid					=		CountryName($packagelist[$i]['countryid']);
							$itineraryphotopath			=		$packagelist[$i]['itineraryphotopath'];
							if($itineraryphotopath!="")
							{
									 $imagesrc						=	PACKAGE_IMAGE.'thumb/'.$itineraryphotopath;
							}
							else
							{
									 $imagesrc						=	IMAGE_DIR.'mail_photo.jpeg';
							}
							$url						=		DOC_ROOT.'packagedetails.php?tourpackageid='.$tourpackageid;
							$moreurl					=		IMAGE_DIR.'gree_arr.jpg';
							if($pagename=='search.php')	
							{
							
											$strPackage		.=		'<div class="packages">';
											$strPackage		.=		'<div class="packageimg"><a href="'.$url.'"><img src="'.$imagesrc.'" width="181" height="120" class="imagesborder" /></a></div>';
											$strPackage		.=		'<div class="packagehading blacktwo"><a href="'.$url.'">'.$tourpackagetitle.'</a></div>';
											$strPackage		.=		'<div class="packagedetails blacknormal">"'.$tourpackagedesc.'"';
											$strPackage		.=		'</div>';
											$strPackage		.=		'<div class="more "> <a class="readmore1" href="'.$url.'">...More</a></div>';
											$strPackage		.=		'</div>';
							}
							else
							{
									$strPackage					.=		'<div class="specialpackagesinner">';
									$strPackage					.=		'<div class="specialpackageshading whitetext"><a href="'.$url.'">'.$tourpackagetitle.'</a></div>';
									$strPackage					.=		'<div class="specialpackagesimg"><a href="'.$url.'"><img src="'.$imagesrc.'" width="145" height="108"  class="imagesborder2"/></a></div>';
									$strPackage					.=		'<div class="specialpackagesimgmore"><a  class="whitetext" href="'.$url.'">'.$countryid.' >></a></div>';
									$strPackage					.=		'</div>';
							}
							
					}
				}
				return $strPackage;
			}
	}
	function DestinationListForHomePage()
	{
			$testclass		=		new AllTables();
			$destsql		=		"select * from mstlocation order by locationname";
			$DestList		=		$testclass->getInfo('',$destsql);
			if(is_array($DestList))
			{
					$totaldestination	=	count($DestList);
					for($i=0;$i<$totaldestination;$i++)
					{
							$locationid				=		$DestList[$i]['locationid'];
							$locationname			=		$DestList[$i]['locationname'];
							
							$url						=		DOC_ROOT.'locations.php?locationid='.$locationid;
							
							//$strDestination					.=		'<li><a href="'.$url.'" id="current">'.$locationname.'</a></li>';
							$strDestination					.=		'<li><a href="'.$url.'">'.$locationname.'</a></li>';
							
							
					}
					return $strDestination;
			}
			
	}
	function RelatedPackageForLacation($locationid)
	{
			$testclass		=		new AllTables();
			if($locationid!='')
			{
					 $locationname			=		LocationName($locationid);
					 $packagesql			=		"select regionid from mstlocation where locationid='$locationid'";
			}
			$Detaillist		=		$testclass->getInfo('',$packagesql);
			if(is_array($Detaillist))
			{
					$totaldestination	=	count($Detaillist);
					for($i=0;$i<$totaldestination;$i++)
					{
							$regionid				=		$Detaillist[$i]['regionid'];
							//$relatedpacksql			=		"select * from GTR_tourpackages where regionid='$regionid'";
							$relatedpacksql			=		"SELECT a.tourpackageid, a.tourpackagetitle, b.itineraryphotopath FROM GTR_tourpackages a INNER JOIN GTR_tourpackageItinerary b ON b.tourpackageid = a.tourpackageid where a.regionid='$regionid' and a.packagedeleted='0' group by a.tourpackagetitle";
							//echo $relatedpacksql;
							$TourPackList			=		$testclass->getInfo('',$relatedpacksql);
							if(is_array($TourPackList))
							{
									
									$totalpacklist			=	count($TourPackList);
									for($i=0;$i<$totalpacklist;$i++)
									{
											$tourpackageid				=	$TourPackList[$i]['tourpackageid'];
											$tourpackagetitle			=	$TourPackList[$i]['tourpackagetitle'];
											$itineraryphotopath			=	$TourPackList[$i]['itineraryphotopath'];
											if($itineraryphotopath!="")
											{
													 $imagesrc						=	PACKAGE_IMAGE.'thumb/'.$itineraryphotopath;
											}
											else
											{
													 $imagesrc						=	IMAGE_DIR.'mail_photo.jpeg';
											}
											$url						=		DOC_ROOT.'packagedetails.php?tourpackageid='.$tourpackageid;
											$moreurl					=		IMAGE_DIR.'gree_arr.jpg';
											//$img					=		IMAGE_DIR.'lo_img1.jpg';
											$strPackList		.=		'<div class="locationspackagesinner">';
											$strPackList		.=		'<div class="locationspackagesname redtext"><a href="'.$url.'">'.$tourpackagetitle.'</a></div>';
											$strPackList		.=		'<div class="locationspackagesimg"><a href="'.$url.'"><img src="'.$imagesrc.'" width="180" height="126" /></a></div>';
											$strPackList		.=		'<div class="locationspackagesmore"><a  class="redtext"href="'.$url.'">More<img src="'.$moreurl.'" width="15" height="11" /></a></div>';
											$strPackList		.=		'</div>';
									}
										return $strPackList;
							}
							else
							{
									
									$strPackList		.=		'<div class="panelgroup-info-holder">';
									$strPackList		.=		'<p class="redtext"><strong>No package are available for '.$locationname.'</strong></p>';
									$strPackList		.=		'</div>';
									return $strPackList;
							}
					}
			}
	}
	function RaletedTourPackageListForHomePage($regionid)
	{
			$testclass			=	new AllTables();
			$sqltourpack		=	"SELECT a.tourpackageid,a.tourpackagetitle,b.itineraryphotopath,a.tourpackagedesc FROM GTR_tourpackages a INNER JOIN GTR_tourpackageItinerary b ON b.tourpackageid = a.tourpackageid where a.regionid='$regionid' and a.packagedeleted='0' group by a.tourpackagetitle order by a.tourpackageid desc";
			//echo $sqltourpack;
			$TourPackList		=	$testclass->getInfo('',$sqltourpack);
			if(is_array($TourPackList))
			{
						$totalrow		=		count($TourPackList);
						for($i=0;$i<$totalrow;$i++)
						{
							$tourpackageid				=	$TourPackList[$i]['tourpackageid'];
							$tourpackagetitle			=	preview_text($TourPackList[$i]['tourpackagetitle'],15);
							$itineraryphotopath			=	$TourPackList[$i]['itineraryphotopath'];
							if($itineraryphotopath!="")
							{
									 $imagesrc						=	PACKAGE_IMAGE.'thumb/'.$itineraryphotopath;
							}
							else
							{
									 $imagesrc						=	IMAGE_DIR.'mail_photo.jpeg';
							}
							$tourpackagedesc			=		preview_text($TourPackList[$i]['tourpackagedesc'],50);
							$url						=		DOC_ROOT.'packagedetails.php?tourpackageid='.$tourpackageid;
							$moreurl					=		IMAGE_DIR.'gree_arr.jpg';
							//$img					=		IMAGE_DIR.'lo_img1.jpg';
							
							
							$strTourPackList		.=		'<div class="packages">';
							$strTourPackList		.=		'<div class="packageimg"><a href="'.$url.'"><img src="'.$imagesrc.'" width="181" height="120" class="imagesborder" /></a></div>';
							$strTourPackList		.=		'<div class="packagehading blacktwo"><a href="'.$url.'">'.$tourpackagetitle.'</a></div>';
							$strTourPackList		.=		'<div class="packagedetails blacknormal">"'.$tourpackagedesc.'"';
							$strTourPackList		.=		'</div>';
							$strTourPackList		.=		'<div class="more"> <a class="readmore1" href="'.$url.'">...More</a></div>';
							$strTourPackList		.=		'</div>';
					}
					return $strTourPackList;
			}
			else
			{			
			
						$strTourPackList		.=		'<div class="panelgroup-info-holder">';
						$strTourPackList		.=		'<p class="redtext"><strong>No Related Package Found</strong></p>';
						$strTourPackList		.=		'</div>';
						//$strTourPackList			=	"No Related Package Found";
						return $strTourPackList;
			}
	}
	function GalleryPhotoForHomePage()
	{
				$testclass				=	new AllTables();
				$galleryphotolist		=	$testclass->getInfo('',"SELECT itineraryphotopath   FROM `GTR_tourpackageItinerary` where itineraryphotopath!='' order by itineraryphotopath desc");
			if(is_array($galleryphotolist))
			{
				$rowcount		=		count($galleryphotolist);
				
				for($i=0;$i<$rowcount;$i++)
				{
						$photoimagepath	=	$galleryphotolist[$i]['itineraryphotopath'];
						$url			=	DOC_ROOT.'gallery.php';
						$galleryimg		=	PACKAGE_IMAGE.'thumb/'.$photoimagepath;
						$biggallery		=	PACKAGE_IMAGE.$photoimagepath;
						$galleryphoto				.=	'<div id="gallery" >';
						$galleryphoto	.=	'<div class="packages">';
                        $galleryphoto	.=	'<div class="packageimg"><a href="'.$biggallery.'"><img src="'.$galleryimg.'" width="181" height="120" class="imagesborder"/></a></div>';
                       	$galleryphoto	.=	'</div>';
						$galleryphoto	.=	'</div>';
						
						
				}
				
				return $galleryphoto;
			}
			else
			{
				$galleryphoto	=	"Gallery Photo Empty";
				return $galleryphoto;
			}
	}
	function GalleryVedioForHomePage()
	{
				$testclass				=	new AllTables();
				$galleryVediolist		=	$testclass->getInfo('',"SELECT PackageVideotitle,videolink,tourpackageid FROM `GTR_tourpackages` where videolink!=''");
				//echo "SELECT videolink FROM `GTR_tourpackages` where videolink!=''";
			if(is_array($galleryVediolist))
			{
				$rowcount		=		count($galleryVediolist);
				
				for($i=0;$i<$rowcount;$i++)
				{
						$Videogepath	=	$galleryVediolist[$i]['videolink'];
						//$url			=	DOC_ROOT.'video.php';
						//$galleryimg		=	$Videogepath;
						//$biggallery		=	$photoimagepath;
						//you tube vedio 
						if ($Videogepath!=''){
								$jutjub = new YouTube($Videogepath);
								//$showvideo = $jutjub->EmbedVideo();
								$showimage = $jutjub->ShowImg();
							}
		
						
						
						$galleryVedio	.=	'<div class="vedioinner">';
						//$galleryVedio	.=	'<div class="vedioleft">'.$showvideo.'</div>';
                        //$galleryVedio	.=	'<div class="vedioright">'.$showvideo.'</div>';
						$galleryVedio	.=	'<div class="vedioleft"><a href="'.DOC_ROOT.'video_details.php?videoid='.$galleryVediolist[$i]['tourpackageid'].'">'.$showimage.'<br /><strong class="lightblue">'.$galleryVediolist[$i]['PackageVideotitle'].'</strong></a></div>';
						$galleryVedio	.=	'<div class="vedioright"><a href="'.DOC_ROOT.'video_details.php?videoid='.$galleryVediolist[$i]['tourpackageid'].'">'.$showimage.'<br /><strong class="lightblue">'.$galleryVediolist[$i]['PackageVideotitle'].'</strong></a></div>';
                       	$galleryVedio	.=	'</div>';
						
						
				}
				
				return $galleryVedio;
			}
			else
			{
				$galleryVedio	=	"Gallery Vedio Empty";
				return $galleryVedio;
			}
	}
	function FooterPageLink($pagevalue)
		{
					//PageValue means, where to display in header or footer
					$footer			=	new AllTables();
					if($pagevalue!='')
					{
								$footersql		=	"Select * from mstpages where  isapproved='1' and pagecategory='0' order by pagename asc limit 0,3";
					}
					else
					{
								$footersql		=	"Select * from mstpages where isapproved='1' order by pagename asc limit 0,5";							
					}
					$pagenamelist	=	$footer->getInfo('',$footersql);
					if(is_array($pagenamelist))
					{
							$pagecount		=	count($pagenamelist);
							$pagecategory	=	'';
							for($i=0;$i<$pagecount;$i++)
							{
									$pageid				=		$pagenamelist[$i]['pageid'];
									$pagename			=		ProperCase($pagenamelist[$i]['pagename']);
									$pagelink			=		$pagenamelist[$i]['pagelink'];
									$pagecategory		=		$pagenamelist[$i]['pagecategory'];
									$url				=		DOC_ROOT.'pages/'.$pagelink.'.htm';
									$selectedlink		=		'/pages/index.php?pagename='.$pagename.'';
									if($pagevalue=='header')
									{
											// check if there are sub pages under this page
											$subpagesql = "select * from mstpages where pagecategory='$pageid' and isapproved='1'";
											$subpageslist	=	$footer->getInfo('',$subpagesql);
											if ($subpageslist)
											{
												$subpagecount = count($subpageslist);
												$footerpages		.=		'<li><a href="#" >'.$pagename.'</a>';
												$footerpages		.=		'<ul>';
												for ($j=0;$j< $subpagecount;$j++)
												{
														$subpagelink			=	$subpageslist[$i]['pagelink'];
														$subpageurl				= 	DOC_ROOT.'pages/'.$subpagelink.'.htm';
														$footerpages			.=	'<li><a href="'.$subpageurl.'">'.$subpageslist[$j]['pagename'].'</a></li>';
												}
														$footerpages			.=	'</ul></li>';
											}
											else
											{
												$footerpages		.=		'<li><a href="'.$url.'" >'.$pagename.'</a></li>';
											}	
									}
									else
									{
											$footerpages		.=		'<a href="'.$url.'" class="whitefooter">'.$pagename.'</a>   |';
									}
								
							}
							return $footerpages;
							
					}
		}
	function BannerListForHome()
	{
					$banner			=	new AllTables();
					$bannersql		=	"Select * from mstbanner order by bannerid desc limit 0,5";
					$bannerlist	=	$banner->getInfo('',$bannersql);
					if(is_array($bannerlist))
					{
						$rowcount	=	count($bannerlist);
						for($i=0;$i<$rowcount;$i++)
						{
								$bannerid		=		$bannerlist[$i]['bannerid'];
								$bannername		=		$bannerlist[$i]['bannername'];
								$image			=		$bannerlist[$i]['image'];
								$imageval		=		($image=='')?IMAGE_DIR.'mail_photo.jpeg':BANNER_IMAGE.$image;	
								$strBanner		.=		'<img src="'.$imageval.'" width="1200" height="400" />';
						}	
						return $strBanner;
						unset($banner);	
					}
	}
	function Attachement($tourpackageid)
	{
	
			
			$testclass			=	new AllTables();
			$attach				=	"SELECT pdf_filepath from  GTR_tourpackages where tourpackageid='$tourpackageid'";
			$attachlist 		=	$testclass->getInfo('',$attach);
			if(is_array($attachlist))
			{
					$pdf_filepath	=	$attachlist[0]['pdf_filepath'];
					return $pdf_filepath;
					unset($testclass);
			}
	}
	function GetTestimonial($testimonialid)
	{
					$test			=	new AllTables();
					if($testimonialid!='')
					{
							$testsql		=	"Select * from  msttestimonial where testimonialid='$testimonialid' order by testimonialid desc limit 0,2"; 
					}
					else
					{
							$testsql		=	"Select * from  msttestimonial order by testimonialid desc limit 0,2"; 
					}
					$testlist		=	$test->getInfo('',$testsql);
					if(is_array($testlist))
					{
						$rowcount	=	count($testlist);
						for($i=0;$i<$rowcount;$i++)
						{
								$testimonialid					=		$testlist[$i]['testimonialid'];
								$testimonial					=		$testlist[$i]['testimonial'];
								$testimonialbyclientname		=		ProperCase($testlist[$i]['testimonialbyclientname']);
								$testimonialdate				=		date("d M Y",strtotime($testlist[$i]['testimonialdate']));
								
								$strTestimonial		.=		'<div class="testimonialstext">'.$testimonial.'';
								//$strTestimonial		.=		'"'.trim($testimonial).'"';
								$strTestimonial		.=		'<br />';
								$strTestimonial		.=		'</div>';
								$strTestimonial		.=		'<div class="testimonialsname blacknormal2">'.$testimonialbyclientname.'<br />';
								$strTestimonial		.=		'Date :&nbsp;'.$testimonialdate.'';
                  				$strTestimonial		.=		'</div>';
								
						}	
						return $strTestimonial;
						unset($test);	
					}
					else
					{	
							$strTestimonial		=	"There are no testimonial";
							return $strTestimonial;
					}
	}
	function HeaderSubMenuListForRegion($regionid)
	{
			$menu			=	new AllTables();
			$menulist		=	$menu->getInfo('',"Select tourpackageid,tourpackagetitle from GTR_tourpackages where regionid='$regionid' and packagedeleted='0' order by tourpackageid limit 0,20 ");
			if(is_array($menulist))
			{
					$rowcount			=		count($menulist);
					for($i=0;$i<$rowcount;$i++)
					{
							$tourpackageid			=		$menulist[$i]['tourpackageid'];
							$tourpackagetitle		=		$menulist[$i]['tourpackagetitle'];
							$link					=		DOC_ROOT.'packagedetails.php?tourpackageid='.$tourpackageid;
							$subMenu				.=		'<li><a href="'.$link.'">'.$tourpackagetitle.'</a></li>';
							
					}
					return $subMenu;
					
			}
			/*else
			{
						$subMenu				.=		'<li>Not Found</li>';
						return $subMenu;
			}*/
	}
	function HeaderSubMenuListForProductCategory()
	{
			$menu			=	new AllTables();
			$menulist		=	$menu->getInfo('',"Select categoryid,categoryname,categorylink from mstcategory order by homepageorder ");
			if(is_array($menulist))
			{
					$rowcount			=		count($menulist);
					for($i=0;$i<$rowcount;$i++)
					{
							$tourpackageid			=		$menulist[$i]['categoryid'];
							$tourpackagetitle		=		$menulist[$i]['categoryname'];
							$categorylink			=		$menulist[$i]['categorylink'];
							$link					=		DOC_ROOT.'cats-'.$categorylink.'.htm';
							$subMenu				.=		'<li><a href="'.$link.'">'.$tourpackagetitle.'</a></li>';
							
					}
					return $subMenu;
					
			}
			/*else
			{
						$subMenu				.=		'<li>Not Found</li>';
						return $subMenu;
			}*/
	}
	function getProductNamesInList($categoryid)
	{
			$menu			=	new AllTables();
			$menulist		=	$menu->getInfo('',"Select productid,productname,productlink from mstproducts where categoryid='$categoryid' limit 0,50 ");
			if(is_array($menulist))
			{
					$rowcount			=		count($menulist);
					for($i=0;$i<$rowcount;$i++)
					{
							$tourpackageid			=		$menulist[$i]['productid'];
							$tourpackagetitle		=		$menulist[$i]['productname'];
							$categorylink			=		$menulist[$i]['productlink'];
							$link					=		DOC_ROOT.'prods-'.$categorylink.'.htm';
							$subMenu				.=		'<li><a href="'.$link.'">'.$tourpackagetitle.'</a></li>';
							
					}
					return $subMenu;
					
			}
	}
	function returnSelected($value1,$value2)
	{
		if ($value1==$value2)
		{
			return "selected='selected'";
		} 
		 else
		{
			return "";
		} 
	}
	function toAscii($str, $replace=array(), $delimiter='-') {
	if( !empty($replace) ) {
		$str = str_replace((array)$replace, ' ', $str);
		}
		$clean = iconv('UTF-8', 'ASCII//TRANSLIT', $str);
		$clean = preg_replace("/[^a-zA-Z0-9\/_|+ -]/", '', $clean);
		$clean = strtolower(trim($clean, '-'));
		$clean = preg_replace("/[\/_|+ -]+/", $delimiter, $clean);

		return $clean;
	}
	
	
	
	
	
	function getExhibitionListForCombo($exhibitionid='',$countryid='',$countryname='')
	{
		$testclass		=	new AllTables();
		
		if ($countryid!='')
		{
			$statelist = $testclass->getInfo("","SELECT * FROM mststate WHERE countryid ='".$countryid."' ORDER BY State asc");
		}
		else if($countryname!='')
		{
			$statelist = $testclass->getInfo("","SELECT * FROM mststate WHERE countryid in (Select countryid from mstcountry where countryname ='".$countryname."') ORDER BY State");
		}
		else
		{
			$statelist = $testclass->getInfo("","select * FROM trnexhibition ORDER BY exhibitionid");
			//echo $statelist;
		}
		$rowcount = count($statelist);
		
		$strstatelist = "";
		
		if ($rowcount > 0)
		{
			for($i=0;$i<$rowcount;$i++) 
			{	
				if(strtoupper($exhibitionid)==$statelist[$i]['exhibitionid'])
				{
					$strstatelist .= "<option value='".$statelist[$i]['exhibitionid']."-".$statelist[$i]['exhibitionname']."' selected='selected'>".ucwords(strtolower($statelist[$i]['exhibitionname']))."</option>";
				}
				else
				{	
					$strstatelist .= "<option value='".$statelist[$i]['exhibitionid']."-".$statelist[$i]['exhibitionname']."'>".ucwords(strtolower($statelist[$i]['exhibitionname']))."</option>";
				}
			}
		}
		unset($testclass);
		return $strstatelist;	
	}	
	
	
	
	
	function getArtistListForCombo($artistid='',$countryid='',$countryname='')
	{
		$testclass		=	new AllTables();
		
		if ($countryid!='')
		{
			$statelist = $testclass->getInfo("","SELECT * FROM mststate WHERE countryid ='".$countryid."' ORDER BY State asc");
		}
		else if($countryname!='')
		{
			$statelist = $testclass->getInfo("","SELECT * FROM mststate WHERE countryid in (Select countryid from mstcountry where countryname ='".$countryname."') ORDER BY State");
		}
		else
		{
			$statelist = $testclass->getInfo("","select * FROM mstartist ORDER BY artistid");
			//echo $statelist;
		}
		$rowcount = count($statelist);
		
		$strstatelist = "";
		
		if ($rowcount > 0)
		{
			for($i=0;$i<$rowcount;$i++) 
			{	
				if(strtoupper($artistid)==$statelist[$i]['artistid'])
				{
					$strstatelist .= "<option value='".$statelist[$i]['artistid']."-".$statelist[$i]['artistname']."' selected='selected'>".ucwords(strtolower($statelist[$i]['artistname']))."</option>";
				}
				else
				{	
					$strstatelist .= "<option value='".$statelist[$i]['artistid']."-".$statelist[$i]['artistname']."'>".ucwords(strtolower($statelist[$i]['artistname']))."</option>";
				}
			}
		}
		unset($testclass);
		return $strstatelist;	
	}

	function getArtistNamesInExhibition($exhibitionid='')
	{
			$menu			=	new AllTables();
			if ($exhibitionid !='')
			{
				$menulist		=	$menu->getInfo('',"Select a.artistid,artistname,artisturl from mstartist a inner join mstpaintings b on a.artistid=b.artistid inner join trnexhibition c on b.exhibitionid=c.exhibitionid where c.exhibitionid='$exhibitionid'  group by artistname order by artistname asc ");

			}
			else
			{
				$menulist		=	$menu->getInfo('',"Select artistid,artistname,artisturl from mstartist order by artistname asc");
			}	
			if(is_array($menulist))
			{
					$rowcount			=		count($menulist);
					$subMenu 			= '<ul class="list-inline artists">';
					for($i=0;$i<$rowcount;$i++)
					{
							$artistid				=		$menulist[$i]['artistid'];
							$artistname				=		strtoupper($menulist[$i]['artistname']);	
							$artisturl				=		$menulist[$i]['artisturl'];
							$artistname_url		=		replaceForURL($artistname);	
							$artisturl				=		$menulist[$i]['artisturl'];
							//$link					=		DOC_ROOT.'prods-'.$categorylink.'.htm';
							$artisturl				=     "Artist-".$artistname_url."-".$artistid.".html";			
							
							
							//$link					=		DOC_ROOT.'artgallery.php?artistname='.$artisturl;
														
							$subMenu				.=		'<li><a href="'.$artisturl.'">'.$artistname.'</a></li>';
							
					}
					$subMenu .= '</ul>';
					return $subMenu;
					
			}
	}
	function getArtistNamesInList($categoryid='')
	{
			$menu			=	new AllTables();
			$menulist		=	$menu->getInfo('',"Select artistid,artistname,artisturl from mstartist order by artistname asc");
			if(is_array($menulist))
			{
					$rowcount			=		count($menulist);
					for($i=0;$i<$rowcount;$i++)
					{
							$artistid				=		$menulist[$i]['artistid'];
							$artistname				=		strtoupper($menulist[$i]['artistname']);
							$artistname_url		=		replaceForURL($artistname);	
							$artisturl				=		$menulist[$i]['artisturl'];
							//$link					=		DOC_ROOT.'prods-'.$categorylink.'.htm';
							$artisturl				=     "Artist-".$artistname_url."-".$artistid.".html";			
							
							
							//$link					=		DOC_ROOT.'artgallery.php?artistname='.$artisturl;
														
							$subMenu				.=		'<li><a href="'.$artisturl.'">'.$artistname.'</a></li>';
							
					}
					return $subMenu;
					
			}
	}

function replaceForURL($strOrgUrl)
{
	$strOrgUrl = trim($strOrgUrl);
	$ReturnURL = str_replace(" ","-",$strOrgUrl);
	$ReturnURL = str_replace("-&-","-_and_-",$ReturnURL);
	$ReturnURL = str_replace("%2F","_s_",$ReturnURL);
	$ReturnURL = str_replace("/","_s_",$ReturnURL);
	$ReturnURL = str_replace("\\","",$ReturnURL);
	$ReturnURL = str_replace("(","_bb_",$ReturnURL);
	$ReturnURL = str_replace(")","_rbrb_",$ReturnURL);
	$ReturnURL = str_replace("&#40;","_bb_",$ReturnURL);
	$ReturnURL = str_replace("&#41;","_rbrb_",$ReturnURL);
	$ReturnURL = str_replace("#40;","_bb_",$ReturnURL);
	$ReturnURL = str_replace("#41;","_rbrb_",$ReturnURL);
	$ReturnURL = str_replace("#45;","-",$ReturnURL);
	$ReturnURL = str_replace("\"","",$ReturnURL);
	$ReturnURL = str_replace("\'","",$ReturnURL);
	$ReturnURL = str_replace("#","_",$ReturnURL);
	$ReturnURL = str_replace(".","",$ReturnURL);
	$ReturnURL = strtolower(str_replace("%","",$ReturnURL));
	return $ReturnURL;
}

function replaceFromURL($strURL)
{
	
	$replaceURL = str_replace("-&amp;-"," & ",$strURL);
	$replaceURL = str_replace("-_and_-","-&-",$replaceURL);
	$replaceURL = str_replace("_n_","&",$replaceURL);
	$replaceURL = str_replace("_s_","/",$replaceURL);
	$replaceURL = str_replace("--"," & ",$replaceURL);
	$replaceURL = str_replace("_bb_","(",$replaceURL);
	$replaceURL = str_replace("_rbrb_",")",$replaceURL);
	$replaceURL = str_replace("-"," ",$replaceURL);
	$replaceURL = str_replace("_"," ",$replaceURL);
	return $replaceURL;
}
	
	
function newPaintings()
{			
$newobj			=	new AllTables();
			$sql = "SELECT artistname,paintingid,paintingurl,a.p_thumbphotoname as paintingimg FROM mstpaintings a
inner join mstartist b on a.artistid=b.artistid
where newpainting=1 order by paintingid desc  limit 0,50";
			//echo $sql;
			$paintarray = $newobj -> getInfo('',$sql);
			//print_r($paintarray	);
			
			$rowcount = count($paintarray);
			//echo "<br>rowcount ".$rowcount;

				for($i=0;$i<$rowcount;$i++)
				{
					//$artistid 			= $paintarray[$i]['artistid'];
					//$title 			   = $paintarray[$i]['title'];
					$artistname 		= $paintarray[$i]['artistname'];
					//$artisturl 			= htmlentities($paintarray[$i]['artisturl']);
					
					/*
					$sql2 = "SELECT * FROM mstpaintings b WHERE b.artistid = ".$artistid." limit 0,1";
					//echo $sql2;
					$paintingsarray = $newobj -> getInfo('',$sql2);
					//print_r ($paintingsarray);
					$p_thumbphotoname 	= "";
					if(is_array($paintingsarray))
					{*/
					   $artistname 		= $paintarray[$i]['artistname'];
						$paintingid 	= $paintarray[$i]['paintingid'];
						$paintingimg 	= $paintarray[$i]['paintingimg'];
						$paintingurl 		= replaceForURL($paintarray[$i]['paintingurl']);					
						$finalurl 			= $paintingurl."-".$paintingid.".html"; 
					//}
					
					
//echo "<div class='col-md-3 text-center '>";
echo "";

echo " <a href='Painting-".$finalurl."'  >";
echo "<img  src='".PRODUCT_PHOTO_THUMB_PATH."".$paintingimg."' class='img-responsive center-block item_image product_image' style='margin-left: 10px; float:left; margin-top: 10px' /><div class='clearfix'></div><div class='h5 text-center' style='text-decoration:none;margin-top:-10px;color:white;background-color:rgba(0,0,0,0.3);position: absolute;bottom: 8px;left: 18px;right: 18px;padding:10px'>".$artistname."</div>";
echo "</a> ";

	  

				}
/*
					$artistname1 		= $paintarray[4]['artistname'];
					$p_thumbphotoname1 	= $paintarray[4]['p_thumbphotoname'];
					$artistid1			= $paintarray[4]['artistid'];
					$artisturl1			= htmlentities($paintarray[4]['artisturl']);
					
					$artistname2 		= $paintarray[5]['artistname'];
					$p_thumbphotoname2 	= $paintarray[5]['p_thumbphotoname'];
					$artistid2			= $paintarray[5]['artistid'];
					$artisturl2			= htmlentities($paintarray[5]['artisturl']);
					
					$artistname3 		= $paintarray[6]['artistname'];
					$p_thumbphotoname3 	= $paintarray[6]['p_thumbphotoname'];
					//echo $p_thumbphotoname3;
					$artistid3			= $paintarray[6]['artistid'];
					$artisturl3			= htmlentities($paintarray[6]['artisturl']);
					
					$artistname4 		= $paintarray[7]['artistname'];
					$p_thumbphotoname4 	= $paintarray[7]['p_thumbphotoname'];
					$artistid4			= $paintarray[7]['artistid'];
					$artisturl4			= htmlentities($paintarray[7]['artisturl']);
					
	*/	
}

  function BannerNew()
	{	  
		   $subMenu=''; 	
			$menu			=	new AllTables();
			$sql="SELECT b. p_thumbphotoname as paintingimage,a.artistid,a.artistname,a.artisturl,b.paintingurl,b.paintingid 
			      FROM mstartist a 
					inner join mstpaintings b on b.artistid=a.artistid  
				   where artistforbanner=1 and bannerpainting=1
				   group by artistid";
			//echo $sql;
			$menulist	=	$menu->getInfo('',$sql);
			//print_r($menulist);				
			if(is_array($menulist))
			{
					$rowcount			      =		count($menulist);
					$startol    ='<ol class="carousel-indicators">';
    
		      for($j=0;$j<$rowcount;$j++)
		      {
		      	      if($j==0)
						  {
						  	  $activeol  = 'class="active"';
						  	
						  }
						  else 
						  {
						  	 $activeol  = '';
						  	 
						  }
		      	
		    	    $li .='<li data-target="#myCarousel" data-slide-to="0" '.$activeol.'></li>';
		    	}
		    	$endol    ='</ol>';
    	       $dataslider = $startol.$li.$endol;
					$divstart					=     '<div class="carousel-inner">';
				   $divend                 =     '</div>';
					for($i=0;$i<$rowcount;$i++)
					{
						  if($i==0)
						  {
						  	  $anctive  = '<div class="item active">';
						  	
						  }
						  else 
						  {
						  	 $anctive  = '<div class="item">';
						  	 
						  }
							
							$artistname		         =		$menulist[$i]['artistname'];
							$paintingimage			=		$menulist[$i]['paintingimage'];							
							
							$artisturl				=		$menulist[$i]['artisturl'];
							$artistid			=		$menulist[$i]['artistid'];
							
							$link				=     "Artist-".$artisturl."-".$artistid.".html";
							
							$subMenu   .= $anctive.'<img src="images/sliderback.jpg" style="width:100%;">
							<div class="carousel-caption">
       <div class="col-md-12 col-sm-12">
	   <div class="col-md-6 col-sm-6 col-xs-6 slider_img">
	   <br> 
	   <img src="'.PRODUCT_PHOTO_PATH.$paintingimage.'" class="img-responsive  ">
	   </div>
	   <div class="col-md-6 col-sm-6 col-xs-6">

	      <div class="h3">Artist</div>
		
		   
	   <div class="h2 carousel_name">'.$artistname.'</div>
	   <br><br> <br><br>
	   <span type="button" class="btn btn-lg"><a href="'.$link.'" style="text-decoration:underline">Explore More</a></span>
	   </div>
	   </div>
	   </div>
      </div>';
					}
					
					$mainmenu   =  $dataslider.$divstart.$subMenu.$divend;
					return $mainmenu;
					
			}
			
			
	}
	
	  function BannerNewforecom($categoryid="")
	{
		  
		   $subMenu=''; 	
			$menu			=	new AllTables();
			$bannersql		=	"Select * from mstbanner where categoryid= ".$categoryid." order by bannerid ASC";
			$menulist	=	$menu->getInfo('',$bannersql);
					
						
			//print_r($menulist);				
			if(is_array($menulist))
			{
					$rowcount			      =		count($menulist);
					$divstart					=     '<div class="carousel-inner">';
				   $divend                 =     '</div>';
					for($i=0;$i<$rowcount;$i++)
					{
						  if($i==0)
						  {
						  	  $anctive  = '<div class="item active">';
						  	
						  }
						  else 
						  {
						  	 $anctive  = '<div class="item">';
						  	 
						  	}
							
							$bannername		         =		$menulist[$i]['bannername'];
							$bannerphotothumb			=		$menulist[$i]['bannerphotothumb'];							
							

							
							$subMenu				     .=		$anctive.'<a href="#"><img style="width:100%;" src="'.PRODUCT_PHOTO_PATH.$bannerphotothumb.'" alt="'.$bannername.'"></a></div>';
					}
					
					$mainmenu   =  $divstart.$subMenu.$divend;
					return $mainmenu;
					
			}
			
			
	}
		function NumberOfItem($G_sessionid='',$G_customerId='')
	{
			$subMenu    =  "";
			$menu			=	new AllTables();
			
			if($G_sessionid <> '') 
			{
				
			  $menulist		=	$menu->getInfo('',"Select * from tmpcart where usersessionid='".$G_sessionid."'");
			  $menucount			=		count($menulist);
			  //rt_r($menucount);
			}
			if($G_customerId <> '')
			{
				$menulist		=	$menu->getInfo('',"Select * from tmpcart where customerId='".$G_customerId."'");
				 $menucount			=		count($menulist);
				 
		   }
			
				
				
				if($menucount == 0)
				{
					$itemcount			=		0;
				}
				else
				{
					$itemcount			=		count($menulist);
				}
				
           		return $itemcount;
					
			
	}
	function getUserIP()
	{
	    $client  = @$_SERVER['HTTP_CLIENT_IP'];
	    $forward = @$_SERVER['HTTP_X_FORWARDED_FOR'];
	    $remote  = $_SERVER['REMOTE_ADDR'];
	
	    if(filter_var($client, FILTER_VALIDATE_IP))
	    {
	        $ip = $client;
	    }
	    elseif(filter_var($forward, FILTER_VALIDATE_IP))
	    {
	        $ip = $forward;
	    }
	    else
	    {
	        $ip = $remote;
	    }
	
	    return $ip;
	}
	function View_cart_subtotal($productid='',$quantity='')
	{		
	
		$subMenu			=	'';
		$subtotal		= 0;

		if ($productid!='')
		{
			$menu				=	new AllTables();
			$menulist		=	$menu->getInfo('',"Select * from mstproducts  where productid='".$productid."'");
			
			//echo $sql="Select * from mstpaintings where painting='".$productid."'";
         if(is_array($menulist))
			{
					$rowcount			=		count($menulist);
					for($i=0;$i<$rowcount;$i++)
					{
           			$productprice			=		$menulist[$i]['productprice'];
           			
           			$subtotal				=	   $productprice *$quantity;
	
           		}
			}	
		}
		return $subtotal;
			
	}
	
	function getcategorylistcombo($categoryid='')
	{
		$testclass		=	new AllTables();
		
		$statelist = $testclass->getInfo("","select * FROM mstcategory ORDER BY categoryid");
			
		$rowcount = count($statelist);
		
		$strstatelist = "";
		
		if ($rowcount > 0)
		{
			for($i=0;$i<$rowcount;$i++) 
			{	
				if(strtoupper($categoryid)==$statelist[$i]['categoryid'])
				{
					$strstatelist .= "<option value='".$statelist[$i]['categoryid']."-".$statelist[$i]['categoryname']."' selected='selected'>".ucwords(strtolower($statelist[$i]['categoryname']))."</option>";
				}
				else
				{	
					$strstatelist .= "<option value='".$statelist[$i]['categoryid']."-".$statelist[$i]['categoryname']."'>".ucwords(strtolower($statelist[$i]['categoryname']))."</option>";
				}
			}
		}
		unset($testclass);
		return $strstatelist;	
	}
	
	function getstylelistcombo($styleid='')
	{
		$testclass		=	new AllTables();
		
		$statelist = $testclass->getInfo("","select * FROM mststyle ORDER BY styleid");
			
		$rowcount = count($statelist);
		
		$strstatelist = "";
		
		if ($rowcount > 0)
		{
			for($i=0;$i<$rowcount;$i++) 
			{	
				if(strtoupper($styleid)==$statelist[$i]['styleid'])
				{
					$strstatelist .= "<option value='".$statelist[$i]['styleid']."-".$statelist[$i]['stylename']."' selected='selected'>".ucwords(strtolower($statelist[$i]['stylename']))."</option>";
				}
				else
				{	
					$strstatelist .= "<option value='".$statelist[$i]['styleid']."-".$statelist[$i]['stylename']."'>".ucwords(strtolower($statelist[$i]['stylename']))."</option>";
				}
			}
		}
		unset($testclass);
		return $strstatelist;	
	}
	
	function getmediumlistcombo($mediumid='')
	{
		$testclass		=	new AllTables();
		
		$statelist = $testclass->getInfo("","select * FROM mstmedium ORDER BY mediumid");
			
		$rowcount = count($statelist);
		
		$strstatelist = "";
		
		if ($rowcount > 0)
		{
			for($i=0;$i<$rowcount;$i++) 
			{	
				if(strtoupper($mediumid)==$statelist[$i]['mediumid'])
				{
					$strstatelist .= "<option value='".$statelist[$i]['mediumid']."-".$statelist[$i]['mediumname']."' selected='selected'>".ucwords(strtolower($statelist[$i]['mediumname']))."</option>";
				}
				else
				{	
					$strstatelist .= "<option value='".$statelist[$i]['mediumid']."-".$statelist[$i]['mediumname']."'>".ucwords(strtolower($statelist[$i]['mediumname']))."</option>";
				}
			}
		}
		unset($testclass);
		return $strstatelist;	
	}
	
	
	function getCategoryList()
	{
					$footer			=	new AllTables();
					$footersql		=	"Select * from mstcategory ";
					$pagenamelist	=	$footer->getInfo('',$footersql);
					
							$pagecount		=	count($pagenamelist);
							for($i=0;$i<$pagecount;$i++)
							{
									$categoryid				=		$pagenamelist[$i]['categoryid'];
									$categoryname			=		ProperCase($pagenamelist[$i]['categoryname']);
									$categorylink			=		toAscii($categoryname);	
							      $link					=		DOC_ROOT.'category-'.$categorylink.'-'.$categoryid.'.html';
									$subMenu				.=		'<li><a href="'.$link.'">'.$categoryname.'</a></li>';
							}
							return $subMenu;
				
		}
		
	function getRecipeList()
	{
					$footer			=	new AllTables();
					$footersql		=	"Select * from mstrecipe ";
					$pagenamelist	=	$footer->getInfo('',$footersql);
					
							$pagecount		=	count($pagenamelist);
							for($i=0;$i<$pagecount;$i++)
							{
									$id				=		$pagenamelist[$i]['id'];
									$name				=		ProperCase($pagenamelist[$i]['name']);
									$recipelink    = 		toAscii($name);
									$link				=		DOC_ROOT.'recipe-'.$recipelink.'-'.$id.'.html';
									$subMenu			.=		'<li><a href="'.$link.'">'.$name.'</a></li>';
							}
							return $subMenu;
				
		}
		
	function getcolorlistcombo($colorid='')
	{
		$testclass		=	new AllTables();
		
		$statelist = $testclass->getInfo("","select * FROM mstcolor ORDER BY colorid");
			
		$rowcount = count($statelist);
		
		$strstatelist = "";
		
		if ($rowcount > 0)
		{
			for($i=0;$i<$rowcount;$i++) 
			{	
				if(strtoupper($colorid)==$statelist[$i]['colorid'])
				{
					$strstatelist .= "<option value='".$statelist[$i]['colorid']."-".$statelist[$i]['colorname']."' selected='selected'>".ucwords(strtolower($statelist[$i]['colorname']))."</option>";
				}
				else
				{	
					$strstatelist .= "<option value='".$statelist[$i]['colorid']."-".$statelist[$i]['colorname']."'>".ucwords(strtolower($statelist[$i]['colorname']))."</option>";
				}
			}
			
		}
		unset($testclass);
		return $strstatelist;	
	}
	
	function getcolorComboCheckbox($colorid='')
	{
		$testclass			=	new AllTables();
		$grouplist	=	$testclass->getInfo("","select * FROM mstcolor ORDER BY colorid");
			
		$rowcount = count($grouplist);
		
		$strgroupList = "";
		
		if ($rowcount > 0)
		{
			
			for($i=0;$i<$rowcount;$i++) 
			{	
				if($colorid==$grouplist[$i]['colorid'])
				{
					
					$strgroupList .= '<input type="checkbox" colorid = "'.$grouplist[$i]["colorid"].'" name="selected_color[]" value="'.$grouplist[$i]["colorid"].'">'
											.ucwords(strtolower($grouplist[$i]["colorname"]));
				}
				else
				{	
				
					$strgroupList .= '<input type="checkbox" colorid = "'.$grouplist[$i]["colorid"].'" name="selected_color[]" value="'.$grouplist[$i]["colorid"].'">'
											.ucwords(strtolower($grouplist[$i]["colorname"]));
				}
			}
		}
		return $strgroupList;
	}
	
	function getcolorComboCheckboxnew($paintingid)
	{
			$testclass			=	new AllTables();
			$claimlist	=	$testclass->getInfo("","select * FROM mstcolor ORDER BY colorid");
			
		   $claimlistcount 		=	count($claimlist);
			//echo $sql;
	      $sql1	=	"SELECT * FROM trnpaintingcolor where paintingid=".$paintingid;

			$doclist1	   =	$testclass->getInfo('',$sql1);

		$count1 		=	count($doclist1);
		for($i=0;$i<$claimlistcount;$i++) 
		{ 
			$claimlistid 					= $claimlist[$i]['colorid'];
		   $claimlistname 				= $claimlist[$i]['colorname'];
			for($j=0;$j<$count1;$j++)
			{
		
				if($claimlistid==$doclist1[$j]['colorid']) 
				{
					$checked = "checked";
					break;	    		          
				}
				else 
				{
					$checked = "unchecked";
					continue;
				}
			}
			$docsubmitlist1 				.= '<input type="checkbox"  name="selected_color[]" value='.$claimlistid.' '.$checked.'>
	                                        		'.$claimlistname.''; 	
       }
	
		return $docsubmitlist1;		
	}	
	
	
	function getprojectcategory($projectcategoryid='')
	{
		$testclass		=	new AllTables();
		
		$statelist = $testclass->getInfo("","select * FROM mstprojectcategory");
			
		$rowcount = count($statelist);
		
		$strstatelist = "";
		
		if ($rowcount > 0)
		{
			for($i=0;$i<$rowcount;$i++) 
			{	
				if(strtoupper($projectcategoryid)==$statelist[$i]['projectcategoryid'])
				{
					$strstatelist .= "<option value='".$statelist[$i]['projectcategoryid']."-".$statelist[$i]['projectcategoryname']."' selected='selected'>".ucwords(strtolower($statelist[$i]['projectcategoryname']))."</option>";
				}
				else
				{	
					$strstatelist .= "<option value='".$statelist[$i]['projectcategoryid']."-".$statelist[$i]['projectcategoryname']."'>".ucwords(strtolower($statelist[$i]['projectcategoryname']))."</option>";
				}
			}
			
		}
		unset($testclass);
		return $strstatelist;	
	}
	
	function getGalleryDetails($projectcategoryid)
   {

			$menu			=	new AllTables();

			if ($projectcategoryid!='')

			{

				$menulist		=	$menu->getInfo('',"SELECT * FROM mstprojectphotos a INNER JOIN mstprojects b ON a.projectid = b.projectid where b.projectcategoryid='$projectcategoryid' order by a.projectid");

			}

			if(is_array($menulist))
         {
         	return $menulist;
         }

	}
	
	function HeaderProjectdropdown()
	{		
			$subMenu='';
			$menu			=	new AllTables();
			$menulist		=	$menu->getInfo('',"Select * from mstprojectcategory");
			if(is_array($menulist))
			{
					$rowcount			=		count($menulist);
					for($i=0;$i<$rowcount;$i++)
					{
							$categoryid			=		$menulist[$i]['projectcategoryid'];
							$categoryname		=		strtoupper($menulist[$i]['projectcategoryname']);

							$link					=		"projects.php?projectcategoryid=$categoryid";
							
							$subMenu				.=		'<li class="dropdown dropdown-submenu f_dropdown-submenu"><a href="'.$link.'">'.$categoryname.'</a></li>';
							
					}
					
					
					return $subMenu;
					
			}
		
	}
	
	function getAllStates($countryid ='', $stateid='')
	{
		//$states = new State();
		$all_obj = new AllTables();
		
		if($countryid != ''){
			
			$sql = "select * from mststate where countryid=".$countryid." ORDER BY StateName, StateId";
		}
		else {
			
	   	$sql = "select * from mststate ORDER BY StateName, StateId";;
	   }
	   
	   $statelist = $all_obj->getInfo('',$sql);
	   $rowcount =count($statelist);
		
		$optionvalue .= "<option value=''>Select state</option>";
		
		for($i=0;$i<$rowcount;$i++){
			
			$statename =$statelist[$i]['StateName'];
			$stateIds =$statelist[$i]['StateId'];
			
			if($stateid == $stateIds){
				
				$optionvalue .= "<option value='".$stateid."-".$statename."' selected='selected'>".$statename."</option>";
				
			}else{
			
				$optionvalue .= "<option value='".$stateid."-".$statename."'>".$statename."</option>";
			}		
		}
		
		
		return $optionvalue;
	}
	
	function getAllStateListForCombo($stateid='',$countryid='',$countryname='',$statelist='')
	{
		$rowcount = (is_array($statelist))?count($statelist):0;
		
		$strstateList = "";
		
		if ($rowcount > 0)
		{
			
			for($i=0;$i<$rowcount;$i++) 
			{	
				if($stateid == $statelist[$i]['StateId'])
				{
					$strstateList .= '<option value="'.$statelist[$i]["StateId"].'-'.$statelist[$i]["StateName"].'" selected="selected">'.ucwords(strtolower($statelist[$i]["StateName"])).'</option>';
				}
				else
				{	
					$strstateList .= '<option value="'.$statelist[$i]["StateId"].'-'.$statelist[$i]["StateName"].'">'.ucwords(strtolower($statelist[$i]["StateName"])).'</option>';
				}
			}
		}
		return $strstateList;	
	}
	
	function getAllStateListForComboEdit($stateid='')
	{
		$testclass    			= 	new AllTables();
		$query ="SELECT * FROM mststate";
	
		 $statelist	         = $testclass-> getInfo("",$query);
		 $rowcount  = count($statelist);
		$strstateList = "";
		
		if ($rowcount > 0)
		{
			
			for($i=0;$i<$rowcount;$i++) 
			{	
				if($stateid == $statelist[$i]['StateId'])
				{
					$strstateList .= '<option value="'.$statelist[$i]["StateId"].'-'.$statelist[$i]["StateName"].'" selected="selected">'.ucwords(strtolower($statelist[$i]["StateName"])).'</option>';
				}
				else
				{	
					$strstateList .= '<option value="'.$statelist[$i]["StateId"].'-'.$statelist[$i]["StateName"].'">'.ucwords(strtolower($statelist[$i]["StateName"])).'</option>';
				}
			}
		}
		return $strstateList;	
	}
	function getAllCountry()
	{
		//$states = new State();
		$all_obj = new AllTables();
	   $sql = "select * from mstcountry";
		$countrylist = $all_obj->getInfo('',$sql);
		return $countrylist;
	}
	
	function getAllCountryListForCombo1($countryid='',$countrylist='')
	{
		$rowcount = (is_array($countrylist))?count($countrylist):0;
		
		$strstateList = "";
		
		if ($rowcount > 0)
		{
			
			for($i=0;$i<$rowcount;$i++) 
			{	
				if($countryid == $countrylist[$i]['countryid'])
				{
					$strstateList .= '<option value="'.$countrylist[$i]["countryid"].'-'.$countrylist[$i]["countryname"].'" selected="selected">'.ucwords(strtolower($countrylist[$i]["countryname"])).'</option>';
				}
				else
				{	
					$strstateList .= '<option value="'.$countrylist[$i]["countryid"].'-'.$countrylist[$i]["countryname"].'">'.ucwords(strtolower($countrylist[$i]["countryname"])).'</option>';
				}
			}
		}
		return $strstateList;	
	}
	
	function getprojectcombolist($projectid='')
	{
		$testclass		=	new AllTables();
		
		$statelist = $testclass->getInfo("","select * FROM mstprojects");
			
		$rowcount = count($statelist);
		
		$strstatelist = "";
		
		if ($rowcount > 0)
		{
			for($i=0;$i<$rowcount;$i++) 
			{	
				if(strtoupper($projectid)==$statelist[$i]['projectid'])
				{
					$strstatelist .= "<option value='".$statelist[$i]['projectid']."-".$statelist[$i]['projectname']."' selected='selected'>".ucwords(strtolower($statelist[$i]['projectname']))."</option>";
				}
				else
				{	
					$strstatelist .= "<option value='".$statelist[$i]['projectid']."-".$statelist[$i]['projectname']."'>".ucwords(strtolower($statelist[$i]['projectname']))."</option>";
				}
			}
			
		}
		unset($testclass);
		return $strstatelist;	
	}
	
	function checkIfNullDate($dateToCheck)
	{
		$returndate='';
		if ($dateToCheck =='01-01-1970' || $dateToCheck =='0000-00-00' || $dateToCheck =='1970-01-01 00:00:00' || $dateToCheck =='0000-00-00 00:00:00' || $dateToCheck =='30-11--0001')
		{
			$returndate =null;
		}
		else 
		{
			$returndate =$dateToCheck;
		}	
		return $returndate;
	} 
	
function getProjectDetails($projectid)
{

			$menu			=	new AllTables();

			if ($projectid!='')

			{

				//$menulist		=	$menu->getInfo('',"Select * from mstprojectphotos where projectid='$projectid' ");



				$menulist		=	$menu->getInfo('',"SELECT * FROM mstprojectphotos a INNER JOIN mstprojects b ON a.projectid = b.projectid where a.projectid='$projectid'");

			}


			if(is_array($menulist))

			{

				return $menulist;

			}

	}

//-----------------format numbers--------------------------//

function format_number($strAmount)
{
	list($OrgAmount,$DotAmount)= explode('.', "$strAmount"); 		
//	list($OrgAmount,$DotAmount)= split ('[.]', $strAmount);	
//	list($OrgAmount)= split ('[.]', $strAmount);	
	
	// -- If Decimal Amount is Blank Then Make It '00 ---- ////
	
	if ($DotAmount =='')
	{
		$DotAmount ='00';
	}
	else if (strlen($DotAmount)==1)
    {
		$DotAmount .= "0"; 
    }	    
    // -- End Decimal Amount
    
    $strlength	 = strlen($OrgAmount);			// Length Of Amount 
        
    if ($strlength >'0')
    {
		if ($strlength == '1')
		{
			$a = substr($OrgAmount,"0","1");
			$strAm ="$a.$DotAmount";					
			return($strAm); 					
		}
		else if ($strlength =='2')
		{
			$a = substr($OrgAmount,"0","2");
			$strAm ="$a.$DotAmount";					
			return($strAm); 					
		}
		else if ($strlength =='3')
		{
			$a = substr($OrgAmount,"0","3");
			$strAm ="$a.$DotAmount";					
			return($strAm); 				
		}
		else if ($strlength =='4')
		{
			$b = substr($OrgAmount,"1","3");
			$a = substr($OrgAmount,"0","1");
			$strAm ="$a,$b.$DotAmount";					
			return($strAm); 		
		}
		else if ($strlength =='5')
		{
			$b = substr($OrgAmount,"2","3");
			$a = substr($OrgAmount,"0","2");
			$strAm ="$a,$b.$DotAmount";					
			return($strAm); 				
		}
		else if ($strlength =='6')
		{
			$c = substr($OrgAmount,"3","3");
			$b = substr($OrgAmount,"1","2");
			$a = substr($OrgAmount,"0","1");
			$strAm ="$a,$b,$c.$DotAmount";					
			return($strAm); 		
		}
		else if ($strlength =='7')
		{
			$c = substr($OrgAmount,"4","3");
			$b = substr($OrgAmount,"2","2");
			$a = substr($OrgAmount,"0","2");
			$strAm ="$a,$b,$c.$DotAmount";					
			return($strAm); 
							
		}
		else if ($strlength =='8')
		{
			$d = substr($OrgAmount,"5","3");
			$c = substr($OrgAmount,"3","2");
			$b = substr($OrgAmount,"1","2");
			$a = substr($OrgAmount,"0","1");
			$strAm ="$a,$b,$c,$d.$DotAmount";					
			return($strAm); 		
		}
		else if ($strlength =='9')
		{
			$d = substr($OrgAmount,"6","3");
			$c = substr($OrgAmount,"4","2");
			$b = substr($OrgAmount,"2","2");
			$a = substr($OrgAmount,"0","2");
			$strAm ="$a,$b,$c,$d.$DotAmount";					
			return($strAm); 
		}
		else if ($strlength =='10')
		{	
			$e = substr($OrgAmount,"7","3");
			$d = substr($OrgAmount,"5","2");
			$c = substr($OrgAmount,"3","2");
			$b = substr($OrgAmount,"1","2");
			$a = substr($OrgAmount,"0","1");
			
			$strAm ="$a,$b,$c,$d,$e.$DotAmount";					
			return($strAm); 
		}
		else if ($strlength =='11')
		{
			$e = substr($OrgAmount,"8","3");
			$d = substr($OrgAmount,"6","2");
			$c = substr($OrgAmount,"4","2");
			$b = substr($OrgAmount,"2","2");
			$a = substr($OrgAmount,"0","2");
			$strAm ="$a,$b,$c,$d,$e.$DotAmount";					
			return($strAm); 
		}		
	}
}
	
//echo number_to_words(11875494);
$nwords = array(  "", "One", "Two", "Three", "Four", "Five", "Six", 
	      	  "Seven", "Eight", "Nine", "Ten", "Eleven", "Twelve", "Thirteen", 
	      	  "Fourteen", "Fifteen", "Sixteen", "Seventeen", "Eighteen", 
	     	  "Nineteen", "Twenty", 30 => "Thirty", 40 => "Fourty",
                     50 => "Fifty", 60 => "Sixty", 70 => "Seventy", 80 => "Eigthy",
                     90 => "Ninety" );
function number_to_words ($x)
{
     global $nwords;
     if(!is_numeric($x))
     {
         $w = 'a';
     }
     else if(fmod($x, 1) != 0)
     {
        //$w = 'b';
			list($OrgAmount,$DotAmount)= explode('.', "$x");        
        //list($OrgAmount,$DotAmount)= preg_split('[.]', $x);
        //list($OrgAmount,$DotAmount)= split ('[.]', $x);
        if (strlen($DotAmount)==1)
        {
			$DotAmount .= "0"; 
        }
        $paise = " and paise ".number_to_words($DotAmount). " ";
        $w = number_to_words($OrgAmount);
     }
     else
     {
         if($x < 0)
         {
             $w = 'minus ';
             $x = -$x;
         }else{
             $w = '';
         }
         if($x < 21)
         {
             $w .= $nwords[$x];
         }else if($x < 100)
         {
             $w .= $nwords[10 * floor($x/10)];
             $r = fmod($x, 10);
             if($r > 0)
             {
                 $w .= ' '. $nwords[$r];
             }
         } else if($x < 1000)
         {
		
             	$w .= $nwords[floor($x/100)] .' hundred';
             $r = fmod($x, 100);
             if($r > 0)
             {
                 $w .= ' '. number_to_words($r);
             }
         } else if($x < 100000)
         {
         	$w .= number_to_words(floor($x/1000)) .' thousand';
             $r = fmod($x, 1000);
             if($r > 0)
             {
                 $w .= ' ';
                 if($r < 100)
                 {
                     $w .= ' ';
                 }
                 $w .= number_to_words($r);
             }
         } else if ($x < 10000000) {
             $w .= number_to_words(floor($x/100000)) .' Lacs';
             $r = fmod($x, 100000);
             if($r > 0)
             {
                 $w .= ' ';
                 if($r < 100)
                 {
                     $word .= ' ';
                 }
                 $w .= number_to_words($r);
             }
         }else  {
             $w .= number_to_words(floor($x/10000000)) .' Crore';
             $r = fmod($x, 10000000);
             if($r > 0)
             {
                 $w .= ' ';
                 if($r < 100)
                 {
                     $word .= ' ';
                 }
                 $w .= number_to_words($r);
             }
         }
     }
     return $w." ".$paise;
}



function CreateInvoiceContinuationNo($finrange='')
	{		
			$invoiceMenu='';
			//$financialyear = '2016-2017';
			$invoice			=	new KeyGen();
			// added by rajiv on 2nd april for invoice approval after fin year is over			
			if ($finrange=='')
			{			
				$invoicelist		=	$invoice->getKeyGen("","Select * from mstkeygen where  keygenfield = 'invoicesrno' and status = 1");
			}
			else 
			{
				$invoicelist		=	$invoice->getKeyGen("","Select * from mstkeygen where  keygenfield = 'invoicesrno' and invoiceyeardisplay = '$finrange' and status = 1");
			}		
			if(is_array($invoicelist))
			{
					$rowcount		=		count($invoicelist);
					$keygenid		=		$invoicelist[0]['keygenid'];
					$keygenvalue	=		$invoicelist[0]['keygenvalue'];
					$invoiceno 		= 		$keygenvalue + 1;
					
					$NewInvoiceNo['keygenvalue'] 		= $invoiceno;
					$wherecondition = "keygenid = ".$keygenid;
					$editkeygen = $invoice -> EditKeyGen($NewInvoiceNo,$wherecondition);
					$invoiceMenu	= $invoiceno;
			}
			return $invoiceMenu;
		
	}
	
	//Encrypt Param
	function encrParam($array){
	    if(is_array($array)){
			$arrayparam = array();
			foreach($array as $key => $value){
					$arrayparam[convert_uuencode($key)] = convert_uuencode($value);
	            //$data .= convert_uuencode($key).'~'.convert_uuencode($value).'||';
	         }						
		}
	    return $arrayparam;
	}
	
	//Decrypt param and return in array format
	function dcrParam($array){
	 	$explodeencr = explode("||", $array);
		
		for($i=0;$i<count($explodeencr)-1;$i++){
		    $param =  $explodeencr[$i];
		    
		    $explodeparam = explode("~", $param);
		   
		       
		    $arrayparam[convert_uudecode($explodeparam[0])] = convert_uudecode($explodeparam[1]);
		    //echo convert_uudecode($explodeparam[0]).'='.convert_uudecode($explodeparam[1];).'<br>';
		}
		                                                                       
		return $arrayparam;
	}
	
	function FinancialYrStartEndDates($date='')
{
	$monthtofind = ($date=='')?gmdate("n",mktime(null,null,null,date("n"),date("d"),date("Y"))):gmdate("n",mktime(null,null,null,substr($date,0,2),substr($date,3,2),substr($date,6,4)));
	
	$yeartofind = ($date=='')?gmdate("Y",mktime(null,null,null,date("n"),date("d"),date("Y"))):gmdate("Y",mktime(null,null,null,substr($date,0,2),substr($date,3,2),substr($date,6,4)))-$noofyearsback;
	
		if ($monthtofind < 4)
		{
			// jan feb or march month so deduct one from current year
			$FnYear = ($yeartofind-1);
			$FinancialYear = $FnYear.'-04-01'."|".$yeartofind.'-03-31';  
		}
		else
		{
			$FnYear = ($yeartofind+1);
			$FinancialYear = $yeartofind.'-04-01'."|".$FnYear.'-03-31';
		}
		
		return $FinancialYear;	
}

function formatdate($date1,$dateformat="d-m-Y")
{
	
	$string = $date1; 	
	if ($string > "1900-12-30")
	{
	
		$string = $date1; 	
		$stringArray = explode("-", $string); 
		$date = mktime(0,0,0,$stringArray[1],$stringArray[2],$stringArray[0]); 

		$converteddate = date($dateformat, $date); 
		return ($converteddate);    	 
	}
}	
function getAllStateListForComboForSearch($countryid='',$stateid='')
	{
		$state = new State();
		//$panelid = '';
		$statelist = $state->getState("","select * from mststate where countryid = $countryid ORDER BY StateId");
		
		$rowcount = count($statelist);
		
		$strstateList = "";
		
		if ($rowcount > 0)
		{
			
			for($i=0;$i<$rowcount;$i++) 
			{	
				if(strtoupper($stateid)==$statelist[$i]['StateId'])
				{
					$strstateList .= '<option value="'.$statelist[$i]["StateId"].'-'.$statelist[$i]["StateName"].'" selected="selected">'.ucwords(strtolower($statelist[$i]["StateName"])).'</option>';
				}
				else
				{	
					$strstateList .= '<option value="'.$statelist[$i]["StateId"].'-'.$statelist[$i]["StateName"].'">'.ucwords(strtolower($statelist[$i]["StateName"])).'</option>';
				}
			}
		}
		return $strstateList;	
	}	
	function getAllCountryListForCombo($GCountry='')
	{
		$conuntries = new State();
		
		$countrylist = $conuntries->getState("","select * from mstcountry");
		
		$rowcount = count($countrylist);
		
		$strCountryList = "";
		
		if ($rowcount > 0)
		{
			
			for($i=0;$i<$rowcount;$i++) 
			{	
				
				if(strtolower($GCountry) == strtolower($countrylist[$i]['countryname']))
				{
					$strCountryList .= '<option value="'.$countrylist[$i]["countryid"].'-'.$countrylist[$i]["countryname"].'" selected="selected">'.ucwords(strtolower($countrylist[$i]["countryname"])).'</option>';
				}
				else
				{	
					$strCountryList .= '<option value="'.$countrylist[$i]["countryid"].'-'.$countrylist[$i]["countryname"].'">'.ucwords(strtolower($countrylist[$i]["countryname"])).'</option>';
				}
			}
		}
		return $strCountryList;	
	}	
	
	function getStateNameORId($stateid='',$statename='')
	{
		$state = new State();
		if($stateid != '')
		{
			$sql = "select * from mststate where StateId = $stateid ";
			$statelist = $state->getState("",$sql);
			$strStateList 	= $statelist[0]['StateName'];
			
		}
		elseif($statename != '')
		{
			$sql = "select * from mststate where StateName = '".$statename."' ";
			$statelist = $state->getState("",$sql);
			$strStateList 	= $statelist[0]['StateId'];
		}
		return $strStateList;	
	}	
	
	function getAllUnits($unit='')
	{
		$units = new AllTables();
		
		$unitlist = $units->getInfo("","select * from product_units");
		
		$rowcount = count($unitlist);
		
		$strunitlist = "";
		
		if ($rowcount > 0)
		{
			
			for($i=0;$i<$rowcount;$i++) 
			{	
				
				if(strtolower($unit) == strtolower($unitlist[$i]['unitid']))
				{
					$strunitlist .= '<option value="'.$unitlist[$i]["unitid"].'-'.$unitlist[$i]["unitname"].'" selected="selected">'.ucwords(strtolower($unitlist[$i]["unitname"])).'</option>';
				}
				else
				{	
					$strunitlist .= '<option value="'.$unitlist[$i]["unitid"].'-'.$unitlist[$i]["unitname"].'">'.ucwords(strtolower($unitlist[$i]["unitname"])).'</option>';
				}
			}
		}
		return $strunitlist;	
	}	
	
	
	function getAllCompanyList($companyid='',$userid='')
	{
		
		$units = new AllTables();
		$sql=("select * from ".COMPANY_TABLE." a 
			  INNER JOIN ".USERCOMPANYDETAILS_TABLE." b on a.companyid = b.companyid 
			  where b.userid= $userid");
		$unitlist = $units->getInfo("",$sql);
		print_r($unitlist);
		//die();
		$rowcount = count($unitlist);
		
		$strunitlist = "";
		
		if ($rowcount > 0)
		{
			
			for($i=0;$i<$rowcount;$i++) 
			{	
				
				if(strtolower($companyid) == strtolower($unitlist[$i]['companyid']))
				{
					$strunitlist .= '<option value="'.$unitlist[$i]["companyid"].'" selected="selected">'.ucwords(strtolower($unitlist[$i]["companyname"])).'</option>';
				}
				else
				{	
					$strunitlist .= '<option value="'.$unitlist[$i]["companyid"].'">'.ucwords(strtolower($unitlist[$i]["companyname"])).'</option>';
				}
			}
		}
		return $strunitlist;	
	}	
	
	
	function getMyCompanyFactoryList($companyid='')
	{
			$menu			=	new Factories();
		$sql="Select * from member_factories where companyid=$companyid";
			$menulist		=	$menu->getFactories('',$sql);
			//print_r($menulist);
			if(is_array($menulist))
			{
					$rowcount			=		count($menulist);
					for($i=0;$i<$rowcount;$i++)
					{
							$factory =$menulist[$i]['factoryaddress'];
							$memberfactoryid =$menulist[$i]['memberfactoryid'];
			
 							$factoryaddress				.=	'<tbody>';
							$factoryaddress				.=	 '<tr>';
							$factoryaddress				.=	'<td>'.$factory.'</td>';
							$factoryaddress				.=	'<td><a href="edit-mycompany-factories.php?memberfactoryid='.$memberfactoryid.'">Edit</a></td>';
							$factoryaddress				.=	'</tr>';
							 $factoryaddress				.=	'</tbody>';
							
							
					}
					
					
			}
			return $factoryaddress;
	}
	
		function getMyCompanyBranchList($companyid='')
	{
			$menu			=	new Branches();
		$sql="Select * from member_branches where companyid=$companyid";
			$menulist		=	$menu->getBranches('',$sql);
			//print_r($menulist);
			if(is_array($menulist))
			{
					$rowcount			=		count($menulist);
					for($i=0;$i<$rowcount;$i++)
					{
							$branch =$menulist[$i]['branchaddress'];
							$memberbranchid =$menulist[$i]['memberbranchid'];
			
 							$branchaddress				.=	'<tbody>';
							$branchaddress				.=	 '<tr>';
							$branchaddress				.=	'<td>'.$branch.'</td>';
							$branchaddress				.=	'<td><a href="edit-mycompany-branches.php?memberbranchid='.$memberbranchid.'">Edit</a></td>';
							$branchaddress				.=	'</tr>';
							 $branchaddress				.=	'</tbody>';
							
							
					}
					
					
			}
			return $branchaddress;
	}
	
	function getClientFactoryList($companyid='')
	{
			$menu			=	new ClientFactories();
		$sql="Select * from client_factories where clientcompanyid=$companyid";
			$menulist		=	$menu->getClientFactories('',$sql);
			//print_r($menulist);
			if(is_array($menulist))
			{
					$rowcount			=		count($menulist);
					for($i=0;$i<$rowcount;$i++)
					{
							$factory =$menulist[$i]['factoryaddress'];
							$clientfactoryid =$menulist[$i]['clientfactoryid'];
			
 							$factoryaddress				.=	'<tbody>';
							$factoryaddress				.=	 '<tr>';
							$factoryaddress				.=	'<td>'.$factory.'</td>';
							$factoryaddress				.=	'<td><a href="edit-client-factories.php?clientfactoryid='.$clientfactoryid.'">Edit</a></td>';
							$factoryaddress				.=	'</tr>';
							 $factoryaddress				.=	'</tbody>';
							
							
					}
					
					
			}
			return $factoryaddress;
	}

	
		function getClientBranchList($companyid='')
	{
			$menu			=	new ClientBranches();
		$sql="Select * from client_branches where clientcompanyid=$companyid";
			$menulist		=	$menu->getClientBranches('',$sql);
			//print_r($menulist);
			if(is_array($menulist))
			{
					$rowcount			=		count($menulist);
					for($i=0;$i<$rowcount;$i++)
					{
							$branch =$menulist[$i]['branchaddress'];
							$clientbranchid =$menulist[$i]['clientbranchid'];
			
 							$branchaddress				.=	'<tbody>';
							$branchaddress				.=	 '<tr>';
							$branchaddress				.=	'<td>'.$branch.'</td>';
							$branchaddress				.=	'<td><a href="edit-client-branches.php?clientbranchid='.$clientbranchid.'">Edit</a></td>';
							$branchaddress				.=	'</tr>';
							 $branchaddress				.=	'</tbody>';
							
							
					}
					
					
			}
			return $branchaddress;
	}
	
	//Function used for factory display in panel
function FactoryDisplay($companyid='')
	{		
			//$accessid = 2;
		
			$factoryMenu='';
			$factory			=	new ClientFactories();
	$factorylist		=	$factory->getClientFactories("","Select * from client_factories where isdeleted =0 and clientcompanyid=$companyid");
	//print_r($factorylist);
			//if(is_array($factorylist))
			//{
					$rowcount			=		count($factorylist);
					for($i=0;$i<$rowcount;$i++)
					{
							$companyid				=		$factorylist[$i]['clientcompanyid'];
							$clientfactoryid		=		$factorylist[$i]['clientfactoryid'];
							$factoryaddress		=		$factorylist[$i]['factoryaddress'];
							$factoryaddressline1	=		$factorylist[$i]['factoryaddressline1'];
						
							$factoryaddressline2	=		$factorylist[$i]['factoryaddressline2'];
							$factoryaddressline3	=		$factorylist[$i]['factoryaddressline3'];
							$factoryaddressline4	=		$factorylist[$i]['factoryaddressline4'];
							$factorystreet			= 		$factorylist[$i]['factorystreet'];
							$factorycity			=		$factorylist[$i]['factorycity'];	
							$factorycountry			=		$factorylist[$i]['factorycountry'];
							$factorypincode		=		$factorylist[$i]['factorypincode'];
							//$factorystateid		= 		$factorylist[$i]['factorystateid'];							
							//$factorystate			= 		$factorylist[$i]['factorystate'];
							//$factorytelno			=		$factorylist[$i]['factorytelno'];
							//$factoryfaxno			= 		$factorylist[$i]['factoryfaxno'];
							//$factoryemail			=		$factorylist[$i]['factoryemail'];
							$factorygstno			=		$factorylist[$i]['factorygstno'];
							$factorystate			= 		$factorylist[$i]['factorystate'];
	 		$factory_Stateid1								= $factorylist[$i]['factory_Stateid1'];
						$factory_StateidName							= $factorylist[$i]['factory_StateidName'];
						$GCountry									= $factorylist[$i]['txtfactorycountry'];
							
							$formid 					= 		"'fact_reg_form_".$clientfactoryid."'";
							$sendurl					=		"'submit.php'";
							$deleteurl				=		"'delete_factory.php'";
							
							

								$editable_grid = '<a href="#" class="btn btn-space btn-light fact_edit fact_span_'.$clientfactoryid.'" rel="'.$clientfactoryid.'" id="fact_edit_'.$clientfactoryid.'" onclick="return false;">EDIT</a>
															<a href="#" class="btn btn-space btn-primary fact_cancel fact_text_'.$clientfactoryid.'" rel="'.$clientfactoryid.'" id="fact_cancel_'.$clientfactoryid.'" onclick="return false;" style="display:none;">CANCEL</a>
															<a href="#" class="btn btn-space btn-secondary fact_save fact_text_'.$clientfactoryid.'" rel="'.$clientfactoryid.'" id="fact_save'.$clientfactoryid.'" onclick="formAjax('.$formid.','.$sendurl.'); return false;" style="display:none;">SAVE</a>
															<a href="#" class="btn btn-space btn-danger fact_delete fact_text_'.$clientfactoryid.'" rel="'.$clientfactoryid.'" id="fact_delete'.$clientfactoryid.'" onclick="DeleteformAjax('.$formid.','.$deleteurl.'); return false;">DELETE</a>';

	
															
				$factoryMenu.=	'<div class="row">
				<div class="col-lg-6" id="single_factory_'.$clientfactoryid.'">
									<div class="card">
				<div class="card-body" id="factory_panel_'.$clientfactoryid.'">
					<div id="form_content_'.$clientfactoryid.'">
							<form id="fact_reg_form_'.$clientfactoryid.'">
								<input type="hidden" id="" name="txtaccessid" value="'.$accessid.'" class="form-control">
									<input type="hidden" id="txtcompanyid_'.$companyid.'" name="txtcompanyid" value="'.$companyid.'" class="form-control">
									<input type="hidden" id="txtclientfactoryid_'.$clientfactoryid.'" name="txtclientfactoryid" value="'.$clientfactoryid.'" class="form-control">
									<input type="hidden" id="operation_'.$clientfactoryid.'" name="operation" value="edit_factory" class="form-control">
			<!--<div class="form-group">
					<label><b>Address : </b></label>
					<div class="fact_span_'.$clientfactoryid.'">'.$factoryaddress.'</div>
					<textarea readonly id="txtfactoryaddress_'.$clientfactoryid.'" name="txtfactoryaddress" class="form-control fact_text_'.$clientfactoryid.'" rows="3" style="display:none;">'.$factoryaddress.'</textarea>
				</div>-->
			<div class="row">
				<div class="form-group col-md-6">
					<label><b>Address Line 1</b></label>
					<div class="fact_span_'.$clientfactoryid.'">'.$factoryaddressline1.'</div>
					<input type="text" id="txtfactoryaddressline1_'.$clientfactoryid.'" name="txtfactoryaddressline1"  value="'.$factoryaddressline1.'" class="form-control fact_text_'.$clientfactoryid.'" style="display:none;">
				</div>
				<div class="form-group col-md-6">
					<label><b>Address Line 2</b></label>
					<div class="fact_span_'.$clientfactoryid.'">'.$factoryaddressline2.'</div>
					<input type="text" id="txtfactoryaddressline2_'.$clientfactoryid.'" name="txtfactoryaddressline2"  value="'.$factoryaddressline2.'" class="form-control fact_text_'.$clientfactoryid.'" style="display:none;">
				</div>
			
				</div>
					<div class="row">
				
				<div class="form-group col-md-6">
					<label><b>City</b></label>
					<div class="fact_span_'.$clientfactoryid.'">'.$factorycity.'</div>
					<input type="text" id="txtfactorycity_'.$clientfactoryid.'" name="txtfactorycity"  value="'.$factorycity.'" class="form-control fact_text_'.$clientfactoryid.'" style="display:none;">
				</div>
				<div class="form-group col-md-6">
					<label><b>Pin Code</b></label>
					<div class="fact_span_'.$clientfactoryid.'">'.$factorypincode.'</div>
					<input type="text" id="txtfactorypincode_'.$clientfactoryid.'" name="txtfactorypincode" value="'.$factorypincode.'" class="form-control fact_text_'.$clientfactoryid.'" style="display:none;">
				</div>
				</div>
					<div class="row">
						<div class="form-group col-md-6">
				<label><b>Country</b></label>
					<div class="fact_span_'.$clientfactoryid.'">'.$factorycountry.'</div>
               <select id="txtfactorycountry_'.$clientfactoryid.'" name="txtfactorycountry" class="form-control fact_text_'.$clientfactoryid.'"  getState(this.value,'.$factory_StateidName.'); style="display:none;">
						<option value="">Select Country</option>
	'.getAllCountryListForCombo($factorycountry).'
	</select>
				</div>
				<div class="form-group col-md-6">
				<label><b>State</b></label>
					<div class="fact_span_'.$clientfactoryid.'">'.$factory_StateidName.'</div>
               <select id="txtstate_'.$clientfactoryid.'" name="txtstate" class="form-control fact_text_'.$clientfactoryid.'"  style="display:none;">
						<option value="" >Select State</option>
						'.getAllStateListForComboEdit($factory_Stateid1).'
					</select>
				</div>
				</div>
				
				<div class="row">
			<div class="form-group col-md-6">
					<label><b>GST No</b></label>
					<div class="fact_span_'.$clientfactoryid.'">'.$factorygstno.'</div>
					<input type="text" id="txtfactorygstno_'.$clientfactoryid.'" name="txtfactorygstno"  value="'.$factorygstno.'" class="form-control fact_text_'.$clientfactoryid.'" style="display:none;">
				</div>
						
							</div>
						
													
									</form>'.$editable_grid.'
									</div>
										</div>
										</div>
										</div>
										</div>';																
		}
					
					
					return $factoryMenu;
					
			//}
}


	//Function used for branch display in panel, 
	function BranchesDisplay($companyid='')
	{		
			
			$branchMenu='';
			$branch			=	new ClientBranches();
	
			$branchlist		=	$branch->getClientBranches("","Select * from ".CLIENT_BRANCHES_TABLE." where isdeleted =0 and  clientcompanyid=$companyid");
			//print_r($branchlist);
			if(is_array($branchlist))
			{
					$rowcount			=		count($branchlist);
					for($i=0;$i<$rowcount;$i++)
					{
									$companyid				=		$branchlist[$i]['clientcompanyid'];
							$clientbranchid		=		$branchlist[$i]['clientbranchid'];
							$branchaddress			=		$branchlist[$i]['branchaddress'];
							$branchaddressline1	=		$branchlist[$i]['branchaddressline1'];
							$branchaddressline2	=		$branchlist[$i]['branchaddressline2'];
							$branchaddressline3	=		$branchlist[$i]['branchaddressline3'];
							$branchaddressline4	=		$branchlist[$i]['branchaddressline4'];
							$branchstreet			= 		$branchlist[$i]['branchstreet'];
							$branchcity				=		$branchlist[$i]['branchcity'];	
							$branchpincode			=		$branchlist[$i]['branchpincode'];
						//	$branchstateid			= 		$branchlist[$i]['branchstateid'];
						//	$branchstate			= 		$branchlist[$i]['branchstate'];
						//	$branchtelno			=		$branchlist[$i]['branchtelno'];
							////$branchfaxno			= 		$branchlist[$i]['branchfaxno'];
					 $branchcountry 			=		$branchlist[$i]['branchcountry'];
							$branchgstno			=		$branchlist[$i]['branchgstno'];

							$branchstate			= 		$branchlist[$i]['branchstate'];
	 						$branch_Stateid1								= $branchlist[$i]['branch_stateid1'];
						$branch_StateidName							= $branchlist[$i]['branch_StateidName'];
						$GCountry									= $branchlist[$i]['txtbranchcountry'];
						$branchaddressfordiv			=		$branchaddress."<br> ".$branchcity."<br> ".$branch_StateidName."<br> ".$branchcountry."-".$branchpincode;
						$branchaddressfortextarea			=		$branchaddress." ".$branchcity." ".$branch_StateidName." ".$branchcountry."-".$branchpincode;
							
							$formid 					= 		"'branch_reg_form_".$clientbranchid."'";
							$sendurl					=		"'branch_submit.php'";
							$deleteurl					=		"'delete_branch.php'";
					//print_r($branchlist);
													$editable_grid = '<a href="#" class="btn btn-space btn-light branch_edit branch_span_'.$clientbranchid.'" rel="'.$clientbranchid.'" id="branch_edit_'.$clientbranchid.'" onclick="return false;">EDIT</a>
														<a href="#" class="btn btn-space btn-primary branch_cancel branch_text_'.$clientbranchid.'" rel="'.$clientbranchid.'" id="branch_cancel_'.$clientbranchid.'" onclick="return false;" style="display:none;">CANCEL</a>
														<a href="#" class="btn btn-space btn-secondary branch_save branch_text_'.$clientbranchid.'" rel="'.$clientbranchid.'" id="branch_save_'.$clientbranchid.'" onclick="formAjax('.$formid.','.$sendurl.'); return false;" style="display:none;">SAVE</a>
														<a href="#" class="btn btn-space btn-danger branch_delete branch_text_'.$clientbranchid.'" rel="'.$clientbranchid.'" id="branch_delete_'.$clientbranchid.'" onclick="DeleteformAjax('.$formid.','.$deleteurl.'); return false;">DELETE</a>';
						
							$branchMenu				.=	'<div class="row">
																<div class="col-lg-6"  id="single_branch_'.$clientbranchid.'">	 									
																	<div class="card">
																			<div class="card-body" id="branch_panel_'.$clientbranchid.'">											
																				<div id="form_content_branch_'.$clientbranchid.'">
																				
																					<form id="branch_reg_form_'.$clientbranchid.'">
																					   <input type="hidden" id="" name="txtaccessid" value="'.$accessid.'" class="form-control">
																						<input type="hidden" id="txtcompanyid_'.$clientbranchid.'" name="txtcompanyid" value="'.$companyid.'" class="form-control">
																						<input type="hidden" id="txtclientbranchid_'.$clientbranchid.'" name="txtclientbranchid" value="'.$clientbranchid.'" class="form-control">
																						<input type="hidden" id="operation_branch_'.$clientbranchid.'" name="operation_branch" value="edit_branch" class="form-control">
																						<!--<div class="form-group">
																							<label><b>Address : </b></label>
																							<div class="branch_span_'.$clientbranchid.'">'.$branchaddressfordiv.'</div>
																							<textarea readonly id="txtbranchaddress_'.$clientbranchid.'" name="txtbranchaddress" class="form-control branch_text_'.$clientbranchid.'" rows="3" style="display:none;">'.$branchaddressfortextarea.'</textarea>
																						</div>-->
																					<div class="row">
																						<div class="form-group col-md-6">
																							<label><b>Address Line 1</b></label>
																							<div class="branch_span_'.$clientbranchid.'">'.$branchaddressline1.'</div>
																							<input type="text" id="txtbranchaddressline1_'.$clientbranchid.'" name="txtbranchaddressline1"  value="'.$branchaddressline1.'" class="form-control branch_text_'.$clientbranchid.'" style="display:none;">
																						</div>
																						<div class="form-group col-md-6">
																							<label><b>Address Line 2</b></label>
																							<div class="branch_span_'.$clientbranchid.'">'.$branchaddressline2.'</div>
																							<input type="text" id="txtbranchaddressline2_'.$clientbranchid.'" name="txtbranchaddressline2"  value="'.$branchaddressline2.'" class="form-control branch_text_'.$clientbranchid.'" style="display:none;">
																						</div>
																					</div>
																					
																					<div class="row">
																						<div class="form-group col-md-6">
																							<label><b>City</b></label>
																							<div class="branch_span_'.$clientbranchid.'">'.$branchcity.'</div>
																							<input type="text" id="txtbranchcity_'.$clientbranchid.'" name="txtbranchcity"  value="'.$branchcity.'" class="form-control branch_text_'.$clientbranchid.'" style="display:none;">
																						</div>
																						<div class="form-group col-md-6">
																							<label><b>Pin Code</b></label>
																							<div class="branch_span_'.$clientbranchid.'">'.$branchpincode.'</div>
																							<input type="text" id="txtbranchpincode_'.$clientbranchid.'" name="txtbranchpincode" value="'.$branchpincode.'" class="form-control branch_text_'.$clientbranchid.'" style="display:none;">
																						</div>
																						</div>
																						<div class="row">
																						<div class="form-group col-md-6">
																							<label><b>Country</b></label>
																								<div class="branch_span_'.$clientbranchid.'">'.$branchcountry.'</div>
																			               <select id="txtbranchcountry_'.$clientbranchid.'" name="txtbranchcountry" class="form-control branch_text_'.$clientbranchid.'"  getState(this.value,'.$branch_StateidName.'); style="display:none;">
																													<option value="">Select Country</option>
																								'.getAllCountryListForCombo($branchcountry).'
																								</select>
																							</div>
																							<div class="form-group col-md-6">
																							<label><b>State</b></label>
																								<div class="branch_span_'.$clientbranchid.'">'.$branch_StateidName.'</div>
																			               <select id="txtbranchstate_'.$clientbranchid.'" name="txtbranchstate" class="form-control branch_text_'.$clientbranchid.'" style="display:none;">
																									<option value="" selected>Select State</option>
																									'.getAllStateListForComboEdit($branch_Stateid1).'
																								</select>
																							</div>
																						</div>
																					<div class="row">
																						<div class="form-group col-md-6">
																							<label><b>GST No</b></label>
																							<div class="branch_span_'.$clientbranchid.'">'.$branchgstno.'</div>
																							<input type="text" id="txtbranchgstno_'.$clientbranchid.'" name="txtbranchgstno" value="'.$branchgstno.'" class="form-control branch_text_'.$clientbranchid.'" style="display:none;">
																						</div>
																						</div>
																						</form>'.$editable_grid.'
																				
																				</div>													
																			</div>
																			</div>
																  	</div>
															</div>';
					}
					
					
					
					
			}
			return $branchMenu;
		
	}
	
	//Function used for branch display in panel, 
	function ContactDisplays($companyid='')
	{		
				
			$contactMenu='';
			$contact			=	new ClientContacts();
	
			$contactlist		=	$contact->getClientContacts("","Select * from ".CLIENT_CONTACTS_TABLE." where isdeleted =0 and  clientcompanyid=$companyid");
			//print_r($branchlist);
			if(is_array($contactlist))
			{
					$rowcount			=		count($contactlist);
					for($i=0;$i<$rowcount;$i++)
					{
							$companyid				=		$contactlist[$i]['clientcompanyid'];
							$clientcontactid		=		$contactlist[$i]['clientcontactid'];
							$contact_parson_name =$contactlist[$i]['contact_parson_name1'];
							//$clientcontactid =$contactlist[$i]['clientcontactid'];
							$contact_telno = $contactlist[$i]['contact_telno'];
							$contactfaxno 			= $contactlist[$i]['contactfaxno'];
							$contactmob 		= $contactlist[$i]['contactmob'];
							$contactemail 			= $contactlist[$i]['contactemail'];
							$contactwebaddress 			= $contactlist[$i]['contactwebaddress'];
								//$clientcontactids 			= $contactlist[$i]['clientcontactid'];
						//$branchaddressfordiv			=		$branchaddress."<br> ".$branchcity."<br> ".$branch_StateidName."<br> ".$branchcountry."-".$branchpincode;
						//$branchaddressfortextarea			=		$branchaddress." ".$branchcity." ".$branch_StateidName." ".$branchcountry."-".$branchpincode;
							
							$formid 					= 		"'contact_reg_form_".$clientcontactid."'";
							$sendurl					=		"'contact_submit.php'";
							$deleteurl					=		"'delete_contact.php'";
					//print_r($branchlist);
													$editable_grid = '<a href="#" class="btn btn-space btn-light contact_edit contact_span_'.$clientcontactid.'" rel="'.$clientcontactid.'" id="contact_edit'.$clientcontactid.'" onclick="return false;">EDIT</a>
														<a href="#" class="btn btn-space btn-primary contact_cancel contact_text_'.$clientcontactid.'" rel="'.$clientcontactid.'" id="contact_cancel_'.$clientcontactid.'" onclick="return false;" style="display:none;">CANCEL</a>
														<a href="#" class="btn btn-space btn-secondary contact_save contact_text_'.$clientcontactid.'" rel="'.$clientcontactid.'" id="contact_save_'.$clientcontactid.'" onclick="formAjax('.$formid.','.$sendurl.'); return false;" style="display:none;">SAVE</a>
														<a href="#" class="btn btn-space btn-danger contact_delete contact_text_'.$clientcontactid.'" rel="'.$clientcontactid.'" id="contact_delete_'.$clientcontactid.'" onclick="DeleteformAjax('.$formid.','.$deleteurl.'); return false;">DELETE</a>';
						
							$contactMenu				.=	'<div class="row">
																<div class="col-lg-6"  id="single_contact_'.$clientcontactid.'">	 									
																	<div class="card">
																			<div class="card-body" id="contact_panel_'.$clientcontactid.'">											
																				<div id="form_content_contact_'.$clientcontactid.'">
																				
																					<form id="contact_reg_form_'.$clientcontactid.'">
																					   <input type="hidden" id="" name="txtaccessid" value="'.$accessid.'" class="form-control">
																						<input type="hidden" id="txtcompanyid_'.$clientcontactid.'" name="txtcompanyid" value="'.$companyid.'" class="form-control">
																						<input type="hidden" id="txtclientcontactid_'.$clientcontactid.'" name="txtclientcontactid" value="'.$clientcontactid.'" class="form-control">
																						<input type="hidden" id="operation_contact_'.$clientcontactid.'" name="operation_contact" value="edit_contact" class="form-control">
																						
																						<div class="row">
																						<div class="form-group col-md-12">
																							<label><b> Contact Person Name </b></label>
																							<div class="contact_span_'.$clientcontactid.'">'.$contact_parson_name.'</div>
																							<input type="text" id="txtclientname'.$clientcontactid.'" name="txtclientname"  value="'.$contact_parson_name.'" class="form-control contact_text_'.$clientcontactid.'" style="display:none;">
																						</div>
																						</div>
																					<div class="row">
																						<div class="form-group col-md-6">
																							<label><b> Phone Number </b></label>
																							<div class="contact_span_'.$clientcontactid.'">'.$contact_telno.'</div>
																							<input type="number" id="txthead_TelNo'.$clientcontactid.'" name="txthead_TelNo"  value="'.$contact_telno.'" class="form-control contact_text_'.$clientcontactid.'" style="display:none;">
																						</div>
																						<div class="form-group col-md-6">
																							<label><b>Fax Number</b></label>
																							<div class="contact_span_'.$clientcontactid.'">'.$contactfaxno.'</div>
																							<input type="text" id="txtcontactaddressline2_'.$clientcontactid.'" name="head_FaxNo"  value="'.$contactfaxno.'" class="form-control contact_text_'.$clientcontactid.'" style="display:none;">
																						</div>
																					</div>
																					
																					<div class="row">
																						<div class="form-group col-md-6">
																							<label><b>Mobile Number  <small class="text-muted">(999) 999-9999</small></b></label>
																							<div class="contact_span_'.$clientcontactid.'">'.$contactmob.'</div>
																							<input type="text" id="phone-mask'.$clientcontactid.'" name="head_mobNo"  value="'.$contactmob.'" class="form-control phone-inputmask  contact_text_'.$clientcontactid.'" style="display:none;">
																						</div>
																						<div class="form-group col-md-6">
																							<label><b>Email Address <small class="text-muted">xxx@xxx.xxx</small></b></label>
																							<div class="contact_span_'.$clientcontactid.'">'.$contactemail.'</div>
																							<input type="text" id="optional-mask'.$clientcontactid.'" name="head_Email" value="'.$contactemail.'" class="form-control email-inputmask  contact_text_'.$clientcontactid.'" style="display:none;">
																						</div>
																						</div>
																						
																					<div class="row">
																						<div class="form-group col-md-6">
																							<label><b>Web Address</b></label>
																							<div class="contact_span_'.$clientcontactid.'">'.$contactwebaddress.'</div>
																							<input type="text" id="txtWebsite'.$clientcontactid.'" name="txtWebsite" value="'.$contactwebaddress.'" class="form-control contact_text_'.$clientcontactid.'" style="display:none;">
																						</div>
																						</div>
																						</form>'.$editable_grid.'
																				
																				</div>	</div>	</div>											</div>		
																			
																			
																  
															</div>';
					}
					
					
					
					
			}
			return $contactMenu;
		
	}
	
	//Function used for Client details display in panel
function ClientDetailsDisplay($companyid='')
	{		
			
		
			$clientMenu='';
			$client			=	new Client();
	$sqllist		=	$client->getClient("","","select * from ".CLIENT_TABLE." where clientcompanyid = $companyid ");
	//print_r($sqllist);
			//if(is_array($factorylist))
			//{
					 $rowcount			=		count($sqllist);
				for($i=0;$i<$rowcount;$i++)
	{
		$companyname 								= $sqllist[$i]['companyname'];
 	    $userid											 = $sqllist[$i]['userid'];
		$clientcompanyid							= $sqllist[$i]['clientcompanyid'];
		$Addline1									= $sqllist[$i]['Addline1'];
		$Addline2									= $sqllist[$i]['Addline2'];
		$head_CityName								= $sqllist[$i]['head_CityName'];
		$gstno 		   = $sqllist[$i]['gstno'];
		$panno 	      = $sqllist[$i]['panno'];
		$Tan_No 	      = $sqllist[$i]['Tan_No'];
		$head_TelNo	   = $sqllist[$i]['head_TelNo'];
		$head_mobNo	   = $sqllist[$i]['head_mobNo'];
		$head_FaxNo	   = $sqllist[$i]['head_FaxNo'];
		$head_Email	   = $sqllist[$i]['head_Email'];
	   $PersonName1   = $sqllist[$i]['PersonName1'];
		$gstapplicable = $sqllist[$i]['gstapplicable'];
		$head_Pin      = $sqllist[$i]['head_Pin'];
		$Country  									=$sqllist[$i]['Country'];
		$head_TelNo    = $sqllist[$i]['head_TelNo'];
		$Address	 	   =	$sqllist[$i]['Addline1']."<br>".$sqllist[$i]['Addline2']."<br>".$sqllist[$i]['head_CityName']."<br>".$sqllist[$i]['head_StateidName']."-".$sqllist[$i]['head_Pin']."<br>".$sqllist[$i]['Country'];
		$Addressfortextarea	 	   =	$sqllist[$i]['Addline1']." ".$sqllist[$i]['Addline2']." ".$sqllist[$i]['head_CityName']." ".$sqllist[$i]['head_StateidName']."-".$sqllist[$i]['head_Pin']." ".$sqllist[$i]['Country'];
				
		$status		   = $sqllist[$i]['memberapprovalstatus'];
		 $memberapprovalstatus					= $sqllist[$i]['memberapprovalstatus'];
		      if($memberapprovalstatus == '1')
		      {
					$valselect1      = "selected";
		      }
		      elseif($memberapprovalstatus == '0')
		      {
					$valselect0      = "selected";
		      }
		       if($status == '1') {
		      	$status1 ="Active";
		      }
		       else if($status == '0') {
		      	$status1 ="Inactive";
		      }
		       if($gstapplicable == '1') {
		      	$gstapplicable1 ="GST applicable/ invoice";
		      	$gstvalselect1 = "selected";
		      	
		      }
		       else if($gstapplicable == '0') {
		      	$gstapplicable1 ="GST applicable/  Product";
		      	$gstvalselect0 = "selected";
		      }
		       else if($gstapplicable == '2') {
		      	$gstapplicable1 ="GST Not applicable";
		      	$gstvalselect2 = "selected";
		      }
		      else if($gstapplicable == '3') {
		      	$gstapplicable1 ="GST Not available ";
		      	$gstvalselect3 = "selected";
		      }
		      
		      

	
	 		$head_Stateid1								= $sqllist[$i]['head_Stateid1'];
		  $head_StateidName							= $sqllist[$i]['head_StateidName'];
			$GCountry									= $branchlist[$i]['txtcountry'];
							$formid 					= 		"'client_reg_form_".$clientcompanyid."'";
							$sendurl					=		"'client_details_submit.php'";
							//$deleteurl				=		"'delete_client_details.php'";
							
							

								$editable_grid = '<a href="#" class="btn btn-space btn-light client_edit client_span_'.$clientcompanyid.'" rel="'.$clientcompanyid.'" id="client_edit_'.$clientcompanyid.'" onclick="return false;">EDIT</a>
															<a href="#" class="btn btn-space btn-primary client_cancel client_text_'.$clientcompanyid.'" rel="'.$clientcompanyid.'" id="client_cancel_'.$clientcompanyid.'" onclick="return false;" style="display:none;">CANCEL</a>
															<a href="#" class="btn btn-space btn-secondary client_save client_text_'.$clientcompanyid.'" rel="'.$clientcompanyid.'" id="client_save'.$clientcompanyid.'" onclick="formAjax('.$formid.','.$sendurl.'); return false;" style="display:none;">SAVE</a>';

	
															
				$clientMenu.=	'<div class="row">
				<div class="col-lg-6 client-details" id="single_client_'.$clientcompanyid.'">
									<div class="card">
				<div class="card-body" id="client_panel_'.$clientcompanyid.'">
					<div id="form_content_client_'.$clientcompanyid.'">
							<form id="client_reg_form_'.$clientcompanyid.'">
								<input type="hidden" id="" name="txtaccessid" value="'.$accessid.'" class="form-control">
									<input type="hidden" id="txtcompanyid_'.$clientcompanyid.'" name="txtcompanyid" value="'.$companyid.'" class="form-control">
									<input type="hidden" id="txtmemberid_'.$clientcompanyid.'" name="txtmemberid" value="'.$userid.'" class="form-control">
									<input type="hidden" id="txtclientcompanyid_'.$clientcompanyid.'" name="txtclientcompanyid" value="'.$clientcompanyid.'" class="form-control">
									<input type="hidden" id="operation_client_'.$clientcompanyid.'" name="operation_client" value="edit_client" class="form-control">
				<!--<div class="form-group">
					<label><b>Address : </b></label>
					<div class="client_span_'.$clientcompanyid.'">'.$Address.'</div>
					<textarea readonly id="txtaddress_'.$clientcompanyid.'" name="txtaddress" class="form-control client_text_'.$clientcompanyid.'" rows="3" style="display:none;">'.$Addressfortextarea.'</textarea>
				</div>-->
				<div class="row">
				<div class="form-group col-md-6">
					<label><b>Company Name</b></label>
					<div class="client_span_'.$clientcompanyid.'">'.$companyname.'</div>
					<input type="text" id="txtcompanyname_'.$clientcompanyid.'" name="txtcompanyname"  value="'.$companyname.'" class="form-control client_text_'.$clientcompanyid.'" style="display:none;">
				</div>
				
				</div>
			<div class="row">
				<div class="form-group col-md-6">
					<label><b>Address Line 1</b></label>
					<div class="client_span_'.$clientcompanyid.'">'.$Addline1.'</div>
					<input type="text" id="txtaddressline1_'.$clientcompanyid.'" name="txtaddressline1"  value="'.$Addline1.'" class="form-control client_text_'.$clientcompanyid.'" style="display:none;">
				</div>
				<div class="form-group col-md-6">
					<label><b>Address Line 2</b></label>
					<div class="client_span_'.$clientcompanyid.'">'.$Addline2.'</div>
					<input type="text" id="txtaddressline2_'.$clientcompanyid.'" name="txtaddressline2"  value="'.$Addline2.'" class="form-control client_text_'.$clientcompanyid.'" style="display:none;">
				</div>
			
				</div>
					<div class="row">
				
				<div class="form-group col-md-6">
					<label><b>City</b></label>
					<div class="client_span_'.$clientcompanyid.'">'.$head_CityName.'</div>
					<input type="text" id="txthead_CityName1_'.$clientcompanyid.'" name="txthead_CityName1"  value="'.$head_CityName.'" class="form-control client_text_'.$clientcompanyid.'" style="display:none;">
				</div>
				<div class="form-group col-md-6">
					<label><b>Pin Code</b></label>
					<div class="client_span_'.$clientcompanyid.'">'.$head_Pin.'</div>
					<input type="text" id="txtpincode1_'.$clientcompanyid.'" name="txtpincode1" value="'.$head_Pin.'" class="form-control client_text_'.$clientcompanyid.'" style="display:none;">
				</div>
				</div>
					<div class="row">
						<div class="form-group col-md-6">
				<label><b>Country</b></label>
					<div class="client_span_'.$clientcompanyid.'">'.$Country.'</div>
               <select id="txtcountry_'.$clientcompanyid.'" name="txtcountry" class="form-control client_text_'.$clientcompanyid.'"  getState(this.value,'.$head_StateidName.'); style="display:none;">
						<option value="">Select Country</option>
	'.getAllCountryListForCombo($Country).'
	</select>
				</div>
				<div class="form-group col-md-6">
				<label><b>State</b></label>
					<div class="client_span_'.$clientcompanyid.'">'.$head_StateidName.'</div>
               <select id="txtstate_'.$clientcompanyid.'" name="txtstate" class="form-control client_text_'.$clientcompanyid.'"  style="display:none;">
						<option value="" >Select State</option>
						'.getAllStateListForComboEdit($head_Stateid1).'
					</select>
				</div>
				</div>
				
				<div class="row">
			<div class="form-group col-md-6">
					<label><b>Contact Person Name</b></label>
					<div class="client_span_'.$clientcompanyid.'">'.$PersonName1.'</div>
					<input type="text" id="txtclientname_'.$clientcompanyid.'" name="txtclientname"  value="'.$PersonName1.'" class="form-control client_text_'.$clientcompanyid.'" style="display:none;">
				</div>
				<div class="form-group col-md-6">
					<label><b>Phone Number</b></label>
					<div class="client_span_'.$clientcompanyid.'">'.$head_TelNo.'</div>
					<input type="text" id="txthead_TelNo_'.$clientcompanyid.'" name="txthead_TelNo"  value="'.$head_TelNo.'" class="form-control client_text_'.$clientcompanyid.'" style="display:none;">
				</div>
				</div>
				<div class="row">
			<div class="form-group col-md-6">
					<label><b>Mobile Number </b></label>
					<div class="client_span_'.$clientcompanyid.'">'.$head_mobNo.'</div>
					<input type="text" id="head_mobNo_'.$clientcompanyid.'" name="head_mobNo"  value="'.$head_mobNo.'" class="form-control client_text_'.$clientcompanyid.'" style="display:none;">
				</div>
				<div class="form-group col-md-6">
					<label><b>Email Address</b></label>
					<div class="client_span_'.$clientcompanyid.'">'.$head_Email.'</div>
					<input type="email" id="head_Email_'.$clientcompanyid.'" name="head_Email"  value="'.$head_Email.'" class="form-control client_text_'.$clientcompanyid.'" style="display:none;">
				</div>
				</div>
				
					<div class="row">
			<div class="form-group col-md-6">
					<label><b>Active/Inactive State</b></label>
					<div class="client_span_'.$clientcompanyid.'">'.$status1.'</div>
					<select  id="input-select" name="txtstatus" class="form-control client_text_'.$clientcompanyid.'"  style="display:none;">
							<option value="1"'.$valselect1.'>Active</option>
							<option value="0"'.$valselect0.'>Inactive</option>
						
							</select>
				</div>
				<div class="form-group col-md-6">
					<label><b>GST applicatble</b></label>
					<div class="client_span_'.$clientcompanyid.'">'.$gstapplicable1.'</div>
					<select  id="input-select" name="txtgstapplicable" class="form-control client_text_'.$clientcompanyid.'"  style="display:none;">
							<option value="0" '.$gstvalselect0.'>GST applicable/ Product</option>
							<option value="1" '.$gstvalselect1.' >GST applicatble/invoice</option>
							<option value="2" '.$gstvalselect2.'>GST Not applicatble</option>
							<option value="3" '.$gstvalselect3.'>GST Not available</option>

							</select>
				</div>
				</div>
				
				<div class="row">
			<div class="form-group col-md-6">
					<label><b>GST No</b></label>
					<div class="client_span_'.$clientcompanyid.'">'.$gstno.'</div>
					<input type="text" id="txtgstno1_'.$clientcompanyid.'" name="txtgstno1"  value="'.$gstno.'" class="form-control client_text_'.$clientcompanyid.'" onchange="Validatecompanygst(this.value,'.$clientcompanyid.');" style="display:none;">
				</div>
				<div class="form-group col-md-6">
					<label><b>Company PAN NO.</b></label>
					<div class="client_span_'.$clientcompanyid.'">'.$panno.'</div>
					<input type="text" id="txtpanno_'.$clientcompanyid.'" name="txtpanno"  value="'.$panno.'" class="form-control client_text_'.$clientcompanyid.'" onchange="ValidatePAN()" style="display:none;">
				</div>
				</div>
				
				<div class="row">
			<div class="form-group col-md-6">
					<label><b>Company TAN NO.</b></label>
					<div class="client_span_'.$clientcompanyid.'">'.$Tan_No.'</div>
					<input type="text" id="txttanno_'.$clientcompanyid.'" name="txttanno"  value="'.$Tan_No.'" class="form-control client_text_'.$clientcompanyid.'" style="display:none;">
				</div>	
					</div>			
						
													
									</form>'.$editable_grid.'
									</div>
										</div>
										</div>
										</div>
										</div>';																
		}
					
					
					return $clientMenu;
					
			//}
}

//Function used for Company details display in panel
function CompanyDetailsDisplay($companyid='')
	{		
			
		
	$companyMenu='';
	$company			=	new Company();
	$sql		= "select a.companyid,a.companyname,a.gstno,a.panno,a.HSN_code,a.Tan_No,a.upload_logo,a.isDeleted,a.gstapplicable,a.comp_contact_personname,a.head_Email as head_Email,a.head_TelNo as head_TelNo,
	 				a.Addline1 as Addline1,a.Addline2 as Addline2,a.head_CityName as head_CityName,a.head_StateidName,a.head_Pin as head_Pin,a.Country as Country,a.head_mobNo,a.Website,a.Bankname,a.BankAC,
	 				a.Branch,a.IFSC_Code,c.userid,c.name,c.userfirstname,c.userlastname,c.head_Email as userhead_Email,c.username,c.userpassword,
	 				c.mobileforsms,c.head_TelNo as userhead_TelNo,c.Addline1 as userAddline1,c.Addline2 as userAddline2,c.head_CityName as userhead_CityName,
	 				c.head_Pin as userhead_Pin,a.head_Stateid1,c.head_StateName,c.Country as userCountry
				  from ".COMPANY_TABLE." a
	  			  inner join ".USERCOMPANYDETAILS_TABLE." b on a.companyid = b.companyid
	  			  inner join ".USER_TABLE." c on b.userid = c.userid
	  			  where a.companyid = $companyid  group by a.companyid";	
	$sqllist	=$company->getCompany("","",$sql);
	//print_r($sqllist);
			//if(is_array($factorylist))
			//{
					 $rowcount			=		count($sqllist);
				for($i=0;$i<$rowcount;$i++)
	{
		$companyname 	= $sqllist[$i]['companyname'];
 	   $userid			= $sqllist[$i]['userid'];
		$companyid		= $sqllist[$i]['companyid'];
		$Addline1		= $sqllist[$i]['Addline1'];
		$Addline2		= $sqllist[$i]['Addline2'];
		$head_CityName	= $sqllist[$i]['head_CityName'];
		$gstno 		   = $sqllist[$i]['gstno'];
		$panno 	      = $sqllist[$i]['panno'];
		$Tan_No 	      = $sqllist[$i]['Tan_No'];
		$HSN_code 	   = $sqllist[$i]['HSN_code'];
		$head_TelNo	   = $sqllist[$i]['head_TelNo'];
		$head_mobNo	   = $sqllist[$i]['head_mobNo'];
		$head_FaxNo	   = $sqllist[$i]['head_FaxNo'];
		$head_Email	   = $sqllist[$i]['head_Email'];
	   $PersonName1   = $sqllist[$i]['comp_contact_personname'];
		$gstapplicable = $sqllist[$i]['gstapplicable'];
		$head_Pin      = $sqllist[$i]['head_Pin'];
	   $Country  		= $sqllist[$i]['Country'];
		$head_TelNo    = $sqllist[$i]['head_TelNo'];

		$BankName = $sqllist[$i]['Bankname'];
		$Bank_ACno      = $sqllist[$i]['BankAC'];
	   $Branch  		= $sqllist[$i]['Branch'];
		$IFSC_Code    = $sqllist[$i]['IFSC_Code'];

		$Address	 	   =	$sqllist[$i]['Addline1']."<br>".$sqllist[$i]['Addline2']."<br>".$sqllist[$i]['head_CityName']."<br>".$sqllist[$i]['head_StateidName'].'-'.$sqllist[$i]['head_Pin']."<br>".$sqllist[$i]['Country'];
		$status		   = $sqllist[$i]['isDeleted'];
		 $Deleted					= $sqllist[$i]['isDeleted'];
		      if($Deleted == '0')
		      {
					$valselect1      = "selected";
					$status1 ="Active";
		      }
		      elseif($Deleted == '1')
		      {
					$valselect0      = "selected";
						$status1 ="Inactive";
		      }
		      /* if($status == '1') {
		      	$status1 ="Active";
		      }
		       else if($status == '0') {
		      	$status1 ="Inactive";
		      }*/
		       if($gstapplicable == '1') {
		      	$gstapplicable1 ="GST applicable/ invoice";
		      }
		       else if($gstapplicable == '0') {
		      	$gstapplicable1 ="GST applicable/  Product";
		      }
		      
		   $head_Stateid1								= $sqllist[$i]['head_Stateid1'];
		   $head_StateidName							= $sqllist[$i]['head_StateidName'];
			
			$selected_country 						= getAllCountryListForCombo($Country); 
	//		$selected_state  							=	getAllStateListForComboEdit($head_Stateid1);
			$upload_logo								= GALLERY_PHOTO_THUMB_PATH.$sqllist[$i]['upload_logo'];
			$upload_header								= GALLERY_PHOTO_THUMB_PATH.$sqllist[$i]['upload_header'];
			$upload_logo1								= $sqllist[$i]['upload_logo'];
			$upload_header1							= $sqllist[$i]['upload_header'];
			$variable_tocallfunction 				= getState($Country,$head_Stateid1);
	 		
							$formid 					= 		"'company_reg_form_".$companyid."'";
							$sendurl					=		"'company_details_submit.php'";
							//$deleteurl				=		"'delete_company_details.php'";
							
							

								$editable_grid = '<a href="#" class="btn btn-space btn-light company_edit company_span_'.$companyid.'" rel="'.$companyid.'" id="company_edit_'.$companyid.'" onclick="return false;">EDIT</a>
															<a href="#" class="btn btn-space btn-primary company_cancel company_text_'.$companyid.'" rel="'.$companyid.'" id="company_cancel_'.$companyid.'" onclick="return false;" style="display:none;">CANCEL</a>
															<a href="#" class="btn btn-space btn-secondary company_save company_text_'.$companyid.'" rel="'.$companyid.'" id="company_save_'.$companyid.'" onclick="formAjax('.$formid.','.$sendurl.'); return false;" style="display:none;">SAVE</a>


															';

	  if ($upload_logo1=="")
	  {
	  	 	$upload_logo_var = '<a href="#" id="fileToUpload" name="fileToUpload" class="form-control company_text_'.$companyid.'" style="display:none;">Upload Logo</a>';
	  }
	  else if ($upload_logo1 !="")
	  {
	  		$upload_logo_var = '<a href="#" id="fileToUpload" name="fileToUpload" class="form-control company_text_'.$companyid.'" style="display:none;">Change Logo</a>';
	   }
	   
	  if ($upload_header1=="")
	  {
	  	 	$upload_header_var = '<a href="#" id="fileToUpload1" name="fileToUpload1" class="form-control company_text_'.$companyid.'" style="display:none;">Upload Header</a>';
	  }
	  else if ($upload_header1 !="")
	  {
	  		$upload_header_var = '<a href="#" id="fileToUpload1" name="fileToUpload1" class="form-control company_text_'.$companyid.'" style="display:none;">Change Header</a> <br> 
	  									 <a href="#" id="CancelUploadedHeader" name="CancelUploadedHeader" class="form-control company_text_'.$companyid.'" style="display:none;">Remove Header</a>';
	  }
		// &nbsp;&nbsp;&nbsp;<a href="#" id="CancelUploadedImage" name="CancelUploadedImage">Remove Logo</a>
	  
															
				$companyMenu.=	'<form id="company_reg_form_'.$companyid.'">
				<div class="row">
				<div class="col-lg-6 company-details" id="single_company_'.$companyid.'">
									<div class="card">
				<div class="card-body" id="company_panel_'.$companyid.'">
					<div id="form_content_company_'.$companyid.'">
						
								<input type="hidden" id="" name="txtaccessid" value="'.$accessid.'" class="form-control">
									<input type="hidden" id="txtcompanyid_'.$companyid.'" name="txtcompanyid" value="'.$companyid.'" class="form-control">
									<input type="hidden" id="txtuserid_'.$companyid.'" name="txtuserid" value="'.$userid.'" class="form-control">
									<input type="hidden" id="txtcompanyid_'.$companyid.'" name="txtcompanyid" value="'.$companyid.'" class="form-control">
									<input type="hidden" id="operation_company_'.$companyid.'" name="operation_company" value="edit_company" class="form-control">
			<!-- <div class="form-group">
					<label><b>Address : </b></label>
					<div class="company_span_'.$companyid.'">'.$Address.'</div>
					<textarea readonly id="txtaddress_'.$companyid.'" name="txtaddress" class="form-control company_text_'.$companyid.'" rows="3" style="display:none;">'.$Address.'</textarea>
				</div>  -->
				<div class="row">
				<div class="form-group col-md-6">
					<label><b>Company Name</b></label>
					<div class="company_span_'.$companyid.'">'.$companyname.'</div>
					<input type="text" id="txtcompanyname_'.$companyid.'" name="txtcompanyname"  value="'.$companyname.'" class="form-control company_text_'.$companyid.'" style="display:none;">
				</div>
				
				</div>
			<div class="row">
				<div class="form-group col-md-6">
					<label><b>Address Line 1</b></label>
					<div class="company_span_'.$companyid.'">'.$Addline1.'</div>
					<input type="text" id="txtaddressline1_'.$companyid.'" name="txtaddressline1"  value="'.$Addline1.'" class="form-control company_text_'.$companyid.'" style="display:none;">
				</div>
				<div class="form-group col-md-6">
					<label><b>Address Line 2</b></label>
					<div class="company_span_'.$companyid.'">'.$Addline2.'</div>
					<input type="text" id="txtaddressline2_'.$companyid.'" name="txtaddressline2"  value="'.$Addline2.'" class="form-control company_text_'.$companyid.'" style="display:none;">
				</div>
			
				</div>
					<div class="row">
				
				<div class="form-group col-md-6">
					<label><b>City</b></label>
					<div class="company_span_'.$companyid.'">'.$head_CityName.'</div>
					<input type="text" id="txthead_CityName1_'.$companyid.'" name="txthead_CityName1"  value="'.$head_CityName.'" class="form-control company_text_'.$companyid.'" style="display:none;">
				</div>
				<div class="form-group col-md-6">
					<label><b>Pin Code</b></label>
					<div class="company_span_'.$companyid.'">'.$head_Pin.'</div>
					<input type="text" id="txtpincode1_'.$companyid.'" name="txtpincode1" value="'.$head_Pin.'" class="form-control company_text_'.$companyid.'" style="display:none;">
				</div>
				</div>
					<div class="row">
						<div class="form-group col-md-6">
				<label><b>Country</b></label>
					<div class="company_span_'.$companyid.'">'.$Country.'</div>
               <select id="txtcountry" name="txtcountry" class="form-control company_text_'.$companyid.'"  onChange="getState(this.value,'.$head_Stateid1.')" style="display:none;">
						<option value="">Select Country</option>
	'.$selected_country.'
	</select>
				</div>
				<div class="form-group col-md-6">
				<label><b>State</b></label>
					<div class="company_span_'.$companyid.'">'.$head_StateidName.'</div>
               <select id="txtstate" name="txtstate" class="form-control company_text_'.$companyid.'"  style="display:none;">
						<option value="" >Select State</option>
						'.$variable_tocallfunction.'
					</select>
				</div>
				</div>
									</div>
										</div>
										</div>
										</div>
										<div class="col-lg-6 company-details" id="single_company_'.$companyid.'">
									<div class="card">
				<div class="card-body" id="company_panel_'.$companyid.'">
					<div id="form_content_company_'.$companyid.'">
					
					<div class="row">
			<div class="form-group col-md-12">
					<label><b>Upload LOGO</b></label>
					<div class="company_span_'.$companyid.'" id="imgupload_logo_div"><img src='.$upload_logo.' class="company_span_'.$companyid.'"></div>
					<div id="uploadedimage" class="uploadedimage">
        
		</div>
		<input type="hidden" name="galleryimagename" id="galleryimagename" value="'.$upload_logo1.'" class="form-control company_text_'.$companyid.'" style="display:none;"/>
		<img src='.$upload_logo.' id="imgupload_logo"  class="form-control company_text_'.$companyid.'" style="display:none;">
			<!--  <a href="#" id="fileToUpload" name="fileToUpload" >Upload Logo</a>  -->
			'.$upload_logo_var.'
				</div>
				</div>
				<div class="row">
				<div class="form-group col-md-12">
					<label><b>Upload Header For Invoice</b></label>
					<div class="company_span_'.$companyid.'" id="imgupload_header_div">
							<img src='.$upload_header.' class="company_span_'.$companyid.'">
					</div>
					<div id="uploadedimageforheader" class="uploadedimageforheader" >
					</div>
		<input type="hidden" name="galleryimagenameforheader" id="galleryimagenameforheader" value="'.$upload_header1.'"  class="form-control company_text_'.$companyid.'" style="display:none;">
		<img src='.$upload_header.' id="imgupload_header" class="form-control company_text_'.$companyid.'" style="display:none;">
<!--	  	<a href="#" id="fileToUpload1" name="fileToUpload1">Upload Photo</a>  -->
				'.$upload_header_var.'	
				</div>
				
				</div>
				
				</div></div></div></div></div>
				
				<div class="row">
				<div class="col-lg-6 company-details" id="single_company_'.$companyid.'">
				<div class="card">
				<div class="card-body" id="company_panel_'.$companyid.'">
					<div id="form_content_company_'.$companyid.'">
					
				<div class="row">
			<div class="form-group col-md-6">
					<label><b>Contact Person Name</b></label>
					<div class="company_span_'.$companyid.'">'.$PersonName1.'</div>
					<input type="text" id="txtclientname_'.$companyid.'" name="txtclientname"  value="'.$PersonName1.'" class="form-control company_text_'.$companyid.'" style="display:none;">
				</div>
				<div class="form-group col-md-6">
					<label><b>Phone Number</b></label>
					<div class="company_span_'.$companyid.'">'.$head_TelNo.'</div>
					<input type="text" id="txthead_TelNo_'.$companyid.'" name="txthead_TelNo"  value="'.$head_TelNo.'" class="form-control company_text_'.$companyid.'" style="display:none;">
				</div>
				</div>
				<div class="row">
			<div class="form-group col-md-6">
					<label><b>Mobile Number </b></label>
					<div class="company_span_'.$companyid.'">'.$head_mobNo.'</div>
					<input type="text" id="head_mobNo_'.$companyid.'" name="head_mobNo"  value="'.$head_mobNo.'" class="form-control company_text_'.$companyid.'" style="display:none;">
				</div>
				<div class="form-group col-md-6">
					<label><b>Email Address</b></label>
					<div class="company_span_'.$companyid.'">'.$head_Email.'</div>
					<input type="text" id="head_Email_'.$companyid.'" name="head_Email"  value="'.$head_Email.'" class="form-control company_text_'.$companyid.'" style="display:none;">
				</div>
				</div>
				
				</div>
				</div>
				</div>
				</div>


				

				
				
				
				<div class="col-lg-6 company-details" id="single_company_'.$companyid.'">
				<div class="card">
				<div class="card-body" id="company_panel_'.$companyid.'">
					<div id="form_content_company_'.$companyid.'">
						<div class="row">
			<div class="form-group col-md-6">
					<label><b>Active/Inactive State</b></label>
					<div class="company_span_'.$companyid.'">'.$status1.'</div>
					<select  id="input-select" name="txtstatus" class="form-control company_text_'.$companyid.'"  style="display:none;">
							<option value="1"'.$valselect1.'>Active</option>
							<option value="0"'.$valselect0.'>Inactive</option>
						
							</select>
				</div>
				<div class="form-group col-md-6">
					<label><b>GST applicatble</b></label>
					<div class="company_span_'.$companyid.'">'.$gstapplicable1.'</div>
					<select  id="input-select" name="txtgstapplicable" class="form-control company_text_'.$companyid.'"  style="display:none;">
							<option value="0">GST applicable/ Product</option>
							<option value="1">GST applicatble/invoice</option>
						
							</select>
				</div>
				</div>
				
				<div class="row">
			<div class="form-group col-md-6">
					<label><b>GST No</b></label>
					<div class="company_span_'.$companyid.'">'.$gstno.'</div>
					<input type="text" id="txtgstno1_'.$companyid.'" name="txtgstno1"  value="'.$gstno.'" class="form-control company_text_'.$companyid.'" onchange="Validatecompanygst(this.value,'.$companyid.');" style="display:none;">
				</div>
				<div class="form-group col-md-6">
					<label><b>Company PAN NO.</b></label>
					<div class="company_span_'.$companyid.'">'.$panno.'</div>
					<input type="text" id="txtpanno_'.$companyid.'" name="txtpanno"  value="'.$panno.'" class="form-control company_text_'.$companyid.'"  style="display:none;">
				</div>
				</div>
				
				<div class="row">
			<div class="form-group col-md-6">
					<label><b>Company TAN NO.</b></label>
					<div class="company_span_'.$companyid.'">'.$Tan_No.'</div>
					<input type="text" id="txttanno_'.$companyid.'" name="txttanno"  value="'.$Tan_No.'" class="form-control company_text_'.$companyid.'" style="display:none;">
				</div>	
				<div class="form-group col-md-6">
					    <label><b> Company HSN code / Service Code .</b></label>
					    <div class="company_span_'.$companyid.'">'.$HSN_code.'</div>
					    <input type="text" id="txtHSN_code_'.$companyid.'" name="txtHSN_code"  value="'.$HSN_code.'" class="form-control company_text_'.$companyid.'" style="display:none;">
				    </div>	
					</div>
				</div>
				</div>
				</div>


				
				<div class="card">
				<h5 class="card-header"> Bank Details</h5>
				<div class="card-body" id="company_panel_'.$companyid.'">
					<div id="form_content_company_'.$companyid.'">
					
				<div class="row">
			<div class="form-group col-md-6">
					<label><b>Bank Name</b></label>
					<div class="company_span_'.$companyid.'">'.$BankName.'</div>
					<input type="text" id="txtbankname1'.$companyid.'" name="txtbankname1"  value="'.$BankName.'" class="form-control company_text_'.$companyid.'" style="display:none;">
					
				</div>
				
				
				
			
				<div class="form-group col-md-6">
					<label><b>Bank A/C No.</b></label>
					<div class="company_span_'.$companyid.'">'.$Bank_ACno.'</div>
					<input type="text" id="txtacno'.$companyid.'" name="txtacno"  value="'.$Bank_ACno.'" class="form-control company_text_'.$companyid.'" style="display:none;">
				</div>
				</div>
				<div class="row">
			<div class="form-group col-md-6">
					<label><b>Branch</b></label>
					<div class="company_span_'.$companyid.'">'.$Branch.'</div>
					<input type="text" id="txtbranch'.$companyid.'" name="txtbranch"  value="'.$Branch.'" class="form-control company_text_'.$companyid.'" style="display:none;">
				</div>
				<div class="form-group col-md-6">
					<label><b>IFSC Code</b></label>
					<div class="company_span_'.$companyid.'">'.$IFSC_Code.'</div>
					<input type="text" id="txtIFSC'.$companyid.'" name="txtIFSC"  value="'.$IFSC_Code.'" class="form-control company_text_'.$companyid.'" style="display:none;">
				</div>
				</div>
				
				
				</div>
				</div>	
					</div>
				</div>
				</div>				
				
				</form>'.$editable_grid.'';																	
		}
					
					
					return $companyMenu;
					
			//}
}



function ManageUserCompanyDetailsDisplayss($companyid='')
	{		
			
		
			$companyMenu1='';
			$company			=	new Company();
		
	$sqllists	=$company->getCompany("","","select * from user_company where membercompanyid = $companyid");
	//print_r($sqllist);
			//if(is_array($factorylist))
			//{
					 $rowcount			=		count($sqllists);
				for($i=0;$i<$rowcount;$i++)
	{
		$companyname 								= $sqllists[$i]['companyname'];
 	    $memberid									= $sqllists[$i]['memberid'];
		$membercompanyid1							= $sqllists[$i]['membercompanyid'];
		$Addline1									= $sqllists[$i]['Addline1'];
		$Addline2									= $sqllists[$i]['Addline2'];
		$head_CityName								= $sqllists[$i]['head_CityName'];
		$gstno 		   = $sqllists[$i]['gstno'];
		$panno 	      = $sqllists[$i]['panno'];
		$Tan_No 	      = $sqllists[$i]['Tan_No'];
		$head_TelNo	   = $sqllists[$i]['head_TelNo'];
		$head_mobNo	   = $sqllists[$i]['head_mobNo'];
		$head_FaxNo	   = $sqllists[$i]['head_FaxNo'];
		$head_Email	   = $sqllists[$i]['head_Email'];
	   $PersonName1   = $sqllists[$i]['comp_contact_personname'];
		$gstapplicable = $sqllists[$i]['gstapplicable'];
		$head_Pin      = $sqllists[$i]['head_Pin'];
	   $Country  		= $sqllists[$i]['Country'];
		$head_TelNo    = $sqllists[$i]['head_TelNo'];

		$BankName = $sqllists[$i]['Bankname'];
		$Bank_ACno      = $sqllists[$i]['BankAC'];
	   $Branch  		= $sqllists[$i]['Branch'];
		$IFSC_Code    = $sqllists[$i]['IFSC_Code'];

		$Address	 	   =	$sqllists[$i]['Addline1']."<br>".$sqllists[$i]['Addline2']."<br>".$sqllists[$i]['head_CityName']."<br>".$sqllists[$i]['head_StateidName'].'-'.$sqllists[$i]['head_Pin']."<br>".$sqllists[$i]['Country'];
		$status		   = $sqllists[$i]['memberapprovalstatus'];
		 $memberapprovalstatus					= $sqllists[$i]['memberapprovalstatus'];
		      if($memberapprovalstatus == '1')
		      {
					$valselect1      = "selected";
		      }
		      elseif($memberapprovalstatus == '0')
		      {
					$valselect0      = "selected";
		      }
		       if($status == '1') {
		      	$status1 ="Active";
		      }
		       else if($status == '0') {
		      	$status1 ="Inactive";
		      }
		       if($gstapplicable == '1') {
		      	$gstapplicable1 ="GST applicable/ invoice";
		      }
		       else if($gstapplicable == '0') {
		      	$gstapplicable1 ="GST applicable/  Product";
		      }
		      
		   $head_Stateid1								= $sqllists[$i]['head_Stateid1'];
		   $head_StateidName							= $sqllists[$i]['head_StateidName'];
			
			$selected_country 						= getAllCountryListForCombo($Country); 
	//		$selected_state  							=	getAllStateListForComboEdit($head_Stateid1);
			$upload_logo								= GALLERY_PHOTO_THUMB_PATH.$sqllists[$i]['upload_logo'];
			$upload_header								= GALLERY_PHOTO_THUMB_PATH.$sqllists[$i]['upload_header'];
			$upload_logo1								= $sqllists[$i]['upload_logo'];
			$upload_header1							= $sqllists[$i]['upload_header'];
			$variable_tocallfunction 				= getState($Country,$head_Stateid1);
	 		
							$formid1 					= 		"'company_reg_form1_".$membercompanyid1."'";
							$sendurl1					=		"'company_details_submit.php'";
							//$deleteurl				=		"'delete_company_details.php'";
							
							

								$editable_grid1 = '<a href="#" class="btn btn-space btn-light company_edit1 company_span1_'.$membercompanyid1.'" rel="'.$membercompanyid1.'" id="company_edit1_'.$membercompanyid1.'" onclick="return false;">EDITs</a>
															<a href="#" class="btn btn-space btn-primary company_cancel1 company_text1_'.$membercompanyid1.'" rel="'.$membercompanyid1.'" id="company_cancel1_'.$membercompanyid1.'" onclick="return false;" style="display:none;">CANCEL</a>
															<a href="#" class="btn btn-space btn-secondary company_save1 company_text1_'.$membercompanyid1.'" rel="'.$membercompanyid1.'" id="company_save1'.$membercompanyid1.'" onclick="formAjax('.$formid1.','.$sendurl1.'); return false;" style="display:none;">SAVE</a>
															';

	  if ($upload_logo1=="")
	  {
	  	 	$upload_logo_var = '<a href="#" id="fileToUpload" name="fileToUpload" class="form-control company_text1_'.$membercompanyid1.'" style="display:none;">Upload Logo</a>';
	  }
	  else if ($upload_logo1 !="")
	  {
	  		$upload_logo_var = '<a href="#" id="fileToUpload" name="fileToUpload" class="form-control company_text1_'.$membercompanyid1.'" style="display:none;">Change Logo</a>';
	   }
	   
	  if ($upload_header1=="")
	  {
	  	 	$upload_header_var = '<a href="#" id="fileToUpload1" name="fileToUpload1" class="form-control company_text1_'.$membercompanyid1.'" style="display:none;">Upload Header</a>';
	  }
	  else if ($upload_header1 !="")
	  {
	  		$upload_header_var = '<a href="#" id="fileToUpload1" name="fileToUpload1" class="form-control company_text1_'.$membercompanyid1.'" style="display:none;">Change Header</a> <br> 
	  									 <a href="#" id="CancelUploadedHeader" name="CancelUploadedHeader" class="form-control company_text1_'.$membercompanyid1.'" style="display:none;">Remove Header</a>';
	  }
		// &nbsp;&nbsp;&nbsp;<a href="#" id="CancelUploadedImage" name="CancelUploadedImage">Remove Logo</a>
	  
															
				$companyMenu1.=	'<form id="company_reg_form1_'.$membercompanyid1.'">
				<div class="row">
				<div class="col-lg-6 company-details1" id="single_companys_'.$membercompanyid1.'">
									<div class="card">
				<div class="card-body" id="company_panel1_'.$membercompanyid1.'">
					<div id="form_content_company1_'.$membercompanyid1.'">
						
								<input type="hidden" id="" name="txtaccessid" value="'.$accessid.'" class="form-control">
									<input type="hidden" id="txtcompanyid_'.$membercompanyid1.'" name="txtcompanyid" value="'.$companyid.'" class="form-control">
									<input type="hidden" id="txtmemberid_'.$membercompanyid1.'" name="txtmemberid" value="'.$memberid.'" class="form-control">
									<input type="hidden" id="txtmembercompanyid1_'.$membercompanyid1.'" name="txtmembercompanyid1" value="'.$membercompanyid1.'" class="form-control">
									<input type="hidden" id="operation_company_'.$membercompanyid1.'" name="operation_company" value="edit_company" class="form-control">
			<!-- <div class="form-group">
					<label><b>Address : </b></label>
					<div class="company_span1_'.$membercompanyid1.'">'.$Address.'</div>
					<textarea readonly id="txtaddress_'.$membercompanyid1.'" name="txtaddress" class="form-control company_text1_'.$membercompanyid1.'" rows="3" style="display:none;">'.$Address.'</textarea>
				</div>  -->
				<div class="row">
				<div class="form-group col-md-6">
					<label><b>Company Name</b></label>
					<div class="company_span1_'.$membercompanyid1.'">'.$companyname.'</div>
					<input type="text" id="txtcompanyname_'.$membercompanyid1.'" name="txtcompanyname"  value="'.$companyname.'" class="form-control company_text1_'.$membercompanyid1.'" style="display:none;">
				</div>
				
				</div>
			<div class="row">
				<div class="form-group col-md-6">
					<label><b>Address Line 1</b></label>
					<div class="company_span1_'.$membercompanyid1.'">'.$Addline1.'</div>
					<input type="text" id="txtaddressline1_'.$membercompanyid1.'" name="txtaddressline1"  value="'.$Addline1.'" class="form-control company_text1_'.$membercompanyid1.'" style="display:none;">
				</div>
				<div class="form-group col-md-6">
					<label><b>Address Line 2</b></label>
					<div class="company_span1_'.$membercompanyid1.'">'.$Addline2.'</div>
					<input type="text" id="txtaddressline2_'.$membercompanyid1.'" name="txtaddressline2"  value="'.$Addline2.'" class="form-control company_text1_'.$membercompanyid1.'" style="display:none;">
				</div>
			
				</div>
					<div class="row">
				
				<div class="form-group col-md-6">
					<label><b>City</b></label>
					<div class="company_span1_'.$membercompanyid1.'">'.$head_CityName.'</div>
					<input type="text" id="txthead_CityName1_'.$membercompanyid1.'" name="txthead_CityName1"  value="'.$head_CityName.'" class="form-control company_text1_'.$membercompanyid1.'" style="display:none;">
				</div>
				<div class="form-group col-md-6">
					<label><b>Pin Code</b></label>
					<div class="company_span1_'.$membercompanyid1.'">'.$head_Pin.'</div>
					<input type="text" id="txtpincode1_'.$membercompanyid1.'" name="txtpincode1" value="'.$head_Pin.'" class="form-control company_text1_'.$membercompanyid1.'" style="display:none;">
				</div>
				</div>
					<div class="row">
						<div class="form-group col-md-6">
				<label><b>Country</b></label>
					<div class="company_span1_'.$membercompanyid1.'">'.$Country.'</div>
               <select id="txtcountry" name="txtcountry" class="form-control company_text1_'.$membercompanyid1.'"  onChange="getState(this.value,'.$head_Stateid1.')" style="display:none;">
						<option value="">Select Country</option>
	'.$selected_country.'
	</select>
				</div>
				<div class="form-group col-md-6">
				<label><b>State</b></label>
					<div class="company_span1_'.$membercompanyid1.'">'.$head_StateidName.'</div>
               <select id="txtstate" name="txtstate" class="form-control company_text1_'.$membercompanyid1.'"  style="display:none;">
						<option value="" >Select State</option>
						'.$variable_tocallfunction.'
					</select>
				</div>
				</div>
									</div>
										</div>
										</div>
										</div>
										<div class="col-lg-6 company-details1" id="single_companys_'.$membercompanyid1.'">
									<div class="card">
				<div class="card-body" id="company_panel1_'.$membercompanyid1.'">
					<div id="form_content_company1_'.$membercompanyid1.'">
					
					<div class="row">
			<div class="form-group col-md-12">
					<label><b>Upload LOGO</b></label>
					<div class="company_span1_'.$membercompanyid1.'" id="imgupload_logo_div"><img src='.$upload_logo.' class="company_span1_'.$membercompanyid1.'"></div>
					<div id="uploadedimage" class="uploadedimage">
        
		</div>
		<input type="hidden" name="galleryimagename" id="galleryimagename" value="'.$upload_logo1.'" class="form-control company_text1_'.$membercompanyid1.'" style="display:none;"/>
		<img src='.$upload_logo.' id="imgupload_logo"  class="form-control company_text1_'.$membercompanyid1.'" style="display:none;">
			<!--  <a href="#" id="fileToUpload" name="fileToUpload" >Upload Logo</a>  -->
			'.$upload_logo_var.'
				</div>
				</div>
				<div class="row">
				<div class="form-group col-md-12">
					<label><b>Upload Header For Invoice</b></label>
					<div class="company_span1_'.$membercompanyid1.'" id="imgupload_header_div">
							<img src='.$upload_header.' class="company_span1_'.$membercompanyid1.'">
					</div>
					<div id="uploadedimageforheader" class="uploadedimageforheader" >
					</div>
		<input type="hidden" name="galleryimagenameforheader" id="galleryimagenameforheader" value="'.$upload_header1.'"  class="form-control company_text1_'.$membercompanyid1.'" style="display:none;">
		<img src='.$upload_header.' id="imgupload_header" class="form-control company_text1_'.$membercompanyid1.'" style="display:none;">
<!--	  	<a href="#" id="fileToUpload1" name="fileToUpload1">Upload Photo</a>  -->
				'.$upload_header_var.'	
				</div>
				
				</div>
				
				</div></div></div></div></div>
				
				<div class="row">
				<div class="col-lg-6 company-details1" id="single_companys_'.$membercompanyid1.'">
				<div class="card">
				<div class="card-body" id="company_panel1_'.$membercompanyid1.'">
					<div id="form_content_company1_'.$membercompanyid1.'">
					
				<div class="row">
			<div class="form-group col-md-6">
					<label><b>Contact Person Name</b></label>
					<div class="company_span1_'.$membercompanyid1.'">'.$PersonName1.'</div>
					<input type="text" id="txtclientname_'.$membercompanyid1.'" name="txtclientname"  value="'.$PersonName1.'" class="form-control company_text1_'.$membercompanyid1.'" style="display:none;">
				</div>
				<div class="form-group col-md-6">
					<label><b>Phone Number</b></label>
					<div class="company_span1_'.$membercompanyid1.'">'.$head_TelNo.'</div>
					<input type="text" id="txthead_TelNo_'.$membercompanyid1.'" name="txthead_TelNo"  value="'.$head_TelNo.'" class="form-control company_text1_'.$membercompanyid1.'" style="display:none;">
				</div>
				</div>
				<div class="row">
			<div class="form-group col-md-6">
					<label><b>Mobile Number </b></label>
					<div class="company_span1_'.$membercompanyid1.'">'.$head_mobNo.'</div>
					<input type="text" id="head_mobNo_'.$membercompanyid1.'" name="head_mobNo"  value="'.$head_mobNo.'" class="form-control company_text1_'.$membercompanyid1.'" style="display:none;">
				</div>
				<div class="form-group col-md-6">
					<label><b>Email Address</b></label>
					<div class="company_span1_'.$membercompanyid1.'">'.$head_Email.'</div>
					<input type="text" id="head_Email_'.$membercompanyid1.'" name="head_Email"  value="'.$head_Email.'" class="form-control company_text1_'.$membercompanyid1.'" style="display:none;">
				</div>
				</div>
				
				</div>
				</div>
				</div>
				</div>


				

				
				
				
				<div class="col-lg-6 company-details1" id="single_companys_'.$membercompanyid1.'">
				<div class="card">
				<div class="card-body" id="company_panel1_'.$membercompanyid1.'">
					<div id="form_content_company1_'.$membercompanyid1.'">
						<div class="row">
			<div class="form-group col-md-6">
					<label><b>Active/Inactive State</b></label>
					<div class="company_span1_'.$membercompanyid1.'">'.$status1.'</div>
					<select  id="input-select" name="txtstatus" class="form-control company_text1_'.$membercompanyid1.'"  style="display:none;">
							<option value="1"'.$valselect1.'>Active</option>
							<option value="0"'.$valselect0.'>Inactive</option>
						
							</select>
				</div>
				<div class="form-group col-md-6">
					<label><b>GST applicatble</b></label>
					<div class="company_span1_'.$membercompanyid1.'">'.$gstapplicable1.'</div>
					<select  id="input-select" name="txtgstapplicable" class="form-control company_text1_'.$membercompanyid1.'"  style="display:none;">
							<option value="0">GST applicable/ Product</option>
							<option value="1">GST applicatble/invoice</option>
						
							</select>
				</div>
				</div>
				
				<div class="row">
			<div class="form-group col-md-6">
					<label><b>GST No</b></label>
					<div class="company_span1_'.$membercompanyid1.'">'.$gstno.'</div>
					<input type="text" id="txtgstno1_'.$membercompanyid1.'" name="txtgstno1"  value="'.$gstno.'" class="form-control company_text1_'.$membercompanyid1.'" onchange="Validatecompanygst(this.value,'.$membercompanyid1.');"  style="display:none;">
				</div>
				<div class="form-group col-md-6">
					<label><b>Company PAN NO.</b></label>
					<div class="company_span1_'.$membercompanyid1.'">'.$panno.'</div>
					<input type="text" id="txtpanno_'.$membercompanyid1.'" name="txtpanno"  value="'.$panno.'" class="form-control company_text1_'.$membercompanyid1.'"  style="display:none;">
				</div>
				</div>
				
				<div class="row">
			<div class="form-group col-md-6">
					<label><b>Company TAN NO.</b></label>
					<div class="company_span1_'.$membercompanyid1.'">'.$Tan_No.'</div>
					<input type="text" id="txttanno_'.$membercompanyid1.'" name="txttanno"  value="'.$Tan_No.'" class="form-control company_text1_'.$membercompanyid1.'" style="display:none;">
				</div>	
					</div>
				</div>
				</div>
				</div>


				
				<div class="card">
				<h5 class="card-header"> Bank Details</h5>
				<div class="card-body" id="company_panel1_'.$membercompanyid1.'">
					<div id="form_content_company1_'.$membercompanyid1.'">
					
				<div class="row">
			<div class="form-group col-md-6">
					<label><b>Bank Name</b></label>
					<div class="company_span1_'.$membercompanyid1.'">'.$BankName.'</div>
					<input type="text" id="txtbankname1'.$membercompanyid1.'" name="txtbankname1"  value="'.$BankName.'" class="form-control company_text1_'.$membercompanyid1.'" style="display:none;">
					
				</div>
				
				
				
			
				<div class="form-group col-md-6">
					<label><b>Bank A/C No.</b></label>
					<div class="company_span1_'.$membercompanyid1.'">'.$Bank_ACno.'</div>
					<input type="text" id="txtacno'.$membercompanyid1.'" name="txtacno"  value="'.$Bank_ACno.'" class="form-control company_text1_'.$membercompanyid1.'" style="display:none;">
				</div>
				</div>
				<div class="row">
			<div class="form-group col-md-6">
					<label><b>Branch</b></label>
					<div class="company_span1_'.$membercompanyid1.'">'.$Branch.'</div>
					<input type="text" id="txtbranch'.$membercompanyid1.'" name="txtbranch"  value="'.$Branch.'" class="form-control company_text1_'.$membercompanyid1.'" style="display:none;">
				</div>
				<div class="form-group col-md-6">
					<label><b>IFSC Code</b></label>
					<div class="company_span1_'.$membercompanyid1.'">'.$IFSC_Code.'</div>
					<input type="text" id="txtIFSC'.$membercompanyid1.'" name="txtIFSC"  value="'.$IFSC_Code.'" class="form-control company_text1_'.$membercompanyid1.'" style="display:none;">
				</div>
				</div>
				
				
				</div>
				</div>	
					</div>
				</div>
				</div>				
				
				</form>'.$editable_grid1.'';																	
		}
					
					
					return $companyMenu1;
					
			//}
}



function ManageUserCompanyDetailsDisplay($companyid='')
	{		
			
		
			$companyMenus='';
			$company			=	new Company();
		
	$sqllist	=$company->getCompany("","","select * from trnuser_company a where a.membercompanyid = $companyid");
	//echo $sqllist;
	//print_r($sqllist);
			//if(is_array($factorylist))
			//{
					 $rowcount			=		count($sqllist);
				for($i=0;$i<$rowcount;$i++)
	{	
		$memberuserscompanyid 								= $sqllist[$i]['memberuserscompanyid'];
		$companyname 								= $sqllist[$i]['user_companyname'];
		$MemberName 								= $sqllist[$i]['MemberName'];
		$MemberSurName 								= $sqllist[$i]['MemberSurName'];
		$password 								= $sqllist[$i]['user_password'];
		$Name=$MemberName." ".$MemberSurName;
 	    $memberid									= $sqllist[$i]['memberid'];
		$membercompanyid							= $sqllist[$i]['membercompanyid'];
		$Addline1									= $sqllist[$i]['Addline1'];
		$Addline2									= $sqllist[$i]['Addline2'];
		$dateofbirth									= $sqllist[$i]['dateofbirth'];
		$gender									= $sqllist[$i]['gender'];
		$head_CityName								= $sqllist[$i]['head_CityName'];
		
		$head_TelNo	   = $sqllist[$i]['head_TelNo'];
		$head_mobNo	   = $sqllist[$i]['head_Mob_no'];
		$head_FaxNo	   = $sqllist[$i]['head_FaxNo'];
		$head_Email	   = $sqllist[$i]['head_Email'];
	  
		$head_Pin      = $sqllist[$i]['head_Pin'];
	   $Country  		= $sqllist[$i]['Country'];
		//$head_TelNo    = $sqllist[$i]['head_TelNo'];

		$BankName = $sqllist[$i]['Bankname'];
		$Bank_ACno      = $sqllist[$i]['BankAC'];
	   $Branch  		= $sqllist[$i]['Branch'];
		$IFSC_Code    = $sqllist[$i]['IFSC_Code'];

		$Address	 	   =	$sqllist[$i]['Addline1']."<br>".$sqllist[$i]['Addline2']."<br>".$sqllist[$i]['head_CityName']."<br>".$sqllist[$i]['head_Stateid'].'-'.$sqllist[$i]['head_Pin']."<br>".$sqllist[$i]['Country'];
		$status		   = $sqllist[$i]['memberapprovalstatus'];
		 $memberapprovalstatus					= $sqllist[$i]['memberapprovalstatus'];
		      if($memberapprovalstatus == '1')
		      {
					$valselect1      = "selected";
		      }
		      elseif($memberapprovalstatus == '0')
		      {
					$valselect0      = "selected";
		      }
		
		      
		   $head_Stateid1								= $sqllist[$i]['head_Stateid1'];
		   $head_StateidName							= $sqllist[$i]['head_StateName'];
			
			$selected_country 						= getAllCountryListForCombo($Country); 
	//		$selected_state  							=	getAllStateListForComboEdit($head_Stateid1);
		
			$variable_tocallfunction 				= getState($Country,$head_Stateid1);
	 		
							$formids 					= 		"'company_reg_form1_'";
							$sendurls					=		"'manage_user_companyform_submit.php'";
							//$deleteurl				=		"'delete_company_details.php'";
							
							
/*
								$editable_grids = '<a href="#" class="btn btn-space btn-light managecompany_edit company_spans_'.$membercompanyid.'" rel="'.$membercompanyid.'" id="managecompany_edit_'.$membercompanyid.'" onclick="return false;">EDIT</a>
									
									<a href="#" class="btn btn-space btn-primary company_cancels company_text1_'.$membercompanyid.'" rel="'.$membercompanyid.'" id="company_cancels_'.$membercompanyid.'" onclick="return false;" style="display:none;">CANCEL</a>
									

										 <a href="#" class="btn btn-space btn-primary claim_save company_text1_'.$membercompanyid.'" rel="'.$membercompanyid.'" id="claim_save'.$membercompanyid.'"  onclick="formAjax('.$formids.','.$sendurls.'); return false;" style="display:none;">SAVE</a>
									
															';*/
$editable_grids = '<a href="#" class="btn btn-space btn-light company_edit1 company_span1_'.$membercompanyid.'" rel="'.$membercompanyid.'" id="company_edit1'.$membercompanyid.'" onclick="return false;">EDIT</a>
															<a href="#" class="btn btn-space btn-primary company_cancel1 company_text1_'.$membercompanyid.'" rel="'.$membercompanyid.'" id="company_cancel1'.$membercompanyid.'" onclick="return false;" style="display:none;">CANCEL</a>
															<a href="#" class="btn btn-space btn-secondary company_save1 company_text1_'.$membercompanyid.'" rel="'.$membercompanyid.'" id="company_save1'.$membercompanyid.'" onclick="formAjax('.$formids.','.$sendurls.'); return false;" style="display:none;">SAVE</a>
															';



	/*$formid1 					= 		"'company_reg_form1_".$membercompanyid1."'";
							$sendurl1					=		"'manage_user_companyform_submit.php'";
							//$deleteurl				=		"'delete_company_details.php'";
							
							

								$editable_grids = '<a href="#" class="btn btn-space btn-light company_edit1 company_span1_'.$membercompanyid1.'" rel="'.$membercompanyid1.'" id="company_edit1_'.$membercompanyid1.'" onclick="return false;">EDITs</a>
															<a href="#" class="btn btn-space btn-primary company_cancel1 company_text1_'.$membercompanyid1.'" rel="'.$membercompanyid1.'" id="company_cancel1_'.$membercompanyid1.'" onclick="return false;" style="display:none;">CANCEL</a>
															<a href="#" class="btn btn-space btn-secondary company_save1 company_text1_'.$membercompanyid1.'" rel="'.$membercompanyid1.'" id="company_save1'.$membercompanyid1.'" onclick="formAjax('.$formid1.','.$sendurl1.'); return false;" style="display:none;">SAVE</a>
															';*/
	 //echo $editable_grids;

		// &nbsp;&nbsp;&nbsp;<a href="#" id="CancelUploadedImage" name="CancelUploadedImage">Remove Logo</a>
	  
															
				$companyMenus.=	'<form id="company_reg_form1_">
				<div class="row">
				<div class="col-lg-6 company-details1" id="single_company1_'.$membercompanyid.'">
									<div class="card">
				<div class="card-body" id="company_panel1_'.$membercompanyid.'">
					<div id="form_content_company1_'.$membercompanyid.'">
						
								<input type="hidden" id="" name="txtaccessid" value="'.$accessid.'" class="form-control">
									<input type="hidden" id="txtcompanyid_'.$membercompanyid.'" name="txtcompanyid" value="'.$companyid.'" class="form-control">
									<input type="hidden" id="txtmemberid_'.$membercompanyid.'" name="txtmemberid" value="'.$memberid.'" class="form-control">
									<input type="hidden" id="txtmembercompanyid_'.$membercompanyid.'" name="txtmembercompanyid" value="'.$membercompanyid.'" class="form-control">
									<input type="hidden" id="txtmemberuserscompanyid_'.$membercompanyid.'" name="txtmemberuserscompanyid" value="'.$memberuserscompanyid.'" class="form-control">
									<input type="hidden" id="operation_company_'.$membercompanyid.'" name="operation_company" value="edit_company" class="form-control">
			
				<div class="row">
				<div class="form-group col-md-6">
					<label><b>First Name</b></label>
					<div class="company_span1_'.$membercompanyid.'">'.$MemberName.'</div>
					<input type="text" id="txtcompanyname_'.$membercompanyid.'" name="txtcustomerName"  value="'.$MemberName.'" class="form-control company_text1_'.$membercompanyid.'" style="display:none;">
				</div>
				<div class="form-group col-md-6">
					<label><b>Last Name</b></label>
					<div class="company_span1_'.$membercompanyid.'">'.$MemberSurName.'</div>
					<input type="text" id="txtcustomerlastName_'.$membercompanyid.'" name="txtcustomerlastName"  value="'.$MemberSurName.'" class="form-control company_text1_'.$membercompanyid.'" style="display:none;">
				</div>
				
				</div>
			<div class="row">
				<div class="form-group col-md-6">
					<label><b>Address Line 1</b></label>
					<div class="company_span1_'.$membercompanyid.'">'.$Addline1.'</div>
					<input type="text" id="txtaddressline1_'.$membercompanyid.'" name="txtaddressline1"  value="'.$Addline1.'" class="form-control company_text1_'.$membercompanyid.'" style="display:none;">
				</div>
				<div class="form-group col-md-6">
					<label><b>Address Line 2</b></label>
					<div class="company_span1_'.$membercompanyid.'">'.$Addline2.'</div>
					<input type="text" id="txtaddressline2_'.$membercompanyid.'" name="txtaddressline2"  value="'.$Addline2.'" class="form-control company_text1_'.$membercompanyid.'" style="display:none;">
				</div>
			
				</div>
					<div class="row">
				
				<div class="form-group col-md-6">
					<label><b>City</b></label>
					<div class="company_span1_'.$membercompanyid.'">'.$head_CityName.'</div>
					<input type="text" id="txthead_CityName1_'.$membercompanyid.'" name="txthead_CityName1"  value="'.$head_CityName.'" class="form-control company_text1_'.$membercompanyid.'" style="display:none;">
				</div>
				<div class="form-group col-md-6">
					<label><b>Pin Code</b></label>
					<div class="company_span1_'.$membercompanyid.'">'.$head_Pin.'</div>
					<input type="text" id="txtpincode1_'.$membercompanyid.'" name="txtpincode1" value="'.$head_Pin.'" class="form-control company_text1_'.$membercompanyid.'" style="display:none;">
				</div>
				</div>
					<div class="row">
						<div class="form-group col-md-6">
				<label><b>Country</b></label>
					<div class="company_span1_'.$membercompanyid.'">'.$Country.'</div>
               <select id="txtcountry" name="txtcountry" class="form-control company_text1_'.$membercompanyid.'"  onChange="getState(this.value,'.$head_Stateid1.')" style="display:none;">
						<option value="">Select Country</option>
	'.$selected_country.'
	</select>
				</div>
				<div class="form-group col-md-6">
				<label><b>State</b></label>
					<div class="company_span1_'.$membercompanyid.'">'.$head_StateidName.'</div>
               <select id="txtstate" name="txtstate" class="form-control company_text1_'.$membercompanyid.'"  style="display:none;">
						<option value="" >Select State</option>
						'.$variable_tocallfunction.'
					</select>
				</div>
				</div>
				<div class="row">
				
				<div class="form-group col-md-6">
					<label><b>Gender</b></label>
					<div class="company_span1_'.$membercompanyid.'">'.$gender.'</div>
					<input type="text" id="txtgender1_'.$membercompanyid.'" name="txtgender"  value="'.$gender.'" class="form-control company_text1_'.$membercompanyid.'" style="display:none;">
				</div>
				<div class="form-group col-md-6">
					<label><b>Date Of Birth</b></label>
					<div class="company_span1_'.$membercompanyid.'">'.$dateofbirth.'</div>
					<input type="date" id="txtpincode1_'.$membercompanyid.'" name="txtDOB" value="'.$dateofbirth.'" class="form-control company_text1_'.$membercompanyid.'" style="display:none;">
				</div>
				</div>

									</div>
										</div>
										</div>
										</div>
										<div class="col-lg-6 company-details1" id="single_company1_'.$membercompanyid.'">
									<div class="card">
				<div class="card-body" id="company_panel1_'.$membercompanyid.'">
					<div id="form_content_company1_'.$membercompanyid.'">
					
					<div class="row">
			<div class="form-group col-md-12">
				




			<div class="row">
			<div class="form-group col-md-6">
					
					<label><b>UserName (Email Address)</b></label>
					<div class="company_span1_'.$membercompanyid.'">'.$head_Email.'</div>
					<input type="text" id="head_Email_'.$membercompanyid.'" name="head_Email"  value="'.$head_Email.'" class="form-control company_text1_'.$membercompanyid.'" style="display:none;">
				</div>
				<div class="form-group col-md-6">
						<label><b>Password</b></label>
					<div class="company_span1_'.$membercompanyid.'">'.$password.'</div>
					<input type="text" id="txtpassword_'.$membercompanyid.'" name="txtpassword"  value="'.$password.'" class="form-control company_text1_'.$membercompanyid.'" style="display:none;">
				</div>
				</div>
				<div class="row">
			<div class="form-group col-md-6">
					<label><b>Mobile Number </b></label>
					<div class="company_span1_'.$membercompanyid.'">'.$head_mobNo.'</div>
					<input type="text" id="head_mobNo_'.$membercompanyid.'" name="head_mobNo"  value="'.$head_mobNo.'" class="form-control company_text1_'.$membercompanyid.'" style="display:none;">
				</div>
				<div class="form-group col-md-6">
				
					<label><b>Phone Number</b></label>
					<div class="company_span1_'.$membercompanyid.'">'.$head_TelNo.'</div>
					<input type="text" id="txthead_TelNo_'.$membercompanyid.'" name="txthead_TelNo"  value="'.$head_TelNo.'" class="form-control company_text1_'.$membercompanyid.'" style="display:none;">
				
				</div>
				</div>
		



				</div>
				</div>
				
				
				</div></div></div></div></div>
				
			

				

				
				
						
				
				</form>'.$editable_grids.'';																	
		}
					
					
					return $companyMenus;
					
			//}
}

//Function used for user comapny factory display in panel
function CompanyFactoryDisplay($companyid)
	{		
			//$accessid = 2;
		
			$factoryMenu='';
			$factory			=	new Factories();
 //echo $sql="Select * from member_factories where companyid=$companyid";
	$factorylist		=	$factory->getFactories("","Select * from member_factories where isdeleted=0 and companyid=$companyid");
	//print_r($factorylist);
			//if(is_array($factorylist))
			//{
					$rowcount			=		count($factorylist);
					for($i=0;$i<$rowcount;$i++)
					{
							$companyid				=		$factorylist[$i]['companyid'];
							$memberfactoryid		=		$factorylist[$i]['memberfactoryid'];
							$factoryaddress		=		$factorylist[$i]['factoryaddress'];
							$factoryaddressline1	=		$factorylist[$i]['factoryaddressline1'];
							$factoryaddressline2	=		$factorylist[$i]['factoryaddressline2'];
							$factoryaddressline3	=		$factorylist[$i]['factoryaddressline3'];
							$factoryaddressline4	=		$factorylist[$i]['factoryaddressline4'];
							$factorystreet			= 		$factorylist[$i]['factorystreet'];
							$factorycity			=		$factorylist[$i]['factorycity'];	
							$factorycountry			=		$factorylist[$i]['factorycountry'];
							$factorypincode		=		$factorylist[$i]['factorypincode'];
							//$factorystateid		= 		$factorylist[$i]['factorystateid'];							
							//$factorystate			= 		$factorylist[$i]['factorystate'];
							//$factorytelno			=		$factorylist[$i]['factorytelno'];
							//$factoryfaxno			= 		$factorylist[$i]['factoryfaxno'];
							//$factoryemail			=		$factorylist[$i]['factoryemail'];
							$factorygstno			=		$factorylist[$i]['factorygstno'];
							$factorystate			= 		$factorylist[$i]['factorystate'];
	 						$factory_Stateid1								= $factorylist[$i]['factory_Stateid1'];
							$factory_StateidName							= $factorylist[$i]['factory_StateidName'];
								
							$selected_country       =getAllCountryListForCombo($factorycountry)		;	
							$variable_tocallfunction 				= getFactoryState($factorycountry,$factory_Stateid1);
							$formid 					= 		"'fact_reg_form_".$memberfactoryid."'";
							$sendurl					=		"'company_factory_submit.php'";
							$deleteurl				=		"'delete_company_factory.php'";
							
							

								$editable_grid = '<a href="#" class="btn btn-space btn-light fact_edit fact_span_'.$memberfactoryid.'" rel="'.$memberfactoryid.'" id="fact_edit_'.$memberfactoryid.'" onclick="return false;">EDIT</a>
															<a href="#" class="btn btn-space btn-primary fact_cancel fact_text_'.$memberfactoryid.'" rel="'.$memberfactoryid.'" id="fact_cancel_'.$memberfactoryid.'" onclick="return false;" style="display:none;">CANCEL</a>
															<a href="#" class="btn btn-space btn-secondary fact_save fact_text_'.$memberfactoryid.'" rel="'.$memberfactoryid.'" id="fact_save'.$memberfactoryid.'" onclick="formAjax('.$formid.','.$sendurl.'); return false;" style="display:none;">SAVE</a>
															<a href="#" class="btn btn-space btn-danger fact_delete fact_text_'.$memberfactoryid.'" rel="'.$memberfactoryid.'" id="fact_delete'.$memberfactoryid.'" onclick="DeleteformAjax('.$formid.','.$deleteurl.'); return false;">DELETE</a>';

	
															
				$factoryMenu.=	'<div class="row" >
				<div class="col-lg-6 " id="single_factory_'.$memberfactoryid.'">
									<div class="card">
				<div class="card-body" id="factory_panel_'.$memberfactoryid.'">
					<div id="form_content_factory_'.$memberfactoryid.'">
							<form id="fact_reg_form_'.$memberfactoryid.'">
									<input type="hidden" id="txtcompanyid_'.$companyid.'" name="txtcompanyid" value="'.$companyid.'" class="form-control">
									<input type="hidden" id="txtmemberfactoryid_'.$memberfactoryid.'" name="txtmemberfactoryid" value="'.$memberfactoryid.'" class="form-control">
									<input type="hidden" id="operation_'.$memberfactoryid.'" name="operation" value="edit_factory" class="form-control">
		<!--	<div class="form-group">
					<label><b>Address : </b></label>
					<div class="fact_span_'.$memberfactoryid.'">'.$factoryaddress.'</div>
					<textarea readonly id="txtfactoryaddress_'.$memberfactoryid.'" name="txtfactoryaddress" class="form-control fact_text_'.$memberfactoryid.'" rows="3" style="display:none;">'.$factoryaddress.'</textarea>
				</div>  -->
			<div class="row">
				<div class="form-group col-md-6">
					<label><b>Address Line 1</b></label>
					<div class="fact_span_'.$memberfactoryid.'">'.$factoryaddressline1.'</div>
					<input type="text" id="txtfactoryaddressline1_'.$memberfactoryid.'" name="txtfactoryaddressline1"  value="'.$factoryaddressline1.'" class="form-control fact_text_'.$memberfactoryid.'" style="display:none;">
				</div>
				<div class="form-group col-md-6">
					<label><b>Address Line 2</b></label>
					<div class="fact_span_'.$memberfactoryid.'">'.$factoryaddressline2.'</div>
					<input type="text" id="txtfactoryaddressline2_'.$memberfactoryid.'" name="txtfactoryaddressline2"  value="'.$factoryaddressline2.'" class="form-control fact_text_'.$memberfactoryid.'" style="display:none;">
				</div>
			
				</div>
					<div class="row">
				
				<div class="form-group col-md-6">
					<label><b>City</b></label>
					<div class="fact_span_'.$memberfactoryid.'">'.$factorycity.'</div>
					<input type="text" id="txtfactorycity_'.$memberfactoryid.'" name="txtfactorycity"  value="'.$factorycity.'" class="form-control fact_text_'.$memberfactoryid.'" style="display:none;">
				</div>
				<div class="form-group col-md-6">
					<label><b>Pin Code</b></label>
					<div class="fact_span_'.$memberfactoryid.'">'.$factorypincode.'</div>
					<input type="text" id="txtfactorypincode_'.$memberfactoryid.'" name="txtfactorypincode" value="'.$factorypincode.'" class="form-control fact_text_'.$memberfactoryid.'" style="display:none;">
				</div>
				</div>
					<div class="row">
						<div class="form-group col-md-6">
				<label><b>Country</b></label>
					<div class="fact_span_'.$memberfactoryid.'">'.$factorycountry.'</div>
               <select id="txtfactorycountry_'.$memberfactoryid.'" name="txtfactorycountry" class="form-control fact_text_'.$memberfactoryid.'"  onChange="getFactoryState(this.value,'.$factory_Stateid1.','.$memberfactoryid.')" style="display:none;">
						<option value="">Select Country</option>
	'.$selected_country.'
	</select>
				</div>
				<div class="form-group col-md-6">
				<label><b>State</b></label>
					<div class="fact_span_'.$memberfactoryid.'">'.$factory_StateidName.'</div>
               <select id="txtfactorystate_'.$memberfactoryid.'" name="txtfactorystate" class="form-control fact_text_'.$memberfactoryid.'"  style="display:none;">
						<option value="" >Select State</option>
						'.$variable_tocallfunction.'
					</select>
				</div>
				</div>
				
				<div class="row">
			<div class="form-group col-md-6">
					<label><b>GST No</b></label>
					<div class="fact_span_'.$memberfactoryid.'">'.$factorygstno.'</div>
					<input type="text" id="txtfactorygstno_'.$memberfactoryid.'" name="txtfactorygstno"  value="'.$factorygstno.'" class="form-control fact_text_'.$memberfactoryid.'" style="display:none;">
				</div>
						
							</div>
						
													
									</form>'.$editable_grid.'
									</div>
										</div>
										</div>
										</div>
										</div>';															
		}
					
					
					return $factoryMenu;
					
			//}
}

//Function used for company branch display in panel, 
	function CompanyBranchesDisplay($companyid='')
	{		
			
			$branchMenu='';
			$branch			=	new Branches();
	
			$branchlist		=	$branch->getBranches("","Select * from member_branches where isdeleted =0 and  companyid=$companyid");
			if(is_array($branchlist))
			{
					$rowcount			=		count($branchlist);
					for($i=0;$i<$rowcount;$i++)
					{
									$companyid				=		$branchlist[$i]['companyid'];
							$memberbranchid		=		$branchlist[$i]['memberbranchid'];
							$branchaddress			=		$branchlist[$i]['branchaddress'];
							$branchaddressline1	=		$branchlist[$i]['branchaddressline1'];
							$branchaddressline2	=		$branchlist[$i]['branchaddressline2'];
							$branchaddressline3	=		$branchlist[$i]['branchaddressline3'];
							$branchaddressline4	=		$branchlist[$i]['branchaddressline4'];
							$branchstreet			= 		$branchlist[$i]['branchstreet'];
							$branchcity				=		$branchlist[$i]['branchcity'];	
							$branchpincode			=		$branchlist[$i]['branchpincode'];
						//	$branchstateid			= 		$branchlist[$i]['branchstateid'];
						//	$branchstate			= 		$branchlist[$i]['branchstate'];
						//	$branchtelno			=		$branchlist[$i]['branchtelno'];
						//$branchfaxno				= 		$branchlist[$i]['branchfaxno'];
							$branchcountry 		=		$branchlist[$i]['branchcountry'];
							$branchgstno			=		$branchlist[$i]['branchgstno'];

							$branchstate			= 		$branchlist[$i]['branchstate'];
		 					$branch_Stateid1		= 		$branchlist[$i]['branch_Stateid1'];
							$branch_StateidName	=		$branchlist[$i]['branch_StateidName'];
							$GCountry				= 	$branchlist[$i]['branchcountry'];
							$selected_country 	=	getAllCountryListForCombo($GCountry);
							$variable_tocallfunction 				= getBranchState($branchcountry,$branch_Stateid1);
							$formid 					= 		"'branch_reg_form_".$memberbranchid."'";
							$sendurl					=		"'company_branch_submit.php'";
							$deleteurl				=	"'delete_company_branch.php'";
					//print_r($branchlist);
													$editable_grid = '<a href="#" class="btn btn-space btn-light branch_edit branch_span_'.$memberbranchid.'" rel="'.$memberbranchid.'" id="branch_edit_'.$memberbranchid.'" onclick="return false;">EDIT</a>
														<a href="#" class="btn btn-space btn-primary branch_cancel branch_text_'.$memberbranchid.'" rel="'.$memberbranchid.'" id="branch_cancel_'.$memberbranchid.'" onclick="return false;" style="display:none;">CANCEL</a>
														<a href="#" class="btn btn-space btn-secondary branch_save branch_text_'.$memberbranchid.'" rel="'.$memberbranchid.'" id="branch_save_'.$memberbranchid.'" onclick="formAjax('.$formid.','.$sendurl.'); return false;" style="display:none;">SAVE</a>
														<a href="#" class="btn btn-space btn-danger branch_delete branch_text_'.$memberbranchid.'" rel="'.$memberbranchid.'" id="branch_delete_'.$memberbranchid.'" onclick="DeleteformAjax('.$formid.','.$deleteurl.'); return false;">DELETE</a>';
						
							$branchMenu				.=	'<div class="row">
																<div class="col-lg-6"  id="single_branch_'.$memberbranchid.'">	 									
																	<div class="card">
																			<div class="card-body" id="branch_panel_'.$memberbranchid.'">											
																				<div id="form_content_branch_'.$memberbranchid.'">
																				
																					<form id="branch_reg_form_'.$memberbranchid.'">
																					   <input type="hidden" id="" name="txtaccessid" value="'.$accessid.'" class="form-control">
																						<input type="hidden" id="txtcompanyid_'.$memberbranchid.'" name="txtcompanyid" value="'.$companyid.'" class="form-control">
																						<input type="hidden" id="txtmemberbranchid_'.$memberbranchid.'" name="txtmemberbranchid" value="'.$memberbranchid.'" class="form-control">
																						<input type="hidden" id="operation_branch_'.$memberbranchid.'" name="operation_branch" value="edit_branch" class="form-control">
																						<!--<div class="form-group">
																							<label><b>Address : </b></label>
																							<div class="branch_span_'.$memberbranchid.'">'.$branchaddress.'</div>
																							<textarea readonly id="txtbranchaddress_'.$memberbranchid.'" name="txtbranchaddress" class="form-control branch_text_'.$memberbranchid.'" rows="3" style="display:none;">'.$branchaddress.'</textarea>
																						</div>  -->
																					<div class="row">
																						<div class="form-group col-md-6">
																							<label><b>Address Line 1</b></label>
																							<div class="branch_span_'.$memberbranchid.'">'.$branchaddressline1.'</div>
																							<input type="text" id="txtbranchaddressline1_'.$memberbranchid.'" name="txtbranchaddressline1"  value="'.$branchaddressline1.'" class="form-control branch_text_'.$memberbranchid.'" style="display:none;">
																						</div>
																						<div class="form-group col-md-6">
																							<label><b>Address Line 2</b></label>
																							<div class="branch_span_'.$memberbranchid.'">'.$branchaddressline2.'</div>
																							<input type="text" id="txtbranchaddressline2_'.$memberbranchid.'" name="txtbranchaddressline2"  value="'.$branchaddressline2.'" class="form-control branch_text_'.$memberbranchid.'" style="display:none;">
																						</div>
																					</div>
																					
																					<div class="row">
																						<div class="form-group col-md-6">
																							<label><b>City</b></label>
																							<div class="branch_span_'.$memberbranchid.'">'.$branchcity.'</div>
																							<input type="text" id="txtbranchcity_'.$memberbranchid.'" name="txtbranchcity"  value="'.$branchcity.'" class="form-control branch_text_'.$memberbranchid.'" style="display:none;">
																						</div>
																						<div class="form-group col-md-6">
																							<label><b>Pin Code</b></label>
																							<div class="branch_span_'.$memberbranchid.'">'.$branchpincode.'</div>
																							<input type="text" id="txtbranchpincode_'.$memberbranchid.'" name="txtbranchpincode" value="'.$branchpincode.'" class="form-control branch_text_'.$memberbranchid.'" style="display:none;">
																						</div>
																						</div>
																						<div class="row">
																						<div class="form-group col-md-6">
																							<label><b>Country</b></label>
																								<div class="branch_span_'.$memberbranchid.'">'.$branchcountry.'</div>
																			               <select id="txtbranchcountry_'.$memberbranchid.'" name="txtbranchcountry" class="form-control branch_text_'.$memberbranchid.'"  onChange="getBranchState(this.value,'.$branch_Stateid1.','.$memberbranchid.')" style="display:none;">
																													<option value="">Select Country</option>
																								'.$selected_country.'
																								</select>
																							</div>
																							<div class="form-group col-md-6">
																							<label><b>State</b></label>
																								<div class="branch_span_'.$memberbranchid.'">'.$branch_StateidName.'</div>
																			               <select id="txtbranchstate_'.$memberbranchid.'" name="txtbranchstate" class="form-control branch_text_'.$memberbranchid.'" style="display:none;">
																									<option value="" selected>Select State</option>
																									'.$variable_tocallfunction.'
																								</select>
																							</div>
																						</div>
																					<div class="row">
																						<div class="form-group col-md-6">
																							<label><b>GST No</b></label>
																							<div class="branch_span_'.$memberbranchid.'">'.$branchgstno.'</div>
																							<input type="text" id="txtbranchgstno_'.$memberbranchid.'" name="txtbranchgstno" value="'.$branchgstno.'" class="form-control branch_text_'.$memberbranchid.'" style="display:none;">
																						</div>
																						</div>
																						</form>'.$editable_grid.'
																				
																				</div>													
																			</div>
																			</div>
																  	</div>
															</div>';
					}
					
					
					
					
			}
			return $branchMenu;
		
	}
	
function getState($countryname='',$stateid="")
{
		$all_obj    			= 	new AllTables();
	
		if($countryname != '')
		{
			 $query ="SELECT * FROM mststate a 
						inner join mstcountry b on a.countryid = b.countryid 
						where b.countryname = '".$countryname."' ";
		}

			$state	         = $all_obj -> getInfo("",$query);
		
			$resultscount = count($state);
			for($i=0;$i<$resultscount;$i++)
			{
				if($stateid == $state[$i]['StateId'])
				{
					$statelist .= '<option value="'.$state[$i]["StateId"].'-'.$state[$i]["StateName"].'" selected="">'.$state[$i]["StateName"].'</option>';	
				}
				else if($stateid != $state[$i]['StateId'])
				{
					$statelist .= '<option value="'.$state[$i]["StateId"].'-'.$state[$i]["StateName"].'">'.$state[$i]["StateName"].'</option>';	
				}
			}
		//return $countryid;
	return $statelist; 
}

function getFactoryState($countryname='',$stateid="")
{
		$all_obj    			= 	new AllTables();
		
		if($countryname != '')
		{
			$query ="SELECT * FROM mststate a 
						inner join mstcountry b on a.countryid = b.countryid 
						where b.countryname = '".$countryname."' ";
		}

			$state	         = $all_obj -> getInfo("",$query);
		
			$resultscount = count($state);
			for($i=0;$i<$resultscount;$i++)
			{
				if($stateid == $state[$i]['StateId'])
				{
					$statelist .= '<option value="'.$state[$i]["StateId"].'-'.$state[$i]["StateName"].'" selected="">'.$state[$i]["StateName"].'</option>';	
				}
				else if($stateid != $state[$i]['StateId'])
				{
					$statelist .= '<option value="'.$state[$i]["StateId"].'-'.$state[$i]["StateName"].'">'.$state[$i]["StateName"].'</option>';	
				}
			}
		//return $countryid;
	return $statelist; 
}

function getBranchState($countryname='',$stateid="")
{
		$all_obj    			= 	new AllTables();
		
		if($countryname != '')
		{
			$query ="SELECT * FROM mststate a 
						inner join mstcountry b on a.countryid = b.countryid 
						where b.countryname = '".$countryname."' ";
		}

			$state	         = $all_obj -> getInfo("",$query);
		
			$resultscount = count($state);
			for($i=0;$i<$resultscount;$i++)
			{
				if($stateid == $state[$i]['StateId'])
				{
					$statelist .= '<option value="'.$state[$i]["StateId"].'-'.$state[$i]["StateName"].'" selected="">'.$state[$i]["StateName"].'</option>';	
				}
				else if($stateid != $state[$i]['StateId'])
				{
					$statelist .= '<option value="'.$state[$i]["StateId"].'-'.$state[$i]["StateName"].'">'.$state[$i]["StateName"].'</option>';	
				}
			}
		//return $countryid;
	return $statelist; 
}

function getClientContactList($companyid='')
	{
			$menu			=	new ClientContacts();
		$sql="Select * from client_contacts where clientcompanyid=$companyid and isdeleted=0";
			$menulist		=	$menu->getClientContacts('',$sql);
			//print_r($menulist);
			if(is_array($menulist))
			{
					$rowcount			=		count($menulist);
					for($i=0;$i<$rowcount;$i++)
					{
							$contact_parson_name =$menulist[$i]['contact_parson_name1'];
							$clientcontactid =$menulist[$i]['clientcontactid'];
			
 							$contact_parson				.=	'<tbody>';
							$contact_parson				.=	 '<tr id="delete_row'.$clientcontactid.'">';
							$contact_parson				.=	'<td>'.$contact_parson_name.'</td>';
							$contact_parson				.=	'<td style="text-align: center;"><a href="edit-client-contacts.php?clientcontactid='.$clientcontactid.'">Edit</a></td>';
							$contact_parson				.=	'<td style="text-align: center;"><a  class="delete_contact" opt="delete_proforma" rel="<?=$i?>" clientcontactid="'.$clientcontactid.'">Delete</a></td>';
							$contact_parson				.=	'</tr>';
							 $contact_parson				.=	'</tbody>';
							
							
					}
					
					
			}
			return $contact_parson;
	}

function headerinvoice($G_userid='',$G_companyid='')
	{		
	    $companyid =    $G_companyid;			

		$header			=	new Company();
		$sql="select * from ".COMPANY_TABLE." a
					inner join ".USERCOMPANYDETAILS_TABLE." b on a.companyid=b.companyid
					where b.userid = $G_userid";
			$headerlist		=	$header->getCompany('','',$sql);
			//print_r($headerlist);
			$header_parsons = "";
			if(is_array($headerlist))
			{
					$rowcount_header			=		count($headerlist);
					//	$header_parsons				.=	'<ul class="dropdown-menu dropdown-user" style="left:auto;right:0;width:250px !important;">';
				//		$header_head				=	'<select class="dropdown-menu dropdown-user" style="left:auto;right:0;width:250px !important;">';
					for($i=0;$i<$rowcount_header;$i++)
					{		$companyid = $headerlist[$i]['companyid'];
							$companyname = $headerlist[$i]['companyname'];
							
							if($companyid == $headerlist[$i]['companyid'])
				            {
					            $header_parsons				.=	'<option value='.$companyid.'>&#x25a0; &nbsp; '.$companyname.'</option>';

				            }
				            else if($companyid != $headerlist[$i]['companyid'])
				            {
				                $header_parsons				.=	'<option value='.$companyid.'>&#x25a0; &nbsp; '.$companyname.'</option>';

				            }
							//echo $companyname;
		
						//	$header_parsons				.=	'<div id="subheader-31" class="collapse subheader" style="">';
 						//	$header_parsons				.=	'<ul class="header flex-column">';
							//$header_parsons				.=	 '<li class="header-item">';
							//$header_parsons				.='<form name="headerinvoicefrom" action="headerinvoicefrom.php?companyid='.$membercompanyid.'" method="POST" id="headerinvoicefrom_">
                             //   <input  type="hidden" name="opt" id="opt" value="'.$companyname.'">
                             //   <input  type="hidden" name="newmembercompanyid" id="newmembercompanyid" value="'.$membercompanyid.'">
                                                 
                           // </form>';

							//$header_parsons				.=	'<li>&#x25a0; &nbsp; <a href="company-details.php?companyid='.$membercompanyid.'">'.$companyname.'</a></li>';
						//	$header_parsons				.=	'<li>&#x25a0; &nbsp; <a id="companyid" href="headerinvoicefrom.php?companyid='.$membercompanyid.'">'.$companyname.'</a></li>';
							//$header_parsons				.=	'<option value='.$membercompanyid.'>&#x25a0; &nbsp; '.$companyname.'</option>';
						

							/*//$nav_parsons				.=	'<td style="text-align: center;"><a href="edit-client-navs.php?clientnavid='.$clientnavid.'">Edit</a></td>';
							//$nav_parsons				.=	'<td style="text-align: center;"><a  class="delete_nav" opt="delete_proforma" rel="<?=$i?>" clientnavid="'.$clientnavid.'">Delete</a></td>';*/
							//$nav_parsons				.=	'</li>';
							
						//	 $nav_parsons				.=	'</div>';
							
					}
					//$header_parsons				.=	'</ul>';
				//	 $header_footer				=	'</select>';
			}
			return $header_parsons;

	}


function leftnavinvoice($G_userid='',$G_companyid='')
	{		
			
         $companyid =    $G_companyid;	
		$nav			=	new Company();
		$sql="select * from ".COMPANY_TABLE." a
					inner join ".USERCOMPANYDETAILS_TABLE." b on a.companyid=b.companyid
					where b.userid = $G_userid";
					
					
	    //echo $sql;
			$navlist		=	$nav->getCompany('','',$sql);
			$nav_parsons = "";
			$active  = "active";
			//print_r($navlist);
			if(is_array($navlist))
			{
					$rowcount_nav			=		count($navlist);
				//	$nav_parsons				.=	'<ul class="nav flex-column membercompanyidchange">';
				//	$nav_parsons				.=	'<select class="nav flex-column membercompanyidchange">';
					for($i=0;$i<$rowcount_nav;$i++)
					{		$companyid = $navlist[$i]['companyid'];
							$companyname = $navlist[$i]['companyname'];
							
							if($companyid == $navlist[$i]['companyid'])
				            {
					            $nav_parsons				.=	'<option class="nav-item    '.$active.'" value='.$companyid.'  >'.$companyname.'</option>';

				            }
				            else if($companyid != $navlist[$i]['companyid'])
				            {
							    $nav_parsons				.=	'<option class="nav-item" value='.$companyid.'>'.$companyname.'</option>';
                            }
							//echo $companyname;
		
						//	$nav_parsons				.=	'<div id="subnav-31" class="collapse subnav" style="">';
 						//	$nav_parsons				.=	'<ul class="nav flex-column">';
							//$nav_parsons				.=	 '<li class="nav-item">';
					//		$nav_parsons				.=	'<li class="nav-item"><a class="nav-link" href="viewInvoice.php?membercompanyid='.$membercompanyid.'">'.$companyname.'</a></li>';
					//		$nav_parsons				.=	'<li class="nav-item" ><a class="nav-link" data-value='.$membercompanyid.'">'.$companyname.'</a></li>';
							//$nav_parsons				.=	'<option class="nav-item" value='.$membercompanyid.'>'.$companyname.'</option>';
				

							/*//$nav_parsons				.=	'<td style="text-align: center;"><a href="edit-client-navs.php?clientnavid='.$clientnavid.'">Edit</a></td>';
							//$nav_parsons				.=	'<td style="text-align: center;"><a  class="delete_nav" opt="delete_proforma" rel="<?=$i?>" clientnavid="'.$clientnavid.'">Delete</a></td>';*/
							//$nav_parsons				.=	'</li>';
							
						//	 $nav_parsons				.=	'</div>';
							
					}
				//	 $nav_parsons				.=	'</ul>';
				//	 $nav_parsons				.=	'</select>';
			}
			return $nav_parsons;

	}


function ManagerepresentDetailsDisplay($userid='')
	{		
			
		
			$companyMenus='';
			$company			=	new AllTables();
		
	$sqllist	=$company->getInfo("","select * from ".USER_TABLE." where userid =$userid ");
	//echo $sqllist;
	//print_r($sqllist);
			//if(is_array($factorylist))
			//{
					 $rowcount			=		count($sqllist);
				for($i=0;$i<$rowcount;$i++)
	{	
		$userid 								= $sqllist[$i]['userid'];
		$companyname 								= $sqllist[$i]['represent_companyname'];
		$userfirstname 								= $sqllist[$i]['userfirstname'];
		$userlastname 								= $sqllist[$i]['userlastname'];
		//$password 								= $sqllist[$i]['user_password'];
		$Name=$userfirstname." ".$userlastname;
 	   // $userid									= $sqllist[$i]['userid'];
		//$companyid							= $sqllist[$i]['companyid'];
		$Addline1									= $sqllist[$i]['Addline1'];
		$Addline2									= $sqllist[$i]['Addline2'];
		//$dateofbirth									= $sqllist[$i]['dateofbirth'];
		//$gender									= $sqllist[$i]['gender'];
		$head_CityName								= $sqllist[$i]['head_CityName'];
		
		$head_TelNo	   = $sqllist[$i]['head_TelNo'];
		$head_mobNo	   = $sqllist[$i]['mobileforsms'];
		//$head_FaxNo	   = $sqllist[$i]['head_FaxNo'];
		$head_Email	   = $sqllist[$i]['head_Email'];
	  
		$head_Pin      = $sqllist[$i]['head_Pin'];
	   $Country  		= $sqllist[$i]['Country'];
		//$head_TelNo    = $sqllist[$i]['head_TelNo'];

	//	$BankName = $sqllist[$i]['Bankname'];
	//	$Bank_ACno      = $sqllist[$i]['BankAC'];
	 //  $Branch  		= $sqllist[$i]['Branch'];
	//	$IFSC_Code    = $sqllist[$i]['IFSC_Code'];

		$Address	 	   =	$sqllist[$i]['Addline1']."<br>".$sqllist[$i]['Addline2']."<br>".$sqllist[$i]['head_CityName']."<br>".$sqllist[$i]['head_Stateid'].'-'.$sqllist[$i]['head_Pin']."<br>".$sqllist[$i]['Country'];
		$status		   = $sqllist[$i]['memberapprovalstatus'];
		 $memberapprovalstatus					= $sqllist[$i]['memberapprovalstatus'];
		      if($memberapprovalstatus == '1')
		      {
					$valselect1      = "selected";
		      }
		      elseif($memberapprovalstatus == '0')
		      {
					$valselect0      = "selected";
		      }
		
		      
		   $head_Stateid1								= $sqllist[$i]['head_Stateid'];
		   $head_StateidName							= $sqllist[$i]['head_StateName'];
			
			$selected_country 						= getAllCountryListForCombo($Country); 
	//		$selected_state  							=	getAllStateListForComboEdit($head_Stateid1);
		
			$variable_tocallfunction 				= getState($Country,$head_Stateid1);
	 		
							$formids 					= 		"'company_reg_form1_'";
							$sendurls					=		"'manage_editrepresent_submit.php'";
							//$deleteurl				=		"'delete_company_details.php'";
							
							
/*
								$editable_grids = '<a href="#" class="btn btn-space btn-light managecompany_edit company_spans_'.$membercompanyid.'" rel="'.$membercompanyid.'" id="managecompany_edit_'.$membercompanyid.'" onclick="return false;">EDIT</a>
									
									<a href="#" class="btn btn-space btn-primary company_cancels company_text1_'.$membercompanyid.'" rel="'.$membercompanyid.'" id="company_cancels_'.$membercompanyid.'" onclick="return false;" style="display:none;">CANCEL</a>
									

										 <a href="#" class="btn btn-space btn-primary claim_save company_text1_'.$membercompanyid.'" rel="'.$membercompanyid.'" id="claim_save'.$membercompanyid.'"  onclick="formAjax('.$formids.','.$sendurls.'); return false;" style="display:none;">SAVE</a>
									
															';*/
$editable_grids = '<a href="#" class="btn btn-space btn-light company_edit1 company_span1_'.$userid.'" rel="'.$userid.'" id="company_edit1'.$userid.'" onclick="return false;">EDIT</a>
															<a href="#" class="btn btn-space btn-primary company_cancel1 company_text1_'.$userid.'" rel="'.$userid.'" id="company_cancel1'.$userid.'" onclick="return false;" style="display:none;">CANCEL</a>
															<a href="#" class="btn btn-space btn-secondary company_save1 company_text1_'.$userid.'" rel="'.$userid.'" id="company_save1'.$userid.'" onclick="formAjax('.$formids.','.$sendurls.'); return false;" style="display:none;">SAVE</a>
															';



	/*$formid1 					= 		"'company_reg_form1_".$membercompanyid1."'";
							$sendurl1					=		"'manage_user_companyform_submit.php'";
							//$deleteurl				=		"'delete_company_details.php'";
							
							

								$editable_grids = '<a href="#" class="btn btn-space btn-light company_edit1 company_span1_'.$membercompanyid1.'" rel="'.$membercompanyid1.'" id="company_edit1_'.$membercompanyid1.'" onclick="return false;">EDITs</a>
															<a href="#" class="btn btn-space btn-primary company_cancel1 company_text1_'.$membercompanyid1.'" rel="'.$membercompanyid1.'" id="company_cancel1_'.$membercompanyid1.'" onclick="return false;" style="display:none;">CANCEL</a>
															<a href="#" class="btn btn-space btn-secondary company_save1 company_text1_'.$membercompanyid1.'" rel="'.$membercompanyid1.'" id="company_save1'.$membercompanyid1.'" onclick="formAjax('.$formid1.','.$sendurl1.'); return false;" style="display:none;">SAVE</a>
															';*/
	 //echo $editable_grids;

		// &nbsp;&nbsp;&nbsp;<a href="#" id="CancelUploadedImage" name="CancelUploadedImage">Remove Logo</a>
	  
															
				$companyMenus.=	'<form id="company_reg_form1_">
				<div class="row">
				<div class="col-lg-6 company-details1" id="single_company1_'.$userid.'">
									<div class="card">
				<div class="card-body" id="company_panel1_'.$userid.'">
					<div id="form_content_company1_'.$userid.'">
						
								<input type="hidden" id="" name="txtaccessid" value="'.$accessid.'" class="form-control">
									
									<input type="hidden" id="txtuserid_'.$userid.'" name="txtuserid" value="'.$userid.'" class="form-control">
									
									<input type="hidden" id="txtuserid_'.$userid.'" name="txtuserid" value="'.$userid.'" class="form-control">
									<input type="hidden" id="operation_sales_representive'.$userid.'" name="operation_sales_representive" value="edit_sales_representive" class="form-control">
			
				<div class="row">
				<div class="form-group col-md-6">
					<label><b>First Name</b></label>
					<div class="company_span1_'.$userid.'">'.$userfirstname.'</div>
					<input type="text" id="txtcompanyname_'.$userid.'" name="txtcustomerName"  value="'.$userfirstname.'" class="form-control company_text1_'.$userid.'" style="display:none;">
				</div>
				<div class="form-group col-md-6">
					<label><b>Last Name</b></label>
					<div class="company_span1_'.$userid.'">'.$userlastname.'</div>
					<input type="text" id="txtcustomerlastName_'.$userid.'" name="txtcustomerlastName"  value="'.$userlastname.'" class="form-control company_text1_'.$userid.'" style="display:none;">
				</div>
				
				</div>
			<div class="row">
				<div class="form-group col-md-6">
					<label><b>Address Line 1</b></label>
					<div class="company_span1_'.$userid.'">'.$Addline1.'</div>
					<input type="text" id="txtaddressline1_'.$userid.'" name="txtaddressline1"  value="'.$Addline1.'" class="form-control company_text1_'.$userid.'" style="display:none;">
				</div>
				<div class="form-group col-md-6">
					<label><b>Address Line 2</b></label>
					<div class="company_span1_'.$userid.'">'.$Addline2.'</div>
					<input type="text" id="txtaddressline2_'.$userid.'" name="txtaddressline2"  value="'.$Addline2.'" class="form-control company_text1_'.$userid.'" style="display:none;">
				</div>
			
				</div>
					<div class="row">
				
				<div class="form-group col-md-6">
					<label><b>City</b></label>
					<div class="company_span1_'.$userid.'">'.$head_CityName.'</div>
					<input type="text" id="txthead_CityName1_'.$userid.'" name="txthead_CityName1"  value="'.$head_CityName.'" class="form-control company_text1_'.$userid.'" style="display:none;">
				</div>
				<div class="form-group col-md-6">
					<label><b>Pin Code</b></label>
					<div class="company_span1_'.$userid.'">'.$head_Pin.'</div>
					<input type="text" id="txtpincode1_'.$userid.'" name="txtpincode1" value="'.$head_Pin.'" class="form-control company_text1_'.$userid.'" style="display:none;">
				</div>
				</div>
					<div class="row">
						<div class="form-group col-md-6">
				<label><b>Country</b></label>
					<div class="company_span1_'.$userid.'">'.$Country.'</div>
               <select id="txtcountry" name="txtcountry" class="form-control company_text1_'.$userid.'"  onChange="getState(this.value,'.$head_Stateid1.')" style="display:none;">
						<option value="">Select Country</option>
	'.$selected_country.'
	</select>
				</div>
				<div class="form-group col-md-6">
				<label><b>State</b></label>
					<div class="company_span1_'.$userid.'">'.$head_StateidName.'</div>
               <select id="txtstate" name="txtstate" class="form-control company_text1_'.$userid.'"  style="display:none;">
						<option value="" >Select State</option>
						'.$variable_tocallfunction.'
					</select>
				</div>
				</div>
				<!--<div class="row">
				
				<div class="form-group col-md-6">
					<label><b>Gender</b></label>
					<div class="company_span1_'.$userid.'">'.$gender.'</div>
					<input type="text" id="txtgender1_'.$userid.'" name="txtgender"  value="'.$gender.'" class="form-control company_text1_'.$userid.'" style="display:none;">
				</div>
				<div class="form-group col-md-6">
					<label><b>Date Of Birth</b></label>
					<div class="company_span1_'.$userid.'">'.$dateofbirth.'</div>
					<input type="date" id="txtpincode1_'.$userid.'" name="txtDOB" value="'.$dateofbirth.'" class="form-control company_text1_'.$userid.'" style="display:none;">
				</div>
				</div>-->

									</div>
										</div>
										</div>
										</div>
										<div class="col-lg-6 company-details1" id="single_company1_'.$userid.'">
									<div class="card">
				<div class="card-body" id="company_panel1_'.$userid.'">
					<div id="form_content_company1_'.$userid.'">
					
					<div class="row">
			<div class="form-group col-md-12">
				




			<div class="row">
			<div class="form-group col-md-6">
					
					<label><b>Email Address</b></label>
					<div class="company_span1_'.$userid.'">'.$head_Email.'</div>
					<input type="text" id="head_Email_'.$userid.'" name="head_Email"  value="'.$head_Email.'" class="form-control company_text1_'.$userid.'" style="display:none;">
				</div>
				<!--<div class="form-group col-md-6">
						<label><b>Password</b></label>
					<div class="company_span1_'.$userid.'">'.$password.'</div>
					<input type="text" id="txtpassword_'.$userid.'" name="txtpassword"  value="'.$password.'" class="form-control company_text1_'.$userid.'" style="display:none;">
				</div>-->
				</div>
				<div class="row">
			<div class="form-group col-md-6">
					<label><b>Mobile Number </b></label>
					<div class="company_span1_'.$userid.'">'.$head_mobNo.'</div>
					<input type="text" id="head_mobNo_'.$userid.'" name="head_mobNo"  value="'.$head_mobNo.'" class="form-control company_text1_'.$userid.'" style="display:none;">
				</div>
				<div class="form-group col-md-6">
				
					<label><b>Phone Number</b></label>
					<div class="company_span1_'.$userid.'">'.$head_TelNo.'</div>
					<input type="text" id="txthead_TelNo_'.$userid.'" name="txthead_TelNo"  value="'.$head_TelNo.'" class="form-control company_text1_'.$userid.'" style="display:none;">
				
				</div>
				</div>
		



				</div>
				</div>
				
				
				</div></div></div></div></div>
				
			

				

				
				
						
				
				</form>'.$editable_grids.'';																	
		}
					
					
					return $companyMenus;
					
			//}
}

	function getAllRepresentativeListForCombo($userid,$companyid)
	{
		$representatives = new AllTables();
		//echo $companyname;

		//$representlist = $representatives->getInfo("","select * from mstrepresentative where membercompanyid=$membercompanyid");
		$representlist = $representatives->getInfo("","select * from ".USER_TABLE." a inner join ".USERCOMPANYDETAILS_TABLE."  b  on a.userid=b.userid  where companyid=$companyid and a.salse_representive=1");
		
	//echo $representlist;
	//print_r($sqllist);
			//if(is_array($factorylist))
			//{
						
		$rowcount = count($representlist);
		
		$strRepresentList = "";
		
		if ($rowcount > 0)
		{
			
			for($i=0;$i<$rowcount;$i++) 
			{	
				
				if(strtolower($userid) == strtolower($representlist[$i]['userid']))
				{
					$strRepresentList .= '<option value="'.$representlist[$i]["userid"].'" selected="selected">'.ucwords(strtolower($representlist[$i]["userfirstname"])).' '.ucwords(strtolower($representlist[$i]["userlastname"])).'</option>';
				}
				else
				{	
					$strRepresentList .= '<option value="'.$representlist[$i]["userid"].'">'.ucwords(strtolower($representlist[$i]["userfirstname"])).' '.ucwords(strtolower($representlist[$i]["userlastname"])).'</option>';
				}
			}
		}
		return $strRepresentList;	
	}		
	
	
	/*function getcsvdataforGSTR3B_withtax($memberuserscompanyid,$memberid,$membercompanyid,$where_paymentmode1,$where_day,$where_date,$day)
	{
	    $obj_Invoice  = new Invoice();
	    $obj_Memberpaymentheader  = new Memberpaymentheader();
	    		if($memberuserscompanyid > 0)
				{	
					if($day){
					$sql_invoice2 = "select SUM(InvoiceTotalAmount) as InvoiceTotalAmounts ,SUM(paid_total_amount) as paid_total_amount1,SUM(igst_amount) as igst_amounts,SUM(cgst_amount) as cgst_amounts,SUM(sgst_amount) as sgst_amounts,SUM(ugst_amount) as ugst_amounts,SUM(InvoiceBaseAmount) as InvoiceBaseAmounts from trninvoicetomember a  where memberid = $memberid  and billing_membercompanyid=$membercompanyid and isdeleted=0 $where_paymentmode1 $where_day and   quotes_proforma_invoice = 2 and (igst_amount > 0 or sgst_amount > 0 or cgst_amount > 0)";
					}
					else{
						$sql_invoice2 = "select SUM(InvoiceTotalAmount) as InvoiceTotalAmounts ,SUM(paid_total_amount) as paid_total_amount1,SUM(igst_amount) as igst_amounts,SUM(cgst_amount) as cgst_amounts,SUM(sgst_amount) as sgst_amounts,SUM(ugst_amount) as ugst_amounts,SUM(InvoiceBaseAmount) as InvoiceBaseAmounts from trninvoicetomember a d where memberid = $memberid   and billing_membercompanyid=$membercompanyid and isdeleted=0 $where_paymentmode1 $where_day and $where_date  quotes_proforma_invoice = 2 and   (igst_amount > 0 or sgst_amount > 0 or cgst_amount > 0)";
					}
				}
				else
				{
					if($day){
					$sql_invoice2 = "select SUM(InvoiceTotalAmount) as InvoiceTotalAmounts ,SUM(paid_total_amount) as paid_total_amount1,SUM(igst_amount) as igst_amounts,SUM(cgst_amount) as cgst_amounts,SUM(sgst_amount) as sgst_amounts,SUM(ugst_amount) as ugst_amounts,SUM(InvoiceBaseAmount) as InvoiceBaseAmounts from trninvoicetomember a  where memberid = $memberid and a.billing_membercompanyid=$membercompanyid  and isdeleted=0 $where_paymentmode1 $where_day and   quotes_proforma_invoice = 2 and (igst_amount > 0 or sgst_amount > 0 or cgst_amount > 0)";
					}
					else{
						$sql_invoice2 = "select SUM(InvoiceTotalAmount) as InvoiceTotalAmounts ,SUM(paid_total_amount) as paid_total_amount1,SUM(igst_amount) as igst_amounts,SUM(cgst_amount) as cgst_amounts,SUM(sgst_amount) as sgst_amounts,SUM(ugst_amount) as ugst_amounts,SUM(InvoiceBaseAmount) as InvoiceBaseAmounts from trninvoicetomember a  where memberid = $memberid and a.billing_membercompanyid=$membercompanyid  and isdeleted=0 $where_paymentmode1 $where_day and $where_date  quotes_proforma_invoice = 2 and (igst_amount > 0 or sgst_amount > 0 or cgst_amount > 0)";
					}
				}	

	            //echo $sql_invoice2;
						$sql_invoice_list2 = $obj_Invoice->getInvoice('',$sql_invoice2);
	
		
			if($memberuserscompanyid > 0)
				{	
					if($day){
					$sql_payment2 = "select SUM(TotalAmount) as TotalAmounts3,SUM(tds) as Totaltds from user_company_payment_header a inner join trninvoicetomember b on a.memberinvoicesid = b.memberinvoicesid
					where memberid = $memberid  and billing_membercompanyid=$membercompanyid and isdeleted=0 $where_paymentmode1 $where_day and   quotes_proforma_invoice = 2 and (igst_amount > 0 or sgst_amount > 0 or cgst_amount > 0)";
					}
					else{
						$sql_payment2 = "select SUM(TotalAmount) as TotalAmounts3,SUM(tds) as Totaltds from user_company_payment_header a inner join trninvoicetomember b on a.memberinvoicesid = b.memberinvoicesid 
						where memberid = $memberid   and billing_membercompanyid=$membercompanyid and isdeleted=0 $where_paymentmode1 $where_day and $where_date  quotes_proforma_invoice = 2 and (igst_amount > 0 or sgst_amount > 0 or cgst_amount > 0)";
					}
				}
				else
				{
					if($day){
					$sql_payment2 = "select SUM(TotalAmount) as TotalAmounts3,SUM(tds) as Totaltds from user_company_payment_header a inner join trninvoicetomember b on a.memberinvoicesid = b.memberinvoicesid  
					where memberid = $memberid and a.billing_membercompanyid=$membercompanyid  and isdeleted=0 $where_paymentmode1 $where_day and   quotes_proforma_invoice = 2 and (igst_amount > 0 or sgst_amount > 0 or cgst_amount > 0)";
					}
					else{
						$sql_payment2 = "select SUM(TotalAmount) as TotalAmounts3,SUM(tds) as Totaltds from user_company_payment_header a inner join trninvoicetomember b on a.memberinvoicesid = b.memberinvoicesid 
						where memberid = $memberid and a.billing_membercompanyid=$membercompanyid  and isdeleted=0 $where_paymentmode1 $where_day and $where_date  quotes_proforma_invoice = 2 and (igst_amount > 0 or sgst_amount > 0 or cgst_amount > 0)";
					}
				}	
                //echo $sql_payment2;

				$sql_paymentlist2 = $obj_Memberpaymentheader->getMemberpaymentheader('',$sql_payment2);
						
	            //echo $sql_invoice1;
						$sql_invoice_list2 = $obj_Invoice->getInvoice('',$sql_invoice2);
	
		
			
						$InvoiceTotalAmount1  		= $sql_invoice_list2[0]['InvoiceTotalAmounts'];
						$igst_amounts  				= $sql_invoice_list2[0]['igst_amounts'];
						$cgst_amounts  				= $sql_invoice_list2[0]['cgst_amounts'];
						$sgst_amounts  				= $sql_invoice_list2[0]['sgst_amounts'];
						$ugst_amounts  				= $sql_invoice_list2[0]['ugst_amounts'];
						$InvoiceBaseAmounts  		= $sql_invoice_list2[0]['InvoiceBaseAmounts'];
						$TotalAmounts3  		    = $sql_paymentlist2[0]['TotalAmounts3'];
						$paid_total_amount1  		= $sql_invoice_list2[0]['paid_total_amount1'];
						$Totaltds  				    = $sql_paymentlist2[0]['Totaltds'];

				if($paid_total_amount1 == '0')
         		{
         			$balance1sds 							= $InvoiceTotalAmount1 - $TotalAmounts3-$Totaltds;
         		}
         		else
         		{
					
					$balance1sds= $InvoiceTotalAmount1 - $paid_total_amount1-$Totaltds;
					
         		}
	
                $result1 = "\n".'"Total","'.$InvoiceBaseAmounts.'","'.$igst_amounts.'","'.$cgst_amounts.'","'.$sgst_amounts.'","'.$InvoiceTotalAmount1.'",""'."\n";
				$result2 = "\n".'"","","","","Total","'.$InvoiceTotalAmount1.'","'.$InvoiceBaseAmounts.'","'.$igst_amounts.'","'.$cgst_amounts.'","'.$sgst_amounts.'",""'."\n";
                $result  = $result1."||".$result2; 
	            return  $result;     
	}*/
	
	/*function getcsvdataforGSTR3B_withouttax($memberuserscompanyid,$memberid,$membercompanyid,$where_paymentmode1,$where_day,$where_date,$day)
	{
	    $obj_Invoice  = new Invoice();
	    $obj_Memberpaymentheader  = new Memberpaymentheader();
	    		if($memberuserscompanyid > 0)
				{	
					if($day){
					$sql_invoice2 = "select SUM(InvoiceTotalAmount) as InvoiceTotalAmounts ,SUM(paid_total_amount) as paid_total_amount1,SUM(igst_amount) as igst_amounts,SUM(cgst_amount) as cgst_amounts,SUM(sgst_amount) as sgst_amounts,SUM(ugst_amount) as ugst_amounts,SUM(InvoiceBaseAmount) as InvoiceBaseAmounts from trninvoicetomember a  where memberid = $memberid  and billing_membercompanyid=$membercompanyid and isdeleted=0 $where_paymentmode1 $where_day and   quotes_proforma_invoice = 2 and  igst_amount =0 and sgst_amount=0 and cgst_amount =0";
					}
					else{
						$sql_invoice2 = "select SUM(InvoiceTotalAmount) as InvoiceTotalAmounts ,SUM(paid_total_amount) as paid_total_amount1,SUM(igst_amount) as igst_amounts,SUM(cgst_amount) as cgst_amounts,SUM(sgst_amount) as sgst_amounts,SUM(ugst_amount) as ugst_amounts,SUM(InvoiceBaseAmount) as InvoiceBaseAmounts from trninvoicetomember a d where memberid = $memberid   and billing_membercompanyid=$membercompanyid and isdeleted=0 $where_paymentmode1 $where_day and $where_date  quotes_proforma_invoice = 2 and  igst_amount =0 and sgst_amount=0 and cgst_amount =0";
					}
				}
				else
				else
				{
					if($day){
					$sql_invoice2 = "select SUM(InvoiceTotalAmount) as InvoiceTotalAmounts ,SUM(paid_total_amount) as paid_total_amount1,SUM(igst_amount) as igst_amounts,SUM(cgst_amount) as cgst_amounts,SUM(sgst_amount) as sgst_amounts,SUM(ugst_amount) as ugst_amounts,SUM(InvoiceBaseAmount) as InvoiceBaseAmounts from trninvoicetomember a  where memberid = $memberid and a.billing_membercompanyid=$membercompanyid  and isdeleted=0 $where_paymentmode1 $where_day and   quotes_proforma_invoice = 2 and  igst_amount =0 and sgst_amount=0 and cgst_amount =0";
					}
					else{
						$sql_invoice2 = "select SUM(InvoiceTotalAmount) as InvoiceTotalAmounts ,SUM(paid_total_amount) as paid_total_amount1,SUM(igst_amount) as igst_amounts,SUM(cgst_amount) as cgst_amounts,SUM(sgst_amount) as sgst_amounts,SUM(ugst_amount) as ugst_amounts,SUM(InvoiceBaseAmount) as InvoiceBaseAmounts from trninvoicetomember a  where memberid = $memberid and a.billing_membercompanyid=$membercompanyid  and isdeleted=0 $where_paymentmode1 $where_day and $where_date  quotes_proforma_invoice = 2 and  igst_amount =0 and sgst_amount=0 and cgst_amount =0";
					}
				}	

	            //echo $sql_invoice2;
						$sql_invoice_list2 = $obj_Invoice->getInvoice('',$sql_invoice2);
	
		
			if($memberuserscompanyid > 0)
				{	
					if($day){
					$sql_payment2 = "select SUM(TotalAmount) as TotalAmounts3,SUM(tds) as Totaltds from user_company_payment_header a inner join trninvoicetomember b on a.memberinvoicesid = b.memberinvoicesid
					where memberid = $memberid  and billing_membercompanyid=$membercompanyid and isdeleted=0 $where_paymentmode1 $where_day and   quotes_proforma_invoice = 2 and  igst_amount =0 and sgst_amount=0 and cgst_amount =0";
					}
					else{
						$sql_payment2 = "select SUM(TotalAmount) as TotalAmounts3,SUM(tds) as Totaltds from user_company_payment_header a inner join trninvoicetomember b on a.memberinvoicesid = b.memberinvoicesid 
						where memberid = $memberid   and billing_membercompanyid=$membercompanyid and isdeleted=0 $where_paymentmode1 $where_day and $where_date  quotes_proforma_invoice = 2 and  igst_amount =0 and sgst_amount=0 and cgst_amount =0";
					}
				}
				else
				{
					if($day){
					$sql_payment2 = "select SUM(TotalAmount) as TotalAmounts3,SUM(tds) as Totaltds from user_company_payment_header a inner join trninvoicetomember b on a.memberinvoicesid = b.memberinvoicesid  
					where memberid = $memberid and a.billing_membercompanyid=$membercompanyid  and isdeleted=0 $where_paymentmode1 $where_day and   quotes_proforma_invoice = 2 and  igst_amount =0 and sgst_amount=0 and cgst_amount =0";
					}
					else{
						$sql_payment2 = "select SUM(TotalAmount) as TotalAmounts3,SUM(tds) as Totaltds from user_company_payment_header a inner join trninvoicetomember b on a.memberinvoicesid = b.memberinvoicesid 
						where memberid = $memberid and a.billing_membercompanyid=$membercompanyid  and isdeleted=0 $where_paymentmode1 $where_day and $where_date  quotes_proforma_invoice = 2 and  igst_amount =0 and sgst_amount=0 and cgst_amount =0";
					}
				}	
                //echo $sql_payment2;

				$sql_paymentlist2 = $obj_Memberpaymentheader->getMemberpaymentheader('',$sql_payment2);
						
	            //echo $sql_invoice1;
						$sql_invoice_list2 = $obj_Invoice->getInvoice('',$sql_invoice2);
	
		
			
						$InvoiceTotalAmount1  		= $sql_invoice_list2[0]['InvoiceTotalAmounts'];
						$igst_amounts  				= $sql_invoice_list2[0]['igst_amounts'];
						$cgst_amounts  				= $sql_invoice_list2[0]['cgst_amounts'];
						$sgst_amounts  				= $sql_invoice_list2[0]['sgst_amounts'];
						$ugst_amounts  				= $sql_invoice_list2[0]['ugst_amounts'];
						$InvoiceBaseAmounts  		= $sql_invoice_list2[0]['InvoiceBaseAmounts'];
						$TotalAmounts3  		    = $sql_paymentlist2[0]['TotalAmounts3'];
						$paid_total_amount1  		= $sql_invoice_list2[0]['paid_total_amount1'];
						$Totaltds  				    = $sql_paymentlist2[0]['Totaltds'];

				if($paid_total_amount1 == '0')
         		{
         			$balance1sds 							= $InvoiceTotalAmount1 - $TotalAmounts3-$Totaltds;
         		}
         		else
         		{
					
					$balance1sds= $InvoiceTotalAmount1 - $paid_total_amount1-$Totaltds;
					
         		}
	
                $result1 = "\n".'"Total","'.$InvoiceBaseAmounts.'","'.$igst_amounts.'","'.$cgst_amounts.'","'.$sgst_amounts.'","'.$InvoiceTotalAmount1.'",""'."\n";
				$result2 = "\n".'"","","","","Total","","'.$InvoiceBaseAmounts.'","'.$igst_amounts.'","'.$cgst_amounts.'","'.$sgst_amounts.'","'.$InvoiceTotalAmount1.'"'."\n";
                $result  = $result1."||".$result2;
	            return  $result; 
	                 
	}*/
	
	function getAllAssignedListForCombo($userid,$companyid)
	{
		$Assigned = new AllTables();
		//echo $companyname;

		//$representlist = $representatives->getInfo("","select * from mstrepresentative where membercompanyid=$membercompanyid");
		$Assignedlist = $Assigned->getInfo("","select * from ".USER_TABLE." a inner join ".USERCOMPANYDETAILS_TABLE."  b  on a.userid=b.userid  where companyid=$companyid");
		
	//echo $representlist;
	//print_r($sqllist);
			//if(is_array($factorylist))
			//{
						
		$rowcount = count($Assignedlist);
		
		$strAssignedList = "";
		
		if ($rowcount > 0)
		{
			
			for($i=0;$i<$rowcount;$i++) 
			{	
				
				if(strtolower($userid) == strtolower($Assignedlist[$i]['userid']))
				{
					$strAssignedList .= '<option value="'.$Assignedlist[$i]["userid"].'" selected="selected">'.ucwords(strtolower($Assignedlist[$i]["userfirstname"])).' '.ucwords(strtolower($Assignedlist[$i]["userlastname"])).'</option>';
				}
				else
				{	
					$strAssignedList .= '<option value="'.$Assignedlist[$i]["userid"].'">'.ucwords(strtolower($Assignedlist[$i]["userfirstname"])).' '.ucwords(strtolower($Assignedlist[$i]["userlastname"])).'</option>';
				}
			}
		}
		return $strAssignedList;	
	}		
	
	function getcompany_url($companyid,$companyname)
	{
	   
        $company_url     =   str_replace(' ', '_', strtolower($companyname ));
        $company_url     =   $company_url."-".$companyid;
        return $company_url;
	}
	
		/*function getcsvdataforGSTR1_withTax($memberuserscompanyid,$memberid,$membercompanyid,$where_paymentmode1,$where_day,$where_date,$day)
	{
	   	$obj  = new Company();
	            //with Tax starts here
				if($memberuserscompanyid > 0)
				{	
					if($day){
					 $sql2 = "select *,e.head_Email,a.memberinvoicesid,a.billed_membercompanyid,a.paid_total_amount,a.billing_membercompanyid,a.invoiceno,a.is_mail_send,
			 				 a.InvoiceTotalAmount,a.invoicedate,a.duedate,a.billed_membername,c.TotalAmount,a.approved,MONTH(CURRENT_DATE()) as today_date,CURRENT_DATE() -1 as Yesterday_date 
			 			    from mstmember x
					  		 inner join trninvoicetomember a on x.memberid = a.memberid 
					  		 inner join trninvoicetomemberdetails b on a.memberinvoicesid = b.memberinvoicesid
					  		 inner join mstclients e on b.billed_membercompanyid = e.clientcompanyid
					  		 left join user_company_payment_header  c on a.memberinvoicesid = c.memberinvoicesid
					  		 left join user_company_payment_detail  d on a.memberinvoicesid = d.memberinvoicesid
					  		  inner join trnuser_company g on x.memberid = g.memberid
					  		 where x.memberid = $memberid  and a.billing_membercompanyid=$membercompanyid and g.memberuserscompanyid = $memberuserscompanyid $where_paymentmode  $where_day and  a.isdeleted= 0 and quotes_proforma_invoice = 2 
					  		 and (igst_amount > 0 or sgst_amount > 0 or cgst_amount > 0) group by a.memberinvoicesid  order by a.invoicedate ASC";
					  		}
					  		else{
					  		$sql2 = "select *,e.head_Email,a.memberinvoicesid,a.billed_membercompanyid,a.paid_total_amount,a.billing_membercompanyid,a.invoiceno,a.is_mail_send,
			 				 a.InvoiceTotalAmount,a.invoicedate,a.duedate,a.billed_membername,c.TotalAmount,a.approved,MONTH(CURRENT_DATE()) as today_date,CURRENT_DATE() -1 as Yesterday_date 
			 			    from mstmember x
					  		 inner join trninvoicetomember a on x.memberid = a.memberid 
					  		 inner join trninvoicetomemberdetails b on a.memberinvoicesid = b.memberinvoicesid
					  		 inner join mstclients e on b.billed_membercompanyid = e.clientcompanyid
					  		 left join user_company_payment_header  c on a.memberinvoicesid = c.memberinvoicesid
					  		 left join user_company_payment_detail  d on a.memberinvoicesid = d.memberinvoicesid
					  		  inner join trnuser_company g on x.memberid = g.memberid
					  		 where x.memberid = $memberid and a.billing_membercompanyid=$membercompanyid and  g.memberuserscompanyid = $memberuserscompanyid  $where_paymentmode   and $where_date a.isdeleted= 0 and quotes_proforma_invoice = 2 
					  		 and (igst_amount > 0 or sgst_amount > 0 or cgst_amount > 0) group by a.memberinvoicesid  order by a.invoicedate ASC";

					  		}
				}
				else
				{
					if($day){
					 $sql2 = "select *,e.head_Email,a.memberinvoicesid,a.billed_membercompanyid,a.paid_total_amount,a.billing_membercompanyid,a.invoiceno,a.is_mail_send,
			 				 a.InvoiceTotalAmount,a.invoicedate,a.duedate,a.billed_membername,c.TotalAmount,a.approved,MONTH(CURRENT_DATE()) as today_date,CURRENT_DATE() -1 as Yesterday_date 
			 			    from mstmember x
					  		 inner join trninvoicetomember a on x.memberid = a.memberid 
					  		 inner join trninvoicetomemberdetails b on a.memberinvoicesid = b.memberinvoicesid
					  		 inner join mstclients e on b.billed_membercompanyid = e.clientcompanyid
					  		 left join user_company_payment_header  c on a.memberinvoicesid = c.memberinvoicesid
					  		 left join user_company_payment_detail  d on a.memberinvoicesid = d.memberinvoicesid
					  		 where x.memberid = $memberid and a.billing_membercompanyid=$membercompanyid $where_paymentmode  $where_day and  a.isdeleted= 0 and quotes_proforma_invoice = 2 
					  		 and (igst_amount > 0 or sgst_amount > 0 or cgst_amount > 0) group by a.memberinvoicesid  order by a.invoicedate ASC";
					  		}
					  		else{
					  		$sql2 = "select *,e.head_Email,a.memberinvoicesid,a.billed_membercompanyid,a.paid_total_amount,a.billing_membercompanyid,a.invoiceno,a.is_mail_send,
			 				 a.InvoiceTotalAmount,a.invoicedate,a.duedate,a.billed_membername,c.TotalAmount,a.approved,MONTH(CURRENT_DATE()) as today_date,CURRENT_DATE() -1 as Yesterday_date 
			 			    from mstmember x
					  		 inner join trninvoicetomember a on x.memberid = a.memberid 
					  		 inner join trninvoicetomemberdetails b on a.memberinvoicesid = b.memberinvoicesid
					  		 inner join mstclients e on b.billed_membercompanyid = e.clientcompanyid
					  		 left join user_company_payment_header  c on a.memberinvoicesid = c.memberinvoicesid
					  		 left join user_company_payment_detail  d on a.memberinvoicesid = d.memberinvoicesid
					  		 where x.memberid = $memberid and a.billing_membercompanyid=$membercompanyid $where_paymentmode   and $where_date a.isdeleted= 0 and quotes_proforma_invoice = 2 
					  		 and (igst_amount > 0 or sgst_amount > 0 or cgst_amount > 0) group by a.memberinvoicesid  order by a.invoicedate ASC";

					  		}
				}	  		
					//echo $sql2;
					//die();
					$heading = "Invoice GSTR1";
					$sqllist2 = $obj->getCompany('','',$sql2);
					$rowcount = count($sqllist2);
					if ($sqllist2)
					{
						$rowcount_adv = $rowcount;
					}
					else
					{
						$rowcount_adv=0;
					}
					$maxrows = $rowcount_adv;
					$csvcolumnsname ='"","GST NO","<b>Company Name</b>","Invoice No","Invoice Date","Total Amount with Tax","Basic Amount","IGST","CGST","SGST "'."\n";
				
			 for($i=0;$i<$maxrows;$i++) 
         	{ 
         		$memberinvoicesid					= $sqllist2[$i]['memberinvoicesid'];
         		$companyid							= $sqllist2[$i]['billed_membercompanyid'];
         		$billing_membercompanyid		= $sqllist2[$i]['billing_membercompanyid'];
         		$statusdata							= $sqllist2[$i]['status'];
         		$invoiceno							= $sqllist2[$i]['invoiceno'];
         		//$InvoiceTotalAmount				= $sqllist[$i]['InvoiceTotalAmount'];
         		$invoicedate						= date("j M Y",strtotime($sqllist2[$i]['invoicedate']));
         		$invoicedatemonth						= date("M Y",strtotime($sqllist2[$i]['invoicedate']));

         		//date("M jS, Y", strtotime("2011-01-05"));
         		$duedate								= date("j M Y",strtotime($sqllist2[$i]['duedate']));
         		$billed_membername				= $sqllist2[$i]['billed_membername'];   
         		$TotalAmount 						= $sqllist2[$i]['TotalAmount']; //total payment by that invoice id
         		$approved							= $sqllist2[$i]['approved'];  //Invoice approve status
         			$InvoiceBaseAmount			= $sqllist2[$i]['InvoiceBaseAmount'];
					$InvoiceTotalAmount			= $sqllist2[$i]['InvoiceTotalAmount'];
					$inv_GST_no						=	$sqllist2[$i]['inv_GST_no'];
         	
					$is_mail_send						= $sqllist2[$i]['is_mail_send'];
     			  $balance1 							= $InvoiceTotalAmount - $TotalAmount;
         			$paid_total_amount				= $sqllist2[$i]['paid_total_amount'];
         			if($paid_total_amount == '0')
         			{
         		
         			 $balance1 							= $InvoiceTotalAmount - $TotalAmount;
         			}
         			else
         			{
         	
						$balance1 =  $InvoiceTotalAmount - $paid_total_amount;
         			}

         			$cgst_amount					= $sqllist2[$i]['cgst_amount'];
			
					$sgst_amount					= $sqllist2[$i]['sgst_amount'];
					$igst_amount					= $sqllist2[$i]['igst_amount'];
					$sgst_percentage 				= $sqllist2[$i]['sgst_percentage'];
					$cgst_percentage 				= $sqllist2[$i]['cgst_percentage'];
					$igst_percentage 				= $sqllist2[$i]['igst_percentage'];


         				$reportname = '"'.$heading.'"'."\n";
         				$resultcsvtotalincome_GSTR1_withtax =getcsvdataforGSTR3B_withtax($memberuserscompanyid,$memberid,$membercompanyid,$where_paymentmode1,$where_day,$where_date,$day);
                        $resultcsvtotalincom_explode = explode('||',$resultcsvtotalincome_GSTR1_withtax);
                        $resultcsvtotalincom_explode1 = $resultcsvtotalincom_explode[0];
                        $resultcsvtotalincom_explode2 = $resultcsvtotalincom_explode[1];
						//$csvtotalincome = "\n".'"","","","","Total","'.$InvoiceBaseAmounts.'","'.$igst_amounts.'","'.$cgst_amounts.'","'.$sgst_amounts.'","'.$InvoiceTotalAmount1.'",""'."\n";
						$csvtotalincome = $resultcsvtotalincom_explode2;

						$csvdata .= '"'.$invoicedatemonth.'","'.$inv_GST_no.'","'.$billed_membername.'","'.$invoiceno.'","'.$invoicedate.'","'.$InvoiceTotalAmount.'","'.$InvoiceBaseAmount.'","'.$igst_amount.'","'.$cgst_amount.'","'.$sgst_amount.'"'."\n";
						$paymentresultCSV_GSTR1_withtax = $reportname.$csvcolumnsname.$csvdata.$csvtotalincome;

       			 }
       			 
       		        return $paymentresultCSV_GSTR1_withtax;
	}*/
	
 /*   function getcsvdataforGSTR1_withouttax($memberuserscompanyid,$memberid,$membercompanyid,$where_paymentmode,$where_day,$where_date,$day)
	{
	   	$obj  = new Company();
	    //without tax starts
       			 if($memberuserscompanyid > 0)
				{	
					if($day){
					 $sql2 = "select *,e.head_Email,a.memberinvoicesid,a.billed_membercompanyid,a.paid_total_amount,a.billing_membercompanyid,a.invoiceno,a.is_mail_send,
			 				 a.InvoiceTotalAmount,a.invoicedate,a.duedate,a.billed_membername,c.TotalAmount,a.approved,MONTH(CURRENT_DATE()) as today_date,CURRENT_DATE() -1 as Yesterday_date 
			 			    from mstmember x
					  		 inner join trninvoicetomember a on x.memberid = a.memberid 
					  		 inner join trninvoicetomemberdetails b on a.memberinvoicesid = b.memberinvoicesid
					  		 inner join mstclients e on b.billed_membercompanyid = e.clientcompanyid
					  		 left join user_company_payment_header  c on a.memberinvoicesid = c.memberinvoicesid
					  		 left join user_company_payment_detail  d on a.memberinvoicesid = d.memberinvoicesid
					  		  inner join trnuser_company g on x.memberid = g.memberid
					  		 where x.memberid = $memberid  and a.billing_membercompanyid=$membercompanyid and g.memberuserscompanyid = $memberuserscompanyid $where_paymentmode  $where_day and  a.isdeleted= 0 and quotes_proforma_invoice = 2 
					  		 and  igst_amount =0 and sgst_amount=0 and cgst_amount =0 group by a.memberinvoicesid  order by a.invoicedate ASC";
					  		}
					  		else{
					  		$sql2 = "select *,e.head_Email,a.memberinvoicesid,a.billed_membercompanyid,a.paid_total_amount,a.billing_membercompanyid,a.invoiceno,a.is_mail_send,
			 				 a.InvoiceTotalAmount,a.invoicedate,a.duedate,a.billed_membername,c.TotalAmount,a.approved,MONTH(CURRENT_DATE()) as today_date,CURRENT_DATE() -1 as Yesterday_date 
			 			    from mstmember x
					  		 inner join trninvoicetomember a on x.memberid = a.memberid 
					  		 inner join trninvoicetomemberdetails b on a.memberinvoicesid = b.memberinvoicesid
					  		 inner join mstclients e on b.billed_membercompanyid = e.clientcompanyid
					  		 left join user_company_payment_header  c on a.memberinvoicesid = c.memberinvoicesid
					  		 left join user_company_payment_detail  d on a.memberinvoicesid = d.memberinvoicesid
					  		  inner join trnuser_company g on x.memberid = g.memberid
					  		 where x.memberid = $memberid and a.billing_membercompanyid=$membercompanyid and  g.memberuserscompanyid = $memberuserscompanyid  $where_paymentmode   and $where_date a.isdeleted= 0 and quotes_proforma_invoice = 2 
					  		 and  igst_amount =0 and sgst_amount=0 and cgst_amount =0 group by a.memberinvoicesid  order by a.invoicedate ASC";

					  		}
				}
				else
				{
					if($day){
					 $sql2 = "select *,e.head_Email,a.memberinvoicesid,a.billed_membercompanyid,a.paid_total_amount,a.billing_membercompanyid,a.invoiceno,a.is_mail_send,
			 				 a.InvoiceTotalAmount,a.invoicedate,a.duedate,a.billed_membername,c.TotalAmount,a.approved,MONTH(CURRENT_DATE()) as today_date,CURRENT_DATE() -1 as Yesterday_date 
			 			    from mstmember x
					  		 inner join trninvoicetomember a on x.memberid = a.memberid 
					  		 inner join trninvoicetomemberdetails b on a.memberinvoicesid = b.memberinvoicesid
					  		 inner join mstclients e on b.billed_membercompanyid = e.clientcompanyid
					  		 left join user_company_payment_header  c on a.memberinvoicesid = c.memberinvoicesid
					  		 left join user_company_payment_detail  d on a.memberinvoicesid = d.memberinvoicesid
					  		 where x.memberid = $memberid and a.billing_membercompanyid=$membercompanyid $where_paymentmode  $where_day and  a.isdeleted= 0 and quotes_proforma_invoice = 2 
					  		 and  igst_amount =0 and sgst_amount=0 and cgst_amount =0 group by a.memberinvoicesid  order by a.invoicedate ASC";
					  		}
					  		else{
					  		$sql2 = "select *,e.head_Email,a.memberinvoicesid,a.billed_membercompanyid,a.paid_total_amount,a.billing_membercompanyid,a.invoiceno,a.is_mail_send,
			 				 a.InvoiceTotalAmount,a.invoicedate,a.duedate,a.billed_membername,c.TotalAmount,a.approved,MONTH(CURRENT_DATE()) as today_date,CURRENT_DATE() -1 as Yesterday_date 
			 			    from mstmember x
					  		 inner join trninvoicetomember a on x.memberid = a.memberid 
					  		 inner join trninvoicetomemberdetails b on a.memberinvoicesid = b.memberinvoicesid
					  		 inner join mstclients e on b.billed_membercompanyid = e.clientcompanyid
					  		 left join user_company_payment_header  c on a.memberinvoicesid = c.memberinvoicesid
					  		 left join user_company_payment_detail  d on a.memberinvoicesid = d.memberinvoicesid
					  		 where x.memberid = $memberid and a.billing_membercompanyid=$membercompanyid $where_paymentmode   and $where_date a.isdeleted= 0 and quotes_proforma_invoice = 2 
					  		 and  igst_amount =0 and sgst_amount=0 and cgst_amount =0 group by a.memberinvoicesid  order by a.invoicedate ASC";

					  		}
				}	  		
					//echo $sql2;
					//die();
					//$heading = "Invoice GSTR1";
					$heading = "";
					$sqllist2 = $obj->getCompany('','',$sql2);
					$rowcount = count($sqllist2);
					if ($sqllist2)
					{
						$rowcount_adv = $rowcount;
					}
					else
					{
						$rowcount_adv=0;
					}
					$maxrows = $rowcount_adv;
					//$csvcolumnsname ='"","GST NO","<b>GST Not Applicable</b>","Invoice No","Invoice Date","Total Amount with Tax","IGST","CGST","SGST","Basic Amount"'."\n";
                    $csvcolumnsname ='"","","<b>GST Not Applicable</b>","","","","","",""," "'."\n";


			 for($i=0;$i<$maxrows;$i++) 
         	{ 
         		$memberinvoicesid					= $sqllist2[$i]['memberinvoicesid'];
         		$companyid							= $sqllist2[$i]['billed_membercompanyid'];
         		$billing_membercompanyid		= $sqllist2[$i]['billing_membercompanyid'];
         		$statusdata							= $sqllist2[$i]['status'];
         		$invoiceno							= $sqllist2[$i]['invoiceno'];
         		//$InvoiceTotalAmount				= $sqllist[$i]['InvoiceTotalAmount'];
         		$invoicedate						= date("j M Y",strtotime($sqllist2[$i]['invoicedate']));
         		$invoicedatemonth						= date("M Y",strtotime($sqllist2[$i]['invoicedate']));

         		//date("M jS, Y", strtotime("2011-01-05"));
         		$duedate								= date("j M Y",strtotime($sqllist2[$i]['duedate']));
         		$billed_membername				= $sqllist2[$i]['billed_membername'];   
         		$TotalAmount 						= $sqllist2[$i]['TotalAmount']; //total payment by that invoice id
         		$approved							= $sqllist2[$i]['approved'];  //Invoice approve status
         			$InvoiceBaseAmount			= $sqllist2[$i]['InvoiceBaseAmount'];
					$InvoiceTotalAmount			= $sqllist2[$i]['InvoiceTotalAmount'];
					$inv_GST_no						=	$sqllist2[$i]['inv_GST_no'];
         	
					$is_mail_send						= $sqllist2[$i]['is_mail_send'];
     			  $balance1 							= $InvoiceTotalAmount - $TotalAmount;
         			$paid_total_amount				= $sqllist2[$i]['paid_total_amount'];
         			if($paid_total_amount == '0')
         			{
         		
         			 $balance1 							= $InvoiceTotalAmount - $TotalAmount;
         			}
         			else
         			{
         	
						$balance1 =  $InvoiceTotalAmount - $paid_total_amount;
         			}

         			$cgst_amount					= $sqllist2[$i]['cgst_amount'];
			
					$sgst_amount					= $sqllist2[$i]['sgst_amount'];
					$igst_amount					= $sqllist2[$i]['igst_amount'];
					$sgst_percentage 				= $sqllist2[$i]['sgst_percentage'];
					$cgst_percentage 				= $sqllist2[$i]['cgst_percentage'];
					$igst_percentage 				= $sqllist2[$i]['igst_percentage'];


         				$reportname = '"'.$heading.'"'."\n";
         				$resultcsvtotalincome_GSTR1_withtax =getcsvdataforGSTR3B_withouttax($memberuserscompanyid,$memberid,$membercompanyid,$where_paymentmode1,$where_day,$where_date,$day);
                        $resultcsvtotalincom_explode = explode('||',$resultcsvtotalincome_GSTR1_withtax);
                        $resultcsvtotalincom_explode1 = $resultcsvtotalincom_explode[0];
                        $resultcsvtotalincom_explode2 = $resultcsvtotalincom_explode[1];
						//$csvtotalincome = "\n".'"","","","","Total","'.$InvoiceBaseAmounts.'","'.$igst_amounts.'","'.$cgst_amounts.'","'.$sgst_amounts.'","'.$InvoiceTotalAmount1.'",""'."\n";
						$csvtotalincome = $resultcsvtotalincom_explode2;

						$csvdata .= '"'.$invoicedatemonth.'","'.$inv_GST_no.'","'.$billed_membername.'","'.$invoiceno.'","'.$invoicedate.'"," ","'.$InvoiceBaseAmount.'","'.$igst_amount.'","'.$cgst_amount.'","'.$sgst_amount.'","'.$InvoiceTotalAmount.'"'."\n";
						$paymentresultCSV_GSTR1_withouttax = $reportname.$csvcolumnsname.$csvdata.$csvtotalincome;

       			 }
       			 return $paymentresultCSV_GSTR1_withouttax;
	}*/
	
	
	
   
   	function getpdffilename($memberinvoicesid = '',$userid='',$quotes_proforma_invoice = '')
	{
	    $obj_Invoice  = new Invoice();
	    if($quotes_proforma_invoice == '2')
	    {
	                $quotes_proforma_invoice_type = 'invoice'; 	 

	        $query="select a.billed_membername,a.invoiceno 
					from mstusers x
				  	inner join trninvoicetomember a on x.userid = a.userid 
				  	inner join trninvoicetomemberdetails b on a.memberinvoicesid = b.memberinvoicesid
              	inner join mstclients c on b.billed_membercompanyid = c.clientcompanyid
              	inner join mstcompany d on a.billing_membercompanyid=d.companyid
             	 where x.userid =$userid and quotes_proforma_invoice ='2'  and a.memberinvoicesid = $memberinvoicesid";	
	    }     
	    if($quotes_proforma_invoice == '1')
	    {
	        $quotes_proforma_invoice_type = 'Proforma'; 

	        $query="select a.billed_membername,a.invoiceno 
					from mstusers x
				  	inner join trninvoicetomember_frproforma a on x.userid = a.userid 
				  	inner join trninvoicetomemberdetails_frproforma b on a.memberinvoicesid = b.memberinvoicesid
              	inner join mstclients c on b.billed_membercompanyid = c.clientcompanyid
              	inner join mstcompany d on a.billing_membercompanyid=d.companyid
             	where x.userid =$userid and quotes_proforma_invoice ='1'  and a.memberinvoicesid = $memberinvoicesid";	
	    }
	    if($quotes_proforma_invoice == '0')
	    {
	        $quotes_proforma_invoice_type = 'Quotes'; 
	        $query="select a.billed_membername,a.invoiceno 
					from mstusers x
				  	inner join trninvoicetomember_frquotation a on x.userid = a.userid 
				  	inner join trninvoicetomemberdetails_frquotation b on a.memberinvoicesid = b.memberinvoicesid
              	inner join mstclients c on b.billed_membercompanyid = c.clientcompanyid
              	inner join mstcompany d on a.billing_membercompanyid=d.companyid
             	where x.userid =$userid and quotes_proforma_invoice ='0'  and a.memberinvoicesid = $memberinvoicesid";	
        }
		$sqllist2 = $obj_Invoice->getInvoice('',$query);
		$rowcount = count($sqllist2);
		
		$result = "";
		
		if ($rowcount > 0)
		{
			
			for($i=0;$i<$rowcount;$i++) 
		    {
		          $billed_membername    =   $sqllist2[$i]['billed_membername'];            
		          $invoiceno            =   $sqllist2[$i]['invoiceno'];
		          $newurl               =   ucwords(strtolower($billed_membername), " ");
		          $companyname                 =   str_replace(' ','',trim($newurl));
		          $result					=	$quotes_proforma_invoice_type.'-'.$invoiceno.'-'.$companyname;

                  //$result = "invoice.'-'.$invoiceno.'-'.$name";      
		    }
	    }
	     return $result;
	} 
	
	
	function getCompanyList($userid='',$companyid='')
	{
		$units = new AllTables();
		
		// $unitlist = $units->getInfo("","select * from user_company  where memberid = $memberid");
		  $unitlist = $units->getInfo("","select * from ".COMPANY_TABLE." a  inner join ".USERCOMPANYDETAILS_TABLE." b on a.companyid=b.companyid  where b.userid = $userid");
		//print_r($unitlist);
		$rowcount = count($unitlist);
		
		$strunitlist = "";
		
		if ($rowcount > 0)
		{
			
			for($i=0;$i<$rowcount;$i++) 
			{	
				
				   $strunitlist .= '<div class="col-md-6 p-0 text-left"><label><input type="radio" name="optradiocompany" value="'.$unitlist[$i]["companyid"].'">'.ucwords(strtolower($unitlist[$i]["companyname"])).'</label></div>';

			}
		}
		
		return $strunitlist;	
	}
	
	
	
	function getcompanyname($userid='',$companyid='')
	{
	    $units			=	new Company();
		//$sql="select * from user_company where memberid = $G_memberid and membercompanyid = $G_membercompanyid";
		$sql="select * from ".COMPANY_TABLE." a
					inner join ".USERCOMPANYDETAILS_TABLE." b on a.companyid=b.companyid
					where b.userid = $userid and a.companyid = $companyid";

	    $unitlist		=	$units->getCompany('','',$sql);
	
		$rowcount = count($unitlist);
		
		$strunitlist = "";
		
		if ($rowcount > 0)
		{
			
			for($i=0;$i<$rowcount;$i++) 
			{	
				
			    $strunitlist .= '<h2 style="padding: 20px;text-align: center;margin:0">'.ucwords(strtolower($unitlist[$i]["companyname"])).'</h2>';
				
			}
		}
		return $strunitlist;
				

	}
	
	
		function getcsvdataforGSTR1_withTax($where_condition_inCSV,$where_condition_inCSV1)
	{
	   	$obj  = new Company();
	            //with Tax starts here

					  	$sql2 = "select *,e.head_Email,a.memberinvoicesid,a.billed_membercompanyid,a.paid_total_amount,a.billing_membercompanyid,a.invoiceno,a.is_mail_send,
			 				 a.InvoiceTotalAmount,a.invoicedate,a.duedate,a.billed_membername,a.cgst_amount,a.sgst_amount,a.igst_amount,a.cgst_percentage,a.sgst_percentage,a.igst_percentage,c.TotalAmount,a.approved
			 			    from ".USER_TABLE." x
					  		 inner join ".INVOICE_TABLE." a on x.userid = a.userid 
					  		 inner join ".INVOICEDETAILS_TABLE." b on a.memberinvoicesid = b.memberinvoicesid
					  		 inner join ".CLIENT_TABLE." e on b.billed_membercompanyid = e.clientcompanyid
					  		 left join ".PAYMENT_TABLE."  c on a.memberinvoicesid = c.memberinvoicesid
					  		 left join ".PAYMENTDETAILS_TABLE."  d on a.memberinvoicesid = d.memberinvoicesid
					  		 where $where_condition_inCSV  and (igst_amount > 0 or sgst_amount > 0 or cgst_amount > 0) and (a.inv_GST_no != ''  or a.inv_GST_no != 'GST Not available') group by a.memberinvoicesid  order by a.invoicedate ASC";
				
				/*$sql2 = "select *,e.head_Email,a.memberinvoicesid,a.billed_membercompanyid,a.paid_total_amount,a.billing_membercompanyid,a.invoiceno,a.is_mail_send,
			 				 a.InvoiceTotalAmount,a.invoicedate,a.duedate,a.billed_membername,a.cgst_amount,a.sgst_amount,a.igst_amount,a.cgst_percentage,a.sgst_percentage,a.igst_percentage,c.TotalAmount,a.approved
			 			    from ".USER_TABLE." x
					  		 inner join ".INVOICE_TABLE." a on x.userid = a.userid 
					  		 inner join ".INVOICEDETAILS_TABLE." b on a.memberinvoicesid = b.memberinvoicesid
					  		 inner join ".CLIENT_TABLE." e on b.billed_membercompanyid = e.clientcompanyid
					  		 left join ".PAYMENT_TABLE."  c on a.memberinvoicesid = c.memberinvoicesid
					  		 left join ".PAYMENTDETAILS_TABLE."  d on a.memberinvoicesid = d.memberinvoicesid
					  		 where $where_condition_inCSV  and (igst_amount > 0 or sgst_amount > 0 or cgst_amount > 0) and (a.inv_GST_no != ''  or a.inv_GST_no != 'GST Not available') and (igst_amount < 0 and sgst_amount > 0 and  cgst_amount > 0 and a.inv_GST_no != '' or a.inv_GST_no != 'GST Not available') group by a.memberinvoicesid  order by a.invoicedate ASC";
				*/
			/*	$sql2 = "select *,e.head_Email,a.memberinvoicesid,a.billed_membercompanyid,a.paid_total_amount,a.billing_membercompanyid,a.invoiceno,a.is_mail_send,
			 				 a.InvoiceTotalAmount,a.invoicedate,a.duedate,a.billed_membername,a.cgst_amount,a.sgst_amount,a.igst_amount,a.cgst_percentage,a.sgst_percentage,a.igst_percentage,c.TotalAmount,a.approved
			 			    from ".USER_TABLE." x
					  		 inner join ".INVOICE_TABLE." a on x.userid = a.userid 
					  		 inner join ".INVOICEDETAILS_TABLE." b on a.memberinvoicesid = b.memberinvoicesid
					  		 inner join ".CLIENT_TABLE." e on b.billed_membercompanyid = e.clientcompanyid
					  		 left join ".PAYMENT_TABLE."  c on a.memberinvoicesid = c.memberinvoicesid
					  		 left join ".PAYMENTDETAILS_TABLE."  d on a.memberinvoicesid = d.memberinvoicesid
					  		 where $where_condition_inCSV  and a.inv_GST_no != '' and (a.inv_GST_no != 'GST Not applicable' or igst_amount < 0 or sgst_amount > 0 or cgst_amount > 0) and (igst_amount > 0 or sgst_amount > 0 or cgst_amount > 0)  group by a.memberinvoicesid  order by a.invoicedate ASC";
				*/
					//echo $sql2;
				//	die();
					$heading = "Invoice GSTR1";
					$sqllist2 = $obj->getCompany('','',$sql2);
					$rowcount = count($sqllist2);
					if ($sqllist2)
					{
						$rowcount_adv = $rowcount;
					}
					else
					{
						$rowcount_adv=0;
					}
					$maxrows = $rowcount_adv;
					$csvcolumnsname ='"","GST NO","<b>Company Name</b>","Invoice No","Invoice Date","Total Amount with Tax","Basic Amount","IGST","CGST","SGST "'."\n";
					for($i=0;$i<$maxrows;$i++) 
        	 	{ 
	         		$memberinvoicesid							= $sqllist2[$i]['memberinvoicesid'];
	         		$companyid											= $sqllist2[$i]['billed_membercompanyid'];
	         		$billing_membercompanyid			= $sqllist2[$i]['billing_membercompanyid'];
	         		$statusdata											= $sqllist2[$i]['status'];
	         		$invoiceno												= $sqllist2[$i]['invoiceno'];
	         		//$InvoiceTotalAmount				= $sqllist[$i]['InvoiceTotalAmount'];
	         		$invoicedate											= date("j M Y",strtotime($sqllist2[$i]['invoicedate']));
	         		$invoicedatemonth								= date("M Y",strtotime($sqllist2[$i]['invoicedate']));
	
	         		//date("M jS, Y", strtotime("2011-01-05"));
	         		$duedate													= date("j M Y",strtotime($sqllist2[$i]['duedate']));
	         		$billed_membername						= $sqllist2[$i]['billed_membername'];   
	         		$TotalAmount 										= $sqllist2[$i]['TotalAmount']; //total payment by that invoice id
	         		$approved												= $sqllist2[$i]['approved'];  //Invoice approve status
         			$InvoiceBaseAmount							= $sqllist2[$i]['InvoiceBaseAmount'];
					$InvoiceTotalAmount						= $sqllist2[$i]['InvoiceTotalAmount'];
					$inv_GST_no											=	$sqllist2[$i]['inv_GST_no'];
					$is_mail_send										= $sqllist2[$i]['is_mail_send'];
     			  $balance1 												= $InvoiceTotalAmount - $TotalAmount;
         			$paid_total_amount							= $sqllist2[$i]['paid_total_amount'];
         			if($paid_total_amount == '0')
         			{
         		
         			 $balance1 			=			$InvoiceTotalAmount - $TotalAmount;
         			}
         			else
         			{
						$balance1 =  $InvoiceTotalAmount - $paid_total_amount;
         			}

         			$cgst_amount									= $sqllist2[$i]['cgst_amount'];
					$sgst_amount									= $sqllist2[$i]['sgst_amount'];
					$igst_amount									= $sqllist2[$i]['igst_amount'];
					$sgst_percentage 							= $sqllist2[$i]['sgst_percentage'];
					$cgst_percentage 							= $sqllist2[$i]['cgst_percentage'];
					$igst_percentage 							= $sqllist2[$i]['igst_percentage'];

         			$reportname = '"'.$heading.'"'."\n";
         			$resultcsvtotalincome_GSTR1_withtax =getcsvdataforGSTR3B_Total_withtax($where_condition_inCSV1);
                      $resultcsvtotalincom_explode = explode('||',$resultcsvtotalincome_GSTR1_withtax);
             		 $resultcsvtotalincom_explode1 = $resultcsvtotalincom_explode[0];
                    $resultcsvtotalincom_explode2 = $resultcsvtotalincom_explode[1];
					//	$csvtotalincome = "\n".'"","","","","Total","'.$InvoiceBaseAmounts.'","'.$igst_amounts.'","'.$cgst_amounts.'","'.$sgst_amounts.'","'.$InvoiceTotalAmount1.'",""'."\n";
						$csvtotalincome = $resultcsvtotalincom_explode2;

						 $csvdata .= '"'.$invoicedatemonth.'","'.$inv_GST_no.'","'.$billed_membername.'","'.$invoiceno.'","'.$invoicedate.'","'.$InvoiceTotalAmount.'","'.$InvoiceBaseAmount.'","'.$igst_amount.'","'.$cgst_amount.'","'.$sgst_amount.'"'."\n";
						$paymentresultCSV_GSTR1_withtax = $reportname.$csvcolumnsname.$csvdata.$csvtotalincome;
						//	$paymentresultCSV_GSTR1_withtax = $reportname.$csvcolumnsname.$csvdata;

       			 }
       			 
		 return $paymentresultCSV_GSTR1_withtax;
	}
	
	function getcsvdataforGSTR3B_Total_withtax($where_condition_inCSV)
	{
	    $obj_Invoice  = new Invoice();
	    $obj_Memberpaymentheader  = new Memberpaymentheader();

						$sql_invoice2 = "select SUM(InvoiceTotalAmount) as InvoiceTotalAmounts ,SUM(paid_total_amount) as paid_total_amount1,SUM(igst_amount) as igst_amounts,SUM(cgst_amount) as cgst_amounts,SUM(sgst_amount) as sgst_amounts,SUM(ugst_amount) as ugst_amounts,SUM(InvoiceBaseAmount) as InvoiceBaseAmounts
						 from trninvoicetomember a  
						where $where_condition_inCSV  and  (igst_amount > 0 or sgst_amount > 0 or cgst_amount > 0)";
	

	            //echo $sql_invoice2;
						$sql_invoice_list2 = $obj_Invoice->getInvoice('',$sql_invoice2);

						$sql_payment2 = "select SUM(TotalAmount) as TotalAmounts3,SUM(tds) as Totaltds from user_company_payment_header a inner join trninvoicetomember b on a.memberinvoicesid = b.memberinvoicesid 
						where $where_condition_inCSV  and  (igst_amount > 0 or sgst_amount > 0 or cgst_amount > 0)";

                //echo $sql_payment2;

				$sql_paymentlist2 = $obj_Memberpaymentheader->getMemberpaymentheader('',$sql_payment2);
						
	            //echo $sql_invoice1;
						$sql_invoice_list2 = $obj_Invoice->getInvoice('',$sql_invoice2);
	
		
			
						$InvoiceTotalAmount1  		= $sql_invoice_list2[0]['InvoiceTotalAmounts'];
						$igst_amounts  				= $sql_invoice_list2[0]['igst_amounts'];
						$cgst_amounts  				= $sql_invoice_list2[0]['cgst_amounts'];
						$sgst_amounts  				= $sql_invoice_list2[0]['sgst_amounts'];
						$ugst_amounts  				= $sql_invoice_list2[0]['ugst_amounts'];
						$InvoiceBaseAmounts  		= $sql_invoice_list2[0]['InvoiceBaseAmounts'];
						$TotalAmounts3  		    = $sql_paymentlist2[0]['TotalAmounts3'];
						$paid_total_amount1  		= $sql_invoice_list2[0]['paid_total_amount1'];
						$Totaltds  				    = $sql_paymentlist2[0]['Totaltds'];

				if($paid_total_amount1 == '0')
         		{
         			$balance1sds 							= $InvoiceTotalAmount1 - $TotalAmounts3-$Totaltds;
         		}
         		else
         		{
					
					$balance1sds= $InvoiceTotalAmount1 - $paid_total_amount1-$Totaltds;
					
         		}
	
                $result1 = "\n".'"Total","'.$InvoiceBaseAmounts.'","'.$igst_amounts.'","'.$cgst_amounts.'","'.$sgst_amounts.'","'.$InvoiceTotalAmount1.'",""'."\n";
				$result2 = "\n".'"","","","","Total","'.$InvoiceTotalAmount1.'","'.$InvoiceBaseAmounts.'","'.$igst_amounts.'","'.$cgst_amounts.'","'.$sgst_amounts.'",""'."\n";
                $result  = $result1."||".$result2; 
	            return  $result;     
	}
	
	function getcsvdataforGSTR1_withouttax($where_condition_inCSV,$where_condition_inCSV1)
	{
	   	$obj  = new Company();
	    //without tax starts

					  		$sql2 = "select *,e.head_Email,a.memberinvoicesid,a.billed_membercompanyid,a.paid_total_amount,a.billing_membercompanyid,a.invoiceno,a.is_mail_send,
			 				 a.InvoiceTotalAmount,a.invoicedate,a.duedate,a.billed_membername,a.cgst_amount,a.sgst_amount,a.igst_amount,a.cgst_percentage,a.sgst_percentage,a.igst_percentage,c.TotalAmount,a.approved
			 			    from  ".USER_TABLE." x
					  		 inner join ".INVOICE_TABLE." a on x.userid = a.userid 
					  		 inner join ".INVOICEDETAILS_TABLE." b on a.memberinvoicesid = b.memberinvoicesid
					  		 inner join ".CLIENT_TABLE." e on b.billed_membercompanyid = e.clientcompanyid
					  		 left join ".PAYMENT_TABLE."  c on a.memberinvoicesid = c.memberinvoicesid
					  		 left join ".PAYMENTDETAILS_TABLE."  d on a.memberinvoicesid = d.memberinvoicesid
					  		 where $where_condition_inCSV and  igst_amount =0 and sgst_amount=0 and cgst_amount =0 group by a.memberinvoicesid  order by a.invoicedate ASC";

				//	echo $sql2;
					//die();
					//$heading = "Invoice GSTR1";
					$heading = "";
					$sqllist2 = $obj->getCompany('','',$sql2);
					$rowcount = count($sqllist2);
					if ($sqllist2)
					{
						$rowcount_adv = $rowcount;
					}
					else
					{
						$rowcount_adv=0;
					}
					$maxrows = $rowcount_adv;
					//$csvcolumnsname ='"","GST NO","<b>GST Not Applicable</b>","Invoice No","Invoice Date","Total Amount with Tax","IGST","CGST","SGST","Basic Amount"'."\n";
                    $csvcolumnsname ='"","","<b>GST Not Applicable</b>","","","","","",""," "'."\n";


			 for($i=0;$i<$maxrows;$i++) 
         	{ 
         		$memberinvoicesid					= $sqllist2[$i]['memberinvoicesid'];
         		$companyid							= $sqllist2[$i]['billed_membercompanyid'];
         		$billing_membercompanyid		= $sqllist2[$i]['billing_membercompanyid'];
         		$statusdata							= $sqllist2[$i]['status'];
         		$invoiceno							= $sqllist2[$i]['invoiceno'];
         		//$InvoiceTotalAmount				= $sqllist[$i]['InvoiceTotalAmount'];
         		$invoicedate						= date("j M Y",strtotime($sqllist2[$i]['invoicedate']));
         		$invoicedatemonth						= date("M Y",strtotime($sqllist2[$i]['invoicedate']));

         		//date("M jS, Y", strtotime("2011-01-05"));
         		$duedate								= date("j M Y",strtotime($sqllist2[$i]['duedate']));
         		$billed_membername				= $sqllist2[$i]['billed_membername'];   
         		$TotalAmount 						= $sqllist2[$i]['TotalAmount']; //total payment by that invoice id
         		$approved							= $sqllist2[$i]['approved'];  //Invoice approve status
         			$InvoiceBaseAmount			= $sqllist2[$i]['InvoiceBaseAmount'];
					$InvoiceTotalAmount			= $sqllist2[$i]['InvoiceTotalAmount'];
					$inv_GST_no						=	$sqllist2[$i]['inv_GST_no'];
         	
					$is_mail_send						= $sqllist2[$i]['is_mail_send'];
     			  $balance1 							= $InvoiceTotalAmount - $TotalAmount;
         			$paid_total_amount				= $sqllist2[$i]['paid_total_amount'];
         			if($paid_total_amount == '0')
         			{
         		
         			 $balance1 							= $InvoiceTotalAmount - $TotalAmount;
         			}
         			else
         			{
         	
						$balance1 =  $InvoiceTotalAmount - $paid_total_amount;
         			}

         			$cgst_amount					= $sqllist2[$i]['cgst_amount'];
			
					$sgst_amount					= $sqllist2[$i]['sgst_amount'];
					$igst_amount					= $sqllist2[$i]['igst_amount'];
					$sgst_percentage 				= $sqllist2[$i]['sgst_percentage'];
					$cgst_percentage 				= $sqllist2[$i]['cgst_percentage'];
					$igst_percentage 				= $sqllist2[$i]['igst_percentage'];


         				$reportname = '"'.$heading.'"'."\n";
         				$resultcsvtotalincome_GSTR1_withtax =getcsvdataforGSTR3B_Total_withouttax($where_condition_inCSV1);
                        $resultcsvtotalincom_explode = explode('||',$resultcsvtotalincome_GSTR1_withtax);
                        $resultcsvtotalincom_explode1 = $resultcsvtotalincom_explode[0];
                        $resultcsvtotalincom_explode2 = $resultcsvtotalincom_explode[1];
						//$csvtotalincome = "\n".'"","","","","Total","'.$InvoiceBaseAmounts.'","'.$igst_amounts.'","'.$cgst_amounts.'","'.$sgst_amounts.'","'.$InvoiceTotalAmount1.'",""'."\n";
						$csvtotalincome = $resultcsvtotalincom_explode2;

						$csvdata .= '"'.$invoicedatemonth.'","'.$inv_GST_no.'","'.$billed_membername.'","'.$invoiceno.'","'.$invoicedate.'","'.$InvoiceTotalAmount.'","'.$InvoiceBaseAmount.'","'.$igst_amount.'","'.$cgst_amount.'","'.$sgst_amount.'"'."\n";
						$paymentresultCSV_GSTR1_withouttax = $reportname.$csvcolumnsname.$csvdata.$csvtotalincome;

       			 }
       			 return $paymentresultCSV_GSTR1_withouttax;
	}
	
	function getcsvdataforGSTR3B_Total_withouttax($where_condition_inCSV)
	{
	    $obj_Invoice  = new Invoice();
	    $obj_Memberpaymentheader  = new Memberpaymentheader();

			$sql_invoice2 = "select SUM(InvoiceTotalAmount) as InvoiceTotalAmounts ,SUM(paid_total_amount) as paid_total_amount1,SUM(igst_amount) as igst_amounts,SUM(cgst_amount) as cgst_amounts,SUM(sgst_amount) as sgst_amounts,SUM(ugst_amount) as ugst_amounts,SUM(InvoiceBaseAmount) as InvoiceBaseAmounts from trninvoicetomember a  
			where $where_condition_inCSV  and  igst_amount =0 and sgst_amount=0 and cgst_amount =0";

	        //  echo $sql_invoice2;
			$sql_invoice_list2 = $obj_Invoice->getInvoice('',$sql_invoice2);

			$sql_payment2 = "select SUM(TotalAmount) as TotalAmounts3,SUM(tds) as Totaltds
												 from user_company_payment_header a 
												inner join trninvoicetomember b on a.memberinvoicesid = b.memberinvoicesid 
											where $where_condition_inCSV  and  igst_amount =0 and sgst_amount=0 and cgst_amount =0";
				
                //echo $sql_payment2;

				$sql_paymentlist2 = $obj_Memberpaymentheader->getMemberpaymentheader('',$sql_payment2);
						
	            //echo $sql_invoice1;
						$sql_invoice_list2 = $obj_Invoice->getInvoice('',$sql_invoice2);
	
		
			
						$InvoiceTotalAmount1  		= $sql_invoice_list2[0]['InvoiceTotalAmounts'];
						$igst_amounts  				= $sql_invoice_list2[0]['igst_amounts'];
						$cgst_amounts  				= $sql_invoice_list2[0]['cgst_amounts'];
						$sgst_amounts  				= $sql_invoice_list2[0]['sgst_amounts'];
						$ugst_amounts  				= $sql_invoice_list2[0]['ugst_amounts'];
						$InvoiceBaseAmounts  		= $sql_invoice_list2[0]['InvoiceBaseAmounts'];
						$TotalAmounts3  		    = $sql_paymentlist2[0]['TotalAmounts3'];
						$paid_total_amount1  		= $sql_invoice_list2[0]['paid_total_amount1'];
						$Totaltds  				    = $sql_paymentlist2[0]['Totaltds'];

				if($paid_total_amount1 == '0')
         		{
         			$balance1sds 							= $InvoiceTotalAmount1 - $TotalAmounts3-$Totaltds;
         		}
         		else
         		{
					
					$balance1sds= $InvoiceTotalAmount1 - $paid_total_amount1-$Totaltds;
					
         		}
	
                $result1 = "\n".'"Total","'.$InvoiceBaseAmounts.'","'.$igst_amounts.'","'.$cgst_amounts.'","'.$sgst_amounts.'","'.$InvoiceTotalAmount1.'",""'."\n";
					$result2 = "\n".'"","","","","Total","'.$InvoiceTotalAmount1.'","'.$InvoiceBaseAmounts.'","'.$igst_amounts.'","'.$cgst_amounts.'","'.$sgst_amounts.'",""'."\n";
                $result  = $result1."||".$result2;
	            return  $result; 
	                 
	}

	function getcsvdataforGSTR3B_withouttax($userid,$companyid,$where_date_range_condition,$where_condition_inCSV_Total)
	{
	    $obj_Invoice  = new Invoice();
	    $obj_Memberpaymentheader  = new Memberpaymentheader();

				$sql_invoice4 = "select *,CONCAT(MONTHNAME(invoicedate),'-',YEAR(invoicedate)) as 
					invoicedate_ym ,COUNT(*),SUM(cgst_amount) as cgst_amount,SUM(sgst_amount) as sgst_amount,SUM(igst_amount) as igst_amount,SUM(InvoiceBaseAmount) as InvoiceBaseAmount,SUM(InvoiceTotalAmount) as InvoiceTotalAmount 
					from ".INVOICE_TABLE."
					where  billing_membercompanyid=$companyid and isdeleted=0 $where_date_range_condition and  quotes_proforma_invoice = 2 and igst_amount =0 and sgst_amount=0 and cgst_amount =0 GROUP by MONTH(invoicedate)";
	$heading4 = "GSTR 3 B  - Non Taxable Amount";
	$sql_invoice_list4 = $obj_Invoice->getInvoice('',$sql_invoice4);

	$rowcount4 = count($sql_invoice_list4);
	if ($sql_invoice_list4)
	{
		$rowcount_adv4 = $rowcount4;
	}
	else
	{
		$rowcount_adv4=0;
	}
			
	$maxrows4 = $rowcount_adv4;
	$csvcolumnsname4 ='"","Amount","IGST","CGST","SGST","Total"'."\n";

		for($i=0;$i<$maxrows4;$i++) 
   		{ 
         		$memberinvoicesid					= $sql_invoice_list4[$i]['memberinvoicesid'];
         		$companyid							= $sql_invoice_list4[$i]['billed_membercompanyid'];
         		$billing_membercompanyid		= $sql_invoice_list4[$i]['billing_membercompanyid'];
         		
         		$invoiceno							= $sql_invoice_list4[$i]['invoiceno'];
         		
         		$invoicedatemonth1						= date("M Y",strtotime($sql_invoice_list4[$i]['invoicedate_ym']));
         		//date("M jS, Y", strtotime("2011-01-05"));
         			$duedate								= date("j M Y",strtotime($sql_invoice_list4[$i]['duedate']));
         		
         			$InvoiceBaseAmount			= $sql_invoice_list4[$i]['InvoiceBaseAmount'];
					$InvoiceTotalAmount			= $sql_invoice_list4[$i]['InvoiceTotalAmount'];
         			$cgst_amount					= $sql_invoice_list4[$i]['cgst_amount'];
					$sgst_amount					= $sql_invoice_list4[$i]['sgst_amount'];
					$igst_amount					= $sql_invoice_list4[$i]['igst_amount'];
					$sgst_percentage 				= $sql_invoice_list4[$i]['sgst_percentage'];
					$cgst_percentage 				= $sql_invoice_list4[$i]['cgst_percentage'];
					$igst_percentage 				= $sql_invoice_list4[$i]['igst_percentage'];
					//$InvoiceTotalAmount1  				= $sql_invoice_list4[$i]['InvoiceTotalAmounts'];

         				$reportname4 = '"'.$heading4.'"'."\n";
					
						//$csvtotalincome4 = "\n".'"Total","'.$InvoiceBaseAmounts.'","'.$igst_amounts.'","'.$cgst_amounts.'","'.$sgst_amounts.'","'.$InvoiceTotalAmount1.'",""'."\n";
						$resultcsvtotalincome4 =getcsvdataforGSTR3B_Total_withouttax($where_condition_inCSV_Total);
						$resultcsvtotalincom_explode = explode('||',$resultcsvtotalincome4);
                        $resultcsvtotalincom_explode1 = $resultcsvtotalincom_explode[0];
                        
						$csvtotalincome4 = $resultcsvtotalincom_explode1;
						//$csvtotalincome4 = $resultcsvtotalincome4;
						$csvdata4 .= '"'.$invoicedatemonth1.'","'.$InvoiceBaseAmount.'","'.$igst_amount.'","'.$cgst_amount.'","'.$sgst_amount.'","'.$InvoiceTotalAmount.'"'."\n";
						$paymentresultCSV_withouttax1 = $reportname4.$csvcolumnsname4.$csvdata4.$csvtotalincome4;
		}
	   	return  $paymentresultCSV_withouttax1; 
	                 
	}

	function getcsvdataforGSTR3B_withtax($userid,$companyid,$where_date_range_condition,$where_condition_inCSV_Total)
	{
	    $obj_Invoice  = new Invoice();
	    $obj_Memberpaymentheader  = new Memberpaymentheader();

		$sql_invoice1 = "select *,CONCAT(MONTHNAME(invoicedate),'-',YEAR(invoicedate)) as 	
					invoicedate_ym ,COUNT(*),SUM(cgst_amount) as cgst_amount,SUM(sgst_amount) as sgst_amount,SUM(igst_amount) as igst_amount,SUM(InvoiceBaseAmount) as InvoiceBaseAmount,SUM(InvoiceTotalAmount) as InvoiceTotalAmount 
					from ".INVOICE_TABLE."
					where billing_membercompanyid=$companyid and isdeleted=0  $where_date_range_condition and  quotes_proforma_invoice = 2 and (igst_amount > 0 or sgst_amount > 0 or cgst_amount > 0) GROUP by MONTH(invoicedate)";

	$heading1 = "GSTR 3 B - Taxable Amount";
	$sql_invoice_list1 = $obj_Invoice->getInvoice('',$sql_invoice1);
	$rowcount1 = count($sql_invoice_list1);
	if ($sql_invoice_list1)
	{
		$rowcount_adv1 = $rowcount1;
	}
	else
	{
		$rowcount_adv1=0;
	}
	$maxrows1 = $rowcount_adv1;
	$csvcolumnsname1 ='"","Amount","IGST","CGST","SGST","Total"'."\n";
		for($i=0;$i<$maxrows1;$i++) 
    	{ 
         		$memberinvoicesid					= $sql_invoice_list1[$i]['memberinvoicesid'];
         		$companyid							= $sql_invoice_list1[$i]['billed_membercompanyid'];
         		$billing_membercompanyid		= $sql_invoice_list1[$i]['billing_membercompanyid'];
         		
         		$invoiceno							= $sql_invoice_list1[$i]['invoiceno'];
         		
         		$invoicedatemonth1						= date("M Y",strtotime($sql_invoice_list1[$i]['invoicedate_ym']));
         		//date("M jS, Y", strtotime("2011-01-05"));
         			$duedate								= date("j M Y",strtotime($sql_invoice_list1[$i]['duedate']));
         		
         			$InvoiceBaseAmount			= $sql_invoice_list1[$i]['InvoiceBaseAmount'];
					$InvoiceTotalAmount			= $sql_invoice_list1[$i]['InvoiceTotalAmount'];
					
         	
				
         			$cgst_amount					= $sql_invoice_list1[$i]['cgst_amount'];
			
					$sgst_amount					= $sql_invoice_list1[$i]['sgst_amount'];
					$igst_amount					= $sql_invoice_list1[$i]['igst_amount'];
					$sgst_percentage 				= $sql_invoice_list1[$i]['sgst_percentage'];
					$cgst_percentage 				= $sql_invoice_list1[$i]['cgst_percentage'];
					$igst_percentage 				= $sql_invoice_list1[$i]['igst_percentage'];
					//$InvoiceTotalAmount1  				= $sql_invoice_list1[$i]['InvoiceTotalAmounts'];
					if($cgst_amount > '0' || $igst_amount > '0'|| $sgst_amount > '0')
                    {
         				$reportname1 = '"'.$heading1.'"'."\n";
						$result_totalscsv_withtax= getcsvdataforGSTR3B_Total_withtax($where_condition_inCSV_Total);
			            //working   //$csvtotalincome1 = "\n".'"Total","'.$InvoiceBaseAmounts.'","'.$igst_amounts.'","'.$cgst_amounts.'","'.$sgst_amounts.'","'.$InvoiceTotalAmount1.'",""'."\n";
						 $resultcsvtotalincom_explode = explode('||',$result_totalscsv_withtax);
                        $resultcsvtotalincom_explode1 = $resultcsvtotalincom_explode[0];
                        $csvtotalincome1 = $resultcsvtotalincom_explode1;

						$csvdata1 .= '"'.$invoicedatemonth1.'","'.$InvoiceBaseAmount.'","'.$igst_amount.'","'.$cgst_amount.'","'.$sgst_amount.'","'.$InvoiceTotalAmount.'"'."\n";
						//$paymentresultCSV1 = $reportname1.$csvcolumnsname1.$csvdata1.$csvtotalincome1; //working
						$paymentresultCSV_withtax1 = $reportname1.$csvcolumnsname1.$csvdata1.$csvtotalincome1; 
                    }
    	}
	            return  $paymentresultCSV_withtax1;     
	}


	function getcsvdataforRiceiptTally($where_condition_inCSV)
	{
		$obj_Invoice  = new Invoice();
	    $obj_Memberpaymentheader  = new Memberpaymentheader();

	      $sql_invoice_tally = "select a.memberinvoicesid,a.billed_membercompanyid,
						a.billing_membercompanyid,a.userid,a.invoiceno,d.head_receipt_no,d.head_receipt_date,d.TotalAmount,e.bankname,d.tds,e.branch,e.transition_no,
						e.chequeno,e.mode_of_payment,e.transition_amount,e.chequeamount,e.transition_date,e.chequedate 
						from ".USER_TABLE." x
						inner join ".INVOICE_TABLE." a on x.userid = a.userid
						inner join ".INVOICEDETAILS_TABLE." b on a.memberinvoicesid = b.memberinvoicesid
						inner join ".CLIENT_TABLE." c on x.head_Stateid = c.head_Stateid1
						inner join ".PAYMENT_TABLE."  d on a.memberinvoicesid = d.memberinvoicesid
						inner join ".PAYMENTDETAILS_TABLE."  e on d.memberpaymentheaderid = e.memberpaymentheaderid
						where $where_condition_inCSV 
					  	group by d.head_receipt_no order by a.invoicedate,CAST(a.invoiceno AS unsigned),CAST(d.head_receipt_no AS unsigned)";
					// $heading1 = "GSTR 3 B";
	$heading_tally = "Receipt Format Report For Tally";

	$invoicelist_tally = $obj_Invoice -> getInvoice('',$sql_invoice_tally);
	$rowcount_tally = count($invoicelist_tally);
	if ($invoicelist_tally)
	{
		$rowcount_adv_tally = $rowcount_tally;
	}
	else
	{
		$rowcount_adv_tally=0;
	}

	$maxrows_tally = $rowcount_adv_tally;
	$csvcolumnsname_tally ='"Sr.No","Receipt No","Receipt Date","Client Name","Invoice No","Receipt Amount","TDS","Transition No","Cheque No","Bank Name","Branch Name"'."\n";

			for($i=0;$i<$maxrows_tally;$i++) 
         	{ 
         		$memberinvoicesid					= $invoicelist_tally[$i]['memberinvoicesid'];
         		$companyid							= $invoicelist_tally[$i]['billed_membercompanyid'];
         		$billing_membercompanyid		= $invoicelist_tally[$i]['billing_membercompanyid'];
         		
         		$userid								= 	$invoicelist_tally[$i]['userid'];
										$MemberName 							= 	str_replace("'","",$invoicelist_tally[$i]['billed_membername']);
										$invoiceno							= $invoicelist_tally[$i]['invoiceno'];
									 	//$invoicesrno							= 	$invoicelist_tally[$i]['invoicesrno'];
									 		$head_receipt_no					= $invoicelist_tally[$i]['head_receipt_no'];
									 	$head_receipt_date_for_check		=  $invoicelist_tally[$i]['head_receipt_date'];	
									 	$head_receipt_date 					= 	date("d-m-Y", strtotime($invoicelist_tally[$i]['head_receipt_date']));	
									 	$TotalAmount 							= 	$invoicelist_tally[$i]['TotalAmount'];
									 	$chequeno 								=	str_replace("'","",$invoicelist_tally[$i]['chequeno']);
										//$bankname 								= 	$invoicelist_tally[$i]['bankname'];
										//$branch 									= 	$invoicelist_tally[$i]['branch'];
										$bankname						= $invoicelist_tally[$i]['bankname'];
											$Totaltdsamount  				= $invoicelist_tally[$i]['tds'];
										$branch						= $invoicelist_tally[$i]['branch'];
										$counter									=	$i+1;
										$transition_no						= $invoicelist_tally[$i]['transition_no'];
										$paymentno						= $invoicelist_tally[$i]['chequeno'];
										$mode_of_payment  				= $invoicelist_tally[$i]['mode_of_payment']; 
										if($mode_of_payment == 'Online_Pay'){
         									
         									$chequeamount						= $invoicelist_tally[$i]['transition_amount'];
         									$payment_date						= date("d-m-Y",strtotime($invoicelist_tally[$i]['transition_date']));  
         									//$bankname						= '';
											//$branch						= '';

											}	
											else{
												
												$chequeamount						= $invoicelist_tally[$i]['chequeamount'];
												
												$payment_date						= date("d-m-Y",strtotime($invoicelist_tally[$i]['chequedate'])); 
											}


         				$reportname_tally = '"'.$heading_tally.'"'."\n";
						//$csvtotalincome1 = "\n".'"","","","","Total Amount","'.$InvoiceTotalAmount1.'",""'."\n";
					//	$csvtotalincome1 = "\n".'"Total","'.$InvoiceBaseAmounts.'","'.$igst_amounts.'","'.$cgst_amounts.'","'.$sgst_amounts.'","'.$InvoiceTotalAmount1.'",""'."\n";
						
					$csvdata_tally .= '"'.$counter.'","'.$head_receipt_no.'","'.$head_receipt_date.'","'.$MemberName.'","'.$invoiceno.'","'.$TotalAmount.'","'.$Totaltdsamount.'","'.$transition_no.'","'.$paymentno.'","'.$bankname.'","'.$branch.'"'."\n";
						//$paymentresultCSV = $reportname1.$csvcolumnsname1.$csvdata1.$csvtotalincome1;
						$paymentresultCSV2 = $reportname_tally.$csvcolumnsname_tally.$csvdata_tally;
			}
	            return  $paymentresultCSV2;     
	}


	
	function getcsvdataforInvoiceList($where_salse_representive_incsv,$companyid,$where_paymentmode,$where_date_range_condition)
	{
		$obj_Invoice  = new Invoice();
	    $obj_Memberpaymentheader  = new Memberpaymentheader();

	    
    $sql_invoice_tally1 = "SELECT c.userid,invoicesrno,invoicedate,invoiceno,billed_membername,
    						itemno,productname,product_description,ProductTotalAmount,igst_amount,cgst_amount,sgst_amount,inv_head_stateid,inv_StateName,inv_GST_no, InvoiceBaseAmount, InvoiceTotalAmount,(a.memberinvoicesid) as memberinvoicesid, (b.memberinvoicesid) as detailsmemberinvoicesid
							FROM ".INVOICE_TABLE." a 
							inner join ".INVOICEDETAILS_TABLE." b on a.memberinvoicesid=b.memberinvoicesid
							inner join ".USER_TABLE." c on a.userid=c.userid
							where c.$where_salse_representive_incsv  a.billing_membercompanyid=$companyid $where_paymentmode  $where_date_range_condition and  a.isdeleted= 0 and a.quotes_proforma_invoice = 2 
					  		order by a.invoicedate,CAST(a.invoiceno AS unsigned)";
					  		 $reportheader = 'Invoice List';

    $invoicelist_tally1 = $obj_Invoice -> getInvoice('',$sql_invoice_tally1);
	$rowcount_tally1 = count($invoicelist_tally1);
	if ($invoicelist_tally1)
	{
		$rowcount_adv_tally1 = $rowcount_tally1;
	}
	else
	{
		$rowcount_adv_tally1=0;
	}
	$maxrows_tally1 = $rowcount_adv_tally1;

	$maxrows_tally1 = $rowcount_adv_tally1;
	//$csvcolumnsname_tally ='"Sr.No","Receipt No","Receipt Date","Client Name","Invoice No","Receipt Amount","TDS","Transition No","Cheque No","Bank Name","Branch Name"'."\n";
	$csvcolumnsname4 ='"","<b>Company Name</b>","Invoice No","Invoice Date","GST NO","itemno","productname","product_description","ProductTotalAmount","Amount","IGST","CGST","SGST","Total"'."\n";
			for($i=0;$i<$maxrows_tally1;$i++) 
         	{ 
         		$memberinvoicesid					= $invoicelist_tally1[$i]['memberinvoicesid'];
         		$detailsmemberinvoicesid					= $invoicelist_tally1[$i]['detailsmemberinvoicesid'];
         		
         		$companyid							= $invoicelist_tally1[$i]['billed_membercompanyid'];
         		$billing_membercompanyid		= $invoicelist_tally1[$i]['billing_membercompanyid'];
         		$statusdata							= $invoicelist_tally1[$i]['status'];
         		//$invoiceno							= $invoicelist_tally1[$i]['invoiceno'];
         		//$InvoiceTotalAmount				= $sqllist[$i]['InvoiceTotalAmount'];
         		$invoicesrno								= 	$invoicelist_tally1[$i]['invoiceno'];
				$InvoiceBaseAmount			= $invoicelist_tally1[$i]['InvoiceBaseAmount'];
         		$invoicedate						= date("j M Y",strtotime($invoicelist_tally1[$i]['invoicedate']));
         		$monthdetails						= date("M Y",strtotime($invoicelist_tally1[$i]['invoicedate']));

         		//date("M jS, Y", strtotime("2011-01-05"));
         		$duedate								= date("j M Y",strtotime($invoicelist_tally1[$i]['duedate']));
         		$billed_membername				= $invoicelist_tally1[$i]['billed_membername'];   
         		$TotalAmount 						= $invoicelist_tally1[$i]['TotalAmount']; //total payment by that invoice id
         		$approved							= $invoicelist_tally1[$i]['approved'];  //Invoice approve status
         		
					$InvoiceTotalAmount			= $invoicelist_tally1[$i]['InvoiceTotalAmount'];
					$inv_GST_no						=	$invoicelist_tally1[$i]['inv_GST_no'];
         			
					$itemno						=	$invoicelist_tally1[$i]['itemno'];
					$productname						=	$invoicelist_tally1[$i]['productname'];
					$product_description						=	$invoicelist_tally1[$i]['product_description'];
					$ProductTotalAmount						=	$invoicelist_tally1[$i]['ProductTotalAmount'];


					$is_mail_send						= $invoicelist_tally1[$i]['is_mail_send'];
     			  $balance1 							= $InvoiceTotalAmount - $TotalAmount;
         			$paid_total_amount				= $invoicelist_tally1[$i]['paid_total_amount'];
         			if($paid_total_amount == '0')
         			{
         		
         			 $balance1 							= $InvoiceTotalAmount - $TotalAmount;
         			}
         			else
         			{
         	
						$balance1 =  $InvoiceTotalAmount - $paid_total_amount;
         			}

         			$cgst_amount					= $invoicelist_tally1[$i]['cgst_amount'];
			
					$sgst_amount					= $invoicelist_tally1[$i]['sgst_amount'];
					$igst_amount					= $invoicelist_tally1[$i]['igst_amount'];
					$sgst_percentage 				= $invoicelist_tally1[$i]['sgst_percentage'];
					$cgst_percentage 				= $invoicelist_tally1[$i]['cgst_percentage'];
					$igst_percentage 				= $invoicelist_tally1[$i]['igst_percentage'];
					$invoicesrno_for_display 			= 	$invoicesrno;
					$invoicedatemonthdetails= 	$monthdetails;

         				$reportname4 = '"'.$heading.'"'."\n";
						//$csvtotalincome = "\n".'"","","","","","","","","Total Amount","'.$InvoiceTotalAmount1.'",""'."\n";
						
         		
						$csvtotalincome4 = "\n".'"","","","","Total","'.$InvoiceBaseAmounts.'","'.$igst_amounts.'","'.$cgst_amounts.'","'.$sgst_amounts.'","'.$InvoiceTotalAmount1.'",""'."\n";
						
					if($invoicesrno_for_display == $invoiceno)
					{
						//$csvdata4 .= '"","","","","","'.$itemno.'","'.$productname.'","'.$product_description.'","'.$ProductTotalAmount.'","","","","",""'."\n".'"","","","","","","","Total","'.$InvoiceBaseAmount.'","'.$InvoiceBaseAmount.'","'.$igst_amount.'","'.$cgst_amount.'","'.$sgst_amount.'","'.$InvoiceTotalAmount.'"'."\n";
						$csvdata4 .= '"","","","","","'.$itemno.'","'.$productname.'","'.$product_description.'","'.$ProductTotalAmount.'","","","","",""'."\n";
					}
					else
					{
						if($invoicedatemonthdetails == $invoicedatemonth)
						{

							$csvdata4 .= '"","'.$billed_membername.'","'.$invoicesrno_for_display.'","'.$invoicedate.'","'.$inv_GST_no.'","'.$itemno.'","'.$productname.'","'.$product_description.'","'.$ProductTotalAmount.'","'.$InvoiceBaseAmount.'","'.$igst_amount.'","'.$cgst_amount.'","'.$sgst_amount.'","'.$InvoiceTotalAmount.'"'."\n";
						}
						else
						{

							$csvdata4 .= '"'.$invoicedatemonthdetails.'","'.$billed_membername.'","'.$invoicesrno_for_display.'","'.$invoicedate.'","'.$inv_GST_no.'","'.$itemno.'","'.$productname.'","'.$product_description.'","'.$ProductTotalAmount.'","'.$InvoiceBaseAmount.'","'.$igst_amount.'","'.$cgst_amount.'","'.$sgst_amount.'","'.$InvoiceTotalAmount.'"'."\n";
						}
					}
					$invoiceno = $invoicesrno_for_display;
					$invoicedatemonth = $invoicedatemonthdetails;
					
				$searchresultCSV = $reportheader.$csvcolumnsname4.$csvdata4;
			}

	        return  $searchresultCSV;     
	}
	
	function getAllLeadTypeForListForCombo($leadforid)
	{
		$obj = new AllTables();

		$leadforlist = $obj->getInfo("","select * from mstleadfor ORDER BY leadforid");

		$rowcount = count($leadforlist);
		
		$strleadforList = "";
		
		if ($rowcount > 0)
		{
			
			for($i=0;$i<$rowcount;$i++) 
			{	
				
				if(strtolower($leadforid) == strtolower($leadforlist[$i]['leadforid']))
				{
					$strleadforList .= '<option value="'.$leadforlist[$i]["leadforid"].'" selected="selected">'.ucwords(strtolower($leadforlist[$i]["leadforname"])).'</option>';
				}
				else
				{	
					$strleadforList .= '<option value="'.$leadforlist[$i]["leadforid"].'">'.ucwords(strtolower($leadforlist[$i]["leadforname"])).'</option>';
				}
			}
		}
		return $strleadforList;	
	}		
	
		function getAllLeadSourceListForCombo($leadsourceid)
	{
		$obj = new AllTables();
		//echo $companyname;

		//$representlist = $representatives->getInfo("","select * from mstrepresentative where membercompanyid=$membercompanyid");
		$leadsourceilist = $obj->getInfo("","select * from mstleadsource ORDER BY leadsourceid");

		$rowcount = count($leadsourceilist);
		
		$strleadsourceiList = "";
		
		if ($rowcount > 0)
		{
			
			for($i=0;$i<$rowcount;$i++) 
			{	
				
				if(strtolower($leadsourceid) == strtolower($leadsourceilist[$i]['leadsourceid']))
				{
					$strleadsourceiList .= '<option value="'.$leadsourceilist[$i]["leadsourceid"].'" selected="selected">'.ucwords(strtolower($leadsourceilist[$i]["leadsourcename"])).'</option>';
				}
				else
				{	
					$strleadsourceiList .= '<option value="'.$leadsourceilist[$i]["leadsourceid"].'">'.ucwords(strtolower($leadsourceilist[$i]["leadsourcename"])).'</option>';
				}
			}
		}
		return $strleadsourceiList;	
	}	
	
	function getAllLeadscoreListforCombo($leadscoreid)
	{
		$obj = new AllTables();

		$leadscorelist = $obj->getInfo("","select * from mstleadscore ORDER BY leadscoreid");

		$rowcount = count($leadscorelist);
		
		$strleadscoreList = "";
		
		if ($rowcount > 0)
		{
			
			for($i=0;$i<$rowcount;$i++) 
			{	
				
				if(strtolower($leadscoreid) == strtolower($leadscorelist[$i]['leadscoreid']))
				{
					$strleadscoreList .= '<option value="'.$leadscorelist[$i]["leadscoreid"].'" selected="selected">'.ucwords(strtolower($leadscorelist[$i]["leadscorename"])).'</option>';
				}
				else
				{	
					$strleadscoreList .= '<option value="'.$leadscorelist[$i]["leadscoreid"].'">'.ucwords(strtolower($leadscorelist[$i]["leadscorename"])).'</option>';
				}
			}
		}
		return $strleadscoreList;	
	}		
	
	function getleadlastsdate($leadid='')
	{
		
		$obj_Leads 			= new Leads();
		
	 	$sql2 ="SELECT firstcontactdate,nextcontactdate	FROM trnleadsdetails where leadid=$leadid ORDER BY nextcontactdate DESC limit 0,1";
 						
 						
		$leadslist1 = $obj_Leads-> getLeads('','',$sql2);
		if(is_array($leadslist1))
			{
				$rowcount = count($leadslist1);
				
			}
			if($rowcount > 0)
			{
				$Contact_date 							= $leadslist1[0]['nextcontactdate'];  
         		$firstContact_date 						= $leadslist1[0]['firstcontactdate'];    
				    
			}
		return $Contact_date."|".$firstContact_date;	
	}
	
	function getAllOrderInvoiceListForCombo($orderinvoicesid,$companyid,$G_FinancialYrStarAndEndDate)
	{
		$order = new AllTables();
        
        if($G_FinancialYrStarAndEndDate > 0) 
		{
			$FinancialYrDates 						= explode('||',$G_FinancialYrStarAndEndDate);
		//print_r($G_FinancialYrStarAndEndDate);
		$FinancialYrStartDate 				= $FinancialYrDates[0];
		$FinancialYrEndDate 					= $FinancialYrDates[1];
		 $cur_fy_startdate                    	 	= date("Y-m-d", strtotime($FinancialYrStartDate));
		 $cur_fy_enddate                     		= 	date("Y-m-d", strtotime($FinancialYrEndDate));
		}	
		else 
		{
			//current financial Year Start And End Date
			$FinancialYrStarAndEndDate		=	FinancialYrStarAndEndDate();
			$CurFinancialYrDates 									= explode('||',$FinancialYrStarAndEndDate);
			$CurFinancialYrStartDate 			= $CurFinancialYrDates[0];
			$CurFinancialYrEndDate 				= $CurFinancialYrDates[1];
			$cur_fy_startdate                      = date("Y-m-d", strtotime($CurFinancialYrStartDate));
			$cur_fy_enddate                      = 	date("Y-m-d", strtotime($CurFinancialYrEndDate));
			//session::add_param('FinancialYrStarAndEndDate',$FinancialYrStarAndEndDate);
	    	//die();
		}
		
		$orderlist = $order->getInfo("","select a.orderinvoicesid,a.orderno 
		                                from ".ORDER_TABLE." a 
		                                  inner join ".ORDERDETAILS_TABLE."  b  on a.orderinvoicesid=b.orderinvoicesid 
		                                  where a.billing_membercompanyid=$companyid  and a.isdeleted = 0 and  a.orderno > 0 
		                                  and  date(a.orderdate) BETWEEN '$cur_fy_startdate' and '$cur_fy_enddate'
		                                  ORDER BY a.orderno ASC");
		//	print_r($orderlist);
		$rowcount = count($orderlist);
		
		$strorderList = "";
		
		if ($rowcount > 0)
		{
			
			for($i=0;$i<$rowcount;$i++) 
			{	
				
				if($orderinvoicesid== $orderlist[$i]['orderinvoicesid'])
				{
					$strorderList .= '<option value="'.$orderlist[$i]["orderinvoicesid"].'" selected="selected">'.$orderlist[$i]["orderno"].'</option>';
				}
				else
				{	
					$strorderList .= '<option value="'.$orderlist[$i]["orderinvoicesid"].'">'.$orderlist[$i]["orderno"].'</option>';
				}
			}
		}
		return $strorderList;	
	}	
	
	function getcsvdataforGSTR1_withTax_AND_GSTNOTAVAILABLE($where_condition_inCSV,$where_condition_inCSV1)
	{
	   	$obj  = new Company();
	            //with Tax starts here

					  		$sql2 = "select *,e.head_Email,a.memberinvoicesid,a.billed_membercompanyid,a.paid_total_amount,a.billing_membercompanyid,a.invoiceno,a.is_mail_send,
			 				 a.InvoiceTotalAmount,a.invoicedate,a.duedate,a.billed_membername,a.cgst_amount,a.sgst_amount,a.igst_amount,a.cgst_percentage,a.sgst_percentage,a.igst_percentage,c.TotalAmount,a.approved
			 			    from ".USER_TABLE." x
					  		 inner join ".INVOICE_TABLE." a on x.userid = a.userid 
					  		 inner join ".INVOICEDETAILS_TABLE." b on a.memberinvoicesid = b.memberinvoicesid
					  		 inner join ".CLIENT_TABLE." e on b.billed_membercompanyid = e.clientcompanyid
					  		 left join ".PAYMENT_TABLE."  c on a.memberinvoicesid = c.memberinvoicesid
					  		 left join ".PAYMENTDETAILS_TABLE."  d on a.memberinvoicesid = d.memberinvoicesid
					  		 where $where_condition_inCSV and (inv_GST_no = '' or inv_GST_no = 'GST Not available') and (igst_amount > 0 or sgst_amount > 0 or cgst_amount > 0) group by a.memberinvoicesid  order by a.invoicedate ASC";
					//echo $sql2;
					$heading = "Invoice GSTR1";
					$sqllist2 = $obj->getCompany('','',$sql2);
					$rowcount = count($sqllist2);
					if ($sqllist2)
					{
						$rowcount_adv = $rowcount;
					}
					else
					{
						$rowcount_adv=0;
					}
					$maxrows = $rowcount_adv;
					$csvcolumnsname ='"","","<b>GST Not Available</b>","","","","","",""," "'."\n";
					//$csvcolumnsname ='"","GST NO","<b>Company Name</b>","Invoice No","Invoice Date","Total Amount with Tax","Basic Amount","IGST","CGST","SGST "'."\n";
					for($i=0;$i<$maxrows;$i++) 
        	 	{ 
	         		$memberinvoicesid							= $sqllist2[$i]['memberinvoicesid'];
	         		$companyid											= $sqllist2[$i]['billed_membercompanyid'];
	         		$billing_membercompanyid			= $sqllist2[$i]['billing_membercompanyid'];
	         		$statusdata											= $sqllist2[$i]['status'];
	         		$invoiceno												= $sqllist2[$i]['invoiceno'];
	         		//$InvoiceTotalAmount				= $sqllist[$i]['InvoiceTotalAmount'];
	         		$invoicedate											= date("j M Y",strtotime($sqllist2[$i]['invoicedate']));
	         		$invoicedatemonth								= date("M Y",strtotime($sqllist2[$i]['invoicedate']));
	
	         		//date("M jS, Y", strtotime("2011-01-05"));
	         		$duedate													= date("j M Y",strtotime($sqllist2[$i]['duedate']));
	         		$billed_membername						= $sqllist2[$i]['billed_membername'];   
	         		$TotalAmount 										= $sqllist2[$i]['TotalAmount']; //total payment by that invoice id
	         		$approved												= $sqllist2[$i]['approved'];  //Invoice approve status
         			$InvoiceBaseAmount							= $sqllist2[$i]['InvoiceBaseAmount'];
					$InvoiceTotalAmount						= $sqllist2[$i]['InvoiceTotalAmount'];
					$inv_GST_no											=	$sqllist2[$i]['inv_GST_no'];
					$is_mail_send										= $sqllist2[$i]['is_mail_send'];
     			  $balance1 												= $InvoiceTotalAmount - $TotalAmount;
         			$paid_total_amount							= $sqllist2[$i]['paid_total_amount'];
         			if($paid_total_amount == '0')
         			{
         		
         			 $balance1 			=			$InvoiceTotalAmount - $TotalAmount;
         			}
         			else
         			{
						$balance1 =  $InvoiceTotalAmount - $paid_total_amount;
         			}

         			$cgst_amount									= $sqllist2[$i]['cgst_amount'];
					$sgst_amount									= $sqllist2[$i]['sgst_amount'];
					$igst_amount									= $sqllist2[$i]['igst_amount'];
					$sgst_percentage 							= $sqllist2[$i]['sgst_percentage'];
					$cgst_percentage 							= $sqllist2[$i]['cgst_percentage'];
					$igst_percentage 							= $sqllist2[$i]['igst_percentage'];

         			$reportname = '"'.$heading.'"'."\n";
         			$resultcsvtotalincome_GSTR1_withtax =getcsvdataforGSTR3B_Total_withtax($where_condition_inCSV1);
                      $resultcsvtotalincom_explode = explode('||',$resultcsvtotalincome_GSTR1_withtax);
             		 $resultcsvtotalincom_explode1 = $resultcsvtotalincom_explode[0];
                    $resultcsvtotalincom_explode2 = $resultcsvtotalincom_explode[1];
					//	$csvtotalincome = "\n".'"","","","","Total","'.$InvoiceBaseAmounts.'","'.$igst_amounts.'","'.$cgst_amounts.'","'.$sgst_amounts.'","'.$InvoiceTotalAmount1.'",""'."\n";
						$csvtotalincome = $resultcsvtotalincom_explode2;

						 $csvdata .= '"'.$invoicedatemonth.'","'.$inv_GST_no.'","'.$billed_membername.'","'.$invoiceno.'","'.$invoicedate.'","'.$InvoiceTotalAmount.'","'.$InvoiceBaseAmount.'","'.$igst_amount.'","'.$cgst_amount.'","'.$sgst_amount.'"'."\n";
						$paymentresultCSV_GSTR1_withtax = $reportname.$csvcolumnsname.$csvdata.$csvtotalincome;
						//	$paymentresultCSV_GSTR1_withtax = $reportname.$csvcolumnsname.$csvdata;

       			 }
       			 
		 return $paymentresultCSV_GSTR1_withtax;
	}
			
function Checkinvoicedateandno($invociedatecheck='',$invocienocheck='')
{
    $invoicedateblank					= date("d-m-Y",strtotime($invociedatecheck));
	if(($invoicedateblank == '30-11--0001') || ($invoicedateblank == '01-01-1970'))
	{
	    $invociedatecheck2					= '';
	}
    else
	{
		$invociedatecheck2					= date("Y-m-d",strtotime($invoicedateblank));
	}
    $currentdate   =   date('Y-m-d');
    $invoice_obj  = new Invoice();
	$sql_lastinvoicedata = "SELECT a.invoiceno as invoiceno,a.invoicedate,a.duedate
								FROM ".INVOICE_TABLE." a 
								INNER JOIN ".INVOICEDETAILS_TABLE." b ON a.memberinvoicesid=b.memberinvoicesid 
								where  a.invoiceno > 0 ORDER BY a. memberinvoicesid DESC LIMIT 0,1" ; 
	$lastinvoicedata_list 	= $invoice_obj-> getInvoice('',$sql_lastinvoicedata);	
	$invoiceno						= $lastinvoicedata_list[0]['invoiceno'];
	$invoicedate					= $lastinvoicedata_list[0]['invoicedate'];
	$duedate						= $lastinvoicedata_list[0]['duedate'];
	if($invociedatecheck2 !='')
	{
        if(($invociedatecheck2 >= $invoicedate) || ($invociedatecheck2 >= $currentdate))
        {
            $invociedatefialcheck= "0";
        }   
        else
        {
            $invociedatefialcheck= "1";
        }
	}
	
	if($invocienocheck !='')
	{
	    if($invocienocheck > $invoiceno)
        {
            $invocienofialcheck ="0";
        }
        else
        {
            $invocienofialcheck ="1";
        }
	    
	}
    return $invociedatefialcheck."||".$invocienofialcheck;
}

function Checkproformadateandno($invociedatecheck='',$invocienocheck='')
{
    $invoicedateblank					= date("d-m-Y",strtotime($invociedatecheck));
	if(($invoicedateblank == '30-11--0001') || ($invoicedateblank == '01-01-1970'))
	{
	    $invociedatecheck2					= '';
	}
    else
	{
		$invociedatecheck2					= date("Y-m-d",strtotime($invoicedateblank));
	}
    $currentdate   =   date('Y-m-d');
    $invoice_obj  = new Invoice();
	$sql_lastinvoicedata = "SELECT a.invoiceno as invoiceno,a.invoicedate,a.duedate
								FROM ".PROFORMA_TABLE." a 
								INNER JOIN ".PROFORMADETAILS_TABLE." b ON a.memberinvoicesid=b.memberinvoicesid 
								where  a.invoiceno > 0 ORDER BY a. memberinvoicesid DESC LIMIT 0,1" ; 
	$lastinvoicedata_list 	= $invoice_obj-> getInvoice('',$sql_lastinvoicedata);	
	$invoiceno						= $lastinvoicedata_list[0]['invoiceno'];
	$invoicedate					= $lastinvoicedata_list[0]['invoicedate'];
	$duedate						= $lastinvoicedata_list[0]['duedate'];
	if($invociedatecheck2 !='')
	{
        if(($invociedatecheck2 >= $invoicedate) || ($invociedatecheck2 >= $currentdate))
        {
            $invociedatefialcheck= "0";
        }   
        else
        {
            $invociedatefialcheck= "1";
        }
	}
	
	if($invocienocheck !='')
	{
	    if($invocienocheck > $invoiceno)
        {
            $invocienofialcheck ="0";
        }
        else
        {
            $invocienofialcheck ="1";
        }
	    
	}
    return $invociedatefialcheck."||".$invocienofialcheck;
}

function Checkquotesdateandno($invociedatecheck='',$invocienocheck='')
{
    $invoicedateblank					= date("d-m-Y",strtotime($invociedatecheck));
	if(($invoicedateblank == '30-11--0001') || ($invoicedateblank == '01-01-1970'))
	{
	    $invociedatecheck2					= '';
	}
    else
	{
		$invociedatecheck2					= date("Y-m-d",strtotime($invoicedateblank));
	}
    $currentdate   =   date('Y-m-d');
    $invoice_obj  = new Invoice();
	$sql_lastinvoicedata = "SELECT a.invoiceno as invoiceno,a.invoicedate,a.duedate
								FROM ".QUOTATION_TABLE." a 
								INNER JOIN ".QUOTATIONDETAILS_TABLE." b ON a.memberinvoicesid=b.memberinvoicesid 
								where  a.invoiceno > 0 ORDER BY a. memberinvoicesid DESC LIMIT 0,1" ; 
	$lastinvoicedata_list 	= $invoice_obj-> getInvoice('',$sql_lastinvoicedata);	
	$invoiceno						= $lastinvoicedata_list[0]['invoiceno'];
	$invoicedate					= $lastinvoicedata_list[0]['invoicedate'];
	$duedate						= $lastinvoicedata_list[0]['duedate'];
	if($invociedatecheck2 !='')
	{
        if(($invociedatecheck2 >= $invoicedate) || ($invociedatecheck2 >= $currentdate))
        {
            $invociedatefialcheck= "0";
        }   
        else
        {
            $invociedatefialcheck= "1";
        }
	}
	
	if($invocienocheck !='')
	{
	    if($invocienocheck > $invoiceno)
        {
            $invocienofialcheck ="0";
        }
        else
        {
            $invocienofialcheck ="1";
        }
	    
	}
    return $invociedatefialcheck."||".$invocienofialcheck;
}

function Checkorderdateandno($invociedatecheck='',$invocienocheck='')
{
    $invoicedateblank					= date("d-m-Y",strtotime($invociedatecheck));
	if(($invoicedateblank == '30-11--0001') || ($invoicedateblank == '01-01-1970'))
	{
	    $invociedatecheck2					= '';
	}
    else
	{
		$invociedatecheck2					= date("Y-m-d",strtotime($invoicedateblank));
	}
    $currentdate   =   date('Y-m-d');
    $invoice_obj  = new Invoice();
	$sql_lastinvoicedata = "SELECT a.orderno as orderno,orderdate,a.duedate
								FROM ".ORDER_TABLE." a 
								INNER JOIN ".ORDERDETAILS_TABLE." b ON a.orderinvoicesid=b.orderinvoicesid 
								where  a.orderno > 0 ORDER BY a. orderinvoicesid DESC LIMIT 0,1" ; 
	$lastinvoicedata_list 	= $invoice_obj-> getInvoice('',$sql_lastinvoicedata);	
	$invoiceno						= $lastinvoicedata_list[0]['orderno'];
	$invoicedate					= $lastinvoicedata_list[0]['orderdate'];
	$duedate						= $lastinvoicedata_list[0]['duedate'];
	if($invociedatecheck2 !='')
	{
        if(($invociedatecheck2 >= $invoicedate) || ($invociedatecheck2 >= $currentdate))
        {
            $invociedatefialcheck= "0";
        }   
        else
        {
            $invociedatefialcheck= "1";
        }
	}
	
	if($invocienocheck !='')
	{
	    if($invocienocheck > $invoiceno)
        {
            $invocienofialcheck ="0";
        }
        else
        {
            $invocienofialcheck ="1";
        }
	    
	}
    return $invociedatefialcheck."||".$invocienofialcheck;
}
// CSV GSTR1_withTax created by saurabh 15/01/2022
	function getcsvdataforGSTR1_withTax1($where_condition_inCSV,$where_condition_inCSV1)
	{
	   	$obj  = new Company();
	            //with Tax starts here

					  	$sql2 = "select *,e.head_Email,a.memberinvoicesid,a.billed_membercompanyid,a.paid_total_amount,a.billing_membercompanyid,a.invoiceno,a.is_mail_send,
			 				 a.InvoiceTotalAmount,a.invoicedate,a.duedate,a.billed_membername,a.cgst_amount,a.sgst_amount,a.igst_amount,a.cgst_percentage,a.sgst_percentage,a.igst_percentage,c.TotalAmount,a.approved
			 			    from ".USER_TABLE." x
					  		 inner join ".INVOICE_TABLE." a on x.userid = a.userid 
					  		 inner join ".INVOICEDETAILS_TABLE." b on a.memberinvoicesid = b.memberinvoicesid
					  		 inner join ".CLIENT_TABLE." e on b.billed_membercompanyid = e.clientcompanyid
					  		 left join ".PAYMENT_TABLE."  c on a.memberinvoicesid = c.memberinvoicesid
					  		 left join ".PAYMENTDETAILS_TABLE."  d on a.memberinvoicesid = d.memberinvoicesid
					  		 where $where_condition_inCSV  and (igst_amount > 0 or sgst_amount > 0 or cgst_amount > 0) and a.inv_GST_no != 'GST Not available' and a.inv_GST_no != '' group by a.memberinvoicesid  order by a.invoicedate ASC";
				
				/*$sql2 = "select *,e.head_Email,a.memberinvoicesid,a.billed_membercompanyid,a.paid_total_amount,a.billing_membercompanyid,a.invoiceno,a.is_mail_send,
			 				 a.InvoiceTotalAmount,a.invoicedate,a.duedate,a.billed_membername,a.cgst_amount,a.sgst_amount,a.igst_amount,a.cgst_percentage,a.sgst_percentage,a.igst_percentage,c.TotalAmount,a.approved
			 			    from ".USER_TABLE." x
					  		 inner join ".INVOICE_TABLE." a on x.userid = a.userid 
					  		 inner join ".INVOICEDETAILS_TABLE." b on a.memberinvoicesid = b.memberinvoicesid
					  		 inner join ".CLIENT_TABLE." e on b.billed_membercompanyid = e.clientcompanyid
					  		 left join ".PAYMENT_TABLE."  c on a.memberinvoicesid = c.memberinvoicesid
					  		 left join ".PAYMENTDETAILS_TABLE."  d on a.memberinvoicesid = d.memberinvoicesid
					  		 where $where_condition_inCSV  and (igst_amount > 0 or sgst_amount > 0 or cgst_amount > 0) and (a.inv_GST_no != ''  or a.inv_GST_no != 'GST Not available') and (igst_amount < 0 and sgst_amount > 0 and  cgst_amount > 0 and a.inv_GST_no != '' or a.inv_GST_no != 'GST Not available') group by a.memberinvoicesid  order by a.invoicedate ASC";
				*/
			/*	$sql2 = "select *,e.head_Email,a.memberinvoicesid,a.billed_membercompanyid,a.paid_total_amount,a.billing_membercompanyid,a.invoiceno,a.is_mail_send,
			 				 a.InvoiceTotalAmount,a.invoicedate,a.duedate,a.billed_membername,a.cgst_amount,a.sgst_amount,a.igst_amount,a.cgst_percentage,a.sgst_percentage,a.igst_percentage,c.TotalAmount,a.approved
			 			    from ".USER_TABLE." x
					  		 inner join ".INVOICE_TABLE." a on x.userid = a.userid 
					  		 inner join ".INVOICEDETAILS_TABLE." b on a.memberinvoicesid = b.memberinvoicesid
					  		 inner join ".CLIENT_TABLE." e on b.billed_membercompanyid = e.clientcompanyid
					  		 left join ".PAYMENT_TABLE."  c on a.memberinvoicesid = c.memberinvoicesid
					  		 left join ".PAYMENTDETAILS_TABLE."  d on a.memberinvoicesid = d.memberinvoicesid
					  		 where $where_condition_inCSV  and a.inv_GST_no != '' and (a.inv_GST_no != 'GST Not applicable' or igst_amount < 0 or sgst_amount > 0 or cgst_amount > 0) and (igst_amount > 0 or sgst_amount > 0 or cgst_amount > 0)  group by a.memberinvoicesid  order by a.invoicedate ASC";
				*/
					//echo $sql2;
				//	die();
					$heading = "Invoice GSTR1";
					$sqllist2 = $obj->getCompany('','',$sql2);
					$rowcount = count($sqllist2);
					if ($sqllist2)
					{
						$rowcount_adv = $rowcount;
					}
					else
					{
						$rowcount_adv=0;
					}
					$maxrows = $rowcount_adv;
					$csvcolumnsname ='"","GST NO","<b>Company Name</b>","Invoice No","Invoice Date","Total Amount with Tax","Basic Amount","IGST","CGST","SGST "'."\n";
				for($i=0;$i<$maxrows;$i++) 
        	 	{ 
        	 	    if($sqllist2[$i]['inv_GST_no'] !='GST Not available')
        	 	    {
        	 	        
        	 	    
	         		$memberinvoicesid							= $sqllist2[$i]['memberinvoicesid'];
	         		$companyid											= $sqllist2[$i]['billed_membercompanyid'];
	         		$billing_membercompanyid			= $sqllist2[$i]['billing_membercompanyid'];
	         		$statusdata											= $sqllist2[$i]['status'];
	         		$invoiceno												= $sqllist2[$i]['invoiceno'];
	         		//$InvoiceTotalAmount				= $sqllist[$i]['InvoiceTotalAmount'];
	         		$invoicedate											= date("j M Y",strtotime($sqllist2[$i]['invoicedate']));
	         		$invoicedatemonth								= date("M Y",strtotime($sqllist2[$i]['invoicedate']));
	
	         		//date("M jS, Y", strtotime("2011-01-05"));
	         		$duedate													= date("j M Y",strtotime($sqllist2[$i]['duedate']));
	         		$billed_membername						= $sqllist2[$i]['billed_membername'];   
	         		$TotalAmount 										= $sqllist2[$i]['TotalAmount']; //total payment by that invoice id
	         		$approved												= $sqllist2[$i]['approved'];  //Invoice approve status
         			$InvoiceBaseAmount							= $sqllist2[$i]['InvoiceBaseAmount'];
					$InvoiceTotalAmount						= $sqllist2[$i]['InvoiceTotalAmount'];
					$inv_GST_no											=	$sqllist2[$i]['inv_GST_no'];
					$is_mail_send										= $sqllist2[$i]['is_mail_send'];
     			  $balance1 												= $InvoiceTotalAmount - $TotalAmount;
         			$paid_total_amount							= $sqllist2[$i]['paid_total_amount'];
         			if($paid_total_amount == '0')
         			{
         		
         			 $balance1 			=			$InvoiceTotalAmount - $TotalAmount;
         			}
         			else
         			{
						$balance1 =  $InvoiceTotalAmount - $paid_total_amount;
         			}

         			$cgst_amount									= $sqllist2[$i]['cgst_amount'];
					$sgst_amount									= $sqllist2[$i]['sgst_amount'];
					$igst_amount									= $sqllist2[$i]['igst_amount'];
					$sgst_percentage 							= $sqllist2[$i]['sgst_percentage'];
					$cgst_percentage 							= $sqllist2[$i]['cgst_percentage'];
					$igst_percentage 							= $sqllist2[$i]['igst_percentage'];

         			$reportname = '"'.$heading.'"'."\n";
         			$resultcsvtotalincome_GSTR1_withtax =getcsvdataforGSTR1_TotalAmount_withtax($where_condition_inCSV1);
                      $resultcsvtotalincom_explode = explode('||',$resultcsvtotalincome_GSTR1_withtax);
             		 $resultcsvtotalincom_explode1 = $resultcsvtotalincom_explode[0];
                    $resultcsvtotalincom_explode2 = $resultcsvtotalincom_explode[1];
					//	$csvtotalincome = "\n".'"","","","","Total","'.$InvoiceBaseAmounts.'","'.$igst_amounts.'","'.$cgst_amounts.'","'.$sgst_amounts.'","'.$InvoiceTotalAmount1.'",""'."\n";
						$csvtotalincome = $resultcsvtotalincom_explode2;

						 $csvdata .= '"'.$invoicedatemonth.'","'.$inv_GST_no.'","'.$billed_membername.'","'.$invoiceno.'","'.$invoicedate.'","'.$InvoiceTotalAmount.'","'.$InvoiceBaseAmount.'","'.$igst_amount.'","'.$cgst_amount.'","'.$sgst_amount.'"'."\n";
						$paymentresultCSV_GSTR1_withtax = $reportname.$csvcolumnsname.$csvdata.$csvtotalincome;
						//	$paymentresultCSV_GSTR1_withtax = $reportname.$csvcolumnsname.$csvdata;
        	 	}
       			 }
       			 
		 return $paymentresultCSV_GSTR1_withtax;
	}
	// CSV GSTR1_TotalAmount_withtax created by saurabh 15/01/2022
	function getcsvdataforGSTR1_TotalAmount_withtax($where_condition_inCSV)
	{
	    $obj_Invoice  = new Invoice();
	    $obj_Memberpaymentheader  = new Memberpaymentheader();

						$sql_invoice2 = "select a.inv_GST_no,SUM(InvoiceTotalAmount) as InvoiceTotalAmounts ,SUM(paid_total_amount) as paid_total_amount1,SUM(igst_amount) as igst_amounts,SUM(cgst_amount) as cgst_amounts,SUM(sgst_amount) as sgst_amounts,SUM(ugst_amount) as ugst_amounts,SUM(InvoiceBaseAmount) as InvoiceBaseAmounts
						 from trninvoicetomember a  
						where $where_condition_inCSV  and  (igst_amount > 0 or sgst_amount > 0 or cgst_amount > 0) and a.inv_GST_no != 'GST Not available'  and a.inv_GST_no !='' ";
	

	            //echo $sql_invoice2;
						$sql_invoice_list2 = $obj_Invoice->getInvoice('',$sql_invoice2);

						$sql_payment2 = "select b.inv_GST_no,SUM(TotalAmount) as TotalAmounts3,SUM(tds) as Totaltds from user_company_payment_header a inner join trninvoicetomember b on a.memberinvoicesid = b.memberinvoicesid 
						where $where_condition_inCSV  and  (igst_amount > 0 or sgst_amount > 0 or cgst_amount > 0) and b.inv_GST_no != 'GST Not available'";
    	$sql_invoice_list2 = $obj_Invoice->getInvoice('',$sql_invoice2);

						/*$sql_payment2 = "select b.inv_GST_no,SUM(TotalAmount) as TotalAmounts3,SUM(tds) as Totaltds 
						                    from  trninvoicetomember b
						                    inner join user_company_payment_header a on b.memberinvoicesid = a.memberinvoicesid 
						where $where_condition_inCSV  and  (igst_amount > 0 or sgst_amount > 0 or cgst_amount > 0) and b.inv_GST_no != 'GST Not available'";
*/
                //echo $sql_payment2;

				$sql_paymentlist2 = $obj_Memberpaymentheader->getMemberpaymentheader('',$sql_payment2);
						
	            //echo $sql_invoice1;
						$sql_invoice_list2 = $obj_Invoice->getInvoice('',$sql_invoice2);
	
		            if($sql_invoice_list2[0]['inv_GST_no'] !='' || $sql_paymentlist2[0]['inv_GST_no'] !='')
        	 	    {
			
						$InvoiceTotalAmount1  		= $sql_invoice_list2[0]['InvoiceTotalAmounts'];
						$igst_amounts  				= $sql_invoice_list2[0]['igst_amounts'];
						$cgst_amounts  				= $sql_invoice_list2[0]['cgst_amounts'];
						$sgst_amounts  				= $sql_invoice_list2[0]['sgst_amounts'];
						$ugst_amounts  				= $sql_invoice_list2[0]['ugst_amounts'];
						$InvoiceBaseAmounts  		= $sql_invoice_list2[0]['InvoiceBaseAmounts'];
						$TotalAmounts3  		    = $sql_paymentlist2[0]['TotalAmounts3'];
						$paid_total_amount1  		= $sql_invoice_list2[0]['paid_total_amount1'];
						$Totaltds  				    = $sql_paymentlist2[0]['Totaltds'];

				if($paid_total_amount1 == '0')
         		{
         			$balance1sds 							= $InvoiceTotalAmount1 - $TotalAmounts3-$Totaltds;
         		}
         		else
         		{
					
					$balance1sds= $InvoiceTotalAmount1 - $paid_total_amount1-$Totaltds;
					
         		}
	
                $result1 = "\n".'"Total","'.$InvoiceBaseAmounts.'","'.$igst_amounts.'","'.$cgst_amounts.'","'.$sgst_amounts.'","'.$InvoiceTotalAmount1.'",""'."\n";
				$result2 = "\n".'"","","","","Total","'.$InvoiceTotalAmount1.'","'.$InvoiceBaseAmounts.'","'.$igst_amounts.'","'.$cgst_amounts.'","'.$sgst_amounts.'",""'."\n";
        	  }
                 $result  = $result1."||".$result2; 
	            return  $result;     
	}
    // CSV GSTR1_GSTNotAvailable created by saurabh 15/01/2022	
	function getcsvdataforGSTR1_GSTNotAvailable($where_condition_inCSV,$where_condition_inCSV1)
	{
	   	$obj  = new Company();
	            //with Tax starts here

					 /* 	$sql2 = "select *,e.head_Email,a.memberinvoicesid,a.billed_membercompanyid,a.paid_total_amount,a.billing_membercompanyid,a.invoiceno,a.is_mail_send,
			 				 a.InvoiceTotalAmount,a.invoicedate,a.duedate,a.billed_membername,a.cgst_amount,a.sgst_amount,a.igst_amount,a.cgst_percentage,a.sgst_percentage,a.igst_percentage,c.TotalAmount,a.approved
			 			    from ".USER_TABLE." x
					  		 inner join ".INVOICE_TABLE." a on x.userid = a.userid 
					  		 inner join ".INVOICEDETAILS_TABLE." b on a.memberinvoicesid = b.memberinvoicesid
					  		 inner join ".CLIENT_TABLE." e on b.billed_membercompanyid = e.clientcompanyid
					  		 left join ".PAYMENT_TABLE."  c on a.memberinvoicesid = c.memberinvoicesid
					  		 left join ".PAYMENTDETAILS_TABLE."  d on a.memberinvoicesid = d.memberinvoicesid
					  		 where $where_condition_inCSV  and (igst_amount > 0 or sgst_amount > 0 or cgst_amount > 0) and a.inv_GST_no != 'GST Not applicable' group by a.memberinvoicesid  order by a.invoicedate ASC";
					*/
					$sql2 = "select *,e.head_Email,a.memberinvoicesid,a.billed_membercompanyid,a.paid_total_amount,a.billing_membercompanyid,a.invoiceno,a.is_mail_send,
			 				 a.InvoiceTotalAmount,a.invoicedate,a.duedate,a.billed_membername,a.cgst_amount,a.sgst_amount,a.igst_amount,a.cgst_percentage,a.sgst_percentage,a.igst_percentage,c.TotalAmount,a.approved
			 			    from ".USER_TABLE." x
					  		 inner join ".INVOICE_TABLE." a on x.userid = a.userid 
					  		 inner join ".INVOICEDETAILS_TABLE." b on a.memberinvoicesid = b.memberinvoicesid
					  		 inner join ".CLIENT_TABLE." e on b.billed_membercompanyid = e.clientcompanyid
					  		 left join ".PAYMENT_TABLE."  c on a.memberinvoicesid = c.memberinvoicesid
					  		 left join ".PAYMENTDETAILS_TABLE."  d on a.memberinvoicesid = d.memberinvoicesid
					  		 where $where_condition_inCSV  and (igst_amount > 0 or sgst_amount > 0 or cgst_amount > 0) and (a.inv_GST_no = 'GST Not available' or a.inv_GST_no ='') group by a.memberinvoicesid  order by a.invoicedate ASC";
				
			
					//echo $sql2;
				//	die();
					//$heading = "Invoice GSTR1";
					$sqllist2 = $obj->getCompany('','',$sql2);
					$rowcount = count($sqllist2);
					if ($sqllist2)
					{
						$rowcount_adv = $rowcount;
					}
					else
					{
						$rowcount_adv=0;
					}
					$maxrows = $rowcount_adv;
				//	$csvcolumnsname ='"","GST NO","<b>Company Name</b>","Invoice No","Invoice Date","Total Amount with Tax","Basic Amount","IGST","CGST","SGST "'."\n";
				$csvcolumnsname ='"","","<b>GST Not Available</b>","","","","","",""," "'."\n";
				for($i=0;$i<$maxrows;$i++) 
        	 	{ 
        	 	    if($sqllist2[$i]['inv_GST_no'] == 'GST Not available' || $sqllist2[$i]['inv_GST_no'] == '')
        	 	    {
        	 	        
        	 	    
	         		$memberinvoicesid							= $sqllist2[$i]['memberinvoicesid'];
	         		$companyid											= $sqllist2[$i]['billed_membercompanyid'];
	         		$billing_membercompanyid			= $sqllist2[$i]['billing_membercompanyid'];
	         		$statusdata											= $sqllist2[$i]['status'];
	         		$invoiceno												= $sqllist2[$i]['invoiceno'];
	         		//$InvoiceTotalAmount				= $sqllist[$i]['InvoiceTotalAmount'];
	         		$invoicedate											= date("j M Y",strtotime($sqllist2[$i]['invoicedate']));
	         		$invoicedatemonth								= date("M Y",strtotime($sqllist2[$i]['invoicedate']));
	
	         		//date("M jS, Y", strtotime("2011-01-05"));
	         		$duedate													= date("j M Y",strtotime($sqllist2[$i]['duedate']));
	         		$billed_membername						= $sqllist2[$i]['billed_membername'];   
	         		$TotalAmount 										= $sqllist2[$i]['TotalAmount']; //total payment by that invoice id
	         		$approved												= $sqllist2[$i]['approved'];  //Invoice approve status
         			$InvoiceBaseAmount							= $sqllist2[$i]['InvoiceBaseAmount'];
					$InvoiceTotalAmount						= $sqllist2[$i]['InvoiceTotalAmount'];
					$inv_GST_no											=	$sqllist2[$i]['inv_GST_no'];
					$is_mail_send										= $sqllist2[$i]['is_mail_send'];
     			  $balance1 												= $InvoiceTotalAmount - $TotalAmount;
         			$paid_total_amount							= $sqllist2[$i]['paid_total_amount'];
         			if($paid_total_amount == '0')
         			{
         		
         			 $balance1 			=			$InvoiceTotalAmount - $TotalAmount;
         			}
         			else
         			{
						$balance1 =  $InvoiceTotalAmount - $paid_total_amount;
         			}

         			$cgst_amount									= $sqllist2[$i]['cgst_amount'];
					$sgst_amount									= $sqllist2[$i]['sgst_amount'];
					$igst_amount									= $sqllist2[$i]['igst_amount'];
					$sgst_percentage 							= $sqllist2[$i]['sgst_percentage'];
					$cgst_percentage 							= $sqllist2[$i]['cgst_percentage'];
					$igst_percentage 							= $sqllist2[$i]['igst_percentage'];

         			$reportname = '"'.$heading.'"'."\n";
         			$resultcsvtotalincome_GSTR1_withtax =getcsvdataforGSTR1_TotalAmount_GSTNotAvailable($where_condition_inCSV1);
                      $resultcsvtotalincom_explode = explode('||',$resultcsvtotalincome_GSTR1_withtax);
             		 $resultcsvtotalincom_explode1 = $resultcsvtotalincom_explode[0];
                    $resultcsvtotalincom_explode2 = $resultcsvtotalincom_explode[1];
					//	$csvtotalincome = "\n".'"","","","","Total","'.$InvoiceBaseAmounts.'","'.$igst_amounts.'","'.$cgst_amounts.'","'.$sgst_amounts.'","'.$InvoiceTotalAmount1.'",""'."\n";
						$csvtotalincome = $resultcsvtotalincom_explode2;

						 $csvdata .= '"'.$invoicedatemonth.'","'.$inv_GST_no.'","'.$billed_membername.'","'.$invoiceno.'","'.$invoicedate.'","'.$InvoiceTotalAmount.'","'.$InvoiceBaseAmount.'","'.$igst_amount.'","'.$cgst_amount.'","'.$sgst_amount.'"'."\n";
						$paymentresultCSV_GSTR1_withtax = $reportname.$csvcolumnsname.$csvdata.$csvtotalincome;
						//	$paymentresultCSV_GSTR1_withtax = $reportname.$csvcolumnsname.$csvdata;
        	 	}
       			 }
       			 
		 return $paymentresultCSV_GSTR1_withtax;
	}
	 // CSV GSTR1_TotalAmount_GSTNotAvailable created by saurabh 15/01/2022
	function getcsvdataforGSTR1_TotalAmount_GSTNotAvailable($where_condition_inCSV)
	{
	    $obj_Invoice  = new Invoice();
	    $obj_Memberpaymentheader  = new Memberpaymentheader();

						$sql_invoice2 = "select a.inv_GST_no,SUM(InvoiceTotalAmount) as InvoiceTotalAmounts ,SUM(paid_total_amount) as paid_total_amount1,SUM(igst_amount) as igst_amounts,SUM(cgst_amount) as cgst_amounts,SUM(sgst_amount) as sgst_amounts,SUM(ugst_amount) as ugst_amounts,SUM(InvoiceBaseAmount) as InvoiceBaseAmounts
						 from trninvoicetomember a  
						where $where_condition_inCSV  and  (igst_amount > 0 or sgst_amount > 0 or cgst_amount > 0) and   (a.inv_GST_no = 'GST Not available' or a.inv_GST_no ='') ";
	

	            //echo $sql_invoice2;
						$sql_invoice_list2 = $obj_Invoice->getInvoice('',$sql_invoice2);

						$sql_payment2 = "select b.inv_GST_no,SUM(TotalAmount) as TotalAmounts3,SUM(tds) as Totaltds from user_company_payment_header a inner join trninvoicetomember b on a.memberinvoicesid = b.memberinvoicesid 
						where $where_condition_inCSV  and  (igst_amount > 0 or sgst_amount > 0 or cgst_amount > 0)  and (b.inv_GST_no = 'GST Not available' or b.inv_GST_no ='')";

                //echo $sql_payment2;

				$sql_paymentlist2 = $obj_Memberpaymentheader->getMemberpaymentheader('',$sql_payment2);
						
	            //echo $sql_invoice1;
						$sql_invoice_list2 = $obj_Invoice->getInvoice('',$sql_invoice2);
	
		            if(($sql_invoice_list2[0]['inv_GST_no'] == 'GST Not available' || $sql_invoice_list2[0]['inv_GST_no'] == '' ) && ($sql_paymentlist2[0]['inv_GST_no'] == 'GST Not available' || $sql_paymentlist2[0]['inv_GST_no'] ==''))
        	 	    {
			        
						$InvoiceTotalAmount1  		= $sql_invoice_list2[0]['InvoiceTotalAmounts'];
						$igst_amounts  				= $sql_invoice_list2[0]['igst_amounts'];
						$cgst_amounts  				= $sql_invoice_list2[0]['cgst_amounts'];
						$sgst_amounts  				= $sql_invoice_list2[0]['sgst_amounts'];
						$ugst_amounts  				= $sql_invoice_list2[0]['ugst_amounts'];
						$InvoiceBaseAmounts  		= $sql_invoice_list2[0]['InvoiceBaseAmounts'];
						$TotalAmounts3  		    = $sql_paymentlist2[0]['TotalAmounts3'];
						$paid_total_amount1  		= $sql_invoice_list2[0]['paid_total_amount1'];
						$Totaltds  				    = $sql_paymentlist2[0]['Totaltds'];

				if($paid_total_amount1 == '0')
         		{
         			$balance1sds 							= $InvoiceTotalAmount1 - $TotalAmounts3-$Totaltds;
         		}
         		else
         		{
					
					$balance1sds= $InvoiceTotalAmount1 - $paid_total_amount1-$Totaltds;
					
         		}
	
                $result1 = "\n".'"Total","'.$InvoiceBaseAmounts.'","'.$igst_amounts.'","'.$cgst_amounts.'","'.$sgst_amounts.'","'.$InvoiceTotalAmount1.'",""'."\n";
				$result2 = "\n".'"","","","","Total","'.$InvoiceTotalAmount1.'","'.$InvoiceBaseAmounts.'","'.$igst_amounts.'","'.$cgst_amounts.'","'.$sgst_amounts.'",""'."\n";
        	  }
                $result  = $result1."||".$result2; 
	            return  $result;     
	}
?>