document.addEventListener('DOMContentLoaded', function () {
    const containers = document.querySelectorAll('.editable-buttons').forEach(buttonsWrapper => {
        const container = buttonsWrapper.closest('form, .card-body, .tab-pane'); // Find the nearest form, card-body, or tab-pane
        const editBtn = buttonsWrapper.querySelector('.btn-edit-all');
        const saveBtn = buttonsWrapper.querySelector('.btn-save-all');
        const cancelBtn = buttonsWrapper.querySelector('.btn-cancel-all');
        const groups = container.querySelectorAll('.editable-group');

        editBtn?.addEventListener('click', () => {
            groups.forEach(group => {
                group.querySelector('.editable-view')?.classList.add('d-none');
                group.querySelector('.editable-edit')?.classList.remove('d-none');
            });
            editBtn.classList.add('d-none');
            saveBtn.classList.remove('d-none');
            cancelBtn.classList.remove('d-none');
        });

        cancelBtn?.addEventListener('click', () => {
            groups.forEach(group => {
                group.querySelector('.editable-view')?.classList.remove('d-none');
                group.querySelector('.editable-edit')?.classList.add('d-none');
            });
            editBtn.classList.remove('d-none');
            saveBtn.classList.add('d-none');
            cancelBtn.classList.add('d-none');  
        });

        
        saveBtn?.addEventListener('click', () => {
            groups.forEach(group => {
                const editInputs = group.querySelectorAll('.editable-edit input, .editable-edit select, .editable-edit textarea');
                const viewContainer = group.querySelector('.editable-view');
                if (viewContainer) {
                    // Update the view mode text manually
                    editInputs.forEach(input => {
                        const value = input.value;
                        const labelDiv = viewContainer.querySelector(`[data-name="${input.name}"]`);
                        if (labelDiv) {
                            labelDiv.innerText = value;
                        }
                    });
                }
                group.querySelector('.editable-view')?.classList.remove('d-none');
                group.querySelector('.editable-edit')?.classList.add('d-none');
            });
            editBtn.classList.remove('d-none');
            saveBtn.classList.add('d-none');
            cancelBtn.classList.add('d-none');
        });
    });
});
